/*
 * Decompiled with CFR 0.152.
 */
package net.spaceeye.elementa.impl.commonmark.internal.inline;

import net.spaceeye.elementa.impl.commonmark.internal.inline.InlineContentParser;
import net.spaceeye.elementa.impl.commonmark.internal.inline.InlineParserState;
import net.spaceeye.elementa.impl.commonmark.internal.inline.ParsedInline;
import net.spaceeye.elementa.impl.commonmark.internal.inline.Position;
import net.spaceeye.elementa.impl.commonmark.internal.inline.Scanner;
import net.spaceeye.elementa.impl.commonmark.internal.util.AsciiMatcher;
import net.spaceeye.elementa.impl.commonmark.node.HtmlInline;

public class HtmlInlineParser
implements InlineContentParser {
    private static final AsciiMatcher asciiLetter;
    private static final AsciiMatcher tagNameStart;
    private static final AsciiMatcher tagNameContinue;
    private static final AsciiMatcher attributeStart;
    private static final AsciiMatcher attributeContinue;
    private static final AsciiMatcher attributeValueEnd;
    private static final AsciiMatcher declaration;

    @Override
    public ParsedInline tryParse(InlineParserState inlineParserState) {
        Scanner scanner = inlineParserState.scanner();
        Position start = scanner.position();
        scanner.next();
        char c = scanner.peek();
        if (tagNameStart.matches(c)) {
            if (HtmlInlineParser.tryOpenTag(scanner)) {
                return HtmlInlineParser.htmlInline(start, scanner);
            }
        } else if (c == '/') {
            if (HtmlInlineParser.tryClosingTag(scanner)) {
                return HtmlInlineParser.htmlInline(start, scanner);
            }
        } else if (c == '?') {
            if (HtmlInlineParser.tryProcessingInstruction(scanner)) {
                return HtmlInlineParser.htmlInline(start, scanner);
            }
        } else if (c == '!') {
            scanner.next();
            c = scanner.peek();
            if (c == '-' ? HtmlInlineParser.tryComment(scanner) : (c == '[' ? HtmlInlineParser.tryCdata(scanner) : declaration.matches(c) && HtmlInlineParser.tryDeclaration(scanner))) {
                return HtmlInlineParser.htmlInline(start, scanner);
            }
        }
        return ParsedInline.none();
    }

    private static ParsedInline htmlInline(Position start, Scanner scanner) {
        String text = scanner.getSource(start, scanner.position()).getContent();
        HtmlInline node2 = new HtmlInline();
        node2.setLiteral(text);
        return ParsedInline.of(node2, scanner.position());
    }

    private static boolean tryOpenTag(Scanner scanner) {
        boolean whitespace;
        scanner.next();
        scanner.match(tagNameContinue);
        boolean bl = whitespace = scanner.whitespace() >= 1;
        while (whitespace && scanner.match(attributeStart) >= 1) {
            scanner.match(attributeContinue);
            boolean bl2 = whitespace = scanner.whitespace() >= 1;
            if (!scanner.next('=')) continue;
            scanner.whitespace();
            char valueStart = scanner.peek();
            if (valueStart == '\'') {
                scanner.next();
                if (scanner.find('\'') < 0) {
                    return false;
                }
                scanner.next();
            } else if (valueStart == '\"') {
                scanner.next();
                if (scanner.find('\"') < 0) {
                    return false;
                }
                scanner.next();
            } else if (scanner.find(attributeValueEnd) <= 0) {
                return false;
            }
            whitespace = scanner.whitespace() >= 1;
        }
        scanner.next('/');
        return scanner.next('>');
    }

    private static boolean tryClosingTag(Scanner scanner) {
        scanner.next();
        if (scanner.match(tagNameStart) >= 1) {
            scanner.match(tagNameContinue);
            scanner.whitespace();
            return scanner.next('>');
        }
        return false;
    }

    private static boolean tryProcessingInstruction(Scanner scanner) {
        scanner.next();
        while (scanner.find('?') > 0) {
            scanner.next();
            if (!scanner.next('>')) continue;
            return true;
        }
        return false;
    }

    private static boolean tryComment(Scanner scanner) {
        scanner.next();
        if (!scanner.next('-')) {
            return false;
        }
        if (scanner.next('>') || scanner.next("->")) {
            return false;
        }
        while (scanner.find('-') >= 0) {
            if (scanner.next("--")) {
                return scanner.next('>');
            }
            scanner.next();
        }
        return false;
    }

    private static boolean tryCdata(Scanner scanner) {
        scanner.next();
        if (scanner.next("CDATA[")) {
            while (scanner.find(']') >= 0) {
                if (scanner.next("]]>")) {
                    return true;
                }
                scanner.next();
            }
        }
        return false;
    }

    private static boolean tryDeclaration(Scanner scanner) {
        scanner.match(declaration);
        if (scanner.whitespace() <= 0) {
            return false;
        }
        if (scanner.find('>') >= 0) {
            scanner.next();
            return true;
        }
        return false;
    }

    static {
        tagNameStart = asciiLetter = AsciiMatcher.builder().range('A', 'Z').range('a', 'z').build();
        tagNameContinue = tagNameStart.newBuilder().range('0', '9').c('-').build();
        attributeStart = asciiLetter.newBuilder().c('_').c(':').build();
        attributeContinue = attributeStart.newBuilder().range('0', '9').c('.').c('-').build();
        attributeValueEnd = AsciiMatcher.builder().c(' ').c('\t').c('\n').c('\u000b').c('\f').c('\r').c('\"').c('\'').c('=').c('<').c('>').c('`').build();
        declaration = AsciiMatcher.builder().range('A', 'Z').build();
    }
}

