/*
 * Decompiled with CFR 0.152.
 */
package net.spaceeye.elementa.impl.dom4j.tree;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import net.spaceeye.elementa.impl.dom4j.Branch;
import net.spaceeye.elementa.impl.dom4j.Comment;
import net.spaceeye.elementa.impl.dom4j.Element;
import net.spaceeye.elementa.impl.dom4j.IllegalAddException;
import net.spaceeye.elementa.impl.dom4j.Namespace;
import net.spaceeye.elementa.impl.dom4j.Node;
import net.spaceeye.elementa.impl.dom4j.ProcessingInstruction;
import net.spaceeye.elementa.impl.dom4j.QName;
import net.spaceeye.elementa.impl.dom4j.tree.AbstractNode;
import net.spaceeye.elementa.impl.dom4j.tree.BackedList;
import net.spaceeye.elementa.impl.dom4j.tree.ContentListFacade;

public abstract class AbstractBranch
extends AbstractNode
implements Branch {
    protected static final int DEFAULT_CONTENT_LIST_SIZE = 5;

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public boolean hasContent() {
        return this.nodeCount() > 0;
    }

    @Override
    public List<Node> content() {
        List<Node> backingList = this.contentList();
        return new ContentListFacade<Node>(this, backingList);
    }

    @Override
    public String getText() {
        int size;
        List<Node> content = this.contentList();
        if (content != null && (size = content.size()) >= 1) {
            Node first = content.get(0);
            String firstText = this.getContentAsText(first);
            if (size == 1) {
                return firstText;
            }
            StringBuilder buffer = new StringBuilder(firstText);
            for (int i2 = 1; i2 < size; ++i2) {
                Node node2 = content.get(i2);
                buffer.append(this.getContentAsText(node2));
            }
            return buffer.toString();
        }
        return "";
    }

    protected String getContentAsText(Object content) {
        if (content instanceof Node) {
            Node node2 = (Node)content;
            switch (node2.getNodeType()) {
                case 3: 
                case 4: 
                case 5: {
                    return node2.getText();
                }
            }
        } else if (content instanceof String) {
            return (String)content;
        }
        return "";
    }

    protected String getContentAsStringValue(Object content) {
        if (content instanceof Node) {
            Node node2 = (Node)content;
            switch (node2.getNodeType()) {
                case 1: 
                case 3: 
                case 4: 
                case 5: {
                    return node2.getStringValue();
                }
            }
        } else if (content instanceof String) {
            return (String)content;
        }
        return "";
    }

    public String getTextTrim() {
        String text = this.getText();
        StringBuilder textContent = new StringBuilder();
        StringTokenizer tokenizer = new StringTokenizer(text);
        while (tokenizer.hasMoreTokens()) {
            String str = tokenizer.nextToken();
            textContent.append(str);
            if (!tokenizer.hasMoreTokens()) continue;
            textContent.append(" ");
        }
        return textContent.toString();
    }

    @Override
    public void setProcessingInstructions(List<ProcessingInstruction> listOfPIs) {
        for (ProcessingInstruction pi : listOfPIs) {
            this.addNode(pi);
        }
    }

    @Override
    public Element addElement(String name) {
        Element node2 = this.getDocumentFactory().createElement(name);
        this.add(node2);
        return node2;
    }

    @Override
    public Element addElement(String qualifiedName, String namespaceURI) {
        Element node2 = this.getDocumentFactory().createElement(qualifiedName, namespaceURI);
        this.add(node2);
        return node2;
    }

    @Override
    public Element addElement(QName qname) {
        Element node2 = this.getDocumentFactory().createElement(qname);
        this.add(node2);
        return node2;
    }

    public Element addElement(String name, String prefix, String uri) {
        Namespace namespace = Namespace.get(prefix, uri);
        QName qName = this.getDocumentFactory().createQName(name, namespace);
        return this.addElement(qName);
    }

    @Override
    public void add(Node node2) {
        switch (node2.getNodeType()) {
            case 1: {
                this.add((Element)node2);
                break;
            }
            case 8: {
                this.add((Comment)node2);
                break;
            }
            case 7: {
                this.add((ProcessingInstruction)node2);
                break;
            }
            default: {
                this.invalidNodeTypeAddException(node2);
            }
        }
    }

    @Override
    public boolean remove(Node node2) {
        switch (node2.getNodeType()) {
            case 1: {
                return this.remove((Element)node2);
            }
            case 8: {
                return this.remove((Comment)node2);
            }
            case 7: {
                return this.remove((ProcessingInstruction)node2);
            }
        }
        this.invalidNodeTypeAddException(node2);
        return false;
    }

    @Override
    public void add(Comment comment) {
        this.addNode(comment);
    }

    @Override
    public void add(Element element) {
        this.addNode(element);
    }

    @Override
    public void add(ProcessingInstruction pi) {
        this.addNode(pi);
    }

    @Override
    public boolean remove(Comment comment) {
        return this.removeNode(comment);
    }

    @Override
    public boolean remove(Element element) {
        return this.removeNode(element);
    }

    @Override
    public boolean remove(ProcessingInstruction pi) {
        return this.removeNode(pi);
    }

    @Override
    public Element elementByID(String elementID) {
        int size = this.nodeCount();
        for (int i2 = 0; i2 < size; ++i2) {
            Node node2 = this.node(i2);
            if (!(node2 instanceof Element)) continue;
            Element element = (Element)node2;
            String id2 = this.elementID(element);
            if (id2 != null && id2.equals(elementID)) {
                return element;
            }
            if ((element = element.elementByID(elementID)) == null) continue;
            return element;
        }
        return null;
    }

    @Override
    public void appendContent(Branch branch) {
        int size = branch.nodeCount();
        for (int i2 = 0; i2 < size; ++i2) {
            Node node2 = branch.node(i2);
            this.add((Node)node2.clone());
        }
    }

    @Override
    public Node node(int index) {
        return this.contentList().get(index);
    }

    @Override
    public int nodeCount() {
        return this.contentList().size();
    }

    @Override
    public int indexOf(Node node2) {
        return this.contentList().indexOf(node2);
    }

    @Override
    public Iterator<Node> nodeIterator() {
        return this.contentList().iterator();
    }

    protected String elementID(Element element) {
        return element.attributeValue("ID");
    }

    protected abstract List<Node> contentList();

    protected List<Node> createContentList() {
        return new ArrayList<Node>(5);
    }

    protected List<Node> createContentList(int size) {
        return new ArrayList<Node>(size);
    }

    protected <T extends Node> BackedList<T> createResultList() {
        return new BackedList(this, this.contentList());
    }

    protected <T extends Node> List<T> createSingleResultList(T result) {
        BackedList<T> list = new BackedList<T>(this, this.contentList(), 1);
        list.addLocal(result);
        return list;
    }

    protected <T extends Node> List<T> createEmptyList() {
        return new BackedList(this, this.contentList(), 0);
    }

    protected abstract void addNode(Node var1);

    protected abstract void addNode(int var1, Node var2);

    protected abstract boolean removeNode(Node var1);

    protected abstract void childAdded(Node var1);

    protected abstract void childRemoved(Node var1);

    protected void contentRemoved() {
        List<Node> content = this.contentList();
        for (Node node2 : content) {
            this.childRemoved(node2);
        }
    }

    protected void invalidNodeTypeAddException(Node node2) {
        throw new IllegalAddException("Invalid node type. Cannot add node: " + node2 + " to this branch: " + this);
    }
}

