/*
 * Decompiled with CFR 0.152.
 */
package net.spaceeye.universal.render;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.spaceeye.universal.render.DrawCallBuilder;
import net.spaceeye.universal.render.ManagedGlState;
import net.spaceeye.universal.render.ScissorState;
import net.spaceeye.universal.render.URenderPipeline;
import net.spaceeye.universal.vertex.UBuiltBuffer;
import net.spaceeye.universal.vertex.UBuiltBufferInternal;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0015B\u0007\u00a2\u0006\u0004\b\u0014\u0010\u0004J\u000f\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0003\u0010\u0004J1\u0010\f\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u00072\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00020\t\u00a2\u0006\u0004\b\f\u0010\rR\u0014\u0010\u000f\u001a\u00020\u000e8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000f\u0010\u0010R\u0018\u0010\u0011\u001a\u0004\u0018\u00010\u00078\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u000e8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0013\u0010\u0010\u00a8\u0006\u0016"}, d2={"Lnet/spaceeye/universal/render/URenderPass;", "Ljava/lang/AutoCloseable;", "", "close", "()V", "Lnet/spaceeye/universal/vertex/UBuiltBuffer;", "builtBuffer", "Lnet/spaceeye/universal/render/URenderPipeline;", "pipeline", "Lkotlin/Function1;", "Lnet/spaceeye/universal/render/DrawCallBuilder;", "configure", "draw", "(Lgg/essential/universal/vertex/UBuiltBuffer;Lgg/essential/universal/render/URenderPipeline;Lkotlin/jvm/functions/Function1;)V", "Lnet/spaceeye/universal/render/ManagedGlState;", "currGlState", "Lnet/spaceeye/universal/render/ManagedGlState;", "currPipeline", "Lnet/spaceeye/universal/render/URenderPipeline;", "prevGlState", "<init>", "DrawCallBuilderImpl", "UniversalCraft 1.20.1-forge"})
public final class URenderPass
implements AutoCloseable {
    @NotNull
    private final ManagedGlState prevGlState = ManagedGlState.Companion.active();
    @NotNull
    private final ManagedGlState currGlState = new ManagedGlState(this.prevGlState);
    @Nullable
    private URenderPipeline currPipeline;

    @Override
    public void close() {
        this.prevGlState.activate(this.currGlState, this.prevGlState, true);
    }

    public final void draw(@NotNull UBuiltBuffer builtBuffer, @NotNull URenderPipeline pipeline, @NotNull Function1<? super DrawCallBuilder, Unit> configure) {
        Intrinsics.checkNotNullParameter((Object)builtBuffer, (String)"builtBuffer");
        Intrinsics.checkNotNullParameter((Object)pipeline, (String)"pipeline");
        Intrinsics.checkNotNullParameter(configure, (String)"configure");
        DrawCallBuilderImpl builder = new DrawCallBuilderImpl(pipeline, (UBuiltBufferInternal)builtBuffer);
        configure.invoke((Object)builder);
        builder.submit();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0014\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0080\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010!\u001a\u00020 \u0012\u0006\u0010\u001e\u001a\u00020\u001d\u00a2\u0006\u0004\b%\u0010&J\u000f\u0010\u0002\u001a\u00020\u0001H\u0016\u00a2\u0006\u0004\b\u0002\u0010\u0003J3\u0010\n\u001a\u00060\u0000R\u00020\t2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\n\u0010\u000bJ\r\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\u001f\u0010\u0011\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u001f\u0010\u0011\u001a\u00020\u00012\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0015J#\u0010\u0019\u001a\u00020\u00012\u0006\u0010\u0014\u001a\u00020\u00132\n\u0010\u0018\u001a\u00020\u0016\"\u00020\u0017H\u0016\u00a2\u0006\u0004\b\u0019\u0010\u001aJ#\u0010\u0019\u001a\u00020\u00012\u0006\u0010\u0014\u001a\u00020\u00132\n\u0010\u0018\u001a\u00020\u001b\"\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0019\u0010\u001cR\u0014\u0010\u001e\u001a\u00020\u001d8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001e\u0010\u001fR\u0014\u0010!\u001a\u00020 8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b!\u0010\"R\u0018\u0010\n\u001a\u0004\u0018\u00010#8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\n\u0010$\u00a8\u0006'"}, d2={"Lnet/spaceeye/universal/render/URenderPass$DrawCallBuilderImpl;", "Lnet/spaceeye/universal/render/DrawCallBuilder;", "noScissor", "()Lgg/essential/universal/render/DrawCallBuilder;", "", "x", "y", "width", "height", "Lnet/spaceeye/universal/render/URenderPass;", "scissor", "(IIII)Lgg/essential/universal/render/URenderPass$DrawCallBuilderImpl;", "", "submit", "()V", "index", "textureGlId", "texture", "(II)Lgg/essential/universal/render/DrawCallBuilder;", "", "name", "(Ljava/lang/String;I)Lgg/essential/universal/render/DrawCallBuilder;", "", "", "values", "uniform", "(Ljava/lang/String;[F)Lgg/essential/universal/render/DrawCallBuilder;", "", "(Ljava/lang/String;[I)Lgg/essential/universal/render/DrawCallBuilder;", "Lnet/spaceeye/universal/vertex/UBuiltBufferInternal;", "builtBuffer", "Lnet/spaceeye/universal/vertex/UBuiltBufferInternal;", "Lnet/spaceeye/universal/render/URenderPipeline;", "pipeline", "Lnet/spaceeye/universal/render/URenderPipeline;", "Lnet/spaceeye/universal/render/ScissorState;", "Lnet/spaceeye/universal/render/ScissorState;", "<init>", "(Lgg/essential/universal/render/URenderPass;Lgg/essential/universal/render/URenderPipeline;Lgg/essential/universal/vertex/UBuiltBufferInternal;)V", "UniversalCraft 1.20.1-forge"})
    public final class DrawCallBuilderImpl
    implements DrawCallBuilder {
        @NotNull
        private final URenderPipeline pipeline;
        @NotNull
        private final UBuiltBufferInternal builtBuffer;
        @Nullable
        private ScissorState scissor;

        public DrawCallBuilderImpl(@NotNull URenderPipeline pipeline, UBuiltBufferInternal builtBuffer) {
            Intrinsics.checkNotNullParameter((Object)pipeline, (String)"pipeline");
            Intrinsics.checkNotNullParameter((Object)builtBuffer, (String)"builtBuffer");
            this.pipeline = pipeline;
            this.builtBuffer = builtBuffer;
            this.pipeline.bind$UniversalCraft_1_20_1_forge();
        }

        @Override
        @NotNull
        public DrawCallBuilder noScissor() {
            DrawCallBuilderImpl drawCallBuilderImpl;
            DrawCallBuilderImpl $this$noScissor_u24lambda_u240 = drawCallBuilderImpl = this;
            boolean bl = false;
            $this$noScissor_u24lambda_u240.scissor = ScissorState.Companion.getDISABLED();
            return drawCallBuilderImpl;
        }

        @Override
        @NotNull
        public DrawCallBuilderImpl scissor(int x, int y, int width, int height) {
            DrawCallBuilderImpl drawCallBuilderImpl;
            DrawCallBuilderImpl $this$scissor_u24lambda_u241 = drawCallBuilderImpl = this;
            boolean bl = false;
            $this$scissor_u24lambda_u241.scissor = new ScissorState(true, x, y, width, height);
            return drawCallBuilderImpl;
        }

        @Override
        @NotNull
        public DrawCallBuilder uniform(@NotNull String name, float ... values) {
            DrawCallBuilderImpl drawCallBuilderImpl;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)values, (String)"values");
            DrawCallBuilderImpl $this$uniform_u24lambda_u242 = drawCallBuilderImpl = this;
            boolean bl = false;
            $this$uniform_u24lambda_u242.pipeline.uniform$UniversalCraft_1_20_1_forge(name, Arrays.copyOf(values, values.length));
            return drawCallBuilderImpl;
        }

        @Override
        @NotNull
        public DrawCallBuilder uniform(@NotNull String name, int ... values) {
            DrawCallBuilderImpl drawCallBuilderImpl;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)values, (String)"values");
            DrawCallBuilderImpl $this$uniform_u24lambda_u243 = drawCallBuilderImpl = this;
            boolean bl = false;
            $this$uniform_u24lambda_u243.pipeline.uniform$UniversalCraft_1_20_1_forge(name, Arrays.copyOf(values, values.length));
            return drawCallBuilderImpl;
        }

        @Override
        @NotNull
        public DrawCallBuilder texture(@NotNull String name, int textureGlId) {
            DrawCallBuilderImpl drawCallBuilderImpl;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            DrawCallBuilderImpl $this$texture_u24lambda_u244 = drawCallBuilderImpl = this;
            boolean bl = false;
            $this$texture_u24lambda_u244.pipeline.texture$UniversalCraft_1_20_1_forge(name, textureGlId);
            return drawCallBuilderImpl;
        }

        @Override
        @NotNull
        public DrawCallBuilder texture(int index, int textureGlId) {
            DrawCallBuilderImpl drawCallBuilderImpl;
            DrawCallBuilderImpl $this$texture_u24lambda_u245 = drawCallBuilderImpl = this;
            boolean bl = false;
            $this$texture_u24lambda_u245.pipeline.texture$UniversalCraft_1_20_1_forge(index, textureGlId);
            return drawCallBuilderImpl;
        }

        public final void submit() {
            if (!Intrinsics.areEqual((Object)URenderPass.this.currPipeline, (Object)this.pipeline)) {
                URenderPass.this.currPipeline = this.pipeline;
                this.pipeline.getGlState$UniversalCraft_1_20_1_forge().activate(URenderPass.this.currGlState, URenderPass.this.prevGlState, false);
            }
            ScissorState prevScissor = null;
            if (this.scissor != null) {
                prevScissor = ScissorState.Companion.active();
                ScissorState scissorState = this.scissor;
                if (scissorState != null) {
                    scissorState.activate();
                }
            }
            this.pipeline.draw$UniversalCraft_1_20_1_forge(this.builtBuffer);
            ScissorState scissorState = prevScissor;
            if (scissorState != null) {
                scissorState.activate();
            }
            this.pipeline.unbind$UniversalCraft_1_20_1_forge();
        }
    }
}

