/*
 * Decompiled with CFR 0.152.
 */
package net.spaceeye.vmod;

import com.google.common.primitives.Ints;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.arguments.DimensionArgument;
import net.minecraft.commands.arguments.coordinates.Vec3Argument;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.spaceeye.valkyrien_ship_schematics.interfaces.IShipSchematic;
import net.spaceeye.valkyrien_ship_schematics.interfaces.v1.IShipSchematicDataV1;
import net.spaceeye.vmod.VMConfig;
import net.spaceeye.vmod.VMKt;
import net.spaceeye.vmod.limits.ServerLimits;
import net.spaceeye.vmod.mixin.ShipObjectWorldAccessor;
import net.spaceeye.vmod.rendering.RenderingData;
import net.spaceeye.vmod.rendering.types.debug.DebugRenderer;
import net.spaceeye.vmod.schematic.VModShipSchematicV2Kt;
import net.spaceeye.vmod.shipAttachments.CustomMassSave;
import net.spaceeye.vmod.shipAttachments.GravityController;
import net.spaceeye.vmod.shipAttachments.PhysgunController;
import net.spaceeye.vmod.shipAttachments.ThrustersController;
import net.spaceeye.vmod.shipAttachments.WeightSynchronizer;
import net.spaceeye.vmod.toolgun.PlayerAccessManager;
import net.spaceeye.vmod.toolgun.modes.state.PlayerSchematics;
import net.spaceeye.vmod.utils.Vector3d;
import net.spaceeye.vmod.utils.vs.TeleportShipWithConnectedKt;
import net.spaceeye.vmod.utils.vs.TraverseGetConnectedShipsKt;
import net.spaceeye.vmod.vsStuff.VSGravityManager;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaterniond;
import org.joml.Quaterniondc;
import org.joml.Vector3dc;
import org.valkyrienskies.core.api.ships.LoadedServerShip;
import org.valkyrienskies.core.api.ships.LoadedShip;
import org.valkyrienskies.core.api.ships.QueryableShipData;
import org.valkyrienskies.core.api.ships.ServerShip;
import org.valkyrienskies.core.api.ships.Ship;
import org.valkyrienskies.core.apigame.world.ServerShipWorldCore;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import org.valkyrienskies.mod.common.command.RelativeVector3Argument;
import org.valkyrienskies.mod.common.command.ShipArgument;
import org.valkyrienskies.mod.common.command.VSCommandsKt;
import org.valkyrienskies.mod.common.util.VectorConversionsMCKt;
import org.valkyrienskies.mod.mixinducks.feature.command.VSCommandSource;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u000256B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J9\u0010\u0004\u001a&\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006 \u0007*\u0012\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006\u0018\u00010\u00050\u00052\u0006\u0010\b\u001a\u00020\tH\u0002\u00a2\u0006\u0002\u0010\nJi\u0010\u000b\u001aB\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006\u0012\f\u0012\n \u0007*\u0004\u0018\u0001H\rH\r \u0007* \u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006\u0012\f\u0012\n \u0007*\u0004\u0018\u0001H\rH\r\u0018\u00010\f0\f\"\u0004\b\u0000\u0010\r2\u0006\u0010\b\u001a\u00020\t2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\r0\u000fH\u0002\u00a2\u0006\u0002\u0010\u0010J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0006H\u0002J\u001c\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00060 H\u0002J\u0016\u0010!\u001a\u00020\u00122\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00060 H\u0002J\u0016\u0010\"\u001a\u00020\u00122\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00060 H\u0002J\u0016\u0010#\u001a\u00020\u00122\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00060 H\u0002J\u0016\u0010$\u001a\u00020\u00122\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00060 H\u0002J\u0016\u0010&\u001a\u00020\u00122\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00060 H\u0002J\u001e\u0010)\u001a\u00020\u00122\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00060 2\u0006\u0010*\u001a\u00020\u001aH\u0002J\u0016\u0010+\u001a\u00020\u00122\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00060 H\u0002J\u0016\u0010,\u001a\u00020\u00122\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00060 H\u0002J\u0016\u0010-\u001a\u00020\u00122\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00060 H\u0002J\u0016\u0010.\u001a\u00020\u00122\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00060 H\u0002J\u0016\u0010/\u001a\u00020\u00122\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00060 H\u0002J\u0016\u00100\u001a\u00020\u00122\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00060 H\u0002J\u0014\u00101\u001a\u0002022\f\u00103\u001a\b\u0012\u0004\u0012\u00020\u000604R$\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u00128F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020(X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lnet/spaceeye/vmod/VMCommands;", "", "<init>", "()V", "lt", "Lcom/mojang/brigadier/builder/LiteralArgumentBuilder;", "Lnet/minecraft/commands/CommandSourceStack;", "kotlin.jvm.PlatformType", "name", "", "(Ljava/lang/String;)Lcom/mojang/brigadier/builder/LiteralArgumentBuilder;", "arg", "Lcom/mojang/brigadier/builder/RequiredArgumentBuilder;", "T", "type", "Lcom/mojang/brigadier/arguments/ArgumentType;", "(Ljava/lang/String;Lcom/mojang/brigadier/arguments/ArgumentType;)Lcom/mojang/brigadier/builder/RequiredArgumentBuilder;", "value", "", "permissionLevel", "getPermissionLevel", "()I", "setPermissionLevel", "(I)V", "permissionString", "hasPermission", "", "it", "findClosestShips", "", "Lorg/valkyrienskies/core/api/ships/Ship;", "cc", "Lcom/mojang/brigadier/context/CommandContext;", "teleportCommand", "scaleCommand", "vsDeleteMasslessShips", "saveSchemToServer", "lastName", "loadSchemFromServer", "placeUUID", "Ljava/util/UUID;", "placeServerSchematic", "customName", "setGravityFor", "setGravityForConnected", "setGravityForConnectedAndTouching", "resetGravityFor", "resetGravityForEveryShipIn", "displayShipsInOrder", "registerServerCommands", "", "dispatcher", "Lcom/mojang/brigadier/CommandDispatcher;", "OP", "DEBUG", "VMod"})
@SourceDebugExtension(value={"SMAP\nVMCommands.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VMCommands.kt\nnet/spaceeye/vmod/VMCommands\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,490:1\n766#2:491\n857#2,2:492\n1045#2:494\n766#2:495\n857#2,2:496\n1855#2,2:498\n1603#2,9:500\n1855#2:509\n1856#2:511\n1612#2:512\n1855#2,2:513\n1855#2,2:515\n1603#2,9:517\n1855#2:526\n1856#2:528\n1612#2:529\n1855#2,2:530\n1855#2,2:532\n1603#2,9:534\n1855#2:543\n1856#2:545\n1612#2:546\n1855#2,2:547\n1603#2,9:549\n1855#2:558\n1856#2:560\n1612#2:561\n1855#2,2:562\n1855#2,2:564\n1864#2,3:566\n1#3:510\n1#3:527\n1#3:544\n1#3:559\n*S KotlinDebug\n*F\n+ 1 VMCommands.kt\nnet/spaceeye/vmod/VMCommands\n*L\n88#1:491\n88#1:492,2\n89#1:494\n125#1:495\n125#1:496,2\n126#1:498,2\n202#1:500,9\n202#1:509\n202#1:511\n202#1:512\n203#1:513,2\n214#1:515,2\n224#1:517,9\n224#1:526\n224#1:528\n224#1:529\n225#1:530,2\n236#1:532,2\n246#1:534,9\n246#1:543\n246#1:545\n246#1:546\n247#1:547,2\n258#1:549,9\n258#1:558\n258#1:560\n258#1:561\n259#1:562,2\n267#1:564,2\n184#1:566,3\n202#1:510\n224#1:527\n246#1:544\n258#1:559\n*E\n"})
public final class VMCommands {
    @NotNull
    public static final VMCommands INSTANCE = new VMCommands();
    @NotNull
    public static final String permissionString = "Allow Command Usage";
    @NotNull
    private static String lastName;
    @NotNull
    private static UUID placeUUID;

    private VMCommands() {
    }

    private final LiteralArgumentBuilder<CommandSourceStack> lt(String name) {
        return LiteralArgumentBuilder.literal((String)name);
    }

    private final <T> RequiredArgumentBuilder<CommandSourceStack, T> arg(String name, ArgumentType<T> type) {
        return RequiredArgumentBuilder.argument((String)name, type);
    }

    public final int getPermissionLevel() {
        return VMConfig.INSTANCE.getSERVER().getPERMISSIONS().getVMOD_COMMANDS_PERMISSION_LEVEL();
    }

    public final void setPermissionLevel(int value) {
        VMConfig.INSTANCE.getSERVER().getPERMISSIONS().setVMOD_COMMANDS_PERMISSION_LEVEL(value);
    }

    private final boolean hasPermission(CommandSourceStack it) {
        ServerPlayer serverPlayer;
        try {
            serverPlayer = it.m_81375_();
        }
        catch (Exception e) {
            return false;
        }
        ServerPlayer player = serverPlayer;
        Intrinsics.checkNotNull((Object)player);
        return PlayerAccessManager.INSTANCE.hasPermission(player, permissionString);
    }

    /*
     * WARNING - void declaration
     */
    private final List<Ship> findClosestShips(CommandContext<CommandSourceStack> cc) {
        void $this$sortedBy$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        ServerLevel serverLevel = ((CommandSourceStack)cc.getSource()).m_81372_();
        Intrinsics.checkNotNullExpressionValue((Object)serverLevel, (String)"getLevel(...)");
        String dimensionId = VSGameUtilsKt.getDimensionId((Level)((Level)serverLevel));
        Vec3 vec3 = ((CommandSourceStack)cc.getSource()).m_81371_();
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"getPosition(...)");
        org.joml.Vector3d pos = VectorConversionsMCKt.toJOML((Vec3)vec3);
        Object object = cc.getSource();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getSource(...)");
        Iterable iterable = (Iterable)VSCommandsKt.getShipWorld((CommandSourceStack)((CommandSourceStack)object)).getAllShips();
        boolean $i$f$filter = false;
        void var6_6 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Ship it = (Ship)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getChunkClaimDimension(), (Object)dimensionId)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$sortedBy = false;
        return CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(pos){
            final /* synthetic */ org.joml.Vector3d $pos$inlined;
            {
                this.$pos$inlined = vector3d;
            }

            public final int compare(T a, T b) {
                Ship it = (Ship)a;
                boolean bl = false;
                Comparable comparable = Double.valueOf(it.getTransform().getPositionInWorld().distanceSquared((Vector3dc)this.$pos$inlined));
                it = (Ship)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Double.valueOf(it.getTransform().getPositionInWorld().distanceSquared((Vector3dc)this.$pos$inlined)));
            }
        });
    }

    private final int teleportCommand(CommandContext<CommandSourceStack> cc) {
        Quaterniondc quaterniondc;
        Object object = cc.getSource();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type net.minecraft.commands.CommandSourceStack");
        CommandSourceStack source = (CommandSourceStack)object;
        Intrinsics.checkNotNull(cc, (String)"null cannot be cast to non-null type com.mojang.brigadier.context.CommandContext<org.valkyrienskies.mod.mixinducks.feature.command.VSCommandSource>");
        Ship ship = ShipArgument.Companion.getShip(cc, "ship");
        Intrinsics.checkNotNull((Object)ship, (String)"null cannot be cast to non-null type org.valkyrienskies.core.api.ships.ServerShip");
        ServerShip mainShip = (ServerShip)ship;
        Vec3 position = Vec3Argument.m_120844_(cc, (String)"position");
        Object object2 = cc.getSource();
        Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type net.minecraft.commands.CommandSourceStack");
        ServerLevel serverLevel = ((CommandSourceStack)object2).m_81372_();
        Intrinsics.checkNotNullExpressionValue((Object)serverLevel, (String)"getLevel(...)");
        String dimensionId = VSGameUtilsKt.getDimensionId((Level)((Level)serverLevel));
        try {
            quaterniondc = (Quaterniondc)RelativeVector3Argument.Companion.getRelativeVector3(cc, "euler-angles").toEulerRotation(0.0, 0.0, 0.0);
        }
        catch (Exception e) {
            quaterniondc = mainShip.getTransform().getShipToWorldRotation();
        }
        Quaterniondc rotation = quaterniondc;
        ServerLevel serverLevel2 = source.m_81372_();
        Intrinsics.checkNotNullExpressionValue((Object)serverLevel2, (String)"getLevel(...)");
        Intrinsics.checkNotNull((Object)position);
        TeleportShipWithConnectedKt.teleportShipWithConnected(serverLevel2, mainShip, new Vector3d(position), rotation, null, dimensionId);
        return 0;
    }

    private final int scaleCommand(CommandContext<CommandSourceStack> cc) {
        Object object = cc.getSource();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type net.minecraft.commands.CommandSourceStack");
        CommandSourceStack source = (CommandSourceStack)object;
        ServerLevel serverLevel = ((CommandSourceStack)cc.getSource()).m_81372_();
        Intrinsics.checkNotNullExpressionValue((Object)serverLevel, (String)"getLevel(...)");
        String dimensionId = VSGameUtilsKt.getDimensionId((Level)((Level)serverLevel));
        Intrinsics.checkNotNull(cc, (String)"null cannot be cast to non-null type com.mojang.brigadier.context.CommandContext<org.valkyrienskies.mod.mixinducks.feature.command.VSCommandSource>");
        Ship ship = ShipArgument.Companion.getShip(cc, "ship");
        Intrinsics.checkNotNull((Object)ship, (String)"null cannot be cast to non-null type org.valkyrienskies.core.api.ships.ServerShip");
        ServerShip mainShip = (ServerShip)ship;
        double scale = DoubleArgumentType.getDouble(cc, (String)"scale");
        ServerLevel serverLevel2 = source.m_81372_();
        Intrinsics.checkNotNullExpressionValue((Object)serverLevel2, (String)"getLevel(...)");
        TeleportShipWithConnectedKt.teleportShipWithConnected(serverLevel2, mainShip, new Vector3d(mainShip.getTransform().getPositionInWorld()), mainShip.getTransform().getShipToWorldRotation(), scale, dimensionId);
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    private final int vsDeleteMasslessShips(CommandContext<CommandSourceStack> cc) {
        void $this$filterTo$iv$iv;
        ServerShipWorldCore shipObjectWorld = VSGameUtilsKt.getShipObjectWorld((ServerLevel)((CommandSourceStack)cc.getSource()).m_81372_());
        Iterable $this$filter$iv = (Iterable)shipObjectWorld.getAllShips();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ServerShip it = (ServerShip)element$iv$iv;
            boolean bl = false;
            if (!(it.getInertiaData().getMass() == 0.0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ServerShip it = (ServerShip)element$iv;
            boolean bl = false;
            shipObjectWorld.deleteShip(it);
        }
        return 0;
    }

    private final int saveSchemToServer(CommandContext<CommandSourceStack> cc) {
        UUID uUID;
        String name = StringArgumentType.getString(cc, (String)"name");
        try {
            uUID = ((CommandSourceStack)cc.getSource()).m_81375_().m_20148_();
        }
        catch (Exception e) {
            VMKt.ELOG("Failed to save schematic to server because user is not a player");
            return 1;
        }
        UUID uuid = uUID;
        IShipSchematic iShipSchematic = PlayerSchematics.INSTANCE.getSchematics().get(uuid);
        if (iShipSchematic == null) {
            VMCommands $this$saveSchemToServer_u24lambda_u244 = this;
            boolean bl = false;
            ((CommandSourceStack)cc.getSource()).m_81375_().m_213846_((Component)Component.m_237113_((String)"Failed to save schematic to sever because player has no schematic chosen. Choose schematic with a toolgun and try again."));
            return 1;
        }
        IShipSchematic schem = iShipSchematic;
        Intrinsics.checkNotNull((Object)name);
        PlayerSchematics.INSTANCE.saveSchematic(name, schem);
        return 0;
    }

    private final int loadSchemFromServer(CommandContext<CommandSourceStack> cc) {
        String name = StringArgumentType.getString(cc, (String)"name");
        UUID uuid = new UUID(0L, 0L);
        Path path = Paths.get("VMod-Schematics/" + name, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        IShipSchematic iShipSchematic = PlayerSchematics.INSTANCE.loadSchematic(path);
        if (iShipSchematic == null) {
            VMCommands $this$loadSchemFromServer_u24lambda_u245 = this;
            boolean bl = false;
            VMKt.ELOG("Failed to load schematic because name doesn't exist.");
            return 1;
        }
        IShipSchematic schem = iShipSchematic;
        PlayerSchematics.INSTANCE.getSchematics().put(uuid, schem);
        lastName = name;
        return 0;
    }

    private final int placeServerSchematic(CommandContext<CommandSourceStack> cc, boolean customName) {
        String e2;
        Quaterniond quaterniond;
        UUID uuid = new UUID(0L, 0L);
        Vec3 position = Vec3Argument.m_120844_(cc, (String)"position");
        try {
            Intrinsics.checkNotNull(cc, (String)"null cannot be cast to non-null type com.mojang.brigadier.context.CommandContext<net.minecraft.commands.CommandSourceStack?>");
            quaterniond = RelativeVector3Argument.Companion.getRelativeVector3(cc, "rotation").toEulerRotation(0.0, 0.0, 0.0);
        }
        catch (Exception e2) {
            quaterniond = new Quaterniond();
        }
        Quaterniond rotation = quaterniond;
        try {
            e2 = StringArgumentType.getString(cc, (String)"name");
        }
        catch (Exception e3) {
            e2 = lastName;
        }
        String name = e2;
        IShipSchematic iShipSchematic = PlayerSchematics.INSTANCE.getSchematics().get(uuid);
        if (iShipSchematic == null) {
            VMCommands $this$placeServerSchematic_u24lambda_u246 = this;
            boolean bl = false;
            VMKt.ELOG("failed to place schematic because it's null.");
            return 1;
        }
        IShipSchematic schem = iShipSchematic;
        placeUUID = new UUID(placeUUID.getMostSignificantBits(), placeUUID.getLeastSignificantBits() + 1L);
        IShipSchematicDataV1 iShipSchematicDataV1 = (IShipSchematicDataV1)schem;
        ServerLevel serverLevel = ((CommandSourceStack)cc.getSource()).m_81372_();
        Intrinsics.checkNotNullExpressionValue((Object)serverLevel, (String)"getLevel(...)");
        Intrinsics.checkNotNull((Object)position);
        VModShipSchematicV2Kt.placeAt$default(iShipSchematicDataV1, serverLevel, null, placeUUID, new Vector3d(position).toJomlVector3d(), (Quaterniondc)rotation, null, arg_0 -> VMCommands.placeServerSchematic$lambda$8(customName, name, arg_0), 32, null);
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    private final int setGravityFor(CommandContext<CommandSourceStack> cc) {
        void $this$forEach$iv;
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv;
        Intrinsics.checkNotNull(cc, (String)"null cannot be cast to non-null type com.mojang.brigadier.context.CommandContext<org.valkyrienskies.mod.mixinducks.feature.command.VSCommandSource>");
        Set ships = ShipArgument.Companion.getShips(cc, "ships");
        QueryableShipData loaded = ((VSCommandSource)cc.getSource()).getShipWorld().getLoadedShips();
        double x = DoubleArgumentType.getDouble(cc, (String)"x");
        double y = DoubleArgumentType.getDouble(cc, (String)"y");
        double z = DoubleArgumentType.getDouble(cc, (String)"z");
        Iterable iterable = ships;
        boolean $i$f$mapNotNull = false;
        Iterator iterator = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            LoadedShip it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            Ship it = (Ship)element$iv$iv;
            boolean bl2 = false;
            if ((LoadedShip)loaded.getById(it.getId()) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            LoadedShip it = (LoadedShip)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type org.valkyrienskies.core.api.ships.LoadedServerShip");
            GravityController.Companion.getOrCreate((LoadedServerShip)it).setGravityVector(new Vector3d(x, y, z));
        }
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    private final int setGravityForConnected(CommandContext<CommandSourceStack> cc) {
        void $this$forEach$iv;
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv;
        Intrinsics.checkNotNull(cc, (String)"null cannot be cast to non-null type com.mojang.brigadier.context.CommandContext<org.valkyrienskies.mod.mixinducks.feature.command.VSCommandSource>");
        Set ships = ShipArgument.Companion.getShips(cc, "ships");
        QueryableShipData loaded = ((VSCommandSource)cc.getSource()).getShipWorld().getLoadedShips();
        Set traversed = new LinkedHashSet();
        Iterable $this$forEach$iv2 = ships;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv2) {
            Ship it = (Ship)element$iv;
            boolean bl = false;
            if (traversed.contains(it.getId())) continue;
            traversed.addAll((Collection)TraverseGetConnectedShipsKt.traverseGetConnectedShips$default(it.getId(), traversed, false, 4, null).getTraversedShipIds());
        }
        double x = DoubleArgumentType.getDouble(cc, (String)"x");
        double y = DoubleArgumentType.getDouble(cc, (String)"y");
        double z = DoubleArgumentType.getDouble(cc, (String)"z");
        Iterable iterable = traversed;
        boolean $i$f$mapNotNull = false;
        Iterator iterator = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach2 = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            LoadedShip it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            long it = ((Number)element$iv$iv).longValue();
            boolean bl2 = false;
            if ((LoadedShip)loaded.getById(it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$forEach3 = false;
        for (Object element$iv : $this$forEach$iv) {
            LoadedShip it = (LoadedShip)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type org.valkyrienskies.core.api.ships.LoadedServerShip");
            GravityController.Companion.getOrCreate((LoadedServerShip)it).setGravityVector(new Vector3d(x, y, z));
        }
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    private final int setGravityForConnectedAndTouching(CommandContext<CommandSourceStack> cc) {
        void $this$forEach$iv;
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv;
        Intrinsics.checkNotNull(cc, (String)"null cannot be cast to non-null type com.mojang.brigadier.context.CommandContext<org.valkyrienskies.mod.mixinducks.feature.command.VSCommandSource>");
        Set ships = ShipArgument.Companion.getShips(cc, "ships");
        QueryableShipData loaded = ((VSCommandSource)cc.getSource()).getShipWorld().getLoadedShips();
        Set traversed = new LinkedHashSet();
        Iterable $this$forEach$iv2 = ships;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv2) {
            Ship it = (Ship)element$iv;
            boolean bl = false;
            if (traversed.contains(it.getId())) continue;
            ServerLevel serverLevel = ((CommandSourceStack)cc.getSource()).m_81372_();
            Intrinsics.checkNotNullExpressionValue((Object)serverLevel, (String)"getLevel(...)");
            traversed.addAll(TraverseGetConnectedShipsKt.traverseGetAllTouchingShips$default(serverLevel, it.getId(), traversed, false, 8, null));
        }
        double x = DoubleArgumentType.getDouble(cc, (String)"x");
        double y = DoubleArgumentType.getDouble(cc, (String)"y");
        double z = DoubleArgumentType.getDouble(cc, (String)"z");
        Iterable iterable = traversed;
        boolean $i$f$mapNotNull = false;
        Iterator iterator = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach2 = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            LoadedShip it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            long it = ((Number)element$iv$iv).longValue();
            boolean bl2 = false;
            if ((LoadedShip)loaded.getById(it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$forEach3 = false;
        for (Object element$iv : $this$forEach$iv) {
            LoadedShip it = (LoadedShip)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type org.valkyrienskies.core.api.ships.LoadedServerShip");
            GravityController.Companion.getOrCreate((LoadedServerShip)it).setGravityVector(new Vector3d(x, y, z));
        }
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    private final int resetGravityFor(CommandContext<CommandSourceStack> cc) {
        void $this$forEach$iv;
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv;
        Intrinsics.checkNotNull(cc, (String)"null cannot be cast to non-null type com.mojang.brigadier.context.CommandContext<org.valkyrienskies.mod.mixinducks.feature.command.VSCommandSource>");
        Set ships = ShipArgument.Companion.getShips(cc, "ships");
        QueryableShipData loaded = ((VSCommandSource)cc.getSource()).getShipWorld().getLoadedShips();
        Iterable iterable = ships;
        boolean $i$f$mapNotNull = false;
        Iterator iterator = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            LoadedShip it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            Ship it = (Ship)element$iv$iv;
            boolean bl2 = false;
            if ((LoadedShip)loaded.getById(it.getId()) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            LoadedShip it = (LoadedShip)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type org.valkyrienskies.core.api.ships.LoadedServerShip");
            GravityController.Companion.getOrCreate((LoadedServerShip)it).reset();
        }
        return 0;
    }

    private final int resetGravityForEveryShipIn(CommandContext<CommandSourceStack> cc) {
        Object object = cc.getSource();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getSource(...)");
        QueryableShipData loaded = VSCommandsKt.getShipWorld((CommandSourceStack)((CommandSourceStack)object)).getLoadedShips();
        Iterable $this$forEach$iv = (Iterable)loaded;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LoadedShip it = (LoadedShip)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type org.valkyrienskies.core.api.ships.LoadedServerShip");
            GravityController.Companion.getOrCreate((LoadedServerShip)it).reset();
        }
        return 0;
    }

    private final int displayShipsInOrder(CommandContext<CommandSourceStack> cc) {
        int e2;
        ServerPlayer serverPlayer;
        try {
            serverPlayer = ((CommandSourceStack)cc.getSource()).m_81375_();
        }
        catch (Exception e2) {
            return 1;
        }
        ServerPlayer player = serverPlayer;
        try {
            e2 = IntegerArgumentType.getInteger(cc, (String)"page") - 1;
        }
        catch (Exception e22) {
            e2 = 0;
        }
        int page = e2;
        List<Ship> ordered = this.findClosestShips(cc);
        int[] e22 = new int[]{page, ordered.size() / 10};
        int e22 = Ints.min((int[])e22);
        int n = 0;
        page = Math.max(e22, n);
        int start = page * 10;
        List ships = new ArrayList();
        Object object = new int[]{start + 10, ordered.size()};
        int i2 = Ints.min((int[])object) - 1;
        if (start <= i2) {
            while (true) {
                ships.add(ordered.get(i2));
                if (i2 == start) break;
                --i2;
            }
        }
        Object string = "";
        object = ships.iterator();
        while (object.hasNext()) {
            Ship ship = (Ship)object.next();
            BlockPos bpos = new Vector3d(ship.getTransform().getPositionInWorld()).toBlockPos();
            string = (String)string + ship.getSlug() + " |||| " + (int)ship.getTransform().getPositionInWorld().distance(player.m_20185_(), player.m_20186_(), player.m_20189_()) + " |||| x=" + bpos.m_123341_() + " y=" + bpos.m_123342_() + " z=" + bpos.m_123343_() + " \n";
        }
        string = (String)string + "Page: " + (page + 1) + "/" + (ordered.size() / 10 + 1);
        player.m_213846_((Component)Component.m_237113_((String)string));
        return 0;
    }

    public final void registerServerCommands(@NotNull CommandDispatcher<CommandSourceStack> dispatcher) {
        Intrinsics.checkNotNullParameter(dispatcher, (String)"dispatcher");
        LiteralArgumentBuilder literalArgumentBuilder = (LiteralArgumentBuilder)this.lt("vmod").requires(VMCommands::registerServerCommands$lambda$20);
        LiteralArgumentBuilder<CommandSourceStack> literalArgumentBuilder2 = this.lt("teleport");
        RequiredArgumentBuilder requiredArgumentBuilder = this.arg("ship", (ArgumentType)ShipArgument.Companion.ships());
        Vec3Argument vec3Argument = Vec3Argument.m_120841_();
        Intrinsics.checkNotNullExpressionValue((Object)vec3Argument, (String)"vec3(...)");
        LiteralArgumentBuilder literalArgumentBuilder3 = (LiteralArgumentBuilder)literalArgumentBuilder.then(literalArgumentBuilder2.then(requiredArgumentBuilder.then(((RequiredArgumentBuilder)this.arg("position", (ArgumentType)vec3Argument).executes(VMCommands::registerServerCommands$lambda$21)).then(this.arg("euler-angles", (ArgumentType)RelativeVector3Argument.Companion.relativeVector3()).executes(VMCommands::registerServerCommands$lambda$22)))));
        LiteralArgumentBuilder<CommandSourceStack> literalArgumentBuilder4 = this.lt("scale");
        RequiredArgumentBuilder requiredArgumentBuilder2 = this.arg("ship", (ArgumentType)ShipArgument.Companion.ships());
        DoubleArgumentType doubleArgumentType = DoubleArgumentType.doubleArg((double)ServerLimits.INSTANCE.getInstance().getScale().getMinValue(), (double)ServerLimits.INSTANCE.getInstance().getScale().getMaxValue());
        Intrinsics.checkNotNullExpressionValue((Object)doubleArgumentType, (String)"doubleArg(...)");
        LiteralArgumentBuilder literalArgumentBuilder5 = (LiteralArgumentBuilder)((LiteralArgumentBuilder)literalArgumentBuilder3.then(literalArgumentBuilder4.then(requiredArgumentBuilder2.then(this.arg("scale", (ArgumentType)doubleArgumentType).executes(VMCommands::registerServerCommands$lambda$23))))).then(this.lt("vs-delete-massless-ships").executes(VMCommands::registerServerCommands$lambda$24));
        LiteralArgumentBuilder literalArgumentBuilder6 = (LiteralArgumentBuilder)this.lt("display-ships-in-order").executes(VMCommands::registerServerCommands$lambda$25);
        IntegerArgumentType integerArgumentType = IntegerArgumentType.integer((int)1);
        Intrinsics.checkNotNullExpressionValue((Object)integerArgumentType, (String)"integer(...)");
        LiteralArgumentBuilder literalArgumentBuilder7 = (LiteralArgumentBuilder)literalArgumentBuilder5.then(literalArgumentBuilder6.then(this.arg("page", (ArgumentType)integerArgumentType).executes(VMCommands::registerServerCommands$lambda$26)));
        LiteralArgumentBuilder<CommandSourceStack> literalArgumentBuilder8 = this.lt("schem");
        LiteralArgumentBuilder<CommandSourceStack> literalArgumentBuilder9 = this.lt("save-to-sever");
        StringArgumentType stringArgumentType = StringArgumentType.string();
        Intrinsics.checkNotNullExpressionValue((Object)stringArgumentType, (String)"string(...)");
        LiteralArgumentBuilder literalArgumentBuilder10 = (LiteralArgumentBuilder)literalArgumentBuilder8.then(literalArgumentBuilder9.then(this.arg("name", (ArgumentType)stringArgumentType).executes(VMCommands::registerServerCommands$lambda$27)));
        LiteralArgumentBuilder<CommandSourceStack> literalArgumentBuilder11 = this.lt("load-from-sever");
        StringArgumentType stringArgumentType2 = StringArgumentType.string();
        Intrinsics.checkNotNullExpressionValue((Object)stringArgumentType2, (String)"string(...)");
        LiteralArgumentBuilder literalArgumentBuilder12 = (LiteralArgumentBuilder)literalArgumentBuilder10.then(literalArgumentBuilder11.then(this.arg("name", (ArgumentType)stringArgumentType2).executes(VMCommands::registerServerCommands$lambda$28)));
        LiteralArgumentBuilder<CommandSourceStack> literalArgumentBuilder13 = this.lt("place");
        Vec3Argument vec3Argument2 = Vec3Argument.m_120841_();
        Intrinsics.checkNotNullExpressionValue((Object)vec3Argument2, (String)"vec3(...)");
        RequiredArgumentBuilder requiredArgumentBuilder3 = (RequiredArgumentBuilder)this.arg("position", (ArgumentType)vec3Argument2).executes(VMCommands::registerServerCommands$lambda$29);
        RequiredArgumentBuilder requiredArgumentBuilder4 = (RequiredArgumentBuilder)this.arg("rotation", (ArgumentType)RelativeVector3Argument.Companion.relativeVector3()).executes(VMCommands::registerServerCommands$lambda$30);
        StringArgumentType stringArgumentType3 = StringArgumentType.string();
        Intrinsics.checkNotNullExpressionValue((Object)stringArgumentType3, (String)"string(...)");
        LiteralArgumentBuilder literalArgumentBuilder14 = (LiteralArgumentBuilder)literalArgumentBuilder12.then(literalArgumentBuilder13.then(requiredArgumentBuilder3.then(requiredArgumentBuilder4.then(this.arg("name", (ArgumentType)stringArgumentType3).executes(VMCommands::registerServerCommands$lambda$31)))));
        LiteralArgumentBuilder<CommandSourceStack> literalArgumentBuilder15 = this.lt("place-no-custom-name");
        Vec3Argument vec3Argument3 = Vec3Argument.m_120841_();
        Intrinsics.checkNotNullExpressionValue((Object)vec3Argument3, (String)"vec3(...)");
        LiteralArgumentBuilder literalArgumentBuilder16 = (LiteralArgumentBuilder)literalArgumentBuilder7.then(literalArgumentBuilder14.then(literalArgumentBuilder15.then(((RequiredArgumentBuilder)this.arg("position", (ArgumentType)vec3Argument3).executes(VMCommands::registerServerCommands$lambda$32)).then(this.arg("rotation", (ArgumentType)RelativeVector3Argument.Companion.relativeVector3()).executes(VMCommands::registerServerCommands$lambda$33)))));
        LiteralArgumentBuilder<CommandSourceStack> literalArgumentBuilder17 = this.lt("gravity");
        LiteralArgumentBuilder<CommandSourceStack> literalArgumentBuilder18 = this.lt("set-for");
        RequiredArgumentBuilder requiredArgumentBuilder5 = this.arg("ships", (ArgumentType)ShipArgument.Companion.ships());
        DoubleArgumentType doubleArgumentType2 = DoubleArgumentType.doubleArg();
        Intrinsics.checkNotNullExpressionValue((Object)doubleArgumentType2, (String)"doubleArg(...)");
        RequiredArgumentBuilder requiredArgumentBuilder6 = this.arg("x", (ArgumentType)doubleArgumentType2);
        DoubleArgumentType doubleArgumentType3 = DoubleArgumentType.doubleArg();
        Intrinsics.checkNotNullExpressionValue((Object)doubleArgumentType3, (String)"doubleArg(...)");
        RequiredArgumentBuilder requiredArgumentBuilder7 = this.arg("y", (ArgumentType)doubleArgumentType3);
        DoubleArgumentType doubleArgumentType4 = DoubleArgumentType.doubleArg();
        Intrinsics.checkNotNullExpressionValue((Object)doubleArgumentType4, (String)"doubleArg(...)");
        LiteralArgumentBuilder literalArgumentBuilder19 = (LiteralArgumentBuilder)literalArgumentBuilder17.then(literalArgumentBuilder18.then(requiredArgumentBuilder5.then(requiredArgumentBuilder6.then(requiredArgumentBuilder7.then(this.arg("z", (ArgumentType)doubleArgumentType4).executes(VMCommands::registerServerCommands$lambda$34))))));
        LiteralArgumentBuilder<CommandSourceStack> literalArgumentBuilder20 = this.lt("set-for-connected");
        RequiredArgumentBuilder requiredArgumentBuilder8 = this.arg("ships", (ArgumentType)ShipArgument.Companion.ships());
        DoubleArgumentType doubleArgumentType5 = DoubleArgumentType.doubleArg();
        Intrinsics.checkNotNullExpressionValue((Object)doubleArgumentType5, (String)"doubleArg(...)");
        RequiredArgumentBuilder requiredArgumentBuilder9 = this.arg("x", (ArgumentType)doubleArgumentType5);
        DoubleArgumentType doubleArgumentType6 = DoubleArgumentType.doubleArg();
        Intrinsics.checkNotNullExpressionValue((Object)doubleArgumentType6, (String)"doubleArg(...)");
        RequiredArgumentBuilder requiredArgumentBuilder10 = this.arg("y", (ArgumentType)doubleArgumentType6);
        DoubleArgumentType doubleArgumentType7 = DoubleArgumentType.doubleArg();
        Intrinsics.checkNotNullExpressionValue((Object)doubleArgumentType7, (String)"doubleArg(...)");
        LiteralArgumentBuilder literalArgumentBuilder21 = (LiteralArgumentBuilder)literalArgumentBuilder19.then(literalArgumentBuilder20.then(requiredArgumentBuilder8.then(requiredArgumentBuilder9.then(requiredArgumentBuilder10.then(this.arg("z", (ArgumentType)doubleArgumentType7).executes(VMCommands::registerServerCommands$lambda$35))))));
        LiteralArgumentBuilder<CommandSourceStack> literalArgumentBuilder22 = this.lt("set-for-connected-and-touching");
        RequiredArgumentBuilder requiredArgumentBuilder11 = this.arg("ships", (ArgumentType)ShipArgument.Companion.ships());
        DoubleArgumentType doubleArgumentType8 = DoubleArgumentType.doubleArg();
        Intrinsics.checkNotNullExpressionValue((Object)doubleArgumentType8, (String)"doubleArg(...)");
        RequiredArgumentBuilder requiredArgumentBuilder12 = this.arg("x", (ArgumentType)doubleArgumentType8);
        DoubleArgumentType doubleArgumentType9 = DoubleArgumentType.doubleArg();
        Intrinsics.checkNotNullExpressionValue((Object)doubleArgumentType9, (String)"doubleArg(...)");
        RequiredArgumentBuilder requiredArgumentBuilder13 = this.arg("y", (ArgumentType)doubleArgumentType9);
        DoubleArgumentType doubleArgumentType10 = DoubleArgumentType.doubleArg();
        Intrinsics.checkNotNullExpressionValue((Object)doubleArgumentType10, (String)"doubleArg(...)");
        LiteralArgumentBuilder literalArgumentBuilder23 = (LiteralArgumentBuilder)((LiteralArgumentBuilder)literalArgumentBuilder21.then(literalArgumentBuilder22.then(requiredArgumentBuilder11.then(requiredArgumentBuilder12.then(requiredArgumentBuilder13.then(this.arg("z", (ArgumentType)doubleArgumentType10).executes(VMCommands::registerServerCommands$lambda$36))))))).then(this.lt("reset-for").then(this.arg("ships", (ArgumentType)ShipArgument.Companion.ships()).executes(VMCommands::registerServerCommands$lambda$37)));
        LiteralArgumentBuilder<CommandSourceStack> literalArgumentBuilder24 = this.lt("reset-for-every-ship-in");
        DimensionArgument dimensionArgument = DimensionArgument.m_88805_();
        Intrinsics.checkNotNullExpressionValue((Object)dimensionArgument, (String)"dimension(...)");
        LiteralArgumentBuilder literalArgumentBuilder25 = (LiteralArgumentBuilder)literalArgumentBuilder16.then(literalArgumentBuilder23.then(literalArgumentBuilder24.then(this.arg("dimension", (ArgumentType)dimensionArgument).executes(VMCommands::registerServerCommands$lambda$38))));
        LiteralArgumentBuilder literalArgumentBuilder26 = (LiteralArgumentBuilder)this.lt("op").requires(VMCommands::registerServerCommands$lambda$39);
        LiteralArgumentBuilder<CommandSourceStack> literalArgumentBuilder27 = this.lt("set-command-permission-level");
        IntegerArgumentType integerArgumentType2 = IntegerArgumentType.integer((int)0, (int)4);
        Intrinsics.checkNotNullExpressionValue((Object)integerArgumentType2, (String)"integer(...)");
        LiteralArgumentBuilder literalArgumentBuilder28 = (LiteralArgumentBuilder)literalArgumentBuilder26.then(literalArgumentBuilder27.then(this.arg("level", (ArgumentType)integerArgumentType2).executes(VMCommands::registerServerCommands$lambda$40)));
        LiteralArgumentBuilder<CommandSourceStack> literalArgumentBuilder29 = this.lt("set-dimension-gravity");
        DimensionArgument dimensionArgument2 = DimensionArgument.m_88805_();
        Intrinsics.checkNotNullExpressionValue((Object)dimensionArgument2, (String)"dimension(...)");
        RequiredArgumentBuilder requiredArgumentBuilder14 = this.arg("dimension", (ArgumentType)dimensionArgument2);
        DoubleArgumentType doubleArgumentType11 = DoubleArgumentType.doubleArg();
        Intrinsics.checkNotNullExpressionValue((Object)doubleArgumentType11, (String)"doubleArg(...)");
        RequiredArgumentBuilder requiredArgumentBuilder15 = this.arg("x", (ArgumentType)doubleArgumentType11);
        DoubleArgumentType doubleArgumentType12 = DoubleArgumentType.doubleArg();
        Intrinsics.checkNotNullExpressionValue((Object)doubleArgumentType12, (String)"doubleArg(...)");
        RequiredArgumentBuilder requiredArgumentBuilder16 = this.arg("y", (ArgumentType)doubleArgumentType12);
        DoubleArgumentType doubleArgumentType13 = DoubleArgumentType.doubleArg();
        Intrinsics.checkNotNullExpressionValue((Object)doubleArgumentType13, (String)"doubleArg(...)");
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)literalArgumentBuilder25.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)literalArgumentBuilder28.then(literalArgumentBuilder29.then(requiredArgumentBuilder14.then(requiredArgumentBuilder15.then(requiredArgumentBuilder16.then(this.arg("z", (ArgumentType)doubleArgumentType13).executes(VMCommands::registerServerCommands$lambda$41))))))).then(this.lt("clear-vmod-attachments").executes(VMCommands::registerServerCommands$lambda$42))).then(this.lt("delete-phys-entities").executes(VMCommands::registerServerCommands$lambda$43)))).then(((LiteralArgumentBuilder)this.lt("debug").requires(VMCommands::registerServerCommands$lambda$44)).then(this.lt("remove-debug-renderers").executes(VMCommands::registerServerCommands$lambda$45))));
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit placeServerSchematic$lambda$8(boolean $customName, String $name, List ships) {
        Intrinsics.checkNotNullParameter((Object)ships, (String)"ships");
        if (!$customName) {
            return Unit.INSTANCE;
        }
        if (ships.size() == 1) {
            ((ServerShip)ships.get(0)).setSlug($name);
            return Unit.INSTANCE;
        }
        Iterable $this$forEachIndexed$iv = ships;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void it;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            ServerShip serverShip = (ServerShip)item$iv;
            int i2 = n;
            boolean bl = false;
            it.setSlug($name + i2);
        }
        return Unit.INSTANCE;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean registerServerCommands$lambda$20(CommandSourceStack it) {
        if (it.m_6761_(INSTANCE.getPermissionLevel())) return true;
        Intrinsics.checkNotNull((Object)it);
        if (!INSTANCE.hasPermission(it)) return false;
        return true;
    }

    private static final int registerServerCommands$lambda$21(CommandContext it) {
        Intrinsics.checkNotNull((Object)it);
        return INSTANCE.teleportCommand((CommandContext<CommandSourceStack>)it);
    }

    private static final int registerServerCommands$lambda$22(CommandContext it) {
        Intrinsics.checkNotNull((Object)it);
        return INSTANCE.teleportCommand((CommandContext<CommandSourceStack>)it);
    }

    private static final int registerServerCommands$lambda$23(CommandContext it) {
        Intrinsics.checkNotNull((Object)it);
        return INSTANCE.scaleCommand((CommandContext<CommandSourceStack>)it);
    }

    private static final int registerServerCommands$lambda$24(CommandContext it) {
        Intrinsics.checkNotNull((Object)it);
        return INSTANCE.vsDeleteMasslessShips((CommandContext<CommandSourceStack>)it);
    }

    private static final int registerServerCommands$lambda$25(CommandContext it) {
        Intrinsics.checkNotNull((Object)it);
        return INSTANCE.displayShipsInOrder((CommandContext<CommandSourceStack>)it);
    }

    private static final int registerServerCommands$lambda$26(CommandContext it) {
        Intrinsics.checkNotNull((Object)it);
        return INSTANCE.displayShipsInOrder((CommandContext<CommandSourceStack>)it);
    }

    private static final int registerServerCommands$lambda$27(CommandContext it) {
        Intrinsics.checkNotNull((Object)it);
        return INSTANCE.saveSchemToServer((CommandContext<CommandSourceStack>)it);
    }

    private static final int registerServerCommands$lambda$28(CommandContext it) {
        Intrinsics.checkNotNull((Object)it);
        return INSTANCE.loadSchemFromServer((CommandContext<CommandSourceStack>)it);
    }

    private static final int registerServerCommands$lambda$29(CommandContext it) {
        Intrinsics.checkNotNull((Object)it);
        return INSTANCE.placeServerSchematic((CommandContext<CommandSourceStack>)it, true);
    }

    private static final int registerServerCommands$lambda$30(CommandContext it) {
        Intrinsics.checkNotNull((Object)it);
        return INSTANCE.placeServerSchematic((CommandContext<CommandSourceStack>)it, true);
    }

    private static final int registerServerCommands$lambda$31(CommandContext it) {
        Intrinsics.checkNotNull((Object)it);
        return INSTANCE.placeServerSchematic((CommandContext<CommandSourceStack>)it, true);
    }

    private static final int registerServerCommands$lambda$32(CommandContext it) {
        Intrinsics.checkNotNull((Object)it);
        return INSTANCE.placeServerSchematic((CommandContext<CommandSourceStack>)it, false);
    }

    private static final int registerServerCommands$lambda$33(CommandContext it) {
        Intrinsics.checkNotNull((Object)it);
        return INSTANCE.placeServerSchematic((CommandContext<CommandSourceStack>)it, false);
    }

    private static final int registerServerCommands$lambda$34(CommandContext it) {
        Intrinsics.checkNotNull((Object)it);
        return INSTANCE.setGravityFor((CommandContext<CommandSourceStack>)it);
    }

    private static final int registerServerCommands$lambda$35(CommandContext it) {
        Intrinsics.checkNotNull((Object)it);
        return INSTANCE.setGravityForConnected((CommandContext<CommandSourceStack>)it);
    }

    private static final int registerServerCommands$lambda$36(CommandContext it) {
        Intrinsics.checkNotNull((Object)it);
        return INSTANCE.setGravityForConnectedAndTouching((CommandContext<CommandSourceStack>)it);
    }

    private static final int registerServerCommands$lambda$37(CommandContext it) {
        Intrinsics.checkNotNull((Object)it);
        return INSTANCE.resetGravityFor((CommandContext<CommandSourceStack>)it);
    }

    private static final int registerServerCommands$lambda$38(CommandContext it) {
        Intrinsics.checkNotNull((Object)it);
        return INSTANCE.resetGravityForEveryShipIn((CommandContext<CommandSourceStack>)it);
    }

    private static final boolean registerServerCommands$lambda$39(CommandSourceStack it) {
        return it.m_6761_(VMConfig.INSTANCE.getSERVER().getPERMISSIONS().getVMOD_OP_COMMANDS_PERMISSION_LEVEL());
    }

    private static final int registerServerCommands$lambda$40(CommandContext it) {
        INSTANCE.setPermissionLevel(IntegerArgumentType.getInteger((CommandContext)it, (String)"level"));
        return 0;
    }

    private static final int registerServerCommands$lambda$41(CommandContext it) {
        Intrinsics.checkNotNull((Object)it);
        return OP.INSTANCE.changeDimensionGravity((CommandContext<CommandSourceStack>)it);
    }

    private static final int registerServerCommands$lambda$42(CommandContext it) {
        Intrinsics.checkNotNull((Object)it);
        return OP.INSTANCE.clearVmodAttachments((CommandContext<CommandSourceStack>)it);
    }

    private static final int registerServerCommands$lambda$43(CommandContext it) {
        Intrinsics.checkNotNull((Object)it);
        return OP.INSTANCE.deletePhysEntities((CommandContext<CommandSourceStack>)it);
    }

    private static final boolean registerServerCommands$lambda$44(CommandSourceStack it) {
        return it.m_6761_(4);
    }

    private static final int registerServerCommands$lambda$45(CommandContext it) {
        Intrinsics.checkNotNull((Object)it);
        return DEBUG.INSTANCE.clearDebugRenderers((CommandContext<CommandSourceStack>)it);
    }

    static {
        PlayerAccessManager.INSTANCE.addPermission(permissionString);
        lastName = "a";
        placeUUID = new UUID(0L, 0L);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a8\u0006\t"}, d2={"Lnet/spaceeye/vmod/VMCommands$DEBUG;", "", "<init>", "()V", "clearDebugRenderers", "", "cc", "Lcom/mojang/brigadier/context/CommandContext;", "Lnet/minecraft/commands/CommandSourceStack;", "VMod"})
    @SourceDebugExtension(value={"SMAP\nVMCommands.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VMCommands.kt\nnet/spaceeye/vmod/VMCommands$DEBUG\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,490:1\n1855#2,2:491\n*S KotlinDebug\n*F\n+ 1 VMCommands.kt\nnet/spaceeye/vmod/VMCommands$DEBUG\n*L\n339#1:491,2\n*E\n"})
    private static final class DEBUG {
        @NotNull
        public static final DEBUG INSTANCE = new DEBUG();

        private DEBUG() {
        }

        public final int clearDebugRenderers(@NotNull CommandContext<CommandSourceStack> cc) {
            Intrinsics.checkNotNullParameter(cc, (String)"cc");
            Iterable $this$forEach$iv = RenderingData.INSTANCE.getServer().getAllIds();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                int it = ((Number)element$iv).intValue();
                boolean bl = false;
                if (!(RenderingData.INSTANCE.getServer().getRenderer(it) instanceof DebugRenderer)) continue;
                RenderingData.INSTANCE.getServer().removeRenderer(it);
            }
            return 0;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007J\u0014\u0010\t\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007J\u0014\u0010\n\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a8\u0006\u000b"}, d2={"Lnet/spaceeye/vmod/VMCommands$OP;", "", "<init>", "()V", "changeDimensionGravity", "", "cc", "Lcom/mojang/brigadier/context/CommandContext;", "Lnet/minecraft/commands/CommandSourceStack;", "clearVmodAttachments", "deletePhysEntities", "VMod"})
    @SourceDebugExtension(value={"SMAP\nVMCommands.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VMCommands.kt\nnet/spaceeye/vmod/VMCommands$OP\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,490:1\n1855#2:491\n1856#2:493\n1855#2,2:494\n1#3:492\n*S KotlinDebug\n*F\n+ 1 VMCommands.kt\nnet/spaceeye/vmod/VMCommands$OP\n*L\n312#1:491\n312#1:493\n326#1:494,2\n*E\n"})
    private static final class OP {
        @NotNull
        public static final OP INSTANCE = new OP();

        private OP() {
        }

        public final int changeDimensionGravity(@NotNull CommandContext<CommandSourceStack> cc) {
            Intrinsics.checkNotNullParameter(cc, (String)"cc");
            ServerLevel dimension = DimensionArgument.m_88808_(cc, (String)"dimension");
            double x = DoubleArgumentType.getDouble(cc, (String)"x");
            double y = DoubleArgumentType.getDouble(cc, (String)"y");
            double z = DoubleArgumentType.getDouble(cc, (String)"z");
            Intrinsics.checkNotNull((Object)dimension);
            VSGravityManager.INSTANCE.setGravity(dimension, new Vector3d(x, y, z));
            return 0;
        }

        public final int clearVmodAttachments(@NotNull CommandContext<CommandSourceStack> cc) {
            Intrinsics.checkNotNullParameter(cc, (String)"cc");
            ServerLevel level = ((CommandSourceStack)cc.getSource()).m_81372_();
            Iterable $this$forEach$iv = (Iterable)VSGameUtilsKt.getShipObjectWorld((ServerLevel)level).getLoadedShips();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                LoadedServerShip it = (LoadedServerShip)element$iv;
                boolean bl = false;
                if ((GravityController)it.getAttachment(GravityController.class) != null) {
                    boolean bl2 = false;
                    it.setAttachment(GravityController.class, null);
                }
                if ((PhysgunController)it.getAttachment(PhysgunController.class) != null) {
                    boolean bl3 = false;
                    it.setAttachment(PhysgunController.class, null);
                }
                if ((ThrustersController)it.getAttachment(ThrustersController.class) != null) {
                    boolean bl4 = false;
                    it.setAttachment(ThrustersController.class, null);
                }
                if ((CustomMassSave)it.getAttachment(CustomMassSave.class) != null) {
                    boolean bl5 = false;
                    it.setAttachment(CustomMassSave.class, null);
                }
                if ((WeightSynchronizer)it.getAttachment(WeightSynchronizer.class) == null) continue;
                boolean bl6 = false;
                it.setAttachment(WeightSynchronizer.class, null);
            }
            return 0;
        }

        public final int deletePhysEntities(@NotNull CommandContext<CommandSourceStack> cc) {
            Intrinsics.checkNotNullParameter(cc, (String)"cc");
            ServerLevel level = ((CommandSourceStack)cc.getSource()).m_81372_();
            ServerShipWorldCore serverShipWorldCore = VSGameUtilsKt.getShipObjectWorld((ServerLevel)level);
            Intrinsics.checkNotNull((Object)serverShipWorldCore, (String)"null cannot be cast to non-null type net.spaceeye.vmod.mixin.ShipObjectWorldAccessor");
            List entities = CollectionsKt.sorted((Iterable)CollectionsKt.toList((Iterable)((ShipObjectWorldAccessor)serverShipWorldCore).getShipIdToPhysEntity().keySet()));
            Iterable $this$forEach$iv = entities;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Long it = (Long)element$iv;
                boolean bl = false;
                try {
                    ServerShipWorldCore serverShipWorldCore2 = VSGameUtilsKt.getShipObjectWorld((ServerLevel)level);
                    Intrinsics.checkNotNull((Object)it);
                    serverShipWorldCore2.deletePhysicsEntity(it.longValue());
                }
                catch (Exception e) {
                    VMKt.ELOG(ExceptionsKt.stackTraceToString((Throwable)e));
                }
                catch (Error e) {
                    VMKt.ELOG(ExceptionsKt.stackTraceToString((Throwable)e));
                }
            }
            return 0;
        }
    }
}

