/*
 * Decompiled with CFR 0.152.
 */
package net.spaceeye.vmod.gui.additions;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.architectury.networking.NetworkManager;
import java.awt.Color;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.spaceeye.elementa.UIComponent;
import net.spaceeye.elementa.UIConstraints;
import net.spaceeye.elementa.components.UIBlock;
import net.spaceeye.elementa.components.UIContainer;
import net.spaceeye.elementa.components.UIWrappedText;
import net.spaceeye.elementa.components.Window;
import net.spaceeye.elementa.constraints.ChildBasedSizeConstraint;
import net.spaceeye.elementa.dsl.ConstraintsKt;
import net.spaceeye.elementa.dsl.UtilitiesKt;
import net.spaceeye.vmod.events.PersistentEvents;
import net.spaceeye.vmod.gui.ScreenWindowAddition;
import net.spaceeye.vmod.guiElements.TextKt;
import net.spaceeye.vmod.networking.C2SConnection;
import net.spaceeye.vmod.networking.NetworkingKt;
import net.spaceeye.vmod.networking.S2CConnection;
import net.spaceeye.vmod.networking.Serializable;
import net.spaceeye.vmod.reflectable.AutoSerializable;
import net.spaceeye.vmod.reflectable.AutoSerializableKt;
import net.spaceeye.vmod.reflectable.ReflectableItemDelegate;
import net.spaceeye.vmod.reflectable.ReflectableObject;
import net.spaceeye.vmod.shipAttachments.CustomMassSave;
import net.spaceeye.vmod.shipAttachments.GravityController;
import net.spaceeye.vmod.toolgun.ClientToolGunState;
import net.spaceeye.vmod.utils.GetNow_msKt;
import net.spaceeye.vmod.utils.RaycastFunctions;
import net.spaceeye.vmod.utils.Vector3d;
import net.spaceeye.vmod.vEntityManaging.ServerLevelExtensionFnsKt;
import net.spaceeye.vmod.vsStuff.VSJointsTracker;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3dc;
import org.joml.Vector3f;
import org.joml.Vector3i;
import org.joml.Vector3ic;
import org.valkyrienskies.core.api.ships.LoadedServerShip;
import org.valkyrienskies.core.api.ships.Ship;
import org.valkyrienskies.mod.common.BlockStateInfo;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import org.valkyrienskies.mod.common.util.VectorConversionsMCKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002-.B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0018\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020\u00170\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R&\u0010&\u001a\u0017\u0012\u0013\u0012\u00110 \u00a2\u0006\f\b(\u0012\b\b)\u0012\u0004\b\b(*0'\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,\u00a8\u0006/"}, d2={"Lnet/spaceeye/vmod/gui/additions/InfoAddition;", "Lnet/spaceeye/vmod/gui/ScreenWindowAddition;", "<init>", "()V", "screenContainer", "Lnet/spaceeye/elementa/components/UIContainer;", "lastShipId", "", "infoContainer", "Lnet/spaceeye/elementa/components/UIBlock;", "shipSlug", "Lnet/spaceeye/elementa/components/UIWrappedText;", "shipId", "mass", "gravity", "customMass", "originalMass", "numVSConstraints", "numVEntities", "lastUpdate", "render", "", "init", "", "onRenderHUD", "stack", "Lcom/mojang/blaze3d/vertex/PoseStack;", "delta", "", "queryShipId", "callback", "Lkotlin/Function1;", "Lnet/spaceeye/vmod/gui/additions/InfoAddition$S2CShipInfoQueryResponse;", "c2sQueryShipInfo", "Lnet/spaceeye/vmod/networking/C2SConnection;", "Lnet/spaceeye/vmod/gui/additions/InfoAddition$C2SQueryShipInfo;", "getC2sQueryShipInfo", "()Lnet/spaceeye/vmod/networking/C2SConnection;", "s2cShipInfoQueryResponse", "Lnet/spaceeye/vmod/networking/S2CConnection;", "Lkotlin/ParameterName;", "name", "pkt", "getS2cShipInfoQueryResponse", "()Lnet/spaceeye/vmod/networking/S2CConnection;", "C2SQueryShipInfo", "S2CShipInfoQueryResponse", "VMod"})
@SourceDebugExtension(value={"SMAP\nInfoAddition.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InfoAddition.kt\nnet/spaceeye/vmod/gui/additions/InfoAddition\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 components.kt\ngg/essential/elementa/dsl/ComponentsKt\n+ 4 Networking.kt\nnet/spaceeye/vmod/networking/NetworkingKt\n*L\n1#1,192:1\n1940#2,14:193\n9#3,3:207\n133#4:210\n48#4:211\n99#4,11:212\n49#4,6:223\n135#4:229\n37#4:230\n124#4,8:231\n38#4,6:239\n*S KotlinDebug\n*F\n+ 1 InfoAddition.kt\nnet/spaceeye/vmod/gui/additions/InfoAddition\n*L\n124#1:193,14\n128#1:207,3\n155#1:210\n155#1:211\n155#1:212,11\n155#1:223,6\n188#1:229\n188#1:230\n188#1:231,8\n188#1:239,6\n*E\n"})
public final class InfoAddition
implements ScreenWindowAddition {
    @NotNull
    public static final InfoAddition INSTANCE;
    private static UIContainer screenContainer;
    private static long lastShipId;
    @NotNull
    private static UIBlock infoContainer;
    @NotNull
    private static final UIWrappedText shipSlug;
    @NotNull
    private static final UIWrappedText shipId;
    @NotNull
    private static final UIWrappedText mass;
    @NotNull
    private static final UIWrappedText gravity;
    @NotNull
    private static final UIWrappedText customMass;
    @NotNull
    private static final UIWrappedText originalMass;
    @NotNull
    private static final UIWrappedText numVSConstraints;
    @NotNull
    private static final UIWrappedText numVEntities;
    private static long lastUpdate;
    private static boolean render;
    private static long queryShipId;
    @NotNull
    private static Function1<? super S2CShipInfoQueryResponse, Unit> callback;
    @NotNull
    private static final C2SConnection<C2SQueryShipInfo> c2sQueryShipInfo;
    @NotNull
    private static final S2CConnection<S2CShipInfoQueryResponse> s2cShipInfoQueryResponse;

    private InfoAddition() {
    }

    @Override
    public void init(@NotNull UIContainer screenContainer) {
        Intrinsics.checkNotNullParameter((Object)screenContainer, (String)"screenContainer");
        InfoAddition.screenContainer = screenContainer;
        screenContainer.addChild(infoContainer);
        UIComponent.hide$default(infoContainer, false, 1, null);
    }

    @Override
    public void onRenderHUD(@NotNull PoseStack stack, float delta) {
        Vector3d vector3d;
        Vector3d vector3d2;
        boolean inFirstPerson;
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        if (!render || !ClientToolGunState.INSTANCE.playerIsUsingToolgun()) {
            UIComponent.hide$default(infoContainer, false, 1, null);
            return;
        }
        ClientLevel clientLevel = Minecraft.m_91087_().f_91073_;
        Intrinsics.checkNotNull((Object)clientLevel);
        ClientLevel level = clientLevel;
        Camera camera = Minecraft.m_91087_().f_91063_.m_109153_();
        LocalPlayer localPlayer = Minecraft.m_91087_().f_91074_;
        Intrinsics.checkNotNull((Object)localPlayer);
        LocalPlayer player = localPlayer;
        boolean bl = inFirstPerson = !camera.m_90594_();
        if (inFirstPerson) {
            Vector3f vector3f = camera.m_253058_();
            Intrinsics.checkNotNullExpressionValue((Object)vector3f, (String)"getLookVector(...)");
            vector3d2 = new Vector3d(vector3f).snormalize();
        } else {
            Vec3 vec3 = player.m_20154_();
            Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"getLookAngle(...)");
            vector3d2 = new Vector3d(vec3).snormalize();
        }
        Vector3d dir = vector3d2;
        Level level2 = (Level)level;
        if (inFirstPerson) {
            Vec3 vec3 = camera.m_90583_();
            Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"getPosition(...)");
            vector3d = new Vector3d(vec3);
        } else {
            Vec3 vec3 = player.m_146892_();
            Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"getEyePosition(...)");
            vector3d = new Vector3d(vec3);
        }
        RaycastFunctions.RaycastResult rr = RaycastFunctions.renderRaycast$default(RaycastFunctions.INSTANCE, level2, new RaycastFunctions.Source(dir, vector3d), 100.0, null, null, null, null, null, 248, null);
        if (rr.getShip() == null) {
            lastShipId = -1L;
            UIComponent.hide$default(infoContainer, false, 1, null);
            return;
        }
        if (lastShipId == rr.getShipId() && GetNow_msKt.getNow_ms() - lastUpdate < 1000L) {
            return;
        }
        lastShipId = rr.getShipId();
        queryShipId = rr.getShipId();
        callback = arg_0 -> InfoAddition.onRenderHUD$lambda$5(rr, arg_0);
        c2sQueryShipInfo.sendToServer((C2SQueryShipInfo)((Serializable)new C2SQueryShipInfo(lastShipId)));
    }

    @NotNull
    public final C2SConnection<C2SQueryShipInfo> getC2sQueryShipInfo() {
        return c2sQueryShipInfo;
    }

    @NotNull
    public final S2CConnection<S2CShipInfoQueryResponse> getS2cShipInfoQueryResponse() {
        return s2cShipInfoQueryResponse;
    }

    private static final boolean _init_$lambda$0(PersistentEvents.OnKeyPress onKeyPress, Function0 function0) {
        boolean isPressed;
        Intrinsics.checkNotNullParameter((Object)onKeyPress, (String)"<destruct>");
        Intrinsics.checkNotNullParameter((Object)function0, (String)"<unused var>");
        int keyCode = onKeyPress.component1();
        int scanCode = onKeyPress.component2();
        int action = onKeyPress.component3();
        int modifiers = onKeyPress.component4();
        if (!ClientToolGunState.INSTANCE.playerIsUsingToolgun()) {
            return false;
        }
        boolean bl = isPressed = action == 1;
        if (isPressed && ClientToolGunState.INSTANCE.getTOOLGUN_TOGGLE_HUD_INFO_KEY().m_90832_(keyCode, scanCode)) {
            render = !render;
            return true;
        }
        return false;
    }

    private static final Unit onRenderHUD$lambda$5$lambda$4(RaycastFunctions.RaycastResult $rr, S2CShipInfoQueryResponse $it) {
        UIComponent uIComponent;
        Object t;
        Ship ship = $rr.getShip();
        Intrinsics.checkNotNull((Object)ship);
        shipSlug.setText("Slug: " + ship.getSlug());
        shipId.setText("ShipId: " + $rr.getShipId());
        mass.setText("Mass: " + $it.getMass());
        gravity.setText("Gravity: " + $it.getGravity());
        customMass.setText("Has custom mass: " + $it.getCustomMass());
        originalMass.setText("Original mass: " + $it.getOriginalMass());
        numVSConstraints.setText("Num VS Constraints: " + $it.getNumVSConstraints());
        numVEntities.setText("Num VEntities: " + $it.getNumVEntities());
        Iterable $this$maxBy$iv = infoContainer.getChildren();
        boolean $i$f$maxByOrThrow = false;
        Iterator iterator$iv = $this$maxBy$iv.iterator();
        if (!iterator$iv.hasNext()) {
            throw new NoSuchElementException();
        }
        Object maxElem$iv = iterator$iv.next();
        if (!iterator$iv.hasNext()) {
            t = maxElem$iv;
        } else {
            UIComponent it = (UIComponent)maxElem$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type gg.essential.elementa.components.UIWrappedText");
            float maxValue$iv = ((UIWrappedText)it).getTextWidth();
            do {
                Object e$iv = iterator$iv.next();
                UIComponent it2 = (UIComponent)e$iv;
                $i$a$-maxByOrThrow-InfoAddition$onRenderHUD$1$1$maxWidth$1 = false;
                Intrinsics.checkNotNull((Object)it2, (String)"null cannot be cast to non-null type gg.essential.elementa.components.UIWrappedText");
                float v$iv = ((UIWrappedText)it2).getTextWidth();
                if (Float.compare(maxValue$iv, v$iv) >= 0) continue;
                maxElem$iv = e$iv;
                maxValue$iv = v$iv;
            } while (iterator$iv.hasNext());
            t = maxElem$iv;
        }
        Intrinsics.checkNotNull(t, (String)"null cannot be cast to non-null type gg.essential.elementa.components.UIWrappedText");
        UIWrappedText it = (UIWrappedText)t;
        boolean bl = false;
        float maxWidth = it.getTextWidth() * it.getTextScale() + (float)4;
        UIComponent $this$constrain$iv = infoContainer;
        boolean $i$f$constrain = false;
        UIComponent $this$constrain_u24lambda_u240$iv = uIComponent = $this$constrain$iv;
        boolean bl2 = false;
        UIConstraints $this$onRenderHUD_u24lambda_u245_u24lambda_u244_u24lambda_u243 = $this$constrain_u24lambda_u240$iv.getConstraints();
        boolean bl3 = false;
        $this$onRenderHUD_u24lambda_u245_u24lambda_u244_u24lambda_u243.setX(UtilitiesKt.getPercent(50));
        $this$onRenderHUD_u24lambda_u245_u24lambda_u244_u24lambda_u243.setY(UtilitiesKt.getPercent(50));
        $this$onRenderHUD_u24lambda_u245_u24lambda_u244_u24lambda_u243.setWidth(UtilitiesKt.getPixels(Float.valueOf(maxWidth)));
        $this$onRenderHUD_u24lambda_u245_u24lambda_u244_u24lambda_u243.setHeight(ConstraintsKt.plus(new ChildBasedSizeConstraint(0.0f, 1, null), UtilitiesKt.getPixels(16)));
        UIComponent.unhide$default(infoContainer, false, 1, null);
        return Unit.INSTANCE;
    }

    private static final Unit onRenderHUD$lambda$5(RaycastFunctions.RaycastResult $rr, S2CShipInfoQueryResponse it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Window.Companion.enqueueRenderOperation((Function0<Unit>)((Function0)() -> InfoAddition.onRenderHUD$lambda$5$lambda$4($rr, it)));
        return Unit.INSTANCE;
    }

    private static final Unit callback$lambda$6(S2CShipInfoQueryResponse it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ long access$getQueryShipId$p() {
        return queryShipId;
    }

    public static final /* synthetic */ Function1 access$getCallback$p() {
        return callback;
    }

    static {
        S2CConnection s2CConnection;
        C2SConnection c2SConnection;
        String name$iv;
        INSTANCE = new InfoAddition();
        lastShipId = -1L;
        infoContainer = new UIBlock(new Color(127, 127, 127, 127));
        Color color = Color.WHITE;
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"WHITE");
        shipSlug = TextKt.makeText("", color, 2.0f, 2.0f, infoContainer);
        Color color2 = Color.WHITE;
        Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"WHITE");
        shipId = TextKt.makeText("", color2, 2.0f, 2.0f, infoContainer);
        Color color3 = Color.WHITE;
        Intrinsics.checkNotNullExpressionValue((Object)color3, (String)"WHITE");
        mass = TextKt.makeText("", color3, 2.0f, 2.0f, infoContainer);
        Color color4 = Color.WHITE;
        Intrinsics.checkNotNullExpressionValue((Object)color4, (String)"WHITE");
        gravity = TextKt.makeText("", color4, 2.0f, 2.0f, infoContainer);
        Color color5 = Color.WHITE;
        Intrinsics.checkNotNullExpressionValue((Object)color5, (String)"WHITE");
        customMass = TextKt.makeText("", color5, 2.0f, 2.0f, infoContainer);
        Color color6 = Color.WHITE;
        Intrinsics.checkNotNullExpressionValue((Object)color6, (String)"WHITE");
        originalMass = TextKt.makeText("", color6, 2.0f, 2.0f, infoContainer);
        Color color7 = Color.WHITE;
        Intrinsics.checkNotNullExpressionValue((Object)color7, (String)"WHITE");
        numVSConstraints = TextKt.makeText("", color7, 2.0f, 2.0f, infoContainer);
        Color color8 = Color.WHITE;
        Intrinsics.checkNotNullExpressionValue((Object)color8, (String)"WHITE");
        numVEntities = TextKt.makeText("", color8, 2.0f, 2.0f, infoContainer);
        PersistentEvents.INSTANCE.getKeyPress().on((Function2<PersistentEvents.OnKeyPress, Function0<Unit>, Boolean>)((Function2)InfoAddition::_init_$lambda$0));
        queryShipId = -1L;
        callback = InfoAddition::callback$lambda$6;
        String string = "query_ship_info";
        String connName$iv = "info_addition";
        boolean $i$f$regC2S = false;
        void $this$idWithConnc$iv$iv = name$iv;
        boolean $i$f$idWithConnc = false;
        void it$iv = $this$idWithConnc$iv$iv;
        boolean bl = false;
        ResourceLocation id$iv$iv = new ResourceLocation("the_vmod", "c2s_" + connName$iv + "_" + (String)it$iv);
        boolean $i$f$makeC2S = false;
        C2SConnection instance$iv$iv = new C2SConnection<C2SQueryShipInfo>(id$iv$iv){
            private final ResourceLocation id;
            {
                this.id = $id;
            }

            public ResourceLocation getId() {
                return this.id;
            }

            /*
             * WARNING - void declaration
             */
            public void serverHandler(FriendlyByteBuf buf, NetworkManager.PacketContext context) {
                LoadedServerShip ship;
                boolean bl;
                ServerPlayer player;
                Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                Player player2 = context.getPlayer();
                Intrinsics.checkNotNull((Object)player2, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerPlayer");
                ServerPlayer player3 = (ServerPlayer)player2;
                T pkt = AutoSerializableKt.constructor(Reflection.getOrCreateKotlinClass(C2SQueryShipInfo.class), buf);
                pkt.deserialize(buf);
                ServerPlayer serverPlayer = player3;
                C2SQueryShipInfo pkt2 = (C2SQueryShipInfo)pkt;
                boolean bl2 = false;
                Level level = player.m_9236_();
                Intrinsics.checkNotNull((Object)level, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
                ServerLevel level2 = (ServerLevel)level;
                LoadedServerShip loadedServerShip = (LoadedServerShip)VSGameUtilsKt.getShipObjectWorld((ServerLevel)level2).getLoadedShips().getById(pkt2.getShipId());
                if (loadedServerShip == null) {
                    bl = false;
                } else {
                    ship = loadedServerShip;
                    Vector3dc vector3dc = ship.getTransform().getPositionInWorld();
                    Vec3 vec3 = player.m_20182_();
                    Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"position(...)");
                    bl = vector3dc.distance((Vector3dc)VectorConversionsMCKt.toJOML((Vec3)vec3)) < 100.0;
                }
                if (!bl) {
                    player = player3;
                    pkt2 = pkt;
                    boolean bl3 = false;
                    return;
                }
                Player player4 = context.getPlayer();
                Intrinsics.checkNotNull((Object)player4, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerPlayer");
                player = (ServerPlayer)player4;
                pkt2 = (C2SQueryShipInfo)pkt;
                boolean bl4 = false;
                Level level3 = player.m_9236_();
                Intrinsics.checkNotNull((Object)level3, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
                level2 = (ServerLevel)level3;
                LoadedServerShip loadedServerShip2 = (LoadedServerShip)VSGameUtilsKt.getShipObjectWorld((ServerLevel)level2).getLoadedShips().getById(pkt2.getShipId());
                if (loadedServerShip2 != null) {
                    double d;
                    List<Pair<Vector3i, Double>> changedMassData;
                    ship = loadedServerShip2;
                    CustomMassSave customMassSave = CustomMassSave.Companion.getOrCreate(ship);
                    List<Pair<Vector3i, Double>> list = changedMassData = customMassSave.getMassSave();
                    if (list != null) {
                        void $this$fold$iv;
                        List<Pair<Vector3i, Double>> it = list;
                        boolean bl5 = false;
                        Iterable iterable = it;
                        double initial$iv = ship.getInertiaData().getMass();
                        boolean $i$f$fold = false;
                        double accumulator$iv = initial$iv;
                        for (T element$iv : $this$fold$iv) {
                            Pair pair = (Pair)element$iv;
                            double mass = accumulator$iv;
                            boolean bl6 = false;
                            Vector3i pos = (Vector3i)pair.component1();
                            double d2 = ((Number)pair.component2()).doubleValue();
                            BlockState state = level2.m_8055_(VectorConversionsMCKt.toBlockPos((Vector3ic)((Vector3ic)pos)));
                            Intrinsics.checkNotNull((Object)state);
                            Pair pair2 = BlockStateInfo.INSTANCE.get(state);
                            Intrinsics.checkNotNull((Object)pair2);
                            double defaultMass = ((Number)pair2.component1()).doubleValue();
                            accumulator$iv = mass - d2 + defaultMass;
                        }
                        d = accumulator$iv;
                    } else {
                        d = ship.getInertiaData().getMass();
                    }
                    double originalMass = d;
                    InfoAddition.INSTANCE.getS2cShipInfoQueryResponse().sendToClient(player, (S2CShipInfoQueryResponse)((Serializable)new S2CShipInfoQueryResponse(pkt2.getShipId(), ship.getInertiaData().getMass(), GravityController.Companion.getOrCreate(ship).effectiveGravity(), changedMassData != null, originalMass, VSJointsTracker.getIdsOfShip(ship.getId()).size(), ServerLevelExtensionFnsKt.getAllVEntityIdsOfShipId(level2, ship.getId()).size())));
                }
            }
        };
        if (NetworkingKt.getRegisteredIDs().contains(instance$iv$iv.getId().toString())) {
            c2SConnection = instance$iv$iv;
        } else {
            Set<String> set = NetworkingKt.getRegisteredIDs();
            String string2 = instance$iv$iv.getId().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
            set.add(string2);
            try {
                NetworkManager.registerReceiver((NetworkManager.Side)instance$iv$iv.getSide(), (ResourceLocation)instance$iv$iv.getId(), (NetworkManager.NetworkReceiver)instance$iv$iv.getHandler());
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            c2SConnection = instance$iv$iv;
        }
        c2sQueryShipInfo = c2SConnection;
        name$iv = "ship_info_query_response";
        connName$iv = "info_addition";
        boolean $i$f$regS2C = false;
        String $this$idWithConns$iv$iv = name$iv;
        boolean $i$f$idWithConns = false;
        String it$iv2 = $this$idWithConns$iv$iv;
        boolean bl2 = false;
        ResourceLocation id$iv$iv2 = new ResourceLocation("the_vmod", "s2c_" + connName$iv + "_" + it$iv2);
        boolean $i$f$makeS2C = false;
        S2CConnection instance$iv$iv2 = new S2CConnection<S2CShipInfoQueryResponse>(id$iv$iv2){
            private final ResourceLocation id;
            {
                this.id = $id;
            }

            public ResourceLocation getId() {
                return this.id;
            }

            public void clientHandler(FriendlyByteBuf buf, NetworkManager.PacketContext context) {
                Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                T pkt = AutoSerializableKt.constructor(Reflection.getOrCreateKotlinClass(S2CShipInfoQueryResponse.class), buf);
                pkt.deserialize(buf);
                S2CShipInfoQueryResponse pkt2 = (S2CShipInfoQueryResponse)pkt;
                boolean bl = false;
                if (InfoAddition.access$getQueryShipId$p() == pkt2.getShipId()) {
                    InfoAddition.access$getCallback$p().invoke((Object)pkt2);
                }
            }
        };
        if (NetworkingKt.getRegisteredIDs().contains(instance$iv$iv2.getId().toString())) {
            s2CConnection = instance$iv$iv2;
        } else {
            Set<String> set = NetworkingKt.getRegisteredIDs();
            String string3 = instance$iv$iv2.getId().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
            set.add(string3);
            try {
                NetworkManager.registerReceiver((NetworkManager.Side)instance$iv$iv2.getSide(), (ResourceLocation)instance$iv$iv2.getId(), (NetworkManager.NetworkReceiver)instance$iv$iv2.getHandler());
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            s2CConnection = instance$iv$iv2;
        }
        s2cShipInfoQueryResponse = s2CConnection;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\n\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\u0005\u00a8\u0006\u0013"}, d2={"Lnet/spaceeye/vmod/gui/additions/InfoAddition$C2SQueryShipInfo;", "Lnet/spaceeye/vmod/reflectable/AutoSerializable;", "shipId", "", "<init>", "(J)V", "getShipId", "()J", "setShipId", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "VMod"})
    public static final class C2SQueryShipInfo
    implements AutoSerializable {
        private long shipId;

        public C2SQueryShipInfo(long shipId) {
            this.shipId = shipId;
        }

        public /* synthetic */ C2SQueryShipInfo(long l, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                l = -1L;
            }
            this(l);
        }

        public final long getShipId() {
            return this.shipId;
        }

        public final void setShipId(long l) {
            this.shipId = l;
        }

        public final long component1() {
            return this.shipId;
        }

        @NotNull
        public final C2SQueryShipInfo copy(long shipId) {
            return new C2SQueryShipInfo(shipId);
        }

        public static /* synthetic */ C2SQueryShipInfo copy$default(C2SQueryShipInfo c2SQueryShipInfo, long l, int n, Object object) {
            if ((n & 1) != 0) {
                l = c2SQueryShipInfo.shipId;
            }
            return c2SQueryShipInfo.copy(l);
        }

        @NotNull
        public String toString() {
            return "C2SQueryShipInfo(shipId=" + this.shipId + ")";
        }

        public int hashCode() {
            return Long.hashCode(this.shipId);
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof C2SQueryShipInfo)) {
                return false;
            }
            C2SQueryShipInfo c2SQueryShipInfo = (C2SQueryShipInfo)other;
            return this.shipId == c2SQueryShipInfo.shipId;
        }

        @Override
        @JsonIgnore
        @ApiStatus.NonExtendable
        @NotNull
        public FriendlyByteBuf serialize() {
            return AutoSerializable.DefaultImpls.serialize(this);
        }

        @Override
        @JsonIgnore
        @ApiStatus.NonExtendable
        public void deserialize(@NotNull FriendlyByteBuf buf) {
            AutoSerializable.DefaultImpls.deserialize(this, buf);
        }

        @Override
        @JsonIgnore
        @NotNull
        public FriendlyByteBuf getBuffer() {
            return AutoSerializable.DefaultImpls.getBuffer(this);
        }

        @Override
        @JsonIgnore
        @Nullable
        public ReflectableObject getReflectObjectOverride() {
            return AutoSerializable.DefaultImpls.getReflectObjectOverride(this);
        }

        @Override
        @JsonIgnore
        @ApiStatus.NonExtendable
        @NotNull
        public List<ReflectableItemDelegate<?>> getAllReflectableItems(boolean processSubReflectables, @NotNull Function1<? super ReflectableItemDelegate<?>, Boolean> filterBy) {
            return AutoSerializable.DefaultImpls.getAllReflectableItems(this, processSubReflectables, filterBy);
        }

        @Override
        @JsonIgnore
        @ApiStatus.NonExtendable
        @NotNull
        public List<ReflectableItemDelegate<?>> getReflectableItemsWithoutDataclassConstructorItems(boolean processSubReflectables, @NotNull Function1<? super ReflectableItemDelegate<?>, Boolean> filterBy) {
            return AutoSerializable.DefaultImpls.getReflectableItemsWithoutDataclassConstructorItems(this, processSubReflectables, filterBy);
        }

        public C2SQueryShipInfo() {
            this(0L, 1, null);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b%\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001BK\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u0012\b\b\u0002\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\t\u0010(\u001a\u00020\u0003H\u00c6\u0003J\t\u0010)\u001a\u00020\u0005H\u00c6\u0003J\t\u0010*\u001a\u00020\u0007H\u00c6\u0003J\t\u0010+\u001a\u00020\tH\u00c6\u0003J\t\u0010,\u001a\u00020\u0005H\u00c6\u0003J\t\u0010-\u001a\u00020\fH\u00c6\u0003J\t\u0010.\u001a\u00020\fH\u00c6\u0003JO\u0010/\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u00052\b\b\u0002\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\fH\u00c6\u0001J\u0013\u00100\u001a\u00020\t2\b\u00101\u001a\u0004\u0018\u000102H\u00d6\u0003J\t\u00103\u001a\u00020\fH\u00d6\u0001J\t\u00104\u001a\u000205H\u00d6\u0001R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u001a\u0010\n\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\u0015\"\u0004\b!\u0010\u0017R\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R\u001a\u0010\r\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010#\"\u0004\b'\u0010%\u00a8\u00066"}, d2={"Lnet/spaceeye/vmod/gui/additions/InfoAddition$S2CShipInfoQueryResponse;", "Lnet/spaceeye/vmod/reflectable/AutoSerializable;", "shipId", "", "mass", "", "gravity", "Lnet/spaceeye/vmod/utils/Vector3d;", "customMass", "", "originalMass", "numVSConstraints", "", "numVEntities", "<init>", "(JDLnet/spaceeye/vmod/utils/Vector3d;ZDII)V", "getShipId", "()J", "setShipId", "(J)V", "getMass", "()D", "setMass", "(D)V", "getGravity", "()Lnet/spaceeye/vmod/utils/Vector3d;", "setGravity", "(Lnet/spaceeye/vmod/utils/Vector3d;)V", "getCustomMass", "()Z", "setCustomMass", "(Z)V", "getOriginalMass", "setOriginalMass", "getNumVSConstraints", "()I", "setNumVSConstraints", "(I)V", "getNumVEntities", "setNumVEntities", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "equals", "other", "", "hashCode", "toString", "", "VMod"})
    public static final class S2CShipInfoQueryResponse
    implements AutoSerializable {
        private long shipId;
        private double mass;
        @NotNull
        private Vector3d gravity;
        private boolean customMass;
        private double originalMass;
        private int numVSConstraints;
        private int numVEntities;

        public S2CShipInfoQueryResponse(long shipId, double mass, @NotNull Vector3d gravity, boolean customMass, double originalMass, int numVSConstraints, int numVEntities) {
            Intrinsics.checkNotNullParameter((Object)gravity, (String)"gravity");
            this.shipId = shipId;
            this.mass = mass;
            this.gravity = gravity;
            this.customMass = customMass;
            this.originalMass = originalMass;
            this.numVSConstraints = numVSConstraints;
            this.numVEntities = numVEntities;
        }

        public /* synthetic */ S2CShipInfoQueryResponse(long l, double d, Vector3d vector3d, boolean bl, double d2, int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n3 & 2) != 0) {
                d = 0.0;
            }
            if ((n3 & 4) != 0) {
                vector3d = new Vector3d();
            }
            if ((n3 & 8) != 0) {
                bl = false;
            }
            if ((n3 & 0x10) != 0) {
                d2 = 0.0;
            }
            if ((n3 & 0x20) != 0) {
                n = 0;
            }
            if ((n3 & 0x40) != 0) {
                n2 = 0;
            }
            this(l, d, vector3d, bl, d2, n, n2);
        }

        public final long getShipId() {
            return this.shipId;
        }

        public final void setShipId(long l) {
            this.shipId = l;
        }

        public final double getMass() {
            return this.mass;
        }

        public final void setMass(double d) {
            this.mass = d;
        }

        @NotNull
        public final Vector3d getGravity() {
            return this.gravity;
        }

        public final void setGravity(@NotNull Vector3d vector3d) {
            Intrinsics.checkNotNullParameter((Object)vector3d, (String)"<set-?>");
            this.gravity = vector3d;
        }

        public final boolean getCustomMass() {
            return this.customMass;
        }

        public final void setCustomMass(boolean bl) {
            this.customMass = bl;
        }

        public final double getOriginalMass() {
            return this.originalMass;
        }

        public final void setOriginalMass(double d) {
            this.originalMass = d;
        }

        public final int getNumVSConstraints() {
            return this.numVSConstraints;
        }

        public final void setNumVSConstraints(int n) {
            this.numVSConstraints = n;
        }

        public final int getNumVEntities() {
            return this.numVEntities;
        }

        public final void setNumVEntities(int n) {
            this.numVEntities = n;
        }

        public final long component1() {
            return this.shipId;
        }

        public final double component2() {
            return this.mass;
        }

        @NotNull
        public final Vector3d component3() {
            return this.gravity;
        }

        public final boolean component4() {
            return this.customMass;
        }

        public final double component5() {
            return this.originalMass;
        }

        public final int component6() {
            return this.numVSConstraints;
        }

        public final int component7() {
            return this.numVEntities;
        }

        @NotNull
        public final S2CShipInfoQueryResponse copy(long shipId, double mass, @NotNull Vector3d gravity, boolean customMass, double originalMass, int numVSConstraints, int numVEntities) {
            Intrinsics.checkNotNullParameter((Object)gravity, (String)"gravity");
            return new S2CShipInfoQueryResponse(shipId, mass, gravity, customMass, originalMass, numVSConstraints, numVEntities);
        }

        public static /* synthetic */ S2CShipInfoQueryResponse copy$default(S2CShipInfoQueryResponse s2CShipInfoQueryResponse, long l, double d, Vector3d vector3d, boolean bl, double d2, int n, int n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                l = s2CShipInfoQueryResponse.shipId;
            }
            if ((n3 & 2) != 0) {
                d = s2CShipInfoQueryResponse.mass;
            }
            if ((n3 & 4) != 0) {
                vector3d = s2CShipInfoQueryResponse.gravity;
            }
            if ((n3 & 8) != 0) {
                bl = s2CShipInfoQueryResponse.customMass;
            }
            if ((n3 & 0x10) != 0) {
                d2 = s2CShipInfoQueryResponse.originalMass;
            }
            if ((n3 & 0x20) != 0) {
                n = s2CShipInfoQueryResponse.numVSConstraints;
            }
            if ((n3 & 0x40) != 0) {
                n2 = s2CShipInfoQueryResponse.numVEntities;
            }
            return s2CShipInfoQueryResponse.copy(l, d, vector3d, bl, d2, n, n2);
        }

        @NotNull
        public String toString() {
            return "S2CShipInfoQueryResponse(shipId=" + this.shipId + ", mass=" + this.mass + ", gravity=" + this.gravity + ", customMass=" + this.customMass + ", originalMass=" + this.originalMass + ", numVSConstraints=" + this.numVSConstraints + ", numVEntities=" + this.numVEntities + ")";
        }

        public int hashCode() {
            int result = Long.hashCode(this.shipId);
            result = result * 31 + Double.hashCode(this.mass);
            result = result * 31 + this.gravity.hashCode();
            result = result * 31 + Boolean.hashCode(this.customMass);
            result = result * 31 + Double.hashCode(this.originalMass);
            result = result * 31 + Integer.hashCode(this.numVSConstraints);
            result = result * 31 + Integer.hashCode(this.numVEntities);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof S2CShipInfoQueryResponse)) {
                return false;
            }
            S2CShipInfoQueryResponse s2CShipInfoQueryResponse = (S2CShipInfoQueryResponse)other;
            if (this.shipId != s2CShipInfoQueryResponse.shipId) {
                return false;
            }
            if (Double.compare(this.mass, s2CShipInfoQueryResponse.mass) != 0) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.gravity, (Object)s2CShipInfoQueryResponse.gravity)) {
                return false;
            }
            if (this.customMass != s2CShipInfoQueryResponse.customMass) {
                return false;
            }
            if (Double.compare(this.originalMass, s2CShipInfoQueryResponse.originalMass) != 0) {
                return false;
            }
            if (this.numVSConstraints != s2CShipInfoQueryResponse.numVSConstraints) {
                return false;
            }
            return this.numVEntities == s2CShipInfoQueryResponse.numVEntities;
        }

        @Override
        @JsonIgnore
        @ApiStatus.NonExtendable
        @NotNull
        public FriendlyByteBuf serialize() {
            return AutoSerializable.DefaultImpls.serialize(this);
        }

        @Override
        @JsonIgnore
        @ApiStatus.NonExtendable
        public void deserialize(@NotNull FriendlyByteBuf buf) {
            AutoSerializable.DefaultImpls.deserialize(this, buf);
        }

        @Override
        @JsonIgnore
        @NotNull
        public FriendlyByteBuf getBuffer() {
            return AutoSerializable.DefaultImpls.getBuffer(this);
        }

        @Override
        @JsonIgnore
        @Nullable
        public ReflectableObject getReflectObjectOverride() {
            return AutoSerializable.DefaultImpls.getReflectObjectOverride(this);
        }

        @Override
        @JsonIgnore
        @ApiStatus.NonExtendable
        @NotNull
        public List<ReflectableItemDelegate<?>> getAllReflectableItems(boolean processSubReflectables, @NotNull Function1<? super ReflectableItemDelegate<?>, Boolean> filterBy) {
            return AutoSerializable.DefaultImpls.getAllReflectableItems(this, processSubReflectables, filterBy);
        }

        @Override
        @JsonIgnore
        @ApiStatus.NonExtendable
        @NotNull
        public List<ReflectableItemDelegate<?>> getReflectableItemsWithoutDataclassConstructorItems(boolean processSubReflectables, @NotNull Function1<? super ReflectableItemDelegate<?>, Boolean> filterBy) {
            return AutoSerializable.DefaultImpls.getReflectableItemsWithoutDataclassConstructorItems(this, processSubReflectables, filterBy);
        }
    }
}

