/*
 * Decompiled with CFR 0.152.
 */
package net.spaceeye.vmod.limits;

import com.fasterxml.jackson.databind.ObjectMapper;
import dev.architectury.event.events.common.LifecycleEvent;
import dev.architectury.networking.NetworkManager;
import java.util.Set;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.spaceeye.vmod.VMKt;
import net.spaceeye.vmod.config.ExternalDataUtil;
import net.spaceeye.vmod.limits.BoolLimit;
import net.spaceeye.vmod.limits.DoubleLimit;
import net.spaceeye.vmod.limits.FloatLimit;
import net.spaceeye.vmod.limits.IntLimit;
import net.spaceeye.vmod.limits.LongLimit;
import net.spaceeye.vmod.limits.ServerLimitsInstance;
import net.spaceeye.vmod.limits.ServerLimitsPacket;
import net.spaceeye.vmod.limits.StrLimit;
import net.spaceeye.vmod.networking.C2SConnection;
import net.spaceeye.vmod.networking.Connection;
import net.spaceeye.vmod.networking.NetworkingKt;
import net.spaceeye.vmod.networking.S2CConnection;
import net.spaceeye.vmod.networking.Serializable;
import net.spaceeye.vmod.reflectable.AutoSerializableKt;
import net.spaceeye.vmod.reflectable.ByteSerializableItem;
import net.spaceeye.vmod.toolgun.ServerToolGunState;
import net.spaceeye.vmod.translate.TranslatableKt;
import net.spaceeye.vmod.utils.EmptyPacket;
import net.spaceeye.vmod.utils.GetMapperKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\u0005H\u0002J\b\u0010\u0014\u001a\u00020\u0013H\u0002J\u0006\u0010\u0015\u001a\u00020\u0013J\u0006\u0010\u0016\u001a\u00020\u0013R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR$\u0010\r\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u00058F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R#\u0010\u0017\u001a\u0017\u0012\u0013\u0012\u00110\u0019\u00a2\u0006\f\b\u001a\u0012\b\b\u001b\u0012\u0004\b\b(\u001c0\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R#\u0010\u001d\u001a\u0017\u0012\u0013\u0012\u00110\u001f\u00a2\u0006\f\b\u001a\u0012\b\b\u001b\u0012\u0004\b\b(\u001c0\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001f0\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lnet/spaceeye/vmod/limits/ServerLimits;", "", "<init>", "()V", "_instance", "Lnet/spaceeye/vmod/limits/ServerLimitsInstance;", "wasLoaded", "", "getWasLoaded", "()Z", "setWasLoaded", "(Z)V", "value", "instance", "getInstance", "()Lnet/spaceeye/vmod/limits/ServerLimitsInstance;", "setInstance", "(Lnet/spaceeye/vmod/limits/ServerLimitsInstance;)V", "save", "", "load", "updateFromServer", "tryUpdateToServer", "c2sRequestServerLimits", "Lnet/spaceeye/vmod/networking/C2SConnection;", "Lnet/spaceeye/vmod/utils/EmptyPacket;", "Lkotlin/ParameterName;", "name", "pkt", "s2cSendCurrentServerLimits", "Lnet/spaceeye/vmod/networking/S2CConnection;", "Lnet/spaceeye/vmod/limits/ServerLimitsPacket;", "c2sSendUpdatedServerLimits", "VMod"})
@SourceDebugExtension(value={"SMAP\nServerLimits.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ServerLimits.kt\nnet/spaceeye/vmod/limits/ServerLimits\n+ 2 Networking.kt\nnet/spaceeye/vmod/networking/NetworkingKt\n*L\n1#1,153:1\n134#2:154\n48#2:155\n113#2,8:156\n49#2,6:164\n135#2:170\n37#2:171\n124#2,8:172\n38#2,6:180\n133#2:186\n48#2:187\n99#2,11:188\n49#2,6:199\n*S KotlinDebug\n*F\n+ 1 ServerLimits.kt\nnet/spaceeye/vmod/limits/ServerLimits\n*L\n141#1:154\n141#1:155\n141#1:156,8\n141#1:164,6\n145#1:170\n145#1:171\n145#1:172,8\n145#1:180,6\n149#1:186\n149#1:187\n149#1:188,11\n149#1:199,6\n*E\n"})
public final class ServerLimits {
    @NotNull
    public static final ServerLimits INSTANCE;
    @NotNull
    private static ServerLimitsInstance _instance;
    private static boolean wasLoaded;
    @NotNull
    private static final C2SConnection<EmptyPacket> c2sRequestServerLimits;
    @NotNull
    private static final S2CConnection<ServerLimitsPacket> s2cSendCurrentServerLimits;
    @NotNull
    private static final C2SConnection<ServerLimitsPacket> c2sSendUpdatedServerLimits;

    private ServerLimits() {
    }

    public final boolean getWasLoaded() {
        return wasLoaded;
    }

    public final void setWasLoaded(boolean bl) {
        wasLoaded = bl;
    }

    @NotNull
    public final ServerLimitsInstance getInstance() {
        if (!wasLoaded) {
            this.load();
            wasLoaded = true;
        }
        return _instance;
    }

    public final void setInstance(@NotNull ServerLimitsInstance value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.save(value);
        _instance = value;
    }

    private final void save(ServerLimitsInstance value) {
        ObjectMapper mapper = GetMapperKt.getMapper();
        byte[] byArray = mapper.writerWithDefaultPrettyPrinter().writeValueAsBytes((Object)value);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"writeValueAsBytes(...)");
        ExternalDataUtil.INSTANCE.writeObject("ServerLimits.json", byArray);
    }

    private final void load() {
        byte[] byArray = ExternalDataUtil.INSTANCE.readObject("ServerLimits.json");
        if (byArray == null) {
            ServerLimits $this$load_u24lambda_u2413 = this;
            boolean bl = false;
            $this$load_u24lambda_u2413.save(_instance);
            return;
        }
        byte[] bytes = byArray;
        try {
            ObjectMapper mapper = GetMapperKt.getMapper();
            _instance = (ServerLimitsInstance)mapper.readValue(bytes, ServerLimitsInstance.class);
        }
        catch (Exception e) {
            VMKt.ELOG("Failed to deserialize Server Limits.\n" + ExceptionsKt.stackTraceToString((Throwable)e));
            _instance = new ServerLimitsInstance();
            this.save(_instance);
        }
    }

    public final void updateFromServer() {
        c2sRequestServerLimits.sendToServer((EmptyPacket)((Serializable)new EmptyPacket()));
    }

    public final void tryUpdateToServer() {
        c2sSendUpdatedServerLimits.sendToServer((ServerLimitsPacket)((Serializable)this.getInstance().toPacket()));
    }

    private static final Unit _init_$lambda$0(DoubleLimit it, FriendlyByteBuf buf) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        buf.writeDouble(it.getMinValue());
        buf.writeDouble(it.getMaxValue());
        return Unit.INSTANCE;
    }

    private static final DoubleLimit _init_$lambda$1(FriendlyByteBuf buf) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        return new DoubleLimit(buf.readDouble(), buf.readDouble());
    }

    private static final Unit _init_$lambda$2(FloatLimit it, FriendlyByteBuf buf) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        buf.writeFloat(it.getMinValue());
        buf.writeFloat(it.getMaxValue());
        return Unit.INSTANCE;
    }

    private static final FloatLimit _init_$lambda$3(FriendlyByteBuf buf) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        return new FloatLimit(buf.readFloat(), buf.readFloat());
    }

    private static final Unit _init_$lambda$4(LongLimit it, FriendlyByteBuf buf) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        buf.writeLong(it.getMinValue());
        buf.writeLong(it.getMaxValue());
        return Unit.INSTANCE;
    }

    private static final LongLimit _init_$lambda$5(FriendlyByteBuf buf) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        return new LongLimit(buf.readLong(), buf.readLong());
    }

    private static final Unit _init_$lambda$6(IntLimit it, FriendlyByteBuf buf) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        buf.writeInt(it.getMinValue());
        buf.writeInt(it.getMaxValue());
        return Unit.INSTANCE;
    }

    private static final IntLimit _init_$lambda$7(FriendlyByteBuf buf) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        return new IntLimit(buf.readInt(), buf.readInt());
    }

    private static final Unit _init_$lambda$8(StrLimit it, FriendlyByteBuf buf) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        buf.writeInt(it.getSizeLimit());
        return Unit.INSTANCE;
    }

    private static final StrLimit _init_$lambda$9(FriendlyByteBuf buf) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        return new StrLimit(buf.readInt());
    }

    private static final Unit _init_$lambda$10(BoolLimit it, FriendlyByteBuf buf) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        buf.m_130068_((Enum)it.getMode());
        return Unit.INSTANCE;
    }

    private static final BoolLimit _init_$lambda$11(FriendlyByteBuf buf) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        Enum enum_ = buf.m_130066_(BoolLimit.Force.class);
        Intrinsics.checkNotNullExpressionValue((Object)enum_, (String)"readEnum(...)");
        return new BoolLimit((BoolLimit.Force)enum_);
    }

    private static final void _init_$lambda$12(MinecraftServer it) {
        wasLoaded = false;
    }

    public static final /* synthetic */ S2CConnection access$getS2cSendCurrentServerLimits$p() {
        return s2cSendCurrentServerLimits;
    }

    static {
        Connection connection;
        Connection connection2;
        String string;
        C2SConnection c2SConnection;
        String name$iv;
        INSTANCE = new ServerLimits();
        ByteSerializableItem.registerSerializationItem(Reflection.getOrCreateKotlinClass(DoubleLimit.class), ServerLimits::_init_$lambda$0, ServerLimits::_init_$lambda$1);
        ByteSerializableItem.registerSerializationItem(Reflection.getOrCreateKotlinClass(FloatLimit.class), ServerLimits::_init_$lambda$2, ServerLimits::_init_$lambda$3);
        ByteSerializableItem.registerSerializationItem(Reflection.getOrCreateKotlinClass(LongLimit.class), ServerLimits::_init_$lambda$4, ServerLimits::_init_$lambda$5);
        ByteSerializableItem.registerSerializationItem(Reflection.getOrCreateKotlinClass(IntLimit.class), ServerLimits::_init_$lambda$6, ServerLimits::_init_$lambda$7);
        ByteSerializableItem.registerSerializationItem(Reflection.getOrCreateKotlinClass(StrLimit.class), ServerLimits::_init_$lambda$8, ServerLimits::_init_$lambda$9);
        ByteSerializableItem.registerSerializationItem(Reflection.getOrCreateKotlinClass(BoolLimit.class), ServerLimits::_init_$lambda$10, ServerLimits::_init_$lambda$11);
        LifecycleEvent.SERVER_STOPPED.register(ServerLimits::_init_$lambda$12);
        _instance = new ServerLimitsInstance();
        String string2 = "request_server_limits";
        String connName$iv = "server_limits";
        boolean $i$f$regC2S = false;
        String $this$idWithConnc$iv$iv = name$iv;
        boolean $i$f$idWithConnc = false;
        String it$iv = $this$idWithConnc$iv$iv;
        boolean bl = false;
        ResourceLocation id$iv$iv = new ResourceLocation("the_vmod", "c2s_" + connName$iv + "_" + it$iv);
        boolean $i$f$makeC2S = false;
        Connection instance$iv$iv = new C2SConnection<EmptyPacket>(id$iv$iv){
            private final ResourceLocation id;
            {
                this.id = $id;
            }

            public ResourceLocation getId() {
                return this.id;
            }

            /*
             * WARNING - void declaration
             */
            public void serverHandler(FriendlyByteBuf buf, NetworkManager.PacketContext context) {
                void player;
                Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                T pkt = AutoSerializableKt.constructor(Reflection.getOrCreateKotlinClass(EmptyPacket.class), buf);
                pkt.deserialize(buf);
                Player player2 = context.getPlayer();
                Intrinsics.checkNotNull((Object)player2, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerPlayer");
                ServerPlayer serverPlayer = (ServerPlayer)player2;
                EmptyPacket pkt2 = (EmptyPacket)pkt;
                boolean bl = false;
                ServerLimits.access$getS2cSendCurrentServerLimits$p().sendToClient((ServerPlayer)player, (Serializable)ServerLimits.INSTANCE.getInstance().toPacket());
            }
        };
        if (NetworkingKt.getRegisteredIDs().contains(instance$iv$iv.getId().toString())) {
            c2SConnection = instance$iv$iv;
        } else {
            Set<String> set = NetworkingKt.getRegisteredIDs();
            string = instance$iv$iv.getId().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            set.add(string);
            try {
                NetworkManager.registerReceiver((NetworkManager.Side)((C2SConnection)instance$iv$iv).getSide(), (ResourceLocation)instance$iv$iv.getId(), (NetworkManager.NetworkReceiver)((C2SConnection)instance$iv$iv).getHandler());
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            c2SConnection = instance$iv$iv;
        }
        c2sRequestServerLimits = c2SConnection;
        name$iv = "send_current_server_limits";
        connName$iv = "server_limits";
        boolean $i$f$regS2C = false;
        String $this$idWithConns$iv$iv = name$iv;
        boolean $i$f$idWithConns = false;
        it$iv = $this$idWithConns$iv$iv;
        boolean bl2 = false;
        id$iv$iv = new ResourceLocation("the_vmod", "s2c_" + connName$iv + "_" + it$iv);
        boolean $i$f$makeS2C = false;
        instance$iv$iv = new S2CConnection<ServerLimitsPacket>(id$iv$iv){
            private final ResourceLocation id;
            {
                this.id = $id;
            }

            public ResourceLocation getId() {
                return this.id;
            }

            public void clientHandler(FriendlyByteBuf buf, NetworkManager.PacketContext context) {
                Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                T pkt = AutoSerializableKt.constructor(Reflection.getOrCreateKotlinClass(ServerLimitsPacket.class), buf);
                pkt.deserialize(buf);
                ServerLimitsPacket it = (ServerLimitsPacket)pkt;
                boolean bl = false;
                ServerLimits.INSTANCE.setInstance(it.getInstance());
            }
        };
        if (NetworkingKt.getRegisteredIDs().contains(instance$iv$iv.getId().toString())) {
            connection2 = instance$iv$iv;
        } else {
            Set<String> set = NetworkingKt.getRegisteredIDs();
            string = instance$iv$iv.getId().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            set.add(string);
            try {
                NetworkManager.registerReceiver((NetworkManager.Side)((S2CConnection)instance$iv$iv).getSide(), (ResourceLocation)instance$iv$iv.getId(), (NetworkManager.NetworkReceiver)((S2CConnection)instance$iv$iv).getHandler());
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            connection2 = instance$iv$iv;
        }
        s2cSendCurrentServerLimits = connection2;
        name$iv = "send_updated_server_limits";
        connName$iv = "server_limits";
        $i$f$regC2S = false;
        $this$idWithConnc$iv$iv = name$iv;
        $i$f$idWithConnc = false;
        it$iv = $this$idWithConnc$iv$iv;
        boolean bl3 = false;
        id$iv$iv = new ResourceLocation("the_vmod", "c2s_" + connName$iv + "_" + it$iv);
        $i$f$makeC2S = false;
        instance$iv$iv = new C2SConnection<ServerLimitsPacket>(id$iv$iv){
            private final ResourceLocation id;
            {
                this.id = $id;
            }

            public ResourceLocation getId() {
                return this.id;
            }

            public void serverHandler(FriendlyByteBuf buf, NetworkManager.PacketContext context) {
                ServerPlayer player;
                Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                Player player2 = context.getPlayer();
                Intrinsics.checkNotNull((Object)player2, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerPlayer");
                ServerPlayer player3 = (ServerPlayer)player2;
                T pkt = AutoSerializableKt.constructor(Reflection.getOrCreateKotlinClass(ServerLimitsPacket.class), buf);
                pkt.deserialize(buf);
                ServerPlayer serverPlayer = player3;
                ServerLimitsPacket pkt2 = (ServerLimitsPacket)pkt;
                boolean bl = false;
                if (!player.m_20310_(4)) {
                    player = player3;
                    pkt2 = (ServerLimitsPacket)pkt;
                    boolean bl2 = false;
                    MutableComponent mutableComponent = TranslatableKt.getSERVER_LIMITS_UPDATE_WAS_REJECTED();
                    Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"<get-SERVER_LIMITS_UPDATE_WAS_REJECTED>(...)");
                    ServerToolGunState.sendErrorTo$default(ServerToolGunState.INSTANCE, player, (Component)mutableComponent, false, 4, null);
                    return;
                }
                Player player4 = context.getPlayer();
                Intrinsics.checkNotNull((Object)player4, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerPlayer");
                player = (ServerPlayer)player4;
                pkt2 = (ServerLimitsPacket)pkt;
                boolean bl3 = false;
                ServerLimits.INSTANCE.setInstance(pkt2.getInstance());
            }
        };
        if (NetworkingKt.getRegisteredIDs().contains(instance$iv$iv.getId().toString())) {
            connection = instance$iv$iv;
        } else {
            Set<String> set = NetworkingKt.getRegisteredIDs();
            string = instance$iv$iv.getId().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            set.add(string);
            try {
                NetworkManager.registerReceiver((NetworkManager.Side)((C2SConnection)instance$iv$iv).getSide(), (ResourceLocation)instance$iv$iv.getId(), (NetworkManager.NetworkReceiver)((C2SConnection)instance$iv$iv).getHandler());
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            connection = instance$iv$iv;
        }
        c2sSendUpdatedServerLimits = connection;
    }
}

