/*
 * Decompiled with CFR 0.152.
 */
package net.spaceeye.vmod.networking;

import dev.architectury.networking.NetworkManager;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.spaceeye.vmod.networking.Connection;
import net.spaceeye.vmod.networking.Serializable;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001c\n\u0002\b\u0002\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H&J\u001b\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0016J!\u0010\u0017\u001a\u00020\r2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00140\u00192\u0006\u0010\u0015\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u001aR\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u001b"}, d2={"Lnet/spaceeye/vmod/networking/S2CConnection;", "T", "Lnet/spaceeye/vmod/networking/Serializable;", "Lnet/spaceeye/vmod/networking/Connection;", "<init>", "()V", "side", "Ldev/architectury/networking/NetworkManager$Side;", "getSide", "()Ldev/architectury/networking/NetworkManager$Side;", "getHandler", "Ldev/architectury/networking/NetworkManager$NetworkReceiver;", "clientHandler", "", "buf", "Lnet/minecraft/network/FriendlyByteBuf;", "context", "Ldev/architectury/networking/NetworkManager$PacketContext;", "sendToClient", "player", "Lnet/minecraft/server/level/ServerPlayer;", "packet", "(Lnet/minecraft/server/level/ServerPlayer;Lnet/spaceeye/vmod/networking/Serializable;)V", "sendToClients", "players", "", "(Ljava/lang/Iterable;Lnet/spaceeye/vmod/networking/Serializable;)V", "VMod"})
public abstract class S2CConnection<T extends Serializable>
implements Connection {
    @NotNull
    private final NetworkManager.Side side = NetworkManager.Side.S2C;

    @Override
    @NotNull
    public NetworkManager.Side getSide() {
        return this.side;
    }

    @Override
    @NotNull
    public NetworkManager.NetworkReceiver getHandler() {
        return this::clientHandler;
    }

    public abstract void clientHandler(@NotNull FriendlyByteBuf var1, @NotNull NetworkManager.PacketContext var2);

    public final void sendToClient(@NotNull ServerPlayer player, @NotNull T packet) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter(packet, (String)"packet");
        NetworkManager.sendToPlayer((ServerPlayer)player, (ResourceLocation)this.getId(), (FriendlyByteBuf)packet.serialize());
    }

    public final void sendToClients(@NotNull Iterable<? extends ServerPlayer> players, @NotNull T packet) {
        Intrinsics.checkNotNullParameter(players, (String)"players");
        Intrinsics.checkNotNullParameter(packet, (String)"packet");
        NetworkManager.sendToPlayers(players, (ResourceLocation)this.getId(), (FriendlyByteBuf)packet.serialize());
    }
}

