/*
 * Decompiled with CFR 0.152.
 */
package net.spaceeye.vmod.rendering;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.phys.Vec3;
import net.spaceeye.vmod.VMKt;
import net.spaceeye.vmod.events.PersistentEvents;
import net.spaceeye.vmod.rendering.RenderingData;
import net.spaceeye.vmod.rendering.RenderingSettings;
import net.spaceeye.vmod.rendering.RenderingStuff;
import net.spaceeye.vmod.rendering.types.BaseRenderer;
import net.spaceeye.vmod.rendering.types.BlockRenderer;
import net.spaceeye.vmod.rendering.types.PositionDependentRenderer;
import net.spaceeye.vmod.rendering.types.TimedRenderer;
import net.spaceeye.vmod.toolgun.ClientToolGunStateKt;
import net.spaceeye.vmod.translate.TranslatableKt;
import net.spaceeye.vmod.utils.GetNow_msKt;
import net.spaceeye.vmod.utils.Vector3d;
import org.jetbrains.annotations.NotNull;
import org.valkyrienskies.core.api.ships.ClientShip;
import org.valkyrienskies.core.apigame.world.ClientShipWorldCore;
import org.valkyrienskies.core.impl.game.ships.ShipObjectClientWorld;
import org.valkyrienskies.mod.common.VSGameUtilsKt;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\u001a&\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u001a0\u0010\f\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u00012\u0006\u0010\u0000\u001a\u00020\u0001H\u0002\u001a(\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u0001H\u0002\u001a(\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u0001H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"renderTick", "", "renderInWorld", "", "poseStack", "Lcom/mojang/blaze3d/vertex/PoseStack;", "camera", "Lnet/minecraft/client/Camera;", "minecraft", "Lnet/minecraft/client/Minecraft;", "renderBlockRenderers", "", "renderShipObjects", "timestamp", "renderTimedObjects", "renderClientsideObjects", "VMod"})
@SourceDebugExtension(value={"SMAP\nCustomRendering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CustomRendering.kt\nnet/spaceeye/vmod/rendering/CustomRenderingKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,179:1\n1549#2:180\n1620#2,3:181\n125#3:184\n152#3,3:185\n1#4:188\n*S KotlinDebug\n*F\n+ 1 CustomRendering.kt\nnet/spaceeye/vmod/rendering/CustomRenderingKt\n*L\n118#1:180\n118#1:181,3\n119#1:184\n119#1:185,3\n*E\n"})
public final class CustomRenderingKt {
    private static long renderTick;

    public static final void renderInWorld(@NotNull PoseStack poseStack, @NotNull Camera camera, @NotNull Minecraft minecraft, boolean renderBlockRenderers) {
        Intrinsics.checkNotNullParameter((Object)poseStack, (String)"poseStack");
        Intrinsics.checkNotNullParameter((Object)camera, (String)"camera");
        Intrinsics.checkNotNullParameter((Object)minecraft, (String)"minecraft");
        long now = GetNow_msKt.getNow_ms();
        PersistentEvents.INSTANCE.getClientPreRender().emit(new PersistentEvents.ClientPreRender(now));
        minecraft.m_91307_().m_6180_("vmod_rendering_ship_objects");
        long l = renderTick;
        renderTick = l + 1L;
        CustomRenderingKt.renderShipObjects(poseStack, camera, renderBlockRenderers, now, l);
        minecraft.m_91307_().m_7238_();
        minecraft.m_91307_().m_6180_("vmod_rendering_timed_objects");
        CustomRenderingKt.renderTimedObjects(poseStack, camera, renderBlockRenderers, now);
        minecraft.m_91307_().m_7238_();
        minecraft.m_91307_().m_6180_("vmod_rendering_clientside_objects");
        CustomRenderingKt.renderClientsideObjects(poseStack, camera, renderBlockRenderers, now);
        minecraft.m_91307_().m_7238_();
    }

    private static final void renderShipObjects(PoseStack poseStack, Camera camera, boolean renderBlockRenderers, long timestamp, long renderTick) {
        ClientLevel clientLevel = Minecraft.m_91087_().f_91073_;
        Intrinsics.checkNotNull((Object)clientLevel);
        ClientLevel level = clientLevel;
        try {
            Object it;
            Collection collection;
            ClientShip clientShip;
            Object item$iv$iv;
            Object $this$mapTo$iv$iv;
            Map data = RenderingData.INSTANCE.getClient().getData();
            Object $this$map$iv = (Iterable)VSGameUtilsKt.getShipObjectWorld((ClientLevel)level).getLoadedShips();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator<Object> iterator = $this$mapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                item$iv$iv = iterator.next();
                clientShip = (ClientShip)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getId());
            }
            List ids = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
            ClientShipWorldCore clientShipWorldCore = VSGameUtilsKt.getShipObjectWorld((ClientLevel)level);
            Intrinsics.checkNotNull((Object)clientShipWorldCore, (String)"null cannot be cast to non-null type org.valkyrienskies.core.impl.game.ships.ShipObjectClientWorld");
            $this$map$iv = ((ShipObjectClientWorld)clientShipWorldCore).getPhysicsEntities();
            collection = ids;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList($this$map$iv.size());
            $i$f$mapTo = false;
            iterator = $this$mapTo$iv$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                it = item$iv$iv = (Map.Entry)iterator.next();
                Collection collection2 = destination$iv$iv;
                boolean bl = false;
                collection2.add(((Number)it.getKey()).longValue());
            }
            collection.addAll((List)destination$iv$iv);
            Iterator iterator2 = ids.iterator();
            while (iterator2.hasNext()) {
                long id2 = ((Number)iterator2.next()).longValue();
                Map map2 = data.get(id2);
                if (map2 == null) continue;
                Iterator iterator3 = map2.entrySet().iterator();
                while (iterator3.hasNext()) {
                    BaseRenderer baseRenderer;
                    BaseRenderer render = (BaseRenderer)iterator3.next().getValue();
                    ClientShip it2 = clientShip = new PoseStack();
                    boolean bl = false;
                    it2.m_166856_();
                    it2.m_252931_(poseStack.m_85850_().m_252922_());
                    ClientShip poseStack2 = clientShip;
                    if (render instanceof BlockRenderer) {
                        if (!renderBlockRenderers || render.getRenderingTick() == renderTick) continue;
                        baseRenderer = render;
                        BlockRenderer it3 = (BlockRenderer)baseRenderer;
                        boolean bl2 = false;
                        it3.setRenderingTick(renderTick);
                        BlockRenderer blockRenderer = (BlockRenderer)baseRenderer;
                        MultiBufferSource.BufferSource bufferSource = RenderingStuff.INSTANCE.getBlockBuffer();
                        Intrinsics.checkNotNullExpressionValue((Object)bufferSource, (String)"<get-blockBuffer>(...)");
                        blockRenderer.renderBlockData((PoseStack)poseStack2, camera, (MultiBufferSource)bufferSource, timestamp);
                        continue;
                    }
                    if (renderBlockRenderers || render.getRenderingTick() == renderTick) continue;
                    BaseRenderer it4 = baseRenderer = render;
                    boolean bl3 = false;
                    it4.setRenderingTick(renderTick);
                    baseRenderer.renderData((PoseStack)poseStack2, camera, timestamp);
                }
            }
        }
        catch (ConcurrentModificationException e) {
            String string = "Got ConcurrentModificationException while rendering.\n" + ExceptionsKt.stackTraceToString((Throwable)e);
            MutableComponent mutableComponent = TranslatableKt.getRENDERING_HAS_THROWN_AN_EXCEPTION();
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"<get-RENDERING_HAS_THROWN_AN_EXCEPTION>(...)");
            ClientToolGunStateKt.CELOG(string, (Component)mutableComponent);
        }
        catch (Exception e) {
            VMKt.ELOG("Renderer raised exception:\n" + ExceptionsKt.stackTraceToString((Throwable)e));
        }
        catch (Error e) {
            VMKt.ELOG("Renderer raised error!!!\n" + ExceptionsKt.stackTraceToString((Throwable)e));
        }
    }

    private static final void renderTimedObjects(PoseStack poseStack, Camera camera, boolean renderBlockRenderers, long timestamp) {
        if (renderBlockRenderers) {
            return;
        }
        LocalPlayer localPlayer = Minecraft.m_91087_().f_91074_;
        Intrinsics.checkNotNull((Object)localPlayer);
        Vec3 vec3 = localPlayer.m_20182_();
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"position(...)");
        Vector3d cpos = new Vector3d(vec3);
        long now = GetNow_msKt.getNow_ms();
        List toDelete = new ArrayList();
        Map map2 = RenderingData.INSTANCE.getClient().getData().get(-1L);
        if (map2 == null) {
            return;
        }
        Map page = map2;
        for (Map.Entry entry2 : page.entrySet()) {
            PoseStack poseStack2;
            int idx = ((Number)entry2.getKey()).intValue();
            BaseRenderer render = (BaseRenderer)entry2.getValue();
            if (!(render instanceof TimedRenderer) || !(render instanceof PositionDependentRenderer)) {
                toDelete.add(idx);
                String string = "Found renderer in " + render.getClass().getSimpleName() + " in renderTimedObjects that didn't implement interface TimedRenderingData or PositionDependentRenderingData.";
                MutableComponent mutableComponent = TranslatableKt.getRENDERING_HAS_THROWN_AN_EXCEPTION();
                Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"<get-RENDERING_HAS_THROWN_AN_EXCEPTION>(...)");
                ClientToolGunStateKt.CELOG(string, (Component)mutableComponent);
                continue;
            }
            if (!((TimedRenderer)((Object)render)).getWasActivated() && ((TimedRenderer)((Object)render)).getActiveFor_ms() == -1L) {
                ((TimedRenderer)((Object)render)).setTimestampOfBeginning(now);
            }
            if (((TimedRenderer)((Object)render)).getActiveFor_ms() + ((TimedRenderer)((Object)render)).getTimestampOfBeginning() < now) {
                toDelete.add(idx);
                continue;
            }
            if (((PositionDependentRenderer)((Object)render)).getRenderingPosition().minus(cpos).sqrDist() > RenderingSettings.INSTANCE.getRenderingArea() * RenderingSettings.INSTANCE.getRenderingArea()) continue;
            PoseStack it = poseStack2 = new PoseStack();
            boolean bl = false;
            it.m_166856_();
            it.m_252931_(poseStack.m_85850_().m_252922_());
            PoseStack poseStack3 = poseStack2;
            ((TimedRenderer)((Object)render)).setWasActivated(true);
            render.renderData(poseStack3, camera, timestamp);
        }
        if (toDelete.isEmpty()) {
            return;
        }
        RenderingData.INSTANCE.getClient().removeTimedRenderers(toDelete);
    }

    private static final void renderClientsideObjects(PoseStack poseStack, Camera camera, boolean renderBlockRenderers, long timestamp) {
        Map map2 = RenderingData.INSTANCE.getClient().getData().get(-2L);
        if (map2 == null) {
            return;
        }
        Map page = map2;
        try {
            Iterator iterator = page.entrySet().iterator();
            while (iterator.hasNext()) {
                BaseRenderer baseRenderer;
                PoseStack poseStack2;
                BaseRenderer render = (BaseRenderer)iterator.next().getValue();
                PoseStack it = poseStack2 = new PoseStack();
                boolean bl = false;
                it.m_166856_();
                it.m_252931_(poseStack.m_85850_().m_252922_());
                PoseStack poseStack3 = poseStack2;
                if (render instanceof BlockRenderer) {
                    if (!renderBlockRenderers || render.getRenderingTick() == renderTick) continue;
                    baseRenderer = render;
                    BlockRenderer it2 = (BlockRenderer)baseRenderer;
                    boolean bl2 = false;
                    it2.setRenderingTick(renderTick);
                    BlockRenderer blockRenderer = (BlockRenderer)baseRenderer;
                    MultiBufferSource.BufferSource bufferSource = RenderingStuff.INSTANCE.getBlockBuffer();
                    Intrinsics.checkNotNullExpressionValue((Object)bufferSource, (String)"<get-blockBuffer>(...)");
                    blockRenderer.renderBlockData(poseStack3, camera, (MultiBufferSource)bufferSource, timestamp);
                    continue;
                }
                if (renderBlockRenderers || render.getRenderingTick() == renderTick) continue;
                BaseRenderer it3 = baseRenderer = render;
                boolean bl3 = false;
                it3.setRenderingTick(renderTick);
                baseRenderer.renderData(poseStack3, camera, timestamp);
            }
        }
        catch (ConcurrentModificationException e) {
            String string = "Got ConcurrentModificationException while rendering.\n" + ExceptionsKt.stackTraceToString((Throwable)e);
            MutableComponent mutableComponent = TranslatableKt.getRENDERING_HAS_THROWN_AN_EXCEPTION();
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"<get-RENDERING_HAS_THROWN_AN_EXCEPTION>(...)");
            ClientToolGunStateKt.CELOG(string, (Component)mutableComponent);
        }
        catch (Exception e) {
            VMKt.ELOG("Renderer raised exception:\n" + ExceptionsKt.stackTraceToString((Throwable)e));
        }
        catch (Error e) {
            VMKt.ELOG("Renderer raised error!!!\n" + ExceptionsKt.stackTraceToString((Throwable)e));
        }
    }
}

