/*
 * Decompiled with CFR 0.152.
 */
package net.spaceeye.vmod.rendering;

import java.awt.Color;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.spaceeye.vmod.rendering.RenderingData;
import net.spaceeye.vmod.rendering.types.TimedA2BRenderer;
import net.spaceeye.vmod.utils.GetNow_msKt;
import net.spaceeye.vmod.utils.RaycastFunctions;
import net.spaceeye.vmod.utils.Vector3d;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0007J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u001e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0005\u00a8\u0006\u0011"}, d2={"Lnet/spaceeye/vmod/rendering/Effects;", "", "<init>", "()V", "rad", "", "deg", "getRightSideClient", "Lnet/spaceeye/vmod/utils/Vector3d;", "player", "Lnet/minecraft/world/entity/player/Player;", "sendToolgunRayEffect", "", "playerSource", "result", "Lnet/spaceeye/vmod/utils/RaycastFunctions$RaycastResult;", "maxDistance", "VMod"})
public final class Effects {
    @NotNull
    public static final Effects INSTANCE = new Effects();

    private Effects() {
    }

    @JvmStatic
    public static final double rad(double deg) {
        return deg * (Math.PI / 180);
    }

    @NotNull
    public final Vector3d getRightSideClient(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        double p = Effects.rad(player.m_146909_());
        double y = -Effects.rad(player.f_20885_);
        Vector3d up = new Vector3d(Math.sin(p) * Math.sin(y), Math.cos(p), Math.sin(p) * Math.cos(y));
        Vector3d dir = new Vector3d(Math.cos(p) * Math.sin(y), -Math.sin(p), Math.cos(p) * Math.cos(y));
        Vector3d right = new Vector3d(-Math.cos(y), 0, Math.sin(y));
        Vec3 vec3 = player.m_146892_();
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"getEyePosition(...)");
        return new Vector3d(vec3).minus(up.times(0.1)).plus(right.times(0.25)).plus(dir.times(0.45));
    }

    public final void sendToolgunRayEffect(@NotNull Player playerSource, @NotNull RaycastFunctions.RaycastResult result, double maxDistance) {
        Intrinsics.checkNotNullParameter((Object)playerSource, (String)"playerSource");
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        Vector3d vector3d = result.getWorldHitPos();
        if (vector3d == null) {
            vector3d = result.getOrigin().plus(result.getLookVec().times(maxDistance));
        }
        Vector3d endPos = vector3d;
        RenderingData.INSTANCE.getServer().addTimedRenderer(new TimedA2BRenderer(this.getRightSideClient(playerSource), endPos, new Color(0, 255, 255, 200), 0.05, GetNow_msKt.getNow_ms(), 200L, result.getOrigin()));
    }
}

