/*
 * Decompiled with CFR 0.152.
 */
package net.spaceeye.vmod.rendering;

import dev.architectury.event.events.common.TickEvent;
import dev.architectury.networking.NetworkManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.spaceeye.vmod.networking.Serializable;
import net.spaceeye.vmod.networking.SynchronisedDataTransmitter;
import net.spaceeye.vmod.rendering.ReservedRenderingPages;
import net.spaceeye.vmod.rendering.types.BaseRenderer;
import net.spaceeye.vmod.rendering.types.TimedRenderer;
import net.spaceeye.vmod.utils.ClosableKt;
import net.spaceeye.vmod.utils.GetNow_msKt;
import net.spaceeye.vmod.utils.ServerObjectsHolder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.valkyrienskies.mod.common.VSGameUtilsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\u0010\"\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0002J(\u0010\u0012\u001a\u00020\u00072\u0010\u0010\u0013\u001a\f\u0012\b\u0012\u00060\tj\u0002`\u00150\u00142\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0002J \u0010\u0016\u001a\u00020\u00072\u0010\u0010\u0013\u001a\f\u0012\b\u0012\u00060\tj\u0002`\u00150\u00142\u0006\u0010\u0011\u001a\u00020\u0002J\u000e\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0007J\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0010\u001a\u00020\u0007J\b\u0010\u0019\u001a\u00020\u001aH\u0002J\u000e\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0002J\u000e\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001eR \u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001f"}, d2={"Lnet/spaceeye/vmod/rendering/ServerSynchronisedRenderingData;", "Lnet/spaceeye/vmod/networking/SynchronisedDataTransmitter;", "Lnet/spaceeye/vmod/rendering/types/BaseRenderer;", "<init>", "()V", "idToPages", "", "", "", "", "groundIds", "", "getGroundIds", "()Ljava/util/Collection;", "setUpdated", "", "id", "renderer", "setRenderer", "shipIds", "", "Lorg/valkyrienskies/core/api/ships/properties/ShipId;", "addRenderer", "removeRenderer", "getRenderer", "trimTimedRenderers", "", "addTimedRenderer", "subscribePlayerToReservedPages", "player", "Lnet/minecraft/server/level/ServerPlayer;", "VMod"})
@SourceDebugExtension(value={"SMAP\nSynchronisedRenderingData.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SynchronisedRenderingData.kt\nnet/spaceeye/vmod/rendering/ServerSynchronisedRenderingData\n+ 2 SynchronisedData.kt\nnet/spaceeye/vmod/networking/SynchronisedDataTransmitter\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,231:1\n56#2,2:232\n56#2,2:234\n56#2,2:240\n56#2,2:245\n56#2,2:254\n56#2,2:258\n56#2,2:262\n766#3:236\n857#3,2:237\n766#3:242\n857#3,2:243\n1549#3:247\n1620#3,3:248\n1747#3,3:251\n1855#3,2:256\n1855#3,2:260\n1855#3,2:264\n1#4:239\n*S KotlinDebug\n*F\n+ 1 SynchronisedRenderingData.kt\nnet/spaceeye/vmod/rendering/ServerSynchronisedRenderingData\n*L\n102#1:232,2\n108#1:234,2\n115#1:240,2\n122#1:245,2\n128#1:254,2\n134#1:258,2\n151#1:262,2\n109#1:236\n109#1:237,2\n116#1:242\n116#1:243,2\n125#1:247\n125#1:248,3\n125#1:251,3\n130#1:256,2\n146#1:260,2\n157#1:264,2\n*E\n"})
public final class ServerSynchronisedRenderingData
extends SynchronisedDataTransmitter<BaseRenderer> {
    @NotNull
    private Map<Integer, Set<Long>> idToPages;

    public ServerSynchronisedRenderingData() {
        super("rendering_data", NetworkManager.Side.C2S, NetworkManager.Side.S2C, 1000000, (Function2<? super FriendlyByteBuf, ? super Serializable, Unit>)((Function2)1.INSTANCE), (Function1<? super FriendlyByteBuf, ? extends Serializable>)((Function1)2.INSTANCE));
        ClosableKt.addCustomServerClosable((Function0<Unit>)((Function0)() -> ServerSynchronisedRenderingData._init_$lambda$0(this)));
        TickEvent.SERVER_PRE.register(arg_0 -> ServerSynchronisedRenderingData._init_$lambda$1(this, arg_0));
        this.idToPages = new LinkedHashMap();
    }

    private final Collection<Long> getGroundIds() {
        ServerLevel serverLevel = ServerObjectsHolder.INSTANCE.getOverworldServerLevel();
        Intrinsics.checkNotNull((Object)serverLevel);
        return VSGameUtilsKt.getShipObjectWorld((ServerLevel)serverLevel).getDimensionToGroundBodyIdImmutable().values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean setUpdated(int id2, @NotNull BaseRenderer renderer) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)renderer, (String)"renderer");
        SynchronisedDataTransmitter this_$iv = this;
        boolean $i$f$lock = false;
        ReentrantLock reentrantLock = SynchronisedDataTransmitter.access$getLock(this_$iv);
        synchronized (reentrantLock) {
            boolean bl2;
            boolean bl3 = false;
            boolean bl4 = false;
            Set<Long> set = this.idToPages.get(id2);
            if (set == null) {
                bl2 = false;
            } else {
                Set<Long> pages = set;
                this.set(pages, id2, (Serializable)renderer);
                bl2 = true;
            }
            bl = bl2;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final int setRenderer(@NotNull List<Long> shipIds, int id2, @NotNull BaseRenderer renderer) {
        Intrinsics.checkNotNullParameter(shipIds, (String)"shipIds");
        Intrinsics.checkNotNullParameter((Object)renderer, (String)"renderer");
        SynchronisedDataTransmitter this_$iv = this;
        boolean $i$f$lock = false;
        ReentrantLock reentrantLock = SynchronisedDataTransmitter.access$getLock(this_$iv);
        synchronized (reentrantLock) {
            List list;
            void $this$filterTo$iv$iv;
            boolean bl = false;
            boolean bl2 = false;
            Iterable $this$filter$iv = shipIds;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                long it = ((Number)element$iv$iv).longValue();
                boolean bl3 = false;
                if (!(!this.getGroundIds().contains(it))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List it = list = (List)destination$iv$iv;
            boolean bl4 = false;
            if (it.isEmpty()) {
                throw new NotImplementedError("World Renderers are not implemented");
            }
            Set idsToUse = CollectionsKt.toSet((Iterable)list);
            this.set(idsToUse, id2, (Serializable)renderer);
            Integer n = id2;
            this.idToPages.put(n, idsToUse);
            int n2 = id2;
            return n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final int addRenderer(@NotNull List<Long> shipIds, @NotNull BaseRenderer renderer) {
        Intrinsics.checkNotNullParameter(shipIds, (String)"shipIds");
        Intrinsics.checkNotNullParameter((Object)renderer, (String)"renderer");
        SynchronisedDataTransmitter this_$iv = this;
        boolean $i$f$lock = false;
        ReentrantLock reentrantLock = SynchronisedDataTransmitter.access$getLock(this_$iv);
        synchronized (reentrantLock) {
            void $this$filterTo$iv$iv;
            boolean bl = false;
            boolean bl2 = false;
            Iterable $this$filter$iv = shipIds;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                long it = ((Number)element$iv$iv).longValue();
                boolean bl3 = false;
                if (!(!this.getGroundIds().contains(it))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable it = $this$filter$iv = (List)destination$iv$iv;
            boolean bl4 = false;
            if (it.isEmpty()) {
                throw new NotImplementedError("World Renderers are not implemented");
            }
            Set idsToUse = CollectionsKt.toSet((Iterable)$this$filter$iv);
            int id2 = this.add(idsToUse, (Serializable)renderer);
            Integer n = id2;
            this.idToPages.put(n, idsToUse);
            int n2 = id2;
            return n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final boolean removeRenderer(int id2) {
        SynchronisedDataTransmitter this_$iv = this;
        boolean $i$f$lock = false;
        ReentrantLock reentrantLock = SynchronisedDataTransmitter.access$getLock(this_$iv);
        synchronized (reentrantLock) {
            boolean bl;
            block9: {
                void $this$any$iv;
                void $this$mapTo$iv$iv;
                Set<Long> set;
                block8: {
                    boolean bl2 = false;
                    boolean bl3 = false;
                    if (this.idToPages.get(id2) != null) break block8;
                    boolean bl4 = false;
                    return bl4;
                }
                Set<Long> pageIds = set;
                this.idToPages.remove(id2);
                Iterable $this$map$iv = pageIds;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void pageId;
                    long l = ((Number)item$iv$iv).longValue();
                    Collection collection = destination$iv$iv;
                    boolean bl5 = false;
                    collection.add(this.remove((long)pageId, id2));
                }
                $this$map$iv = (List)destination$iv$iv;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        boolean it = (Boolean)element$iv;
                        boolean bl6 = false;
                        if (!it) continue;
                        bl = true;
                        break block9;
                    }
                    bl = false;
                }
            }
            boolean bl7 = bl;
            return bl7;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public final BaseRenderer getRenderer(int id2) {
        SynchronisedDataTransmitter this_$iv = this;
        boolean $i$f$lock = false;
        ReentrantLock reentrantLock = SynchronisedDataTransmitter.access$getLock(this_$iv);
        synchronized (reentrantLock) {
            long pageId;
            Object object;
            boolean bl = false;
            boolean bl2 = false;
            Set<Long> set = this.idToPages.get(id2);
            if (set == null) {
                return null;
            }
            Set<Long> pagesId = set;
            Iterable $this$forEach$iv = pagesId;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.iterator();
            do {
                if (!iterator.hasNext()) {
                    return null;
                }
                Object element$iv = iterator.next();
                pageId = ((Number)element$iv).longValue();
                boolean bl3 = false;
            } while ((object = this.get(pageId)) == null || (object = (BaseRenderer)object.get(id2)) == null);
            Object it = object;
            boolean bl4 = false;
            return it;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void trimTimedRenderers() {
        SynchronisedDataTransmitter this_$iv = this;
        boolean $i$f$lock = false;
        ReentrantLock reentrantLock = SynchronisedDataTransmitter.access$getLock(this_$iv);
        synchronized (reentrantLock) {
            boolean bl = false;
            boolean bl2 = false;
            Map map2 = this.get(-1L);
            if (map2 == null) {
                return;
            }
            Map page = map2;
            if (page.isEmpty()) {
                return;
            }
            List toRemove = new ArrayList();
            long current = GetNow_msKt.getNow_ms();
            try {
                for (Map.Entry entry2 : page.entrySet()) {
                    int k = ((Number)entry2.getKey()).intValue();
                    BaseRenderer item = (BaseRenderer)entry2.getValue();
                    if (!(item instanceof TimedRenderer)) {
                        toRemove.add(k);
                        continue;
                    }
                    if (((TimedRenderer)((Object)item)).getTimestampOfBeginning() + ((TimedRenderer)((Object)item)).getActiveFor_ms() >= current) continue;
                    toRemove.add(k);
                }
                Iterable $this$forEach$iv = toRemove;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    int it = ((Number)element$iv).intValue();
                    boolean bl3 = false;
                    this.remove(-1L, it);
                }
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                return;
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int addTimedRenderer(@NotNull BaseRenderer renderer) {
        int n;
        Intrinsics.checkNotNullParameter((Object)renderer, (String)"renderer");
        SynchronisedDataTransmitter this_$iv = this;
        boolean $i$f$lock = false;
        ReentrantLock reentrantLock = SynchronisedDataTransmitter.access$getLock(this_$iv);
        synchronized (reentrantLock) {
            boolean bl = false;
            boolean bl2 = false;
            this.trimTimedRenderers();
            n = this.add(-1L, (Serializable)renderer);
        }
        return n;
    }

    public final void subscribePlayerToReservedPages(@NotNull ServerPlayer player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Iterable $this$forEach$iv = ReservedRenderingPages.INSTANCE.getReservedPages();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            long it = ((Number)element$iv).longValue();
            boolean bl = false;
            UUID uUID = player.m_20148_();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
            this.subscribeTo(uUID, (Player)player, it);
        }
    }

    private static final Unit _init_$lambda$0(ServerSynchronisedRenderingData this$0) {
        this$0.close();
        this$0.idToPages.clear();
        return Unit.INSTANCE;
    }

    private static final void _init_$lambda$1(ServerSynchronisedRenderingData this$0, MinecraftServer it) {
        this$0.synchronizationTick();
    }
}

