/*
 * Decompiled with CFR 0.152.
 */
package net.spaceeye.vmod.rendering;

import dev.architectury.event.events.common.PlayerEvent;
import dev.architectury.utils.EnvExecutor;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.api.distmarker.Dist;
import net.spaceeye.vmod.events.AVSEvents;
import net.spaceeye.vmod.networking.S2CConnection;
import net.spaceeye.vmod.networking.Serializable;
import net.spaceeye.vmod.rendering.ClientSynchronisedRenderingData;
import net.spaceeye.vmod.rendering.RenderingTypes;
import net.spaceeye.vmod.rendering.ServerSetRenderingSchemaPacket;
import net.spaceeye.vmod.rendering.ServerSynchronisedRenderingData;
import org.jetbrains.annotations.NotNull;
import org.valkyrienskies.core.api.ships.Ship;
import org.valkyrienskies.core.impl.game.phys_entities.PhysicsEntityClient;
import org.valkyrienskies.core.impl.game.ships.ShipData;
import org.valkyrienskies.core.impl.game.ships.ShipObjectClient;
import org.valkyrienskies.core.impl.hooks.VSEvents;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0010\u001a\u00020\u0011H\u0002J\b\u0010\u0012\u001a\u00020\u0011H\u0002R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0013"}, d2={"Lnet/spaceeye/vmod/rendering/SynchronisedRenderingData;", "", "<init>", "()V", "clientSynchronisedData", "Lnet/spaceeye/vmod/rendering/ClientSynchronisedRenderingData;", "getClientSynchronisedData", "()Lnet/spaceeye/vmod/rendering/ClientSynchronisedRenderingData;", "setClientSynchronisedData", "(Lnet/spaceeye/vmod/rendering/ClientSynchronisedRenderingData;)V", "serverSynchronisedData", "Lnet/spaceeye/vmod/rendering/ServerSynchronisedRenderingData;", "getServerSynchronisedData", "()Lnet/spaceeye/vmod/rendering/ServerSynchronisedRenderingData;", "setServerSynchronisedData", "(Lnet/spaceeye/vmod/rendering/ServerSynchronisedRenderingData;)V", "makeClientEvents", "", "makeServerEvents", "VMod"})
final class SynchronisedRenderingData {
    @NotNull
    public static final SynchronisedRenderingData INSTANCE = new SynchronisedRenderingData();
    @NotNull
    private static ClientSynchronisedRenderingData clientSynchronisedData = new ClientSynchronisedRenderingData();
    @NotNull
    private static ServerSynchronisedRenderingData serverSynchronisedData = new ServerSynchronisedRenderingData();

    private SynchronisedRenderingData() {
    }

    @NotNull
    public final ClientSynchronisedRenderingData getClientSynchronisedData() {
        return clientSynchronisedData;
    }

    public final void setClientSynchronisedData(@NotNull ClientSynchronisedRenderingData clientSynchronisedRenderingData) {
        Intrinsics.checkNotNullParameter((Object)clientSynchronisedRenderingData, (String)"<set-?>");
        clientSynchronisedData = clientSynchronisedRenderingData;
    }

    @NotNull
    public final ServerSynchronisedRenderingData getServerSynchronisedData() {
        return serverSynchronisedData;
    }

    public final void setServerSynchronisedData(@NotNull ServerSynchronisedRenderingData serverSynchronisedRenderingData) {
        Intrinsics.checkNotNullParameter((Object)serverSynchronisedRenderingData, (String)"<set-?>");
        serverSynchronisedData = serverSynchronisedRenderingData;
    }

    private final void makeClientEvents() {
        EnvExecutor.runInEnv((Dist)Dist.CLIENT, SynchronisedRenderingData::makeClientEvents$lambda$5);
    }

    private final void makeServerEvents() {
        AVSEvents.INSTANCE.getServerShipRemoveEvent().on((Function2<AVSEvents.ServerShipRemoveEvent, Function0<Unit>, Unit>)((Function2)SynchronisedRenderingData::makeServerEvents$lambda$6));
        PlayerEvent.PLAYER_JOIN.register(SynchronisedRenderingData::makeServerEvents$lambda$7);
        PlayerEvent.PLAYER_QUIT.register(SynchronisedRenderingData::makeServerEvents$lambda$8);
    }

    private static final void makeClientEvents$lambda$5$lambda$4$lambda$0(VSEvents.ShipLoadEventClient shipLoadEventClient) {
        Intrinsics.checkNotNullParameter((Object)shipLoadEventClient, (String)"<destruct>");
        ShipObjectClient ship = shipLoadEventClient.component1();
        clientSynchronisedData.subscribeToPageUpdates(ship.getId());
    }

    private static final Unit makeClientEvents$lambda$5$lambda$4$lambda$1(AVSEvents.ClientShipUnloadEvent clientShipUnloadEvent, Function0 function0) {
        Intrinsics.checkNotNullParameter((Object)clientShipUnloadEvent, (String)"<destruct>");
        Intrinsics.checkNotNullParameter((Object)function0, (String)"<unused var>");
        Ship ship = clientShipUnloadEvent.component1();
        Ship ship2 = ship;
        if (ship2 == null) {
            return Unit.INSTANCE;
        }
        clientSynchronisedData.unsubscribeFromPageUpdates(ship2.getId());
        return Unit.INSTANCE;
    }

    private static final Unit makeClientEvents$lambda$5$lambda$4$lambda$2(AVSEvents.ClientPhysEntityLoad clientPhysEntityLoad, Function0 function0) {
        Intrinsics.checkNotNullParameter((Object)clientPhysEntityLoad, (String)"<destruct>");
        Intrinsics.checkNotNullParameter((Object)function0, (String)"<unused var>");
        PhysicsEntityClient data = clientPhysEntityLoad.component1();
        clientSynchronisedData.subscribeToPageUpdates(data.getId());
        return Unit.INSTANCE;
    }

    private static final Unit makeClientEvents$lambda$5$lambda$4$lambda$3(long id2, Function0 function0) {
        Intrinsics.checkNotNullParameter((Object)function0, (String)"<unused var>");
        clientSynchronisedData.unsubscribeFromPageUpdates(id2);
        return Unit.INSTANCE;
    }

    private static final void makeClientEvents$lambda$5$lambda$4() {
        VSEvents.INSTANCE.getShipLoadEventClient().on(SynchronisedRenderingData::makeClientEvents$lambda$5$lambda$4$lambda$0);
        AVSEvents.INSTANCE.getClientShipUnloadEvent().on((Function2<AVSEvents.ClientShipUnloadEvent, Function0<Unit>, Unit>)((Function2)SynchronisedRenderingData::makeClientEvents$lambda$5$lambda$4$lambda$1));
        AVSEvents.INSTANCE.getClientPhysEntityLoad().on((Function2<AVSEvents.ClientPhysEntityLoad, Function0<Unit>, Unit>)((Function2)SynchronisedRenderingData::makeClientEvents$lambda$5$lambda$4$lambda$2));
        AVSEvents.INSTANCE.getClientPhysEntityUnload().on((Function2<Long, Function0<Unit>, Unit>)((Function2)SynchronisedRenderingData::makeClientEvents$lambda$5$lambda$4$lambda$3));
    }

    private static final Runnable makeClientEvents$lambda$5() {
        return SynchronisedRenderingData::makeClientEvents$lambda$5$lambda$4;
    }

    private static final Unit makeServerEvents$lambda$6(AVSEvents.ServerShipRemoveEvent serverShipRemoveEvent, Function0 handler) {
        Intrinsics.checkNotNullParameter((Object)serverShipRemoveEvent, (String)"<destruct>");
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        ShipData shipData = serverShipRemoveEvent.component1();
        serverSynchronisedData.remove(shipData.getId());
        return Unit.INSTANCE;
    }

    private static final void makeServerEvents$lambda$7(ServerPlayer it) {
        S2CConnection<ServerSetRenderingSchemaPacket> s2CConnection = clientSynchronisedData.getS2cSetSchema();
        Intrinsics.checkNotNull((Object)it);
        s2CConnection.sendToClient(it, (ServerSetRenderingSchemaPacket)((Serializable)new ServerSetRenderingSchemaPacket(RenderingTypes.INSTANCE.getSchema())));
        serverSynchronisedData.subscribePlayerToReservedPages(it);
    }

    private static final void makeServerEvents$lambda$8(ServerPlayer it) {
        UUID uUID = it.m_20148_();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
        serverSynchronisedData.removeSubscriber(uUID);
    }

    static {
        INSTANCE.makeServerEvents();
        INSTANCE.makeClientEvents();
    }
}

