/*
 * Decompiled with CFR 0.152.
 */
package net.spaceeye.vmod.rendering.types;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.awt.Color;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KProperty;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.spaceeye.vmod.reflectable.AutoSerializable;
import net.spaceeye.vmod.reflectable.ReflectableItem;
import net.spaceeye.vmod.reflectable.ReflectableItemDelegate;
import net.spaceeye.vmod.reflectable.ReflectableObject;
import net.spaceeye.vmod.rendering.RenderSetups;
import net.spaceeye.vmod.rendering.RenderingUtils;
import net.spaceeye.vmod.rendering.types.BaseRenderer;
import net.spaceeye.vmod.rendering.types.PhysgunRayRendererKt;
import net.spaceeye.vmod.rendering.types.PositionDependentRenderer;
import net.spaceeye.vmod.rendering.types.TimedRenderer;
import net.spaceeye.vmod.utils.RaycastFunctions;
import net.spaceeye.vmod.utils.Vector3d;
import net.spaceeye.vmod.utils.vs.VSShipPosTransformsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.valkyrienskies.core.api.ships.ClientShip;
import org.valkyrienskies.core.api.ships.Ship;
import org.valkyrienskies.mod.common.VSGameUtilsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0001\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004:\u0001AB\u0007\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0011H\u0016J\u001e\u0010(\u001a\u00020\u001f2\u0006\u0010)\u001a\u00020\u001f2\u0006\u0010*\u001a\u00020\u001f2\u0006\u0010+\u001a\u00020,J&\u0010-\u001a\u00020\u001f2\u0006\u0010.\u001a\u00020\u001f2\u0006\u0010/\u001a\u00020\u001f2\u0006\u00100\u001a\u00020\u001f2\u0006\u0010+\u001a\u00020,J \u00101\u001a\u00020\u00132\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u00020\u0016H\u0016JF\u00107\u001a\u0004\u0018\u00010\u00012\u0016\u00108\u001a\u0012\u0012\b\u0012\u00060\u0016j\u0002`:\u0012\u0004\u0012\u00020;092\"\u0010<\u001a\u001e\u0012\b\u0012\u00060\u0016j\u0002`:\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\u001f0=09H\u0016J\u0010\u0010>\u001a\u00020?2\u0006\u0010@\u001a\u00020,H\u0016R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0016\u0010\r\u001a\u0004\u0018\u00010\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR$\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0015\u001a\u00020\u00168V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001c\u001a\u00020\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u0019R\u0014\u0010\u001e\u001a\u00020\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u001a\u0010\"\u001a\u00020#X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'\u00a8\u0006B"}, d2={"Lnet/spaceeye/vmod/rendering/types/PhysgunRayRenderer;", "Lnet/spaceeye/vmod/rendering/types/BaseRenderer;", "Lnet/spaceeye/vmod/rendering/types/TimedRenderer;", "Lnet/spaceeye/vmod/rendering/types/PositionDependentRenderer;", "Lnet/spaceeye/vmod/reflectable/ReflectableObject;", "<init>", "()V", "data", "Lnet/spaceeye/vmod/rendering/types/PhysgunRayRenderer$Data;", "getData", "()Lnet/spaceeye/vmod/rendering/types/PhysgunRayRenderer$Data;", "setData", "(Lnet/spaceeye/vmod/rendering/types/PhysgunRayRenderer$Data;)V", "reflectObjectOverride", "getReflectObjectOverride", "()Lnet/spaceeye/vmod/reflectable/ReflectableObject;", "serialize", "Lnet/minecraft/network/FriendlyByteBuf;", "deserialize", "", "buf", "value", "", "timestampOfBeginning", "getTimestampOfBeginning", "()J", "setTimestampOfBeginning", "(J)V", "activeFor_ms", "getActiveFor_ms", "renderingPosition", "Lnet/spaceeye/vmod/utils/Vector3d;", "getRenderingPosition", "()Lnet/spaceeye/vmod/utils/Vector3d;", "wasActivated", "", "getWasActivated", "()Z", "setWasActivated", "(Z)V", "lerp", "a", "b", "f", "", "quadBeizer", "start", "middle", "stop", "renderData", "poseStack", "Lcom/mojang/blaze3d/vertex/PoseStack;", "camera", "Lnet/minecraft/client/Camera;", "timestamp", "copy", "oldToNew", "", "Lorg/valkyrienskies/core/api/ships/properties/ShipId;", "Lorg/valkyrienskies/core/api/ships/Ship;", "centerPositions", "Lkotlin/Pair;", "scaleBy", "", "by", "Data", "VMod"})
public final class PhysgunRayRenderer
extends BaseRenderer
implements TimedRenderer,
PositionDependentRenderer,
ReflectableObject {
    @NotNull
    private Data data = new Data();
    private boolean wasActivated;

    @NotNull
    public final Data getData() {
        return this.data;
    }

    public final void setData(@NotNull Data data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"<set-?>");
        this.data = data;
    }

    @Override
    @Nullable
    public ReflectableObject getReflectObjectOverride() {
        return this.data;
    }

    @Override
    @NotNull
    public FriendlyByteBuf serialize() {
        return this.data.serialize();
    }

    @Override
    public void deserialize(@NotNull FriendlyByteBuf buf) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        this.data.deserialize(buf);
    }

    @Override
    public long getTimestampOfBeginning() {
        return this.data.getTimestampOfBeginning();
    }

    @Override
    public void setTimestampOfBeginning(long value) {
        this.data.setTimestampOfBeginning(value);
    }

    @Override
    public long getActiveFor_ms() {
        return this.data.getActiveFor_ms();
    }

    @Override
    @NotNull
    public Vector3d getRenderingPosition() {
        Data $this$_get_renderingPosition__u24lambda_u240 = this.data;
        boolean bl = false;
        ClientLevel clientLevel = Minecraft.m_91087_().f_91073_;
        Intrinsics.checkNotNull((Object)clientLevel);
        Player player = clientLevel.m_46003_($this$_get_renderingPosition__u24lambda_u240.getPlayer());
        if (player == null) {
            return new Vector3d(999999999, 999999999, 999999999);
        }
        Player player2 = player;
        Vec3 vec3 = player2.m_146892_();
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"getEyePosition(...)");
        return new Vector3d(vec3);
    }

    @Override
    public boolean getWasActivated() {
        return this.wasActivated;
    }

    @Override
    public void setWasActivated(boolean bl) {
        this.wasActivated = bl;
    }

    @NotNull
    public final Vector3d lerp(@NotNull Vector3d a, @NotNull Vector3d b, double f) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        return a.times(1.0 - f).plus(b.times(f));
    }

    @NotNull
    public final Vector3d quadBeizer(@NotNull Vector3d start, @NotNull Vector3d middle, @NotNull Vector3d stop, double f) {
        Intrinsics.checkNotNullParameter((Object)start, (String)"start");
        Intrinsics.checkNotNullParameter((Object)middle, (String)"middle");
        Intrinsics.checkNotNullParameter((Object)stop, (String)"stop");
        Vector3d a = this.lerp(start, middle, f);
        Vector3d b = this.lerp(middle, stop, f);
        Vector3d c = this.lerp(a, b, f);
        return c;
    }

    @Override
    public void renderData(@NotNull PoseStack poseStack, @NotNull Camera camera, long timestamp) {
        Vector3d vector3d;
        Vector3d raycastPos;
        double width;
        Color color;
        Vector3d point1;
        Vector3d dir;
        block11: {
            block12: {
                ClientLevel level;
                Data $this$renderData_u24lambda_u242;
                block10: {
                    Vector3d vector3d2;
                    Pair pair;
                    boolean inFirstPerson;
                    Intrinsics.checkNotNullParameter((Object)poseStack, (String)"poseStack");
                    Intrinsics.checkNotNullParameter((Object)camera, (String)"camera");
                    $this$renderData_u24lambda_u242 = this.data;
                    boolean bl = false;
                    LocalPlayer selfPlayer = Minecraft.m_91087_().f_91074_;
                    ClientLevel clientLevel = Minecraft.m_91087_().f_91073_;
                    Intrinsics.checkNotNull((Object)clientLevel);
                    Player player = clientLevel.m_46003_($this$renderData_u24lambda_u242.getPlayer());
                    if (player == null) {
                        return;
                    }
                    Player player2 = player;
                    Level level2 = player2.m_9236_();
                    Intrinsics.checkNotNull((Object)level2, (String)"null cannot be cast to non-null type net.minecraft.client.multiplayer.ClientLevel");
                    level = (ClientLevel)level2;
                    LocalPlayer localPlayer = selfPlayer;
                    boolean bl2 = inFirstPerson = Intrinsics.areEqual((Object)player2.m_20148_(), (Object)(localPlayer != null ? localPlayer.m_20148_() : null)) && !camera.m_90594_();
                    if (inFirstPerson) {
                        Vector3f vector3f = camera.m_253058_();
                        Intrinsics.checkNotNullExpressionValue((Object)vector3f, (String)"getLookVector(...)");
                        Vector3d dir2 = new Vector3d(vector3f).snormalize();
                        Vec3 vec3 = camera.m_90583_();
                        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"getPosition(...)");
                        Vector3d vector3d3 = new Vector3d(vec3);
                        Vector3f vector3f2 = camera.m_253028_();
                        Intrinsics.checkNotNullExpressionValue((Object)vector3f2, (String)"getUpVector(...)");
                        Vector3d vector3d4 = vector3d3.minus(new Vector3d(vector3f2).times(0.2));
                        Vector3f vector3f3 = camera.m_252775_();
                        Intrinsics.checkNotNullExpressionValue((Object)vector3f3, (String)"getLeftVector(...)");
                        Vector3d pos = vector3d4.minus(new Vector3d(vector3f3).times(0.6)).plus(dir2.times(0.45));
                        pair = new Pair((Object)pos, (Object)dir2);
                    } else {
                        Vec3 vec3 = player2.m_146892_();
                        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"getEyePosition(...)");
                        Vector3d pos = new Vector3d(vec3);
                        Vec3 vec32 = player2.m_20154_();
                        Intrinsics.checkNotNullExpressionValue((Object)vec32, (String)"getLookAngle(...)");
                        dir = new Vector3d(vec32).snormalize();
                        pair = new Pair((Object)pos, (Object)dir);
                    }
                    Pair pair2 = pair;
                    point1 = (Vector3d)pair2.component1();
                    dir = (Vector3d)pair2.component2();
                    color = new Color(0, 0, 255, 100);
                    width = 0.1;
                    Level level3 = (Level)level;
                    if (inFirstPerson) {
                        Vec3 vec3 = camera.m_90583_();
                        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"getPosition(...)");
                        vector3d2 = new Vector3d(vec3);
                    } else {
                        Vec3 vec3 = player2.m_146892_();
                        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"getEyePosition(...)");
                        vector3d2 = new Vector3d(vec3);
                    }
                    RaycastFunctions.RaycastResult raycastResult = RaycastFunctions.renderRaycast$default(RaycastFunctions.INSTANCE, level3, new RaycastFunctions.Source(dir, vector3d2), 100.0, null, null, null, null, null, 248, null);
                    Vector3d vector3d5 = raycastResult.getWorldHitPos();
                    if (vector3d5 == null) {
                        vector3d5 = raycastPos = point1.plus(dir.times(100.0));
                    }
                    if ($this$renderData_u24lambda_u242.getShipId() != -1L) break block10;
                    vector3d = raycastPos;
                    break block11;
                }
                vector3d = (ClientShip)VSGameUtilsKt.getShipObjectWorld((ClientLevel)level).getLoadedShips().getById($this$renderData_u24lambda_u242.getShipId());
                if (vector3d == null) break block12;
                Vector3d it = vector3d;
                boolean bl = false;
                Vector3d vector3d6 = VSShipPosTransformsKt.posShipToWorldRender$default((ClientShip)it, $this$renderData_u24lambda_u242.getHitPosInShipyard(), null, 4, null);
                vector3d = vector3d6;
                if (vector3d6 != null) break block11;
            }
            return;
        }
        Vector3d point2 = vector3d;
        Vector3d linePoint = PhysgunRayRendererKt.closestPointOnALineToAnotherPoint(point2, point1, raycastPos);
        double length = linePoint.minus(point1).dist();
        Vector3d middle = point1.plus(dir.times(length / 2.0));
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder vBuffer = tesselator.m_85915_();
        poseStack.m_85836_();
        int light = 0xF000F0;
        vBuffer.m_166779_(VertexFormat.Mode.QUADS, RenderSetups.INSTANCE.setupPCRendering());
        RenderSystem.enableCull();
        poseStack.m_85837_(-camera.m_90583_().f_82479_, -camera.m_90583_().f_82480_, -camera.m_90583_().f_82481_);
        Matrix4f matrix = poseStack.m_85850_().m_252922_();
        Vector3f vector3f = camera.m_253028_();
        Intrinsics.checkNotNullExpressionValue((Object)vector3f, (String)"getUpVector(...)");
        Vector3d up = new Vector3d(vector3f);
        Vector3f vector3f4 = camera.m_252775_();
        Intrinsics.checkNotNullExpressionValue((Object)vector3f4, (String)"getLeftVector(...)");
        Vector3d right = new Vector3d(vector3f4).unaryMinus();
        int num = 32;
        Vector3d fpos = point1;
        List<Vector3d> leftPoints = RenderingUtils.Quad.makePolygon(4, width, up, right, point1);
        int i2 = 1;
        while (true) {
            Vector3d spos = this.quadBeizer(point1, middle, point2, (double)i2 / (double)num);
            Vector3d dir3 = fpos.minus(spos).snormalize();
            right = dir3.cross(up);
            List<Vector3d> rightPoints = RenderingUtils.Quad.makePolygon(4, width, up, right, spos);
            Intrinsics.checkNotNull((Object)vBuffer);
            VertexConsumer vertexConsumer = (VertexConsumer)vBuffer;
            Intrinsics.checkNotNull((Object)matrix);
            RenderingUtils.Quad.drawPolygonTube(vertexConsumer, matrix, color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha(), light, light, 0.0f, 0.0f, leftPoints, rightPoints);
            leftPoints = rightPoints;
            fpos = spos;
            if (i2 == num) break;
            ++i2;
        }
        tesselator.m_85914_();
        poseStack.m_85849_();
        RenderSetups.INSTANCE.clearPCRendering();
    }

    @Override
    @Nullable
    public BaseRenderer copy(@NotNull Map<Long, ? extends Ship> oldToNew, @NotNull Map<Long, Pair<Vector3d, Vector3d>> centerPositions) {
        Intrinsics.checkNotNullParameter(oldToNew, (String)"oldToNew");
        Intrinsics.checkNotNullParameter(centerPositions, (String)"centerPositions");
        throw new AssertionError((Object)"shouldn't be copied");
    }

    @NotNull
    public Void scaleBy(double by) {
        throw new AssertionError((Object)"shouldn't be scaled");
    }

    @Override
    @JsonIgnore
    @ApiStatus.NonExtendable
    @NotNull
    public List<ReflectableItemDelegate<?>> getAllReflectableItems(boolean processSubReflectables, @NotNull Function1<? super ReflectableItemDelegate<?>, Boolean> filterBy) {
        return ReflectableObject.DefaultImpls.getAllReflectableItems(this, processSubReflectables, filterBy);
    }

    @Override
    @JsonIgnore
    @ApiStatus.NonExtendable
    @NotNull
    public List<ReflectableItemDelegate<?>> getReflectableItemsWithoutDataclassConstructorItems(boolean processSubReflectables, @NotNull Function1<? super ReflectableItemDelegate<?>, Boolean> filterBy) {
        return ReflectableObject.DefaultImpls.getReflectableItemsWithoutDataclassConstructorItems(this, processSubReflectables, filterBy);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000f\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0012\u0010\u0004\u001a\u00020\u00058\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R+\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00078F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\r\u0010\u000e\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR+\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u000f8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0015\u0010\u000e\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R+\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0006\u001a\u00020\u00168F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u001c\u0010\u000e\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR+\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u000f8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b \u0010\u000e\u001a\u0004\b\u001e\u0010\u0012\"\u0004\b\u001f\u0010\u0014R+\u0010!\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u000f8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b$\u0010\u000e\u001a\u0004\b\"\u0010\u0012\"\u0004\b#\u0010\u0014\u00a8\u0006%"}, d2={"Lnet/spaceeye/vmod/rendering/types/PhysgunRayRenderer$Data;", "Lnet/spaceeye/vmod/reflectable/AutoSerializable;", "<init>", "()V", "i", "", "<set-?>", "Ljava/util/UUID;", "player", "getPlayer", "()Ljava/util/UUID;", "setPlayer", "(Ljava/util/UUID;)V", "player$delegate", "Lnet/spaceeye/vmod/reflectable/ReflectableItemDelegate;", "", "shipId", "getShipId", "()J", "setShipId", "(J)V", "shipId$delegate", "Lnet/spaceeye/vmod/utils/Vector3d;", "hitPosInShipyard", "getHitPosInShipyard", "()Lnet/spaceeye/vmod/utils/Vector3d;", "setHitPosInShipyard", "(Lnet/spaceeye/vmod/utils/Vector3d;)V", "hitPosInShipyard$delegate", "timestampOfBeginning", "getTimestampOfBeginning", "setTimestampOfBeginning", "timestampOfBeginning$delegate", "activeFor_ms", "getActiveFor_ms", "setActiveFor_ms", "activeFor_ms$delegate", "VMod"})
    public static final class Data
    implements AutoSerializable {
        static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
        @JsonIgnore
        private int i;
        @NotNull
        private final ReflectableItemDelegate player$delegate;
        @NotNull
        private final ReflectableItemDelegate shipId$delegate;
        @NotNull
        private final ReflectableItemDelegate hitPosInShipyard$delegate;
        @NotNull
        private final ReflectableItemDelegate timestampOfBeginning$delegate;
        @NotNull
        private final ReflectableItemDelegate activeFor_ms$delegate;

        public Data() {
            int n = this.i;
            this.i = n + 1;
            this.player$delegate = ReflectableItem.get(n, new UUID(0L, 0L)).provideDelegate(this, $$delegatedProperties[0]);
            n = this.i;
            this.i = n + 1;
            this.shipId$delegate = ReflectableItem.get(n, -1L).provideDelegate(this, $$delegatedProperties[1]);
            n = this.i;
            this.i = n + 1;
            this.hitPosInShipyard$delegate = ReflectableItem.get(n, new Vector3d()).provideDelegate(this, $$delegatedProperties[2]);
            n = this.i;
            this.i = n + 1;
            this.timestampOfBeginning$delegate = ReflectableItem.get(n, -1L).provideDelegate(this, $$delegatedProperties[3]);
            n = this.i;
            this.i = n + 1;
            this.activeFor_ms$delegate = ReflectableItem.get(n, Long.MAX_VALUE).provideDelegate(this, $$delegatedProperties[4]);
        }

        @NotNull
        public final UUID getPlayer() {
            return (UUID)this.player$delegate.getValue(this, $$delegatedProperties[0]);
        }

        public final void setPlayer(@NotNull UUID uUID) {
            Intrinsics.checkNotNullParameter((Object)uUID, (String)"<set-?>");
            this.player$delegate.setValue(this, $$delegatedProperties[0], uUID);
        }

        public final long getShipId() {
            return ((Number)this.shipId$delegate.getValue(this, $$delegatedProperties[1])).longValue();
        }

        public final void setShipId(long l) {
            this.shipId$delegate.setValue(this, $$delegatedProperties[1], l);
        }

        @NotNull
        public final Vector3d getHitPosInShipyard() {
            return (Vector3d)this.hitPosInShipyard$delegate.getValue(this, $$delegatedProperties[2]);
        }

        public final void setHitPosInShipyard(@NotNull Vector3d vector3d) {
            Intrinsics.checkNotNullParameter((Object)vector3d, (String)"<set-?>");
            this.hitPosInShipyard$delegate.setValue(this, $$delegatedProperties[2], vector3d);
        }

        public final long getTimestampOfBeginning() {
            return ((Number)this.timestampOfBeginning$delegate.getValue(this, $$delegatedProperties[3])).longValue();
        }

        public final void setTimestampOfBeginning(long l) {
            this.timestampOfBeginning$delegate.setValue(this, $$delegatedProperties[3], l);
        }

        public final long getActiveFor_ms() {
            return ((Number)this.activeFor_ms$delegate.getValue(this, $$delegatedProperties[4])).longValue();
        }

        public final void setActiveFor_ms(long l) {
            this.activeFor_ms$delegate.setValue(this, $$delegatedProperties[4], l);
        }

        @Override
        @JsonIgnore
        @ApiStatus.NonExtendable
        @NotNull
        public FriendlyByteBuf serialize() {
            return AutoSerializable.DefaultImpls.serialize(this);
        }

        @Override
        @JsonIgnore
        @ApiStatus.NonExtendable
        public void deserialize(@NotNull FriendlyByteBuf buf) {
            AutoSerializable.DefaultImpls.deserialize(this, buf);
        }

        @Override
        @JsonIgnore
        @NotNull
        public FriendlyByteBuf getBuffer() {
            return AutoSerializable.DefaultImpls.getBuffer(this);
        }

        @Override
        @JsonIgnore
        @Nullable
        public ReflectableObject getReflectObjectOverride() {
            return AutoSerializable.DefaultImpls.getReflectObjectOverride(this);
        }

        @Override
        @JsonIgnore
        @ApiStatus.NonExtendable
        @NotNull
        public List<ReflectableItemDelegate<?>> getAllReflectableItems(boolean processSubReflectables, @NotNull Function1<? super ReflectableItemDelegate<?>, Boolean> filterBy) {
            return AutoSerializable.DefaultImpls.getAllReflectableItems(this, processSubReflectables, filterBy);
        }

        @Override
        @JsonIgnore
        @ApiStatus.NonExtendable
        @NotNull
        public List<ReflectableItemDelegate<?>> getReflectableItemsWithoutDataclassConstructorItems(boolean processSubReflectables, @NotNull Function1<? super ReflectableItemDelegate<?>, Boolean> filterBy) {
            return AutoSerializable.DefaultImpls.getReflectableItemsWithoutDataclassConstructorItems(this, processSubReflectables, filterBy);
        }

        static {
            KProperty[] kPropertyArray = new KProperty[]{Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(Data.class, "player", "getPlayer()Ljava/util/UUID;", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(Data.class, "shipId", "getShipId()J", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(Data.class, "hitPosInShipyard", "getHitPosInShipyard()Lnet/spaceeye/vmod/utils/Vector3d;", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(Data.class, "timestampOfBeginning", "getTimestampOfBeginning()J", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(Data.class, "activeFor_ms", "getActiveFor_ms()J", 0)))};
            $$delegatedProperties = kPropertyArray;
        }
    }
}

