/*
 * Decompiled with CFR 0.152.
 */
package net.spaceeye.vmod.rendering.types.special;

import com.mojang.blaze3d.vertex.VertexConsumer;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.spaceeye.vmod.rendering.types.special.SchemMultiBufferSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Vector3f;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0012\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u000f\u0018\u00002\u00020\u0001:\u0001NB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005Jx\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u00142\u0006\u0010(\u001a\u00020\u00142\u0006\u0010)\u001a\u00020\u00142\u0006\u0010*\u001a\u00020\u00142\u0006\u0010+\u001a\u00020\u00142\u0006\u0010,\u001a\u00020\u00142\u0006\u0010-\u001a\u00020\u00142\u0006\u0010.\u001a\u00020\u00142\u0006\u0010/\u001a\u00020\u00142\u0006\u00100\u001a\u00020 2\u0006\u00101\u001a\u00020 2\u0006\u00102\u001a\u00020\u00142\u0006\u00103\u001a\u00020\u00142\u0006\u00104\u001a\u00020\u0014H\u0016J\u0006\u00105\u001a\u00020&J\u001c\u00106\u001a\u00020&2\u0006\u00107\u001a\u00020\u00012\f\u00108\u001a\b\u0012\u0004\u0012\u00020:09J\"\u0010%\u001a\u0004\u0018\u00010\u00012\u0006\u0010'\u001a\u00020@2\u0006\u0010(\u001a\u00020@2\u0006\u0010)\u001a\u00020@H\u0016J*\u0010A\u001a\u0004\u0018\u00010\u00012\u0006\u0010*\u001a\u00020 2\u0006\u0010+\u001a\u00020 2\u0006\u0010,\u001a\u00020 2\u0006\u0010-\u001a\u00020 H\u0016J\u001a\u0010B\u001a\u0004\u0018\u00010\u00012\u0006\u0010C\u001a\u00020\u00142\u0006\u0010D\u001a\u00020\u0014H\u0016J\u001a\u0010E\u001a\u0004\u0018\u00010\u00012\u0006\u0010C\u001a\u00020 2\u0006\u0010D\u001a\u00020 H\u0016J\u001a\u0010F\u001a\u0004\u0018\u00010\u00012\u0006\u0010C\u001a\u00020 2\u0006\u0010D\u001a\u00020 H\u0016J\"\u0010G\u001a\u0004\u0018\u00010\u00012\u0006\u0010'\u001a\u00020\u00142\u0006\u0010(\u001a\u00020\u00142\u0006\u0010)\u001a\u00020\u0014H\u0016J\b\u0010H\u001a\u00020&H\u0016J(\u0010\r\u001a\u00020&2\u0006\u0010I\u001a\u00020 2\u0006\u0010J\u001a\u00020 2\u0006\u0010K\u001a\u00020 2\u0006\u0010L\u001a\u00020 H\u0016J\b\u0010M\u001a\u00020&H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u00020\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0019\u001a\u00020\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u001a\u0010\u001f\u001a\u00020 X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u001a\u0010;\u001a\u00020\nX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b<\u0010=\"\u0004\b>\u0010?\u00a8\u0006O"}, d2={"Lnet/spaceeye/vmod/rendering/types/special/FakeBufferBuilder;", "Lcom/mojang/blaze3d/vertex/VertexConsumer;", "source", "Lnet/spaceeye/vmod/rendering/types/special/SchemMultiBufferSource;", "<init>", "(Lnet/spaceeye/vmod/rendering/types/special/SchemMultiBufferSource;)V", "getSource", "()Lnet/spaceeye/vmod/rendering/types/special/SchemMultiBufferSource;", "vertices", "", "Lnet/spaceeye/vmod/rendering/types/special/FakeBufferBuilder$Vertex;", "getVertices", "()Ljava/util/List;", "defaultColor", "Ljava/awt/Color;", "getDefaultColor", "()Ljava/awt/Color;", "setDefaultColor", "(Ljava/awt/Color;)V", "transparency", "", "getTransparency", "()F", "setTransparency", "(F)V", "vertexOffset", "Lorg/joml/Vector3f;", "getVertexOffset", "()Lorg/joml/Vector3f;", "setVertexOffset", "(Lorg/joml/Vector3f;)V", "vertexMatrixIndex", "", "getVertexMatrixIndex", "()I", "setVertexMatrixIndex", "(I)V", "vertex", "", "x", "y", "z", "red", "green", "blue", "alpha", "texU", "texV", "overlayUV", "lightmapUV", "normalX", "normalY", "normalZ", "clear", "apply", "buffer", "matrices", "", "Lorg/joml/Matrix4f;", "temp", "getTemp", "()Lnet/spaceeye/vmod/rendering/types/special/FakeBufferBuilder$Vertex;", "setTemp", "(Lnet/spaceeye/vmod/rendering/types/special/FakeBufferBuilder$Vertex;)V", "", "color", "uv", "u", "v", "overlayCoords", "uv2", "normal", "endVertex", "defaultR", "defaultG", "defaultB", "defaultA", "unsetDefaultColor", "Vertex", "VMod"})
public final class FakeBufferBuilder
implements VertexConsumer {
    @NotNull
    private final SchemMultiBufferSource source;
    @NotNull
    private final List<Vertex> vertices;
    @NotNull
    private Color defaultColor;
    private float transparency;
    @NotNull
    private Vector3f vertexOffset;
    private int vertexMatrixIndex;
    public Vertex temp;

    public FakeBufferBuilder(@NotNull SchemMultiBufferSource source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        this.source = source;
        this.vertices = new ArrayList();
        this.defaultColor = new Color(255, 255, 255, 255);
        this.transparency = 0.5f;
        this.vertexOffset = new Vector3f(0.0f, 0.0f, 0.0f);
    }

    @NotNull
    public final SchemMultiBufferSource getSource() {
        return this.source;
    }

    @NotNull
    public final List<Vertex> getVertices() {
        return this.vertices;
    }

    @NotNull
    public final Color getDefaultColor() {
        return this.defaultColor;
    }

    public final void setDefaultColor(@NotNull Color color) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"<set-?>");
        this.defaultColor = color;
    }

    public final float getTransparency() {
        return this.transparency;
    }

    public final void setTransparency(float f) {
        this.transparency = f;
    }

    @NotNull
    public final Vector3f getVertexOffset() {
        return this.vertexOffset;
    }

    public final void setVertexOffset(@NotNull Vector3f vector3f) {
        Intrinsics.checkNotNullParameter((Object)vector3f, (String)"<set-?>");
        this.vertexOffset = vector3f;
    }

    public final int getVertexMatrixIndex() {
        return this.vertexMatrixIndex;
    }

    public final void setVertexMatrixIndex(int n) {
        this.vertexMatrixIndex = n;
    }

    public void m_5954_(float x, float y, float z, float red, float green, float blue, float alpha, float texU, float texV, int overlayUV, int lightmapUV, float normalX, float normalY, float normalZ) {
        this.vertices.add(new Vertex(x + this.vertexOffset.x, y + this.vertexOffset.y, z + this.vertexOffset.z, red, green, blue, alpha, texU, texV, overlayUV, lightmapUV, normalX, normalY, normalZ, this.vertexMatrixIndex));
    }

    public final void clear() {
        this.vertices.clear();
        this.m_141991_();
    }

    public final void apply(@NotNull VertexConsumer buffer, @NotNull List<? extends Matrix4f> matrices) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        Intrinsics.checkNotNullParameter(matrices, (String)"matrices");
        int size = this.vertices.size();
        for (int i2 = 0; i2 < size; ++i2) {
            this.vertices.get(i2).apply(buffer, this.transparency, matrices);
        }
    }

    @NotNull
    public final Vertex getTemp() {
        Vertex vertex = this.temp;
        if (vertex != null) {
            return vertex;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"temp");
        return null;
    }

    public final void setTemp(@NotNull Vertex vertex) {
        Intrinsics.checkNotNullParameter((Object)vertex, (String)"<set-?>");
        this.temp = vertex;
    }

    @Nullable
    public VertexConsumer m_5483_(double x, double y, double z) {
        this.setTemp(new Vertex((float)x + this.vertexOffset.x, (float)y + this.vertexOffset.y, (float)z + this.vertexOffset.z, (float)this.defaultColor.getRed() / 255.0f, (float)this.defaultColor.getGreen() / 255.0f, (float)this.defaultColor.getBlue() / 255.0f, (float)this.defaultColor.getAlpha() / 255.0f, 1.0f, 1.0f, 0, 0, 1.0f, 1.0f, 1.0f, this.vertexMatrixIndex));
        return this;
    }

    @Nullable
    public VertexConsumer m_6122_(int red, int green, int blue, int alpha) {
        this.getTemp().setRed((float)red / 255.0f);
        this.getTemp().setGreen((float)green / 255.0f);
        this.getTemp().setBlue((float)blue / 255.0f);
        this.getTemp().setAlpha((float)alpha / 255.0f);
        return this;
    }

    @Nullable
    public VertexConsumer m_7421_(float u, float v) {
        this.getTemp().setTexU(u);
        this.getTemp().setTexV(v);
        return this;
    }

    @Nullable
    public VertexConsumer m_7122_(int u, int v) {
        this.getTemp().setOverlayUV(u << 16 | v & 0xFFFF);
        return this;
    }

    @Nullable
    public VertexConsumer m_7120_(int u, int v) {
        this.getTemp().setLightmapUV(u << 16 | v & 0xFFFF);
        return this;
    }

    @Nullable
    public VertexConsumer m_5601_(float x, float y, float z) {
        this.getTemp().setNormalX(x);
        this.getTemp().setNormalY(y);
        this.getTemp().setNormalZ(z);
        return this;
    }

    public void m_5752_() {
        this.vertices.add(this.getTemp());
    }

    public void m_7404_(int defaultR, int defaultG, int defaultB, int defaultA) {
        this.defaultColor = new Color(defaultR, defaultG, defaultB, defaultA);
    }

    public void m_141991_() {
        this.defaultColor = new Color(255, 255, 255, 255);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0007\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b*\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u007f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\u0003\u0012\u0006\u0010\n\u001a\u00020\u0003\u0012\u0006\u0010\u000b\u001a\u00020\u0003\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\r\u0012\u0006\u0010\u000f\u001a\u00020\u0003\u0012\u0006\u0010\u0010\u001a\u00020\u0003\u0012\u0006\u0010\u0011\u001a\u00020\u0003\u0012\u0006\u0010\u0012\u001a\u00020\r\u00a2\u0006\u0004\b\u0013\u0010\u0014J$\u00107\u001a\u0002082\u0006\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020\u00032\f\u0010<\u001a\b\u0012\u0004\u0012\u00020>0=J\t\u0010?\u001a\u00020\u0003H\u00c6\u0003J\t\u0010@\u001a\u00020\u0003H\u00c6\u0003J\t\u0010A\u001a\u00020\u0003H\u00c6\u0003J\t\u0010B\u001a\u00020\u0003H\u00c6\u0003J\t\u0010C\u001a\u00020\u0003H\u00c6\u0003J\t\u0010D\u001a\u00020\u0003H\u00c6\u0003J\t\u0010E\u001a\u00020\u0003H\u00c6\u0003J\t\u0010F\u001a\u00020\u0003H\u00c6\u0003J\t\u0010G\u001a\u00020\u0003H\u00c6\u0003J\t\u0010H\u001a\u00020\rH\u00c6\u0003J\t\u0010I\u001a\u00020\rH\u00c6\u0003J\t\u0010J\u001a\u00020\u0003H\u00c6\u0003J\t\u0010K\u001a\u00020\u0003H\u00c6\u0003J\t\u0010L\u001a\u00020\u0003H\u00c6\u0003J\t\u0010M\u001a\u00020\rH\u00c6\u0003J\u009f\u0001\u0010N\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\u00032\b\b\u0002\u0010\b\u001a\u00020\u00032\b\b\u0002\u0010\t\u001a\u00020\u00032\b\b\u0002\u0010\n\u001a\u00020\u00032\b\b\u0002\u0010\u000b\u001a\u00020\u00032\b\b\u0002\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\r2\b\b\u0002\u0010\u000f\u001a\u00020\u00032\b\b\u0002\u0010\u0010\u001a\u00020\u00032\b\b\u0002\u0010\u0011\u001a\u00020\u00032\b\b\u0002\u0010\u0012\u001a\u00020\rH\u00c6\u0001J\u0013\u0010O\u001a\u00020P2\b\u0010Q\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010R\u001a\u00020\rH\u00d6\u0001J\t\u0010S\u001a\u00020TH\u00d6\u0001R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u0016\"\u0004\b\u001a\u0010\u0018R\u001a\u0010\u0005\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u0016\"\u0004\b\u001c\u0010\u0018R\u001a\u0010\u0006\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u0016\"\u0004\b\u001e\u0010\u0018R\u001a\u0010\u0007\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u0016\"\u0004\b \u0010\u0018R\u001a\u0010\b\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\u0016\"\u0004\b\"\u0010\u0018R\u001a\u0010\t\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\u0016\"\u0004\b$\u0010\u0018R\u001a\u0010\n\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010\u0016\"\u0004\b&\u0010\u0018R\u001a\u0010\u000b\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010\u0016\"\u0004\b(\u0010\u0018R\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,R\u001a\u0010\u000e\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010*\"\u0004\b.\u0010,R\u001a\u0010\u000f\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u0010\u0016\"\u0004\b0\u0010\u0018R\u001a\u0010\u0010\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b1\u0010\u0016\"\u0004\b2\u0010\u0018R\u001a\u0010\u0011\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b3\u0010\u0016\"\u0004\b4\u0010\u0018R\u001a\u0010\u0012\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b5\u0010*\"\u0004\b6\u0010,\u00a8\u0006U"}, d2={"Lnet/spaceeye/vmod/rendering/types/special/FakeBufferBuilder$Vertex;", "", "x", "", "y", "z", "red", "green", "blue", "alpha", "texU", "texV", "overlayUV", "", "lightmapUV", "normalX", "normalY", "normalZ", "matrixIndex", "<init>", "(FFFFFFFFFIIFFFI)V", "getX", "()F", "setX", "(F)V", "getY", "setY", "getZ", "setZ", "getRed", "setRed", "getGreen", "setGreen", "getBlue", "setBlue", "getAlpha", "setAlpha", "getTexU", "setTexU", "getTexV", "setTexV", "getOverlayUV", "()I", "setOverlayUV", "(I)V", "getLightmapUV", "setLightmapUV", "getNormalX", "setNormalX", "getNormalY", "setNormalY", "getNormalZ", "setNormalZ", "getMatrixIndex", "setMatrixIndex", "apply", "", "buffer", "Lcom/mojang/blaze3d/vertex/VertexConsumer;", "transparency", "matrices", "", "Lorg/joml/Matrix4f;", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "component10", "component11", "component12", "component13", "component14", "component15", "copy", "equals", "", "other", "hashCode", "toString", "", "VMod"})
    public static final class Vertex {
        private float x;
        private float y;
        private float z;
        private float red;
        private float green;
        private float blue;
        private float alpha;
        private float texU;
        private float texV;
        private int overlayUV;
        private int lightmapUV;
        private float normalX;
        private float normalY;
        private float normalZ;
        private int matrixIndex;

        public Vertex(float x, float y, float z, float red, float green, float blue, float alpha, float texU, float texV, int overlayUV, int lightmapUV, float normalX, float normalY, float normalZ, int matrixIndex) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.red = red;
            this.green = green;
            this.blue = blue;
            this.alpha = alpha;
            this.texU = texU;
            this.texV = texV;
            this.overlayUV = overlayUV;
            this.lightmapUV = lightmapUV;
            this.normalX = normalX;
            this.normalY = normalY;
            this.normalZ = normalZ;
            this.matrixIndex = matrixIndex;
        }

        public final float getX() {
            return this.x;
        }

        public final void setX(float f) {
            this.x = f;
        }

        public final float getY() {
            return this.y;
        }

        public final void setY(float f) {
            this.y = f;
        }

        public final float getZ() {
            return this.z;
        }

        public final void setZ(float f) {
            this.z = f;
        }

        public final float getRed() {
            return this.red;
        }

        public final void setRed(float f) {
            this.red = f;
        }

        public final float getGreen() {
            return this.green;
        }

        public final void setGreen(float f) {
            this.green = f;
        }

        public final float getBlue() {
            return this.blue;
        }

        public final void setBlue(float f) {
            this.blue = f;
        }

        public final float getAlpha() {
            return this.alpha;
        }

        public final void setAlpha(float f) {
            this.alpha = f;
        }

        public final float getTexU() {
            return this.texU;
        }

        public final void setTexU(float f) {
            this.texU = f;
        }

        public final float getTexV() {
            return this.texV;
        }

        public final void setTexV(float f) {
            this.texV = f;
        }

        public final int getOverlayUV() {
            return this.overlayUV;
        }

        public final void setOverlayUV(int n) {
            this.overlayUV = n;
        }

        public final int getLightmapUV() {
            return this.lightmapUV;
        }

        public final void setLightmapUV(int n) {
            this.lightmapUV = n;
        }

        public final float getNormalX() {
            return this.normalX;
        }

        public final void setNormalX(float f) {
            this.normalX = f;
        }

        public final float getNormalY() {
            return this.normalY;
        }

        public final void setNormalY(float f) {
            this.normalY = f;
        }

        public final float getNormalZ() {
            return this.normalZ;
        }

        public final void setNormalZ(float f) {
            this.normalZ = f;
        }

        public final int getMatrixIndex() {
            return this.matrixIndex;
        }

        public final void setMatrixIndex(int n) {
            this.matrixIndex = n;
        }

        public final void apply(@NotNull VertexConsumer buffer, float transparency, @NotNull List<? extends Matrix4f> matrices) {
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            Intrinsics.checkNotNullParameter(matrices, (String)"matrices");
            Matrix4f matrix = matrices.get(this.matrixIndex);
            float x_ = matrix.m00() * this.x + matrix.m10() * this.y + matrix.m20() * this.z + matrix.m30();
            float y_ = matrix.m01() * this.x + matrix.m11() * this.y + matrix.m21() * this.z + matrix.m31();
            float z_ = matrix.m02() * this.x + matrix.m12() * this.y + matrix.m22() * this.z + matrix.m32();
            buffer.m_5954_(x_, y_, z_, this.red, this.green, this.blue, this.alpha * transparency, this.texU, this.texV, this.overlayUV, this.lightmapUV, this.normalX, this.normalY, this.normalZ);
        }

        public final float component1() {
            return this.x;
        }

        public final float component2() {
            return this.y;
        }

        public final float component3() {
            return this.z;
        }

        public final float component4() {
            return this.red;
        }

        public final float component5() {
            return this.green;
        }

        public final float component6() {
            return this.blue;
        }

        public final float component7() {
            return this.alpha;
        }

        public final float component8() {
            return this.texU;
        }

        public final float component9() {
            return this.texV;
        }

        public final int component10() {
            return this.overlayUV;
        }

        public final int component11() {
            return this.lightmapUV;
        }

        public final float component12() {
            return this.normalX;
        }

        public final float component13() {
            return this.normalY;
        }

        public final float component14() {
            return this.normalZ;
        }

        public final int component15() {
            return this.matrixIndex;
        }

        @NotNull
        public final Vertex copy(float x, float y, float z, float red, float green, float blue, float alpha, float texU, float texV, int overlayUV, int lightmapUV, float normalX, float normalY, float normalZ, int matrixIndex) {
            return new Vertex(x, y, z, red, green, blue, alpha, texU, texV, overlayUV, lightmapUV, normalX, normalY, normalZ, matrixIndex);
        }

        public static /* synthetic */ Vertex copy$default(Vertex vertex, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, int n, int n2, float f10, float f11, float f12, int n3, int n4, Object object) {
            if ((n4 & 1) != 0) {
                f = vertex.x;
            }
            if ((n4 & 2) != 0) {
                f2 = vertex.y;
            }
            if ((n4 & 4) != 0) {
                f3 = vertex.z;
            }
            if ((n4 & 8) != 0) {
                f4 = vertex.red;
            }
            if ((n4 & 0x10) != 0) {
                f5 = vertex.green;
            }
            if ((n4 & 0x20) != 0) {
                f6 = vertex.blue;
            }
            if ((n4 & 0x40) != 0) {
                f7 = vertex.alpha;
            }
            if ((n4 & 0x80) != 0) {
                f8 = vertex.texU;
            }
            if ((n4 & 0x100) != 0) {
                f9 = vertex.texV;
            }
            if ((n4 & 0x200) != 0) {
                n = vertex.overlayUV;
            }
            if ((n4 & 0x400) != 0) {
                n2 = vertex.lightmapUV;
            }
            if ((n4 & 0x800) != 0) {
                f10 = vertex.normalX;
            }
            if ((n4 & 0x1000) != 0) {
                f11 = vertex.normalY;
            }
            if ((n4 & 0x2000) != 0) {
                f12 = vertex.normalZ;
            }
            if ((n4 & 0x4000) != 0) {
                n3 = vertex.matrixIndex;
            }
            return vertex.copy(f, f2, f3, f4, f5, f6, f7, f8, f9, n, n2, f10, f11, f12, n3);
        }

        @NotNull
        public String toString() {
            return "Vertex(x=" + this.x + ", y=" + this.y + ", z=" + this.z + ", red=" + this.red + ", green=" + this.green + ", blue=" + this.blue + ", alpha=" + this.alpha + ", texU=" + this.texU + ", texV=" + this.texV + ", overlayUV=" + this.overlayUV + ", lightmapUV=" + this.lightmapUV + ", normalX=" + this.normalX + ", normalY=" + this.normalY + ", normalZ=" + this.normalZ + ", matrixIndex=" + this.matrixIndex + ")";
        }

        public int hashCode() {
            int result = Float.hashCode(this.x);
            result = result * 31 + Float.hashCode(this.y);
            result = result * 31 + Float.hashCode(this.z);
            result = result * 31 + Float.hashCode(this.red);
            result = result * 31 + Float.hashCode(this.green);
            result = result * 31 + Float.hashCode(this.blue);
            result = result * 31 + Float.hashCode(this.alpha);
            result = result * 31 + Float.hashCode(this.texU);
            result = result * 31 + Float.hashCode(this.texV);
            result = result * 31 + Integer.hashCode(this.overlayUV);
            result = result * 31 + Integer.hashCode(this.lightmapUV);
            result = result * 31 + Float.hashCode(this.normalX);
            result = result * 31 + Float.hashCode(this.normalY);
            result = result * 31 + Float.hashCode(this.normalZ);
            result = result * 31 + Integer.hashCode(this.matrixIndex);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Vertex)) {
                return false;
            }
            Vertex vertex = (Vertex)other;
            if (Float.compare(this.x, vertex.x) != 0) {
                return false;
            }
            if (Float.compare(this.y, vertex.y) != 0) {
                return false;
            }
            if (Float.compare(this.z, vertex.z) != 0) {
                return false;
            }
            if (Float.compare(this.red, vertex.red) != 0) {
                return false;
            }
            if (Float.compare(this.green, vertex.green) != 0) {
                return false;
            }
            if (Float.compare(this.blue, vertex.blue) != 0) {
                return false;
            }
            if (Float.compare(this.alpha, vertex.alpha) != 0) {
                return false;
            }
            if (Float.compare(this.texU, vertex.texU) != 0) {
                return false;
            }
            if (Float.compare(this.texV, vertex.texV) != 0) {
                return false;
            }
            if (this.overlayUV != vertex.overlayUV) {
                return false;
            }
            if (this.lightmapUV != vertex.lightmapUV) {
                return false;
            }
            if (Float.compare(this.normalX, vertex.normalX) != 0) {
                return false;
            }
            if (Float.compare(this.normalY, vertex.normalY) != 0) {
                return false;
            }
            if (Float.compare(this.normalZ, vertex.normalZ) != 0) {
                return false;
            }
            return this.matrixIndex == vertex.matrixIndex;
        }
    }
}

