/*
 * Decompiled with CFR 0.152.
 */
package net.spaceeye.vmod.rendering.types.special;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.awt.Color;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.spaceeye.vmod.VMConfig;
import net.spaceeye.vmod.compat.vsBackwardsCompat.BodyTransformKt;
import net.spaceeye.vmod.rendering.RenderingUtils;
import net.spaceeye.vmod.rendering.types.BaseRenderer;
import net.spaceeye.vmod.toolgun.ClientToolGunState;
import net.spaceeye.vmod.toolgun.modes.BaseMode;
import net.spaceeye.vmod.toolgun.modes.state.SchemMode;
import net.spaceeye.vmod.utils.GetQuatFromDirKt;
import net.spaceeye.vmod.utils.RaycastFunctions;
import net.spaceeye.vmod.utils.Ref;
import net.spaceeye.vmod.utils.Vector3d;
import net.spaceeye.vmod.utils.vs.RotateAroundCenterKt;
import net.spaceeye.vmod.utils.vs.VSShipPosTransformsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.AxisAngle4d;
import org.joml.Matrix4f;
import org.joml.Quaterniond;
import org.joml.Quaterniondc;
import org.joml.Vector3dc;
import org.joml.Vector3f;
import org.joml.primitives.AABBic;
import org.valkyrienskies.core.api.ships.Ship;
import org.valkyrienskies.core.api.ships.properties.ShipTransform;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0018\u0010\t\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\f0\u000b0\n\u00a2\u0006\u0004\b\r\u0010\u000eJ \u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0016J\b\u0010)\u001a\u00020*H\u0016J\u0010\u0010+\u001a\u00020\"2\u0006\u0010,\u001a\u00020*H\u0016JF\u0010-\u001a\u0004\u0018\u00010\u00012\u0016\u0010.\u001a\u0012\u0012\b\u0012\u00060(j\u0002`0\u0012\u0004\u0012\u0002010/2\"\u00102\u001a\u001e\u0012\b\u0012\u00060(j\u0002`0\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u000b0/H\u0016J\u0010\u00103\u001a\u00020\"2\u0006\u00104\u001a\u00020\u0006H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R#\u0010\t\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\f0\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0017\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00030\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0016R\u0011\u0010\u001a\u001a\u00020\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u001e\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 \u00a8\u00065"}, d2={"Lnet/spaceeye/vmod/rendering/types/special/SchemOutlinesRenderer;", "Lnet/spaceeye/vmod/rendering/types/BaseRenderer;", "maxObjectEdge", "Lnet/spaceeye/vmod/utils/Vector3d;", "rotationAngle", "Lnet/spaceeye/vmod/utils/Ref;", "", "center", "Lorg/valkyrienskies/core/api/ships/properties/ShipTransform;", "ships", "", "Lkotlin/Pair;", "Lorg/joml/primitives/AABBic;", "<init>", "(Lnet/spaceeye/vmod/utils/Vector3d;Lnet/spaceeye/vmod/utils/Ref;Lorg/valkyrienskies/core/api/ships/properties/ShipTransform;Ljava/util/List;)V", "getMaxObjectEdge", "()Lnet/spaceeye/vmod/utils/Vector3d;", "getRotationAngle", "()Lnet/spaceeye/vmod/utils/Ref;", "getCenter", "()Lorg/valkyrienskies/core/api/ships/properties/ShipTransform;", "getShips", "()Ljava/util/List;", "aabbPoints", "", "getAabbPoints", "level", "Lnet/minecraft/client/multiplayer/ClientLevel;", "getLevel", "()Lnet/minecraft/client/multiplayer/ClientLevel;", "raycastDistance", "getRaycastDistance", "()D", "renderData", "", "poseStack", "Lcom/mojang/blaze3d/vertex/PoseStack;", "camera", "Lnet/minecraft/client/Camera;", "timestamp", "", "serialize", "Lnet/minecraft/network/FriendlyByteBuf;", "deserialize", "buf", "copy", "oldToNew", "", "Lorg/valkyrienskies/core/api/ships/properties/ShipId;", "Lorg/valkyrienskies/core/api/ships/Ship;", "centerPositions", "scaleBy", "by", "VMod"})
@SourceDebugExtension(value={"SMAP\nSchemOutlinesRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SchemOutlinesRenderer.kt\nnet/spaceeye/vmod/rendering/types/special/SchemOutlinesRenderer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,137:1\n1864#2,3:138\n*S KotlinDebug\n*F\n+ 1 SchemOutlinesRenderer.kt\nnet/spaceeye/vmod/rendering/types/special/SchemOutlinesRenderer\n*L\n100#1:138,3\n*E\n"})
public final class SchemOutlinesRenderer
extends BaseRenderer {
    @NotNull
    private final Vector3d maxObjectEdge;
    @NotNull
    private final Ref<Double> rotationAngle;
    @NotNull
    private final ShipTransform center;
    @NotNull
    private final List<Pair<ShipTransform, AABBic>> ships;
    @NotNull
    private final List<Vector3d> aabbPoints;
    @NotNull
    private final ClientLevel level;
    private final double raycastDistance;

    public SchemOutlinesRenderer(@NotNull Vector3d maxObjectEdge, @NotNull Ref<Double> rotationAngle, @NotNull ShipTransform center, @NotNull List<? extends Pair<? extends ShipTransform, ? extends AABBic>> ships) {
        Intrinsics.checkNotNullParameter((Object)maxObjectEdge, (String)"maxObjectEdge");
        Intrinsics.checkNotNullParameter(rotationAngle, (String)"rotationAngle");
        Intrinsics.checkNotNullParameter((Object)center, (String)"center");
        Intrinsics.checkNotNullParameter(ships, (String)"ships");
        this.maxObjectEdge = maxObjectEdge;
        this.rotationAngle = rotationAngle;
        this.center = center;
        this.ships = ships;
        Object[] objectArray = new Vector3d[]{new Vector3d(), new Vector3d(), new Vector3d(), new Vector3d(), new Vector3d(), new Vector3d(), new Vector3d(), new Vector3d()};
        this.aabbPoints = CollectionsKt.mutableListOf((Object[])objectArray);
        ClientLevel clientLevel = Minecraft.m_91087_().f_91073_;
        Intrinsics.checkNotNull((Object)clientLevel);
        this.level = clientLevel;
        this.raycastDistance = VMConfig.INSTANCE.getCLIENT().getTOOLGUN().getMAX_RAYCAST_DISTANCE();
    }

    @NotNull
    public final Vector3d getMaxObjectEdge() {
        return this.maxObjectEdge;
    }

    @NotNull
    public final Ref<Double> getRotationAngle() {
        return this.rotationAngle;
    }

    @NotNull
    public final ShipTransform getCenter() {
        return this.center;
    }

    @NotNull
    public final List<Pair<ShipTransform, AABBic>> getShips() {
        return this.ships;
    }

    @NotNull
    public final List<Vector3d> getAabbPoints() {
        return this.aabbPoints;
    }

    @NotNull
    public final ClientLevel getLevel() {
        return this.level;
    }

    public final double getRaycastDistance() {
        return this.raycastDistance;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void renderData(@NotNull PoseStack poseStack, @NotNull Camera camera, long timestamp) {
        Intrinsics.checkNotNullParameter((Object)poseStack, (String)"poseStack");
        Intrinsics.checkNotNullParameter((Object)camera, (String)"camera");
        BaseMode mode = ClientToolGunState.INSTANCE.getCurrentMode();
        if (!(mode instanceof SchemMode)) {
            return;
        }
        if (!ClientToolGunState.INSTANCE.playerIsUsingToolgun()) {
            return;
        }
        double width = 0.05;
        Level level = (Level)this.level;
        Vector3f vector3f = Minecraft.m_91087_().f_91063_.m_109153_().m_253058_();
        Intrinsics.checkNotNullExpressionValue((Object)vector3f, (String)"getLookVector(...)");
        Vector3d vector3d = new Vector3d(vector3f).snormalize();
        LocalPlayer localPlayer = Minecraft.m_91087_().f_91074_;
        Intrinsics.checkNotNull((Object)localPlayer);
        Vec3 vec3 = localPlayer.m_146892_();
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"getEyePosition(...)");
        RaycastFunctions.RaycastResult raycastResult = RaycastFunctions.renderRaycast$default(RaycastFunctions.INSTANCE, level, new RaycastFunctions.Source(vector3d, new Vector3d(vec3)), this.raycastDistance, null, null, null, null, null, 248, null);
        Vector3d vector3d2 = raycastResult.getWorldHitPos();
        if (vector3d2 == null) {
            return;
        }
        Vector3d hitPos = vector3d2;
        Vector3d vector3d3 = raycastResult.getWorldNormalDirection();
        if (vector3d3 == null) {
            return;
        }
        Vector3d pos = hitPos.plus(vector3d3.times(this.maxObjectEdge.y));
        Quaterniond quaterniond = new Quaterniond();
        double d = ((Number)this.rotationAngle.getIt()).doubleValue();
        Vector3d vector3d4 = raycastResult.getWorldNormalDirection();
        Intrinsics.checkNotNull((Object)vector3d4);
        Quaterniond quaterniond2 = quaterniond.mul((Quaterniondc)new Quaterniond(new AxisAngle4d(d, (Vector3dc)vector3d4.toJomlVector3d())));
        Vector3d vector3d5 = raycastResult.getWorldNormalDirection();
        Intrinsics.checkNotNull((Object)vector3d5);
        Quaterniond rotation = quaterniond2.mul((Quaterniondc)GetQuatFromDirKt.getQuatFromDir(vector3d5)).normalize();
        Vec3 vec32 = camera.m_90583_();
        Intrinsics.checkNotNullExpressionValue((Object)vec32, (String)"getPosition(...)");
        Vector3d cameraPos = new Vector3d(vec32);
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder vBuffer = tesselator.m_85915_();
        RenderSystem.enableDepthTest();
        RenderSystem.depthFunc((int)515);
        RenderSystem.depthMask((boolean)true);
        RenderSystem.setShader(GameRenderer::m_172811_);
        RenderSystem.enableBlend();
        vBuffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        poseStack.m_85836_();
        Matrix4f matrix = poseStack.m_85850_().m_252922_();
        Vector3d offset2 = pos.minus(cameraPos);
        for (Pair<ShipTransform, AABBic> pair : this.ships) {
            ShipTransform transform = (ShipTransform)pair.component1();
            AABBic aabb = (AABBic)pair.component2();
            Intrinsics.checkNotNull((Object)rotation);
            ShipTransform newTransform = RotateAroundCenterKt.rotateAroundCenter(this.center, transform, (Quaterniondc)rotation);
            this.aabbPoints.get(0).set((Number)aabb.minX(), (Number)aabb.minY(), (Number)aabb.minZ());
            this.aabbPoints.get(1).set((Number)aabb.minX(), (Number)aabb.maxY(), (Number)aabb.minZ());
            this.aabbPoints.get(2).set((Number)aabb.minX(), (Number)aabb.maxY(), (Number)aabb.maxZ());
            this.aabbPoints.get(3).set((Number)aabb.minX(), (Number)aabb.minY(), (Number)aabb.maxZ());
            this.aabbPoints.get(4).set((Number)aabb.maxX(), (Number)aabb.minY(), (Number)aabb.minZ());
            this.aabbPoints.get(5).set((Number)aabb.maxX(), (Number)aabb.maxY(), (Number)aabb.minZ());
            this.aabbPoints.get(6).set((Number)aabb.maxX(), (Number)aabb.maxY(), (Number)aabb.maxZ());
            this.aabbPoints.get(7).set((Number)aabb.maxX(), (Number)aabb.minY(), (Number)aabb.maxZ());
            Iterable $this$forEachIndexed$iv = this.aabbPoints;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void it;
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                Vector3d vector3d6 = (Vector3d)item$iv;
                int i2 = n;
                boolean bl = false;
                this.aabbPoints.set(i2, VSShipPosTransformsKt.posShipToWorld(null, (Vector3d)it, newTransform).plus(offset2));
            }
            Intrinsics.checkNotNull((Object)vBuffer);
            VertexConsumer vertexConsumer = (VertexConsumer)vBuffer;
            Intrinsics.checkNotNull((Object)matrix);
            Color color = Color.RED;
            Intrinsics.checkNotNullExpressionValue((Object)color, (String)"RED");
            RenderingUtils.Line.renderLineBox(vertexConsumer, matrix, color, this.aabbPoints, width);
            Vector3d transformCenter = new Vector3d(BodyTransformKt.getPositionInModel(newTransform));
            Vector3d xAxis = new Vector3d(transformCenter);
            Vector3d yAxis = new Vector3d(transformCenter);
            Vector3d zAxis = new Vector3d(transformCenter);
            xAxis.x = aabb.maxX();
            yAxis.y = aabb.maxY();
            zAxis.z = aabb.maxZ();
            xAxis = VSShipPosTransformsKt.posShipToWorld(null, xAxis, newTransform).plus(offset2);
            yAxis = VSShipPosTransformsKt.posShipToWorld(null, yAxis, newTransform).plus(offset2);
            zAxis = VSShipPosTransformsKt.posShipToWorld(null, zAxis, newTransform).plus(offset2);
            transformCenter = VSShipPosTransformsKt.posShipToWorld(null, transformCenter, newTransform).plus(offset2);
            VertexConsumer vertexConsumer2 = (VertexConsumer)vBuffer;
            Color color2 = Color.RED;
            Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"RED");
            RenderingUtils.Line.renderLine(vertexConsumer2, matrix, color2, transformCenter, xAxis, width);
            VertexConsumer vertexConsumer3 = (VertexConsumer)vBuffer;
            Color color3 = Color.GREEN;
            Intrinsics.checkNotNullExpressionValue((Object)color3, (String)"GREEN");
            RenderingUtils.Line.renderLine(vertexConsumer3, matrix, color3, transformCenter, yAxis, width);
            VertexConsumer vertexConsumer4 = (VertexConsumer)vBuffer;
            Color color4 = Color.BLUE;
            Intrinsics.checkNotNullExpressionValue((Object)color4, (String)"BLUE");
            RenderingUtils.Line.renderLine(vertexConsumer4, matrix, color4, transformCenter, zAxis, width);
        }
        tesselator.m_85914_();
        poseStack.m_85849_();
    }

    @Override
    @NotNull
    public FriendlyByteBuf serialize() {
        throw new AssertionError((Object)"Shouldn't be serialized");
    }

    @Override
    public void deserialize(@NotNull FriendlyByteBuf buf) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        throw new AssertionError((Object)"Shouldn't be deserialized");
    }

    @Override
    @Nullable
    public BaseRenderer copy(@NotNull Map<Long, ? extends Ship> oldToNew, @NotNull Map<Long, Pair<Vector3d, Vector3d>> centerPositions) {
        Intrinsics.checkNotNullParameter(oldToNew, (String)"oldToNew");
        Intrinsics.checkNotNullParameter(centerPositions, (String)"centerPositions");
        throw new AssertionError((Object)"Shouldn't be copied");
    }

    @Override
    public void scaleBy(double by) {
        throw new AssertionError((Object)"Shouldn't be scaled");
    }
}

