/*
 * Decompiled with CFR 0.152.
 */
package net.spaceeye.vmod.rendering.types.special;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.spaceeye.valkyrien_ship_schematics.interfaces.IShipSchematic;
import net.spaceeye.valkyrien_ship_schematics.interfaces.IShipSchematicInfo;
import net.spaceeye.vmod.rendering.types.BaseRenderer;
import net.spaceeye.vmod.rendering.types.BlockRenderer;
import net.spaceeye.vmod.rendering.types.special.SchematicRenderer;
import net.spaceeye.vmod.toolgun.ClientToolGunState;
import net.spaceeye.vmod.toolgun.modes.BaseMode;
import net.spaceeye.vmod.toolgun.modes.state.SchemMode;
import net.spaceeye.vmod.utils.GetQuatFromDirKt;
import net.spaceeye.vmod.utils.RaycastFunctions;
import net.spaceeye.vmod.utils.Ref;
import net.spaceeye.vmod.utils.Vector3d;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.AxisAngle4d;
import org.joml.Quaterniond;
import org.joml.Quaterniondc;
import org.joml.Quaternionf;
import org.joml.Vector3dc;
import org.joml.Vector3f;
import org.valkyrienskies.core.api.ships.Ship;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ(\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0016J\b\u0010)\u001a\u00020*H\u0016J\u0010\u0010+\u001a\u00020 2\u0006\u0010,\u001a\u00020*H\u0016JF\u0010-\u001a\u0004\u0018\u00010.2\u0016\u0010/\u001a\u0012\u0012\b\u0012\u00060(j\u0002`1\u0012\u0004\u0012\u000202002\"\u00103\u001a\u001e\u0012\b\u0012\u00060(j\u0002`1\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u000205\u0012\u0004\u0012\u0002050400H\u0016J\u0010\u00106\u001a\u00020 2\u0006\u00107\u001a\u00020\u0006H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u001c\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001e\u00a8\u00068"}, d2={"Lnet/spaceeye/vmod/rendering/types/special/SchemRenderer;", "Lnet/spaceeye/vmod/rendering/types/BlockRenderer;", "schem", "Lnet/spaceeye/valkyrien_ship_schematics/interfaces/IShipSchematic;", "rotationAngle", "Lnet/spaceeye/vmod/utils/Ref;", "", "transparency", "", "renderBlockEntities", "", "<init>", "(Lnet/spaceeye/valkyrien_ship_schematics/interfaces/IShipSchematic;Lnet/spaceeye/vmod/utils/Ref;FZ)V", "getSchem", "()Lnet/spaceeye/valkyrien_ship_schematics/interfaces/IShipSchematic;", "getRotationAngle", "()Lnet/spaceeye/vmod/utils/Ref;", "getTransparency", "()F", "setTransparency", "(F)V", "getRenderBlockEntities", "()Z", "setRenderBlockEntities", "(Z)V", "renderer", "Lnet/spaceeye/vmod/rendering/types/special/SchematicRenderer;", "getRenderer", "()Lnet/spaceeye/vmod/rendering/types/special/SchematicRenderer;", "setRenderer", "(Lnet/spaceeye/vmod/rendering/types/special/SchematicRenderer;)V", "renderBlockData", "", "poseStack", "Lcom/mojang/blaze3d/vertex/PoseStack;", "camera", "Lnet/minecraft/client/Camera;", "sources", "Lnet/minecraft/client/renderer/MultiBufferSource;", "timestamp", "", "serialize", "Lnet/minecraft/network/FriendlyByteBuf;", "deserialize", "buf", "copy", "Lnet/spaceeye/vmod/rendering/types/BaseRenderer;", "oldToNew", "", "Lorg/valkyrienskies/core/api/ships/properties/ShipId;", "Lorg/valkyrienskies/core/api/ships/Ship;", "centerPositions", "Lkotlin/Pair;", "Lnet/spaceeye/vmod/utils/Vector3d;", "scaleBy", "by", "VMod"})
public final class SchemRenderer
extends BlockRenderer {
    @NotNull
    private final IShipSchematic schem;
    @NotNull
    private final Ref<Double> rotationAngle;
    private float transparency;
    private boolean renderBlockEntities;
    @Nullable
    private SchematicRenderer renderer;

    public SchemRenderer(@NotNull IShipSchematic schem, @NotNull Ref<Double> rotationAngle, float transparency, boolean renderBlockEntities) {
        Intrinsics.checkNotNullParameter((Object)schem, (String)"schem");
        Intrinsics.checkNotNullParameter(rotationAngle, (String)"rotationAngle");
        this.schem = schem;
        this.rotationAngle = rotationAngle;
        this.transparency = transparency;
        this.renderBlockEntities = renderBlockEntities;
        new Thread(() -> SchemRenderer._init_$lambda$0(this)).start();
    }

    public /* synthetic */ SchemRenderer(IShipSchematic iShipSchematic, Ref ref, float f, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            f = 0.5f;
        }
        this(iShipSchematic, ref, f, bl);
    }

    @NotNull
    public final IShipSchematic getSchem() {
        return this.schem;
    }

    @NotNull
    public final Ref<Double> getRotationAngle() {
        return this.rotationAngle;
    }

    public final float getTransparency() {
        return this.transparency;
    }

    public final void setTransparency(float f) {
        this.transparency = f;
    }

    public final boolean getRenderBlockEntities() {
        return this.renderBlockEntities;
    }

    public final void setRenderBlockEntities(boolean bl) {
        this.renderBlockEntities = bl;
    }

    @Nullable
    public final SchematicRenderer getRenderer() {
        return this.renderer;
    }

    public final void setRenderer(@Nullable SchematicRenderer schematicRenderer) {
        this.renderer = schematicRenderer;
    }

    @Override
    public void renderBlockData(@NotNull PoseStack poseStack, @NotNull Camera camera, @NotNull MultiBufferSource sources, long timestamp) {
        Intrinsics.checkNotNullParameter((Object)poseStack, (String)"poseStack");
        Intrinsics.checkNotNullParameter((Object)camera, (String)"camera");
        Intrinsics.checkNotNullParameter((Object)sources, (String)"sources");
        BaseMode mode = ClientToolGunState.INSTANCE.getCurrentMode();
        if (!(mode instanceof SchemMode)) {
            return;
        }
        if (!ClientToolGunState.INSTANCE.playerIsUsingToolgun()) {
            return;
        }
        ClientLevel clientLevel = Minecraft.m_91087_().f_91073_;
        Intrinsics.checkNotNull((Object)clientLevel);
        ClientLevel level = clientLevel;
        Level level2 = (Level)level;
        Vector3f vector3f = Minecraft.m_91087_().f_91063_.m_109153_().m_253058_();
        Intrinsics.checkNotNullExpressionValue((Object)vector3f, (String)"getLookVector(...)");
        Vector3d vector3d = new Vector3d(vector3f).snormalize();
        Vec3 vec3 = Minecraft.m_91087_().f_91063_.m_109153_().m_90583_();
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"getPosition(...)");
        RaycastFunctions.RaycastResult raycastResult = RaycastFunctions.renderRaycast$default(RaycastFunctions.INSTANCE, level2, new RaycastFunctions.Source(vector3d, new Vector3d(vec3)), 200.0, null, null, null, null, null, 248, null);
        Vector3d vector3d2 = raycastResult.getWorldHitPos();
        if (vector3d2 == null) {
            return;
        }
        Vector3d vector3d3 = raycastResult.getWorldNormalDirection();
        if (vector3d3 == null) {
            return;
        }
        IShipSchematicInfo iShipSchematicInfo = this.schem.getInfo();
        Intrinsics.checkNotNull((Object)iShipSchematicInfo);
        Vector3d pos = vector3d2.plus(vector3d3.times(iShipSchematicInfo.getMaxObjectPos().y));
        Quaterniond quaterniond = new Quaterniond();
        double d = ((Number)this.rotationAngle.getIt()).doubleValue();
        Vector3d vector3d4 = raycastResult.getWorldNormalDirection();
        Intrinsics.checkNotNull((Object)vector3d4);
        Quaterniond quaterniond2 = quaterniond.mul((Quaterniondc)new Quaterniond(new AxisAngle4d(d, (Vector3dc)vector3d4.toJomlVector3d())));
        Vector3d vector3d5 = raycastResult.getWorldNormalDirection();
        Intrinsics.checkNotNull((Object)vector3d5);
        Quaternionf rotation = quaterniond2.mul((Quaterniondc)GetQuatFromDirKt.getQuatFromDir(vector3d5)).normalize().get(new Quaternionf());
        poseStack.m_85836_();
        poseStack.m_85837_(-camera.m_90583_().f_82479_, -camera.m_90583_().f_82480_, -camera.m_90583_().f_82481_);
        poseStack.m_85837_(pos.x, pos.y, pos.z);
        poseStack.m_252781_(rotation);
        SchematicRenderer schematicRenderer = this.renderer;
        if (schematicRenderer != null) {
            schematicRenderer.render(sources, poseStack);
        }
        poseStack.m_85849_();
    }

    @Override
    @NotNull
    public FriendlyByteBuf serialize() {
        throw new AssertionError((Object)"Shouldn't be serialized");
    }

    @Override
    public void deserialize(@NotNull FriendlyByteBuf buf) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        throw new AssertionError((Object)"Shouldn't be deserialized");
    }

    @Override
    @Nullable
    public BaseRenderer copy(@NotNull Map<Long, ? extends Ship> oldToNew, @NotNull Map<Long, Pair<Vector3d, Vector3d>> centerPositions) {
        Intrinsics.checkNotNullParameter(oldToNew, (String)"oldToNew");
        Intrinsics.checkNotNullParameter(centerPositions, (String)"centerPositions");
        throw new AssertionError((Object)"Shouldn't be copied");
    }

    @Override
    public void scaleBy(double by) {
        throw new AssertionError((Object)"Shouldn't be scaled");
    }

    private static final void _init_$lambda$0(SchemRenderer this$0) {
        this$0.renderer = new SchematicRenderer(this$0.schem, this$0.transparency, this$0.renderBlockEntities);
    }
}

