/*
 * Decompiled with CFR 0.152.
 */
package net.spaceeye.vmod.shipAttachments;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.spaceeye.vmod.compat.vsBackwardsCompat.PhysShipKt;
import net.spaceeye.vmod.utils.Vector3d;
import net.spaceeye.vmod.vsStuff.VSGravityManager;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3dc;
import org.valkyrienskies.core.api.ships.LoadedServerShip;
import org.valkyrienskies.core.api.ships.PhysShip;
import org.valkyrienskies.core.api.ships.ServerShip;
import org.valkyrienskies.core.api.ships.ShipForcesInducer;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE, fieldVisibility=JsonAutoDetect.Visibility.ANY)
@JsonIgnoreProperties(ignoreUnknown=true)
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 &2\u00020\u0001:\u0001&B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0016J\u0006\u0010$\u001a\u00020!J\b\u0010%\u001a\u00020\u0010H\u0007R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\u0005R\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001e\u0010\u000f\u001a\u00020\u00108\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001e\u0010\u0015\u001a\u00020\u00108\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0012\"\u0004\b\u0017\u0010\u0014R,\u0010\u001b\u001a\u00060\u0019j\u0002`\u001a2\n\u0010\u0018\u001a\u00060\u0019j\u0002`\u001a8B@BX\u0082\u000e\u00a2\u0006\f\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001f\u00a8\u0006'"}, d2={"Lnet/spaceeye/vmod/shipAttachments/GravityController;", "Lorg/valkyrienskies/core/api/ships/ShipForcesInducer;", "dimensionId", "", "<init>", "(Ljava/lang/String;)V", "getDimensionId", "()Ljava/lang/String;", "setDimensionId", "useDimensionGravity", "", "getUseDimensionGravity", "()Z", "setUseDimensionGravity", "(Z)V", "dimensionGravity", "Lnet/spaceeye/vmod/utils/Vector3d;", "getDimensionGravity", "()Lnet/spaceeye/vmod/utils/Vector3d;", "setDimensionGravity", "(Lnet/spaceeye/vmod/utils/Vector3d;)V", "gravityVector", "getGravityVector", "setGravityVector", "value", "Lorg/joml/Vector3d;", "Lnet/spaceeye/vmod/utils/JVector3d;", "gravityVectorForSaving", "getGravityVectorForSaving", "()Lorg/joml/Vector3d;", "setGravityVectorForSaving", "(Lorg/joml/Vector3d;)V", "applyForces", "", "physShip", "Lorg/valkyrienskies/core/api/ships/PhysShip;", "reset", "effectiveGravity", "Companion", "VMod"})
public final class GravityController
implements ShipForcesInducer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private String dimensionId;
    private boolean useDimensionGravity;
    @JsonIgnore
    @NotNull
    private Vector3d dimensionGravity;
    @JsonIgnore
    @NotNull
    private Vector3d gravityVector;
    @NotNull
    private static final Vector3d VS_DEFAULT_GRAVITY = new Vector3d(0, -10, 0);

    public GravityController(@NotNull String dimensionId) {
        Intrinsics.checkNotNullParameter((Object)dimensionId, (String)"dimensionId");
        this.dimensionId = dimensionId;
        this.useDimensionGravity = true;
        this.gravityVector = this.dimensionGravity = VSGravityManager.INSTANCE.getDimensionGravityMutableReference(this.dimensionId);
    }

    @NotNull
    public final String getDimensionId() {
        return this.dimensionId;
    }

    public final void setDimensionId(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.dimensionId = string;
    }

    public final boolean getUseDimensionGravity() {
        return this.useDimensionGravity;
    }

    public final void setUseDimensionGravity(boolean bl) {
        this.useDimensionGravity = bl;
    }

    @NotNull
    public final Vector3d getDimensionGravity() {
        return this.dimensionGravity;
    }

    public final void setDimensionGravity(@NotNull Vector3d vector3d) {
        Intrinsics.checkNotNullParameter((Object)vector3d, (String)"<set-?>");
        this.dimensionGravity = vector3d;
    }

    @NotNull
    public final Vector3d getGravityVector() {
        return this.gravityVector;
    }

    public final void setGravityVector(@NotNull Vector3d vector3d) {
        Intrinsics.checkNotNullParameter((Object)vector3d, (String)"<set-?>");
        this.gravityVector = vector3d;
    }

    private final org.joml.Vector3d getGravityVectorForSaving() {
        return this.gravityVector.toJomlVector3d();
    }

    private final void setGravityVectorForSaving(org.joml.Vector3d value) {
        this.gravityVector = new Vector3d(value);
    }

    public void applyForces(@NotNull PhysShip physShip) {
        Intrinsics.checkNotNullParameter((Object)physShip, (String)"physShip");
        Vector3d gravityVector = this.useDimensionGravity ? this.dimensionGravity : this.gravityVector;
        Vector3d forceDiff = gravityVector.minus(VS_DEFAULT_GRAVITY).times(PhysShipKt.getMass(physShip));
        if (forceDiff.sqrDist() < (double)1.4E-45f) {
            return;
        }
        physShip.applyInvariantForce((Vector3dc)forceDiff.toJomlVector3d());
    }

    public final void reset() {
        this.gravityVector = VSGravityManager.INSTANCE.getDimensionGravityMutableReference(this.dimensionId);
        this.useDimensionGravity = true;
    }

    @JsonIgnore
    @NotNull
    public final Vector3d effectiveGravity() {
        return this.useDimensionGravity ? this.dimensionGravity : this.gravityVector;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\f"}, d2={"Lnet/spaceeye/vmod/shipAttachments/GravityController$Companion;", "", "<init>", "()V", "VS_DEFAULT_GRAVITY", "Lnet/spaceeye/vmod/utils/Vector3d;", "getVS_DEFAULT_GRAVITY", "()Lnet/spaceeye/vmod/utils/Vector3d;", "getOrCreate", "Lnet/spaceeye/vmod/shipAttachments/GravityController;", "ship", "Lorg/valkyrienskies/core/api/ships/LoadedServerShip;", "VMod"})
    @SourceDebugExtension(value={"SMAP\nGravityController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GravityController.kt\nnet/spaceeye/vmod/shipAttachments/GravityController$Companion\n+ 2 Attachments.kt\nnet/spaceeye/vmod/compat/vsBackwardsCompat/AttachmentsKt\n+ 3 ServerShip.kt\norg/valkyrienskies/core/api/ships/ServerShipKt\n*L\n1#1,59:1\n6#2:60\n44#3:61\n41#3:62\n*S KotlinDebug\n*F\n+ 1 GravityController.kt\nnet/spaceeye/vmod/shipAttachments/GravityController$Companion\n*L\n54#1:60\n54#1:61\n56#1:62\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Vector3d getVS_DEFAULT_GRAVITY() {
            return VS_DEFAULT_GRAVITY;
        }

        @NotNull
        public final GravityController getOrCreate(@NotNull LoadedServerShip ship) {
            Intrinsics.checkNotNullParameter((Object)ship, (String)"ship");
            ServerShip $this$getAttachment$iv = (ServerShip)ship;
            boolean $i$f$getAttachment = false;
            ServerShip $this$getAttachment$iv$iv = $this$getAttachment$iv;
            boolean $i$f$getAttachment2 = false;
            GravityController gravityController = (GravityController)$this$getAttachment$iv$iv.getAttachment(GravityController.class);
            if (gravityController == null) {
                GravityController gravityController2;
                GravityController it = gravityController2 = new GravityController(ship.getChunkClaimDimension());
                boolean bl = false;
                ServerShip $this$saveAttachment$iv = (ServerShip)ship;
                boolean $i$f$saveAttachment = false;
                $this$saveAttachment$iv.saveAttachment(GravityController.class, (Object)it);
                gravityController = gravityController2;
            }
            return gravityController;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

