/*
 * Decompiled with CFR 0.152.
 */
package net.spaceeye.vmod.shipAttachments;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import net.spaceeye.vmod.shipAttachments.ThrusterData;
import net.spaceeye.vmod.utils.Vector3d;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3dc;
import org.valkyrienskies.core.api.ships.LoadedServerShip;
import org.valkyrienskies.core.api.ships.PhysShip;
import org.valkyrienskies.core.api.ships.ServerShip;
import org.valkyrienskies.core.api.ships.ShipForcesInducer;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE, fieldVisibility=JsonAutoDetect.Visibility.ANY)
@JsonIgnoreProperties(ignoreUnknown=true)
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\b\u0007\u0018\u0000 )2\u00020\u0001:\u0002()B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u001e\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0018J\u0010\u0010\u0019\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\fJ\u0016\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u000e\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\rJ\u000e\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u000e\u001a\u00020\fJ\u0016\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u000e\u001a\u00020\f2\u0006\u0010\u001f\u001a\u00020\u0018R\u001e\u0010\u0004\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001e\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R0\u0010#\u001a\b\u0012\u0004\u0012\u00020\"0!2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!8B@BX\u0082\u000e\u00a2\u0006\f\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'\u00a8\u0006*"}, d2={"Lnet/spaceeye/vmod/shipAttachments/ThrustersController;", "Lorg/valkyrienskies/core/api/ships/ShipForcesInducer;", "<init>", "()V", "lock", "Ljava/util/concurrent/locks/ReentrantLock;", "getLock", "()Ljava/util/concurrent/locks/ReentrantLock;", "setLock", "(Ljava/util/concurrent/locks/ReentrantLock;)V", "thrustersData", "", "", "Lnet/spaceeye/vmod/shipAttachments/ThrusterData;", "id", "applyForces", "", "physShip", "Lorg/valkyrienskies/core/api/ships/PhysShip;", "newThruster", "pos", "Lnet/spaceeye/vmod/utils/Vector3d;", "forceDir", "force", "", "getThruster", "updateThruster", "", "data", "removeThruster", "activateThruster", "percentage", "value", "", "Lnet/spaceeye/vmod/shipAttachments/ThrustersController$ThrusterDataToSave;", "thrustersDataSave", "getThrustersDataSave", "()Ljava/util/List;", "setThrustersDataSave", "(Ljava/util/List;)V", "ThrusterDataToSave", "Companion", "VMod"})
@SourceDebugExtension(value={"SMAP\nThrustersController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ThrustersController.kt\nnet/spaceeye/vmod/shipAttachments/ThrustersController\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,130:1\n1855#2,2:131\n1179#2,2:137\n1253#2,4:139\n125#3:133\n152#3,3:134\n*S KotlinDebug\n*F\n+ 1 ThrustersController.kt\nnet/spaceeye/vmod/shipAttachments/ThrustersController\n*L\n71#1:131,2\n121#1:137,2\n121#1:139,4\n120#1:133\n120#1:134,3\n*E\n"})
public final class ThrustersController
implements ShipForcesInducer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JsonIgnore
    @NotNull
    private ReentrantLock lock = new ReentrantLock();
    @JsonIgnore
    @NotNull
    private Map<Integer, ThrusterData> thrustersData = new LinkedHashMap();
    private int id;

    @NotNull
    public final ReentrantLock getLock() {
        return this.lock;
    }

    public final void setLock(@NotNull ReentrantLock reentrantLock) {
        Intrinsics.checkNotNullParameter((Object)reentrantLock, (String)"<set-?>");
        this.lock = reentrantLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyForces(@NotNull PhysShip physShip) {
        Intrinsics.checkNotNullParameter((Object)physShip, (String)"physShip");
        ReentrantLock reentrantLock = this.lock;
        synchronized (reentrantLock) {
            boolean bl = false;
            Iterable $this$forEach$iv = this.thrustersData.values();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ThrusterData it = (ThrusterData)element$iv;
                boolean bl2 = false;
                if (it.getPercentage() <= 0.0) continue;
                org.joml.Vector3d pos = it.getPos().sub(physShip.getTransform().getPositionInShip(), new org.joml.Vector3d());
                Vector3dc vector3dc = (Vector3dc)it.getCompiledForce();
                Intrinsics.checkNotNull((Object)pos);
                physShip.applyRotDependentForceToPos(vector3dc, (Vector3dc)pos);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int newThruster(@NotNull Vector3d pos, @NotNull Vector3d forceDir, double force) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)forceDir, (String)"forceDir");
        ReentrantLock reentrantLock = this.lock;
        synchronized (reentrantLock) {
            boolean bl = false;
            int n = this.id;
            this.id = n + 1;
            this.thrustersData.put(this.id, new ThrusterData(this.id, pos.toJomlVector3d(), forceDir.toJomlVector3d(), force, 0.0, forceDir.times(force).times(0.0).toJomlVector3d()));
            int n2 = this.id;
            return n2;
        }
    }

    @Nullable
    public final ThrusterData getThruster(int id2) {
        ThrusterData thrusterData = this.thrustersData.get(id2);
        if (thrusterData == null) {
            return null;
        }
        ThrusterData it = thrusterData;
        return it.deepCopy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean updateThruster(int id2, @NotNull ThrusterData data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        ReentrantLock reentrantLock = this.lock;
        synchronized (reentrantLock) {
            block6: {
                block5: {
                    boolean bl = false;
                    if (data.getId() == id2) break block5;
                    boolean bl2 = false;
                    return bl2;
                }
                if (this.thrustersData.get(id2) != null) break block6;
                boolean bl = false;
                return bl;
            }
            ThrusterData copy = data.deepCopy();
            copy.setCompiledForce(copy.getForceDir().mul(copy.getForce() * copy.getPercentage(), new org.joml.Vector3d()));
            Integer n = id2;
            this.thrustersData.put(n, copy);
            boolean bl = true;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean removeThruster(int id2) {
        ReentrantLock reentrantLock = this.lock;
        synchronized (reentrantLock) {
            boolean bl = false;
            boolean bl2 = this.thrustersData.remove(id2) != null;
            return bl2;
        }
    }

    public final boolean activateThruster(int id2, double percentage) {
        ThrusterData thrusterData = this.thrustersData.get(id2);
        if (thrusterData == null) {
            return false;
        }
        ThrusterData it = thrusterData;
        it.setCompiledForce(it.getForceDir().mul(it.getForce() * percentage, new org.joml.Vector3d()));
        it.setPercentage(percentage);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final List<ThrusterDataToSave> getThrustersDataSave() {
        void $this$mapTo$iv$iv;
        Map<Integer, ThrusterData> $this$map$iv = this.thrustersData;
        boolean $i$f$map = false;
        Map<Integer, ThrusterData> map2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry item$iv$iv;
            Map.Entry entry2 = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            int k = ((Number)entry2.getKey()).intValue();
            ThrusterData v = (ThrusterData)entry2.getValue();
            collection.add(v.toSave());
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final void setThrustersDataSave(List<ThrusterDataToSave> value) {
        void $this$associateTo$iv$iv;
        void $this$associate$iv;
        Iterable iterable = value;
        ThrustersController thrustersController = this;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        void var5_6 = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map2 = destination$iv$iv;
            ThrusterDataToSave it = (ThrusterDataToSave)element$iv$iv;
            boolean bl = false;
            Pair pair = new Pair((Object)it.getId(), (Object)new ThrusterData(it));
            map2.put(pair.getFirst(), pair.getSecond());
        }
        thrustersController.thrustersData = MapsKt.toMutableMap((Map)destination$iv$iv);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lnet/spaceeye/vmod/shipAttachments/ThrustersController$Companion;", "", "<init>", "()V", "getOrCreate", "Lnet/spaceeye/vmod/shipAttachments/ThrustersController;", "ship", "Lorg/valkyrienskies/core/api/ships/LoadedServerShip;", "VMod"})
    @SourceDebugExtension(value={"SMAP\nThrustersController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ThrustersController.kt\nnet/spaceeye/vmod/shipAttachments/ThrustersController$Companion\n+ 2 Attachments.kt\nnet/spaceeye/vmod/compat/vsBackwardsCompat/AttachmentsKt\n+ 3 ServerShip.kt\norg/valkyrienskies/core/api/ships/ServerShipKt\n*L\n1#1,130:1\n6#2:131\n44#3:132\n41#3:133\n*S KotlinDebug\n*F\n+ 1 ThrustersController.kt\nnet/spaceeye/vmod/shipAttachments/ThrustersController$Companion\n*L\n125#1:131\n125#1:132\n127#1:133\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ThrustersController getOrCreate(@NotNull LoadedServerShip ship) {
            Intrinsics.checkNotNullParameter((Object)ship, (String)"ship");
            ServerShip $this$getAttachment$iv = (ServerShip)ship;
            boolean $i$f$getAttachment = false;
            ServerShip $this$getAttachment$iv$iv = $this$getAttachment$iv;
            boolean $i$f$getAttachment2 = false;
            ThrustersController thrustersController = (ThrustersController)$this$getAttachment$iv$iv.getAttachment(ThrustersController.class);
            if (thrustersController == null) {
                ThrustersController thrustersController2;
                ThrustersController it = thrustersController2 = new ThrustersController();
                boolean bl = false;
                ServerShip $this$saveAttachment$iv = (ServerShip)ship;
                boolean $i$f$saveAttachment = false;
                $this$saveAttachment$iv.saveAttachment(ThrustersController.class, (Object)it);
                thrustersController = thrustersController2;
            }
            return thrustersController;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u001a\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006\u0012\n\u0010\u0007\u001a\u00060\u0005j\u0002`\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\t\u0010\u001d\u001a\u00020\u0003H\u00c6\u0003J\r\u0010\u001e\u001a\u00060\u0005j\u0002`\u0006H\u00c6\u0003J\r\u0010\u001f\u001a\u00060\u0005j\u0002`\u0006H\u00c6\u0003J\t\u0010 \u001a\u00020\tH\u00c6\u0003J\t\u0010!\u001a\u00020\tH\u00c6\u0003JC\u0010\"\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\f\b\u0002\u0010\u0004\u001a\u00060\u0005j\u0002`\u00062\f\b\u0002\u0010\u0007\u001a\u00060\u0005j\u0002`\u00062\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\tH\u00c6\u0001J\u0013\u0010#\u001a\u00020$2\b\u0010%\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010&\u001a\u00020\u0003H\u00d6\u0001J\t\u0010'\u001a\u00020(H\u00d6\u0001R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001e\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001e\u0010\u0007\u001a\u00060\u0005j\u0002`\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0012\"\u0004\b\u0016\u0010\u0014R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001a\u0010\n\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u0018\"\u0004\b\u001c\u0010\u001a\u00a8\u0006)"}, d2={"Lnet/spaceeye/vmod/shipAttachments/ThrustersController$ThrusterDataToSave;", "", "id", "", "pos", "Lorg/joml/Vector3d;", "Lnet/spaceeye/vmod/utils/JVector3d;", "forceDir", "force", "", "percentage", "<init>", "(ILorg/joml/Vector3d;Lorg/joml/Vector3d;DD)V", "getId", "()I", "setId", "(I)V", "getPos", "()Lorg/joml/Vector3d;", "setPos", "(Lorg/joml/Vector3d;)V", "getForceDir", "setForceDir", "getForce", "()D", "setForce", "(D)V", "getPercentage", "setPercentage", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "toString", "", "VMod"})
    public static final class ThrusterDataToSave {
        private int id;
        @NotNull
        private org.joml.Vector3d pos;
        @NotNull
        private org.joml.Vector3d forceDir;
        private double force;
        private double percentage;

        public ThrusterDataToSave(int id2, @NotNull org.joml.Vector3d pos, @NotNull org.joml.Vector3d forceDir, double force, double percentage) {
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            Intrinsics.checkNotNullParameter((Object)forceDir, (String)"forceDir");
            this.id = id2;
            this.pos = pos;
            this.forceDir = forceDir;
            this.force = force;
            this.percentage = percentage;
        }

        public final int getId() {
            return this.id;
        }

        public final void setId(int n) {
            this.id = n;
        }

        @NotNull
        public final org.joml.Vector3d getPos() {
            return this.pos;
        }

        public final void setPos(@NotNull org.joml.Vector3d vector3d) {
            Intrinsics.checkNotNullParameter((Object)vector3d, (String)"<set-?>");
            this.pos = vector3d;
        }

        @NotNull
        public final org.joml.Vector3d getForceDir() {
            return this.forceDir;
        }

        public final void setForceDir(@NotNull org.joml.Vector3d vector3d) {
            Intrinsics.checkNotNullParameter((Object)vector3d, (String)"<set-?>");
            this.forceDir = vector3d;
        }

        public final double getForce() {
            return this.force;
        }

        public final void setForce(double d) {
            this.force = d;
        }

        public final double getPercentage() {
            return this.percentage;
        }

        public final void setPercentage(double d) {
            this.percentage = d;
        }

        public final int component1() {
            return this.id;
        }

        @NotNull
        public final org.joml.Vector3d component2() {
            return this.pos;
        }

        @NotNull
        public final org.joml.Vector3d component3() {
            return this.forceDir;
        }

        public final double component4() {
            return this.force;
        }

        public final double component5() {
            return this.percentage;
        }

        @NotNull
        public final ThrusterDataToSave copy(int id2, @NotNull org.joml.Vector3d pos, @NotNull org.joml.Vector3d forceDir, double force, double percentage) {
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            Intrinsics.checkNotNullParameter((Object)forceDir, (String)"forceDir");
            return new ThrusterDataToSave(id2, pos, forceDir, force, percentage);
        }

        public static /* synthetic */ ThrusterDataToSave copy$default(ThrusterDataToSave thrusterDataToSave, int n, org.joml.Vector3d vector3d, org.joml.Vector3d vector3d2, double d, double d2, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = thrusterDataToSave.id;
            }
            if ((n2 & 2) != 0) {
                vector3d = thrusterDataToSave.pos;
            }
            if ((n2 & 4) != 0) {
                vector3d2 = thrusterDataToSave.forceDir;
            }
            if ((n2 & 8) != 0) {
                d = thrusterDataToSave.force;
            }
            if ((n2 & 0x10) != 0) {
                d2 = thrusterDataToSave.percentage;
            }
            return thrusterDataToSave.copy(n, vector3d, vector3d2, d, d2);
        }

        @NotNull
        public String toString() {
            return "ThrusterDataToSave(id=" + this.id + ", pos=" + this.pos + ", forceDir=" + this.forceDir + ", force=" + this.force + ", percentage=" + this.percentage + ")";
        }

        public int hashCode() {
            int result = Integer.hashCode(this.id);
            result = result * 31 + this.pos.hashCode();
            result = result * 31 + this.forceDir.hashCode();
            result = result * 31 + Double.hashCode(this.force);
            result = result * 31 + Double.hashCode(this.percentage);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ThrusterDataToSave)) {
                return false;
            }
            ThrusterDataToSave thrusterDataToSave = (ThrusterDataToSave)other;
            if (this.id != thrusterDataToSave.id) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.pos, (Object)thrusterDataToSave.pos)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.forceDir, (Object)thrusterDataToSave.forceDir)) {
                return false;
            }
            if (Double.compare(this.force, thrusterDataToSave.force) != 0) {
                return false;
            }
            return Double.compare(this.percentage, thrusterDataToSave.percentage) == 0;
        }
    }
}

