/*
 * Decompiled with CFR 0.152.
 */
package net.spaceeye.vmod.toolgun.modes.state;

import com.fasterxml.jackson.annotation.JsonIgnore;
import dev.architectury.event.events.common.PlayerEvent;
import dev.architectury.networking.NetworkManager;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Stream;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.spaceeye.valkyrien_ship_schematics.ShipSchematic;
import net.spaceeye.valkyrien_ship_schematics.interfaces.IShipSchematic;
import net.spaceeye.vmod.VMConfig;
import net.spaceeye.vmod.VMKt;
import net.spaceeye.vmod.networking.DataStream;
import net.spaceeye.vmod.networking.Serializable;
import net.spaceeye.vmod.reflectable.AutoSerializable;
import net.spaceeye.vmod.reflectable.AutoSerializableKt;
import net.spaceeye.vmod.reflectable.ReflectableItemDelegate;
import net.spaceeye.vmod.reflectable.ReflectableObject;
import net.spaceeye.vmod.toolgun.ClientToolGunState;
import net.spaceeye.vmod.toolgun.ServerToolGunState;
import net.spaceeye.vmod.toolgun.modes.BaseMode;
import net.spaceeye.vmod.toolgun.modes.state.SchemMode;
import net.spaceeye.vmod.toolgun.modes.state.SchemModeKt;
import net.spaceeye.vmod.utils.Either;
import net.spaceeye.vmod.utils.ServerClosable;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0003()*B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001fJ\u0010\u0010!\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\"\u001a\u00020 J\u0016\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u001aR&\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR&\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\t\"\u0004\b\u000e\u0010\u000bR&\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00070\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\t\"\u0004\b\u0012\u0010\u000bR\u001d\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u001f\u0010\u0019\u001a\u0010\u0012\u0004\u0012\u00020\u0015\u0012\u0006\u0012\u0004\u0018\u00010\u001a0\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0018\u00a8\u0006+"}, d2={"Lnet/spaceeye/vmod/toolgun/modes/state/PlayerSchematics;", "Lnet/spaceeye/vmod/utils/ServerClosable;", "<init>", "()V", "saveSchemStream", "Lnet/spaceeye/vmod/networking/DataStream;", "Lnet/spaceeye/vmod/toolgun/modes/state/PlayerSchematics$SendSchemRequest;", "Lnet/spaceeye/vmod/toolgun/modes/state/PlayerSchematics$SchemHolder;", "getSaveSchemStream", "()Lnet/spaceeye/vmod/networking/DataStream;", "setSaveSchemStream", "(Lnet/spaceeye/vmod/networking/DataStream;)V", "getSchemStream", "getGetSchemStream", "setGetSchemStream", "loadSchemStream", "Lnet/spaceeye/vmod/toolgun/modes/state/PlayerSchematics$SendLoadRequest;", "getLoadSchemStream", "setLoadSchemStream", "loadRequests", "", "Ljava/util/UUID;", "", "getLoadRequests", "()Ljava/util/Map;", "schematics", "Lnet/spaceeye/valkyrien_ship_schematics/interfaces/IShipSchematic;", "getSchematics", "close", "", "listSchematics", "", "Ljava/nio/file/Path;", "loadSchematic", "path", "saveSchematic", "", "name", "", "schematic", "SendLoadRequest", "SchemHolder", "SendSchemRequest", "VMod"})
public final class PlayerSchematics
extends ServerClosable {
    @NotNull
    public static final PlayerSchematics INSTANCE = new PlayerSchematics();
    @NotNull
    private static DataStream<SendSchemRequest, SchemHolder> saveSchemStream;
    @NotNull
    private static DataStream<SendSchemRequest, SchemHolder> getSchemStream;
    @NotNull
    private static DataStream<SendLoadRequest, SchemHolder> loadSchemStream;
    @NotNull
    private static final Map<UUID, Long> loadRequests;
    @NotNull
    private static final Map<UUID, IShipSchematic> schematics;

    private PlayerSchematics() {
    }

    @NotNull
    public final DataStream<SendSchemRequest, SchemHolder> getSaveSchemStream() {
        return saveSchemStream;
    }

    public final void setSaveSchemStream(@NotNull DataStream<SendSchemRequest, SchemHolder> dataStream) {
        Intrinsics.checkNotNullParameter(dataStream, (String)"<set-?>");
        saveSchemStream = dataStream;
    }

    @NotNull
    public final DataStream<SendSchemRequest, SchemHolder> getGetSchemStream() {
        return getSchemStream;
    }

    public final void setGetSchemStream(@NotNull DataStream<SendSchemRequest, SchemHolder> dataStream) {
        Intrinsics.checkNotNullParameter(dataStream, (String)"<set-?>");
        getSchemStream = dataStream;
    }

    @NotNull
    public final DataStream<SendLoadRequest, SchemHolder> getLoadSchemStream() {
        return loadSchemStream;
    }

    public final void setLoadSchemStream(@NotNull DataStream<SendLoadRequest, SchemHolder> dataStream) {
        Intrinsics.checkNotNullParameter(dataStream, (String)"<set-?>");
        loadSchemStream = dataStream;
    }

    @NotNull
    public final Map<UUID, Long> getLoadRequests() {
        return loadRequests;
    }

    @NotNull
    public final Map<UUID, IShipSchematic> getSchematics() {
        return schematics;
    }

    @Override
    public void close() {
        schematics.clear();
        loadRequests.clear();
    }

    @NotNull
    public final List<Path> listSchematics() {
        try {
            Files.createDirectories(Paths.get("VMod-Schematics", new String[0]), new FileAttribute[0]);
        }
        catch (IOException e) {
            return CollectionsKt.emptyList();
        }
        Stream<Path> files = Files.list(Paths.get("VMod-Schematics", new String[0]));
        List<Object> list = files.filter(arg_0 -> PlayerSchematics.listSchematics$lambda$2(PlayerSchematics::listSchematics$lambda$1, arg_0)).toList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"toList(...)");
        return list;
    }

    @Nullable
    public final IShipSchematic loadSchematic(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        try {
            byte[] bytes = Files.readAllBytes(path);
            Intrinsics.checkNotNull((Object)bytes);
            return SchemModeKt.access$bcGetSchematicFromBytes(bytes);
        }
        catch (Exception e) {
            VMKt.ELOG("Failed to load file because " + ExceptionsKt.stackTraceToString((Throwable)e));
            return null;
        }
    }

    public final boolean saveSchematic(@NotNull String name, @NotNull IShipSchematic schematic) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)schematic, (String)"schematic");
        try {
            Path path = Paths.get("VMod-Schematics/" + name, new String[0]);
            ByteBuf byteBuf = ShipSchematic.writeSchematicToBuffer((IShipSchematic)schematic);
            Intrinsics.checkNotNull((Object)byteBuf);
            Files.write(path, byteBuf.array(), new OpenOption[0]);
        }
        catch (IOException e) {
            VMKt.ELOG("Failed to save schematic to file because " + ExceptionsKt.stackTraceToString((Throwable)e));
            return false;
        }
        return true;
    }

    private static final void _init_$lambda$0(ServerPlayer it) {
        schematics.remove(it.m_20148_());
        loadRequests.remove(it.m_20148_());
    }

    private static final boolean listSchematics$lambda$1(Path it) {
        Intrinsics.checkNotNull((Object)it);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        return !Files.isDirectory(it, Arrays.copyOf(linkOptionArray, linkOptionArray.length)) && Intrinsics.areEqual((Object)PathsKt.getExtension((Path)it), (Object)"vschem");
    }

    private static final boolean listSchematics$lambda$2(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    static {
        NetworkManager.Side side = NetworkManager.Side.S2C;
        saveSchemStream = new DataStream<SendSchemRequest, SchemHolder>(side){

            public int getPartByteAmount() {
                return VMConfig.INSTANCE.getSERVER().getTOOLGUN().getSCHEMATIC_PACKET_PART_SIZE();
            }

            public SendSchemRequest requestPacketConstructor(FriendlyByteBuf buf) {
                Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
                return (SendSchemRequest)AutoSerializableKt.constructor(Reflection.getOrCreateKotlinClass(SendSchemRequest.class), buf);
            }

            public SchemHolder dataPacketConstructor() {
                return new SchemHolder();
            }

            public void receiverDataTransmissionFailed(DataStream.RequestFailurePkt failurePkt) {
                Intrinsics.checkNotNullParameter((Object)failurePkt, (String)"failurePkt");
                VMKt.ELOG("Client Save Schem Transmission Failed");
            }

            public boolean uuidHasAccess(UUID uuid, NetworkManager.PacketContext ctx, SendSchemRequest req) {
                Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
                Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
                Intrinsics.checkNotNullParameter((Object)req, (String)"req");
                Player player = ctx.getPlayer();
                Intrinsics.checkNotNull((Object)player, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerPlayer");
                return ServerToolGunState.playerHasAccess((ServerPlayer)player);
            }

            public Either<SchemHolder, DataStream.RequestFailurePkt> transmitterRequestProcessor(SendSchemRequest req, NetworkManager.PacketContext ctx) {
                SchemHolder schemHolder;
                Intrinsics.checkNotNullParameter((Object)req, (String)"req");
                Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
                IShipSchematic iShipSchematic = PlayerSchematics.INSTANCE.getSchematics().get(req.getUuid());
                if (iShipSchematic != null) {
                    IShipSchematic it = iShipSchematic;
                    boolean bl = false;
                    ByteBuf byteBuf = ShipSchematic.writeSchematicToBuffer((IShipSchematic)it);
                    Intrinsics.checkNotNull((Object)byteBuf);
                    schemHolder = new SchemHolder(byteBuf, null, 2, null);
                } else {
                    schemHolder = null;
                }
                SchemHolder res = schemHolder;
                return res != null ? (Either)new Either.Left<SchemHolder>(res) : (Either)new Either.Right<DataStream.RequestFailurePkt>(new DataStream.RequestFailurePkt());
            }

            public void receiverDataTransmitted(UUID uuid, SchemHolder data, NetworkManager.PacketContext ctx) {
                block1: {
                    Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
                    Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                    Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
                    BaseMode baseMode = ClientToolGunState.INSTANCE.getCurrentMode();
                    if (baseMode == null) break block1;
                    BaseMode it = baseMode;
                    boolean bl = false;
                    if (it instanceof SchemMode) {
                        SchemMode schemMode = (SchemMode)it;
                        byte[] byArray = data.getData().array();
                        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"array(...)");
                        schemMode.setSchem(SchemModeKt.access$bcGetSchematicFromBytes(byArray));
                        ((SchemMode)it).saveSchem(PlayerSchematics.INSTANCE.listSchematics());
                        ((SchemMode)it).reloadScrollItems();
                    }
                }
            }
        };
        side = NetworkManager.Side.S2C;
        getSchemStream = new DataStream<SendSchemRequest, SchemHolder>(side){

            public int getPartByteAmount() {
                return VMConfig.INSTANCE.getSERVER().getTOOLGUN().getSCHEMATIC_PACKET_PART_SIZE();
            }

            public SendSchemRequest requestPacketConstructor(FriendlyByteBuf buf) {
                Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
                return (SendSchemRequest)AutoSerializableKt.constructor(Reflection.getOrCreateKotlinClass(SendSchemRequest.class), buf);
            }

            public SchemHolder dataPacketConstructor() {
                return new SchemHolder();
            }

            public void receiverDataTransmissionFailed(DataStream.RequestFailurePkt failurePkt) {
                Intrinsics.checkNotNullParameter((Object)failurePkt, (String)"failurePkt");
            }

            public boolean uuidHasAccess(UUID uuid, NetworkManager.PacketContext ctx, SendSchemRequest req) {
                Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
                Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
                Intrinsics.checkNotNullParameter((Object)req, (String)"req");
                Player player = ctx.getPlayer();
                Intrinsics.checkNotNull((Object)player, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerPlayer");
                return ServerToolGunState.playerHasAccess((ServerPlayer)player);
            }

            public Either<SchemHolder, DataStream.RequestFailurePkt> transmitterRequestProcessor(SendSchemRequest req, NetworkManager.PacketContext ctx) {
                SchemHolder schemHolder;
                Intrinsics.checkNotNullParameter((Object)req, (String)"req");
                Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
                IShipSchematic iShipSchematic = PlayerSchematics.INSTANCE.getSchematics().get(req.getUuid());
                if (iShipSchematic != null) {
                    IShipSchematic it = iShipSchematic;
                    boolean bl = false;
                    ByteBuf byteBuf = ShipSchematic.writeSchematicToBuffer((IShipSchematic)it);
                    Intrinsics.checkNotNull((Object)byteBuf);
                    schemHolder = new SchemHolder(byteBuf, null, 2, null);
                } else {
                    schemHolder = null;
                }
                SchemHolder res = schemHolder;
                return res != null ? (Either)new Either.Left<SchemHolder>(res) : (Either)new Either.Right<DataStream.RequestFailurePkt>(new DataStream.RequestFailurePkt());
            }

            public void receiverDataTransmitted(UUID uuid, SchemHolder data, NetworkManager.PacketContext ctx) {
                block1: {
                    Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
                    Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                    Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
                    BaseMode baseMode = ClientToolGunState.INSTANCE.getCurrentMode();
                    if (baseMode == null) break block1;
                    BaseMode it = baseMode;
                    boolean bl = false;
                    if (it instanceof SchemMode) {
                        SchemMode schemMode = (SchemMode)it;
                        byte[] byArray = data.getData().array();
                        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"array(...)");
                        schemMode.setSchem(SchemModeKt.access$bcGetSchematicFromBytes(byArray));
                    }
                }
            }
        };
        side = NetworkManager.Side.C2S;
        loadSchemStream = new DataStream<SendLoadRequest, SchemHolder>(side){

            public int getPartByteAmount() {
                return VMConfig.INSTANCE.getCLIENT().getTOOLGUN().getSCHEMATIC_PACKET_PART_SIZE();
            }

            public SendLoadRequest requestPacketConstructor(FriendlyByteBuf buf) {
                Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
                return (SendLoadRequest)AutoSerializableKt.constructor(Reflection.getOrCreateKotlinClass(SendLoadRequest.class), buf);
            }

            public SchemHolder dataPacketConstructor() {
                return new SchemHolder();
            }

            public void receiverDataTransmissionFailed(DataStream.RequestFailurePkt failurePkt) {
                Intrinsics.checkNotNullParameter((Object)failurePkt, (String)"failurePkt");
                VMKt.ELOG("Client Load Schem Transmission Failed");
            }

            public Either<SchemHolder, DataStream.RequestFailurePkt> transmitterRequestProcessor(SendLoadRequest req, NetworkManager.PacketContext ctx) {
                SchemHolder schemHolder;
                Intrinsics.checkNotNullParameter((Object)req, (String)"req");
                Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
                BaseMode baseMode = ClientToolGunState.INSTANCE.getCurrentMode();
                if (baseMode != null) {
                    BaseMode mode = baseMode;
                    boolean bl = false;
                    if (!(mode instanceof SchemMode)) {
                        schemHolder = null;
                    } else {
                        IShipSchematic iShipSchematic = ((SchemMode)mode).getSchem();
                        if (iShipSchematic != null) {
                            IShipSchematic it = iShipSchematic;
                            boolean bl2 = false;
                            ByteBuf byteBuf = ShipSchematic.writeSchematicToBuffer((IShipSchematic)it);
                            Intrinsics.checkNotNull((Object)byteBuf);
                            schemHolder = new SchemHolder(byteBuf, req.getRequestUUID());
                        } else {
                            schemHolder = null;
                        }
                    }
                } else {
                    schemHolder = null;
                }
                SchemHolder res = schemHolder;
                return res != null ? (Either)new Either.Left<Object>(res) : (Either)new Either.Right<DataStream.RequestFailurePkt>(new DataStream.RequestFailurePkt());
            }

            public void receiverDataTransmitted(UUID uuid, SchemHolder data, NetworkManager.PacketContext ctx) {
                Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
                Map<UUID, IShipSchematic> map2 = PlayerSchematics.INSTANCE.getSchematics();
                UUID uUID = data.getUuid();
                byte[] byArray = data.getData().array();
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"array(...)");
                IShipSchematic iShipSchematic = SchemModeKt.access$bcGetSchematicFromBytes(byArray);
                map2.put(uUID, iShipSchematic);
                PlayerSchematics.INSTANCE.getLoadRequests().remove(data.getUuid());
            }
        };
        loadRequests = new LinkedHashMap();
        schematics = new LinkedHashMap();
        PlayerEvent.PLAYER_QUIT.register(PlayerSchematics::_init_$lambda$0);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003B\u001b\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0002\u0010\bJ\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0012H\u0016R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\u0006\u001a\u00020\u0007X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0016"}, d2={"Lnet/spaceeye/vmod/toolgun/modes/state/PlayerSchematics$SchemHolder;", "Lnet/spaceeye/vmod/networking/Serializable;", "<init>", "()V", "data", "Lio/netty/buffer/ByteBuf;", "uuid", "Ljava/util/UUID;", "(Lio/netty/buffer/ByteBuf;Ljava/util/UUID;)V", "getData", "()Lio/netty/buffer/ByteBuf;", "setData", "(Lio/netty/buffer/ByteBuf;)V", "getUuid", "()Ljava/util/UUID;", "setUuid", "(Ljava/util/UUID;)V", "serialize", "Lnet/minecraft/network/FriendlyByteBuf;", "deserialize", "", "buf", "VMod"})
    public static final class SchemHolder
    implements Serializable {
        public ByteBuf data;
        public UUID uuid;

        public SchemHolder() {
        }

        @NotNull
        public final ByteBuf getData() {
            ByteBuf byteBuf = this.data;
            if (byteBuf != null) {
                return byteBuf;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"data");
            return null;
        }

        public final void setData(@NotNull ByteBuf byteBuf) {
            Intrinsics.checkNotNullParameter((Object)byteBuf, (String)"<set-?>");
            this.data = byteBuf;
        }

        @NotNull
        public final UUID getUuid() {
            UUID uUID = this.uuid;
            if (uUID != null) {
                return uUID;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"uuid");
            return null;
        }

        public final void setUuid(@NotNull UUID uUID) {
            Intrinsics.checkNotNullParameter((Object)uUID, (String)"<set-?>");
            this.uuid = uUID;
        }

        public SchemHolder(@NotNull ByteBuf data, @NotNull UUID uuid) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
            this();
            this.setData(data);
            this.setUuid(uuid);
        }

        public /* synthetic */ SchemHolder(ByteBuf byteBuf, UUID uUID, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                uUID = new UUID(0L, 0L);
            }
            this(byteBuf, uUID);
        }

        @Override
        @NotNull
        public FriendlyByteBuf serialize() {
            FriendlyByteBuf buf = this.getBuffer();
            buf.m_130077_(this.getUuid());
            buf.m_130087_(this.getData().array());
            return buf;
        }

        @Override
        public void deserialize(@NotNull FriendlyByteBuf buf) {
            Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
            this.setUuid(buf.m_130259_());
            this.setData(Unpooled.wrappedBuffer((byte[])buf.m_130052_()));
        }

        @Override
        @NotNull
        public FriendlyByteBuf getBuffer() {
            return Serializable.DefaultImpls.getBuffer(this);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\n\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\u0005\u00a8\u0006\u0013"}, d2={"Lnet/spaceeye/vmod/toolgun/modes/state/PlayerSchematics$SendLoadRequest;", "Lnet/spaceeye/vmod/reflectable/AutoSerializable;", "requestUUID", "Ljava/util/UUID;", "<init>", "(Ljava/util/UUID;)V", "getRequestUUID", "()Ljava/util/UUID;", "setRequestUUID", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "VMod"})
    public static final class SendLoadRequest
    implements AutoSerializable {
        @NotNull
        private UUID requestUUID;

        public SendLoadRequest(@NotNull UUID requestUUID) {
            Intrinsics.checkNotNullParameter((Object)requestUUID, (String)"requestUUID");
            this.requestUUID = requestUUID;
        }

        @NotNull
        public final UUID getRequestUUID() {
            return this.requestUUID;
        }

        public final void setRequestUUID(@NotNull UUID uUID) {
            Intrinsics.checkNotNullParameter((Object)uUID, (String)"<set-?>");
            this.requestUUID = uUID;
        }

        @NotNull
        public final UUID component1() {
            return this.requestUUID;
        }

        @NotNull
        public final SendLoadRequest copy(@NotNull UUID requestUUID) {
            Intrinsics.checkNotNullParameter((Object)requestUUID, (String)"requestUUID");
            return new SendLoadRequest(requestUUID);
        }

        public static /* synthetic */ SendLoadRequest copy$default(SendLoadRequest sendLoadRequest, UUID uUID, int n, Object object) {
            if ((n & 1) != 0) {
                uUID = sendLoadRequest.requestUUID;
            }
            return sendLoadRequest.copy(uUID);
        }

        @NotNull
        public String toString() {
            return "SendLoadRequest(requestUUID=" + this.requestUUID + ")";
        }

        public int hashCode() {
            return this.requestUUID.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SendLoadRequest)) {
                return false;
            }
            SendLoadRequest sendLoadRequest = (SendLoadRequest)other;
            return Intrinsics.areEqual((Object)this.requestUUID, (Object)sendLoadRequest.requestUUID);
        }

        @Override
        @JsonIgnore
        @ApiStatus.NonExtendable
        @NotNull
        public FriendlyByteBuf serialize() {
            return AutoSerializable.DefaultImpls.serialize(this);
        }

        @Override
        @JsonIgnore
        @ApiStatus.NonExtendable
        public void deserialize(@NotNull FriendlyByteBuf buf) {
            AutoSerializable.DefaultImpls.deserialize(this, buf);
        }

        @Override
        @JsonIgnore
        @NotNull
        public FriendlyByteBuf getBuffer() {
            return AutoSerializable.DefaultImpls.getBuffer(this);
        }

        @Override
        @JsonIgnore
        @Nullable
        public ReflectableObject getReflectObjectOverride() {
            return AutoSerializable.DefaultImpls.getReflectObjectOverride(this);
        }

        @Override
        @JsonIgnore
        @ApiStatus.NonExtendable
        @NotNull
        public List<ReflectableItemDelegate<?>> getAllReflectableItems(boolean processSubReflectables, @NotNull Function1<? super ReflectableItemDelegate<?>, Boolean> filterBy) {
            return AutoSerializable.DefaultImpls.getAllReflectableItems(this, processSubReflectables, filterBy);
        }

        @Override
        @JsonIgnore
        @ApiStatus.NonExtendable
        @NotNull
        public List<ReflectableItemDelegate<?>> getReflectableItemsWithoutDataclassConstructorItems(boolean processSubReflectables, @NotNull Function1<? super ReflectableItemDelegate<?>, Boolean> filterBy) {
            return AutoSerializable.DefaultImpls.getReflectableItemsWithoutDataclassConstructorItems(this, processSubReflectables, filterBy);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\n\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\u0005\u00a8\u0006\u0013"}, d2={"Lnet/spaceeye/vmod/toolgun/modes/state/PlayerSchematics$SendSchemRequest;", "Lnet/spaceeye/vmod/reflectable/AutoSerializable;", "uuid", "Ljava/util/UUID;", "<init>", "(Ljava/util/UUID;)V", "getUuid", "()Ljava/util/UUID;", "setUuid", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "VMod"})
    public static final class SendSchemRequest
    implements AutoSerializable {
        @NotNull
        private UUID uuid;

        public SendSchemRequest(@NotNull UUID uuid) {
            Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
            this.uuid = uuid;
        }

        @NotNull
        public final UUID getUuid() {
            return this.uuid;
        }

        public final void setUuid(@NotNull UUID uUID) {
            Intrinsics.checkNotNullParameter((Object)uUID, (String)"<set-?>");
            this.uuid = uUID;
        }

        @NotNull
        public final UUID component1() {
            return this.uuid;
        }

        @NotNull
        public final SendSchemRequest copy(@NotNull UUID uuid) {
            Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
            return new SendSchemRequest(uuid);
        }

        public static /* synthetic */ SendSchemRequest copy$default(SendSchemRequest sendSchemRequest, UUID uUID, int n, Object object) {
            if ((n & 1) != 0) {
                uUID = sendSchemRequest.uuid;
            }
            return sendSchemRequest.copy(uUID);
        }

        @NotNull
        public String toString() {
            return "SendSchemRequest(uuid=" + this.uuid + ")";
        }

        public int hashCode() {
            return this.uuid.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SendSchemRequest)) {
                return false;
            }
            SendSchemRequest sendSchemRequest = (SendSchemRequest)other;
            return Intrinsics.areEqual((Object)this.uuid, (Object)sendSchemRequest.uuid);
        }

        @Override
        @JsonIgnore
        @ApiStatus.NonExtendable
        @NotNull
        public FriendlyByteBuf serialize() {
            return AutoSerializable.DefaultImpls.serialize(this);
        }

        @Override
        @JsonIgnore
        @ApiStatus.NonExtendable
        public void deserialize(@NotNull FriendlyByteBuf buf) {
            AutoSerializable.DefaultImpls.deserialize(this, buf);
        }

        @Override
        @JsonIgnore
        @NotNull
        public FriendlyByteBuf getBuffer() {
            return AutoSerializable.DefaultImpls.getBuffer(this);
        }

        @Override
        @JsonIgnore
        @Nullable
        public ReflectableObject getReflectObjectOverride() {
            return AutoSerializable.DefaultImpls.getReflectObjectOverride(this);
        }

        @Override
        @JsonIgnore
        @ApiStatus.NonExtendable
        @NotNull
        public List<ReflectableItemDelegate<?>> getAllReflectableItems(boolean processSubReflectables, @NotNull Function1<? super ReflectableItemDelegate<?>, Boolean> filterBy) {
            return AutoSerializable.DefaultImpls.getAllReflectableItems(this, processSubReflectables, filterBy);
        }

        @Override
        @JsonIgnore
        @ApiStatus.NonExtendable
        @NotNull
        public List<ReflectableItemDelegate<?>> getReflectableItemsWithoutDataclassConstructorItems(boolean processSubReflectables, @NotNull Function1<? super ReflectableItemDelegate<?>, Boolean> filterBy) {
            return AutoSerializable.DefaultImpls.getReflectableItemsWithoutDataclassConstructorItems(this, processSubReflectables, filterBy);
        }
    }
}

