/*
 * Decompiled with CFR 0.152.
 */
package net.spaceeye.vmod.vEntityManaging.extensions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.spaceeye.vmod.VMKt;
import net.spaceeye.vmod.reflectable.ReflectableObject;
import net.spaceeye.vmod.reflectable.TagAutoSerializableKt;
import net.spaceeye.vmod.rendering.RenderingData;
import net.spaceeye.vmod.rendering.RenderingTypes;
import net.spaceeye.vmod.rendering.types.BaseRenderer;
import net.spaceeye.vmod.utils.Vector3d;
import net.spaceeye.vmod.vEntityManaging.util.ExtendableVEntity;
import net.spaceeye.vmod.vEntityManaging.util.VEntityExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.valkyrienskies.core.api.ships.Ship;
import org.valkyrienskies.mod.common.VSGameUtilsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003B\u0011\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0002\u0010\u0006J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0011\u001a\u00020\u0012H\u0016JX\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u001b2\u001a\u0010\u001c\u001a\u0016\u0012\b\u0012\u00060\u001ej\u0002`\u001f\u0012\b\u0012\u00060\u001ej\u0002`\u001f0\u001d2\"\u0010 \u001a\u001e\u0012\b\u0012\u00060\u001ej\u0002`\u001f\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020\"0!0\u001d2\u0006\u0010#\u001a\u00020\u0012H\u0016J \u0010$\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\"H\u0016J\n\u0010(\u001a\u0004\u0018\u00010)H\u0016J(\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020)2\u0016\u0010-\u001a\u0012\u0012\b\u0012\u00060\u001ej\u0002`\u001f\u0012\u0004\u0012\u00020.0\u001dH\u0016J\u0010\u0010/\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u00100\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u001bH\u0016R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\u0006R$\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\u0012X\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016\u00a8\u00061"}, d2={"Lnet/spaceeye/vmod/vEntityManaging/extensions/RenderableExtension;", "Lnet/spaceeye/vmod/vEntityManaging/util/VEntityExtension;", "<init>", "()V", "renderer", "Lnet/spaceeye/vmod/rendering/types/BaseRenderer;", "(Lnet/spaceeye/vmod/rendering/types/BaseRenderer;)V", "getRenderer", "()Lnet/spaceeye/vmod/rendering/types/BaseRenderer;", "setRenderer", "value", "", "rID", "getRID", "()I", "setRID", "(I)V", "obj", "Lnet/spaceeye/vmod/vEntityManaging/util/ExtendableVEntity;", "getObj", "()Lnet/spaceeye/vmod/vEntityManaging/util/ExtendableVEntity;", "setObj", "(Lnet/spaceeye/vmod/vEntityManaging/util/ExtendableVEntity;)V", "onInit", "", "onAfterCopyVEntity", "level", "Lnet/minecraft/server/level/ServerLevel;", "mapped", "", "", "Lorg/valkyrienskies/core/api/ships/properties/ShipId;", "centerPositions", "Lkotlin/Pair;", "Lnet/spaceeye/vmod/utils/Vector3d;", "new", "onBeforeOnScaleByVEntity", "scaleBy", "", "scalingCenter", "onSerialize", "Lnet/minecraft/nbt/CompoundTag;", "onDeserialize", "", "tag", "lastDimensionIds", "", "onMakeVEntity", "onDeleteVEntity", "VMod"})
@SourceDebugExtension(value={"SMAP\nRenderableExtension.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RenderableExtension.kt\nnet/spaceeye/vmod/vEntityManaging/extensions/RenderableExtension\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,74:1\n125#2:75\n152#2,3:76\n*S KotlinDebug\n*F\n+ 1 RenderableExtension.kt\nnet/spaceeye/vmod/vEntityManaging/extensions/RenderableExtension\n*L\n34#1:75\n34#1:76,3\n*E\n"})
public class RenderableExtension
implements VEntityExtension {
    public BaseRenderer renderer;
    private int rID;
    protected ExtendableVEntity obj;

    public RenderableExtension() {
        this.rID = -1;
    }

    @NotNull
    public final BaseRenderer getRenderer() {
        BaseRenderer baseRenderer = this.renderer;
        if (baseRenderer != null) {
            return baseRenderer;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"renderer");
        return null;
    }

    public final void setRenderer(@NotNull BaseRenderer baseRenderer) {
        Intrinsics.checkNotNullParameter((Object)baseRenderer, (String)"<set-?>");
        this.renderer = baseRenderer;
    }

    public final int getRID() {
        return this.rID;
    }

    protected final void setRID(int n) {
        this.rID = n;
    }

    @NotNull
    protected final ExtendableVEntity getObj() {
        ExtendableVEntity extendableVEntity = this.obj;
        if (extendableVEntity != null) {
            return extendableVEntity;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"obj");
        return null;
    }

    protected final void setObj(@NotNull ExtendableVEntity extendableVEntity) {
        Intrinsics.checkNotNullParameter((Object)extendableVEntity, (String)"<set-?>");
        this.obj = extendableVEntity;
    }

    public RenderableExtension(@NotNull BaseRenderer renderer) {
        Intrinsics.checkNotNullParameter((Object)renderer, (String)"renderer");
        this();
        this.setRenderer(renderer);
    }

    @Override
    public void onInit(@NotNull ExtendableVEntity obj) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        this.setObj(obj);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onAfterCopyVEntity(@NotNull ServerLevel level, @NotNull Map<Long, Long> mapped, @NotNull Map<Long, Pair<Vector3d, Vector3d>> centerPositions, @NotNull ExtendableVEntity extendableVEntity) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter(mapped, (String)"mapped");
        Intrinsics.checkNotNullParameter(centerPositions, (String)"centerPositions");
        Intrinsics.checkNotNullParameter((Object)extendableVEntity, (String)"new");
        Map<Long, Long> map2 = mapped;
        BaseRenderer baseRenderer = this.getRenderer();
        boolean $i$f$map = false;
        void var8_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry item$iv$iv;
            Map.Entry entry2 = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            long k = ((Number)entry2.getKey()).longValue();
            long v = ((Number)entry2.getValue()).longValue();
            Long l = k;
            Ship ship = VSGameUtilsKt.getShipObjectWorld((ServerLevel)level).getAllShips().getById(v);
            Intrinsics.checkNotNull((Object)ship);
            collection.add(new Pair((Object)l, (Object)ship));
        }
        BaseRenderer baseRenderer2 = baseRenderer.copy(MapsKt.toMap((Iterable)((List)destination$iv$iv)), centerPositions);
        if (baseRenderer2 == null) {
            return;
        }
        BaseRenderer newRenderer = baseRenderer2;
        extendableVEntity.addExtension(new RenderableExtension(newRenderer));
    }

    @Override
    public void onBeforeOnScaleByVEntity(@NotNull ServerLevel level, double scaleBy, @NotNull Vector3d scalingCenter) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)scalingCenter, (String)"scalingCenter");
        this.getRenderer().scaleBy(scaleBy);
        RenderingData.INSTANCE.getServer().setUpdated(this.rID, this.getRenderer());
    }

    @Override
    @Nullable
    public CompoundTag onSerialize() {
        CompoundTag tag = new CompoundTag();
        try {
            tag.m_128359_("rendererType", RenderingTypes.getType(this.getRenderer()));
            BaseRenderer baseRenderer = this.getRenderer();
            Intrinsics.checkNotNull((Object)baseRenderer, (String)"null cannot be cast to non-null type net.spaceeye.vmod.reflectable.ReflectableObject");
            tag.m_128365_("renderer", (Tag)TagAutoSerializableKt.tSerialize$default((ReflectableObject)((Object)baseRenderer), null, 1, null));
        }
        catch (Exception e) {
            VMKt.ELOG("FAILED TO SERIALIZE RENDERER WITH EXCEPTION\n" + ExceptionsKt.stackTraceToString((Throwable)e));
            return null;
        }
        catch (Error e) {
            VMKt.ELOG("FAILED TO SERIALIZE RENDERER WITH ERROR\n" + ExceptionsKt.stackTraceToString((Throwable)e));
            return null;
        }
        return tag;
    }

    @Override
    public boolean onDeserialize(@NotNull CompoundTag tag, @NotNull Map<Long, String> lastDimensionIds) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter(lastDimensionIds, (String)"lastDimensionIds");
        if (!tag.m_128441_("renderer")) {
            return false;
        }
        try {
            String type = tag.m_128461_("rendererType");
            Intrinsics.checkNotNull((Object)type);
            this.setRenderer((BaseRenderer)RenderingTypes.INSTANCE.strTypeToSupplier(type).get());
            BaseRenderer baseRenderer = this.getRenderer();
            Intrinsics.checkNotNull((Object)baseRenderer, (String)"null cannot be cast to non-null type net.spaceeye.vmod.reflectable.ReflectableObject");
            ReflectableObject reflectableObject = (ReflectableObject)((Object)baseRenderer);
            CompoundTag compoundTag = tag.m_128469_("renderer");
            Intrinsics.checkNotNullExpressionValue((Object)compoundTag, (String)"getCompound(...)");
            TagAutoSerializableKt.tDeserialize(reflectableObject, compoundTag);
        }
        catch (Exception e) {
            VMKt.ELOG("FAILED TO DESERIALIZE RENDERER WITH EXCEPTION\n" + ExceptionsKt.stackTraceToString((Throwable)e));
            return false;
        }
        catch (Error e) {
            VMKt.ELOG("FAILED TO DESERIALIZE RENDERER WITH ERROR\n" + ExceptionsKt.stackTraceToString((Throwable)e));
            return false;
        }
        return true;
    }

    @Override
    public void onMakeVEntity(@NotNull ServerLevel level) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        List<Long> ids = this.getObj().attachedToShips(CollectionsKt.emptyList());
        RenderingData.INSTANCE.getServer().removeRenderer(this.rID);
        this.rID = RenderingData.INSTANCE.getServer().addRenderer(ids, this.getRenderer());
    }

    @Override
    public void onDeleteVEntity(@NotNull ServerLevel level) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        RenderingData.INSTANCE.getServer().removeRenderer(this.rID);
    }

    @Override
    public void onAfterMoveShipyardPositions(@NotNull ServerLevel level, @NotNull BlockPos previous, @NotNull BlockPos blockPos, long newShipId) {
        VEntityExtension.DefaultImpls.onAfterMoveShipyardPositions(this, level, previous, blockPos, newShipId);
    }

    @Override
    public void onBeforeCopyVEntity(@NotNull ServerLevel level, @NotNull Map<Long, Long> mapped, @NotNull Map<Long, Pair<Vector3d, Vector3d>> centerPositions) {
        VEntityExtension.DefaultImpls.onBeforeCopyVEntity(this, level, mapped, centerPositions);
    }
}

