/*
 * Decompiled with CFR 0.152.
 */
package net.spaceeye.vmod.vEntityManaging.types.entities;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KProperty;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.spaceeye.vmod.network.MessagingNetwork;
import net.spaceeye.vmod.network.Signal;
import net.spaceeye.vmod.reflectable.ReflectableItemDelegate;
import net.spaceeye.vmod.reflectable.ReflectableObject;
import net.spaceeye.vmod.utils.RaycastFunctions;
import net.spaceeye.vmod.utils.Vector3d;
import net.spaceeye.vmod.utils.vs.VSShipPosTransformsKt;
import net.spaceeye.vmod.vEntityManaging.Tickable;
import net.spaceeye.vmod.vEntityManaging.VEntity;
import net.spaceeye.vmod.vEntityManaging.util.ExtendableVEntity;
import net.spaceeye.vmod.vEntityManaging.util.VEAutoSerializable;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.valkyrienskies.core.api.ships.LoadedServerShip;
import org.valkyrienskies.core.api.ships.QueryableShipData;
import org.valkyrienskies.core.api.ships.ServerShip;
import org.valkyrienskies.core.api.ships.Ship;
import org.valkyrienskies.mod.common.VSGameUtilsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005BE\b\u0016\u0012\n\u0010\u0006\u001a\u00060\u0007j\u0002`\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\r\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\u0004\b\u0004\u0010\u0013J(\u00108\u001a\u00020\u000f2\f\u00109\u001a\b\u0012\u0004\u0012\u00020;0:2\u0010\u0010<\u001a\f\u0012\b\u0012\u00060\u0007j\u0002`\b0=H\u0016J$\u0010>\u001a\f\u0012\b\u0012\u00060\u0007j\u0002`\b0?2\u0010\u0010<\u001a\f\u0012\b\u0012\u00060\u0007j\u0002`\b0=H\u0016J\u001a\u0010@\u001a\b\u0012\u0004\u0012\u00020\n0A2\n\u0010B\u001a\u00060\u0007j\u0002`\bH\u0016J \u0010C\u001a\u00020D2\u0006\u0010E\u001a\u00020F2\u0006\u0010G\u001a\u00020\r2\u0006\u0010H\u001a\u00020\nH\u0016JR\u0010I\u001a\u0004\u0018\u00010J2\u0006\u0010E\u001a\u00020F2\u001a\u0010K\u001a\u0016\u0012\b\u0012\u00060\u0007j\u0002`\b\u0012\b\u0012\u00060\u0007j\u0002`\b0L2\"\u0010M\u001a\u001e\u0012\b\u0012\u00060\u0007j\u0002`\b\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0N0LH\u0016J\u0010\u0010O\u001a\u00020\u000f2\u0006\u0010E\u001a\u00020FH\u0016J\u0010\u0010P\u001a\u00020D2\u0006\u0010E\u001a\u00020FH\u0016J\u001e\u0010Q\u001a\u00020D2\u0006\u0010R\u001a\u00020S2\f\u0010T\u001a\b\u0012\u0004\u0012\u00020D0UH\u0016R\u0012\u0010\u0014\u001a\u00020\u00158\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R3\u0010\u0006\u001a\u00060\u0007j\u0002`\b2\n\u0010\u0016\u001a\u00060\u0007j\u0002`\b8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u001b\u0010\u001c\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR+\u0010\t\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\n8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b!\u0010\u001c\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R+\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\n8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b$\u0010\u001c\u001a\u0004\b\"\u0010\u001e\"\u0004\b#\u0010 R+\u0010%\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\r8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b*\u0010\u001c\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)R+\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00128F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b/\u0010\u001c\u001a\u0004\b+\u0010,\"\u0004\b-\u0010.R+\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u000f8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b4\u0010\u001c\u001a\u0004\b0\u00101\"\u0004\b2\u00103R+\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\r8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b7\u0010\u001c\u001a\u0004\b5\u0010'\"\u0004\b6\u0010)\u00a8\u0006V"}, d2={"Lnet/spaceeye/vmod/vEntityManaging/types/entities/SensorVEntity;", "Lnet/spaceeye/vmod/vEntityManaging/util/ExtendableVEntity;", "Lnet/spaceeye/vmod/vEntityManaging/Tickable;", "Lnet/spaceeye/vmod/vEntityManaging/util/VEAutoSerializable;", "<init>", "()V", "shipId", "", "Lorg/valkyrienskies/core/api/ships/properties/ShipId;", "pos", "Lnet/spaceeye/vmod/utils/Vector3d;", "lookDir", "distance", "", "ignoreSelf", "", "scale", "channel", "", "(JLnet/spaceeye/vmod/utils/Vector3d;Lnet/spaceeye/vmod/utils/Vector3d;DZDLjava/lang/String;)V", "i", "", "<set-?>", "getShipId", "()J", "setShipId", "(J)V", "shipId$delegate", "Lnet/spaceeye/vmod/reflectable/ReflectableItemDelegate;", "getPos", "()Lnet/spaceeye/vmod/utils/Vector3d;", "setPos", "(Lnet/spaceeye/vmod/utils/Vector3d;)V", "pos$delegate", "getLookDir", "setLookDir", "lookDir$delegate", "maxDistance", "getMaxDistance", "()D", "setMaxDistance", "(D)V", "maxDistance$delegate", "getChannel", "()Ljava/lang/String;", "setChannel", "(Ljava/lang/String;)V", "channel$delegate", "getIgnoreSelf", "()Z", "setIgnoreSelf", "(Z)V", "ignoreSelf$delegate", "getScale", "setScale", "scale$delegate", "iStillExists", "allShips", "Lorg/valkyrienskies/core/api/ships/QueryableShipData;", "Lorg/valkyrienskies/core/api/ships/Ship;", "dimensionIds", "", "iAttachedToShips", "", "iGetAttachmentPoints", "", "qshipId", "iOnScaleBy", "", "level", "Lnet/minecraft/server/level/ServerLevel;", "scaleBy", "scalingCenter", "iCopyVEntity", "Lnet/spaceeye/vmod/vEntityManaging/VEntity;", "mapped", "", "centerPositions", "Lkotlin/Pair;", "iOnMakeVEntity", "iOnDeleteVEntity", "tick", "server", "Lnet/minecraft/server/MinecraftServer;", "unregister", "Lkotlin/Function0;", "VMod"})
public final class SensorVEntity
extends ExtendableVEntity
implements Tickable,
VEAutoSerializable {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @JsonIgnore
    private int i;
    @NotNull
    private final ReflectableItemDelegate shipId$delegate;
    @NotNull
    private final ReflectableItemDelegate pos$delegate;
    @NotNull
    private final ReflectableItemDelegate lookDir$delegate;
    @NotNull
    private final ReflectableItemDelegate maxDistance$delegate;
    @NotNull
    private final ReflectableItemDelegate channel$delegate;
    @NotNull
    private final ReflectableItemDelegate ignoreSelf$delegate;
    @NotNull
    private final ReflectableItemDelegate scale$delegate;

    public SensorVEntity() {
        int n = this.i;
        this.i = n + 1;
        this.shipId$delegate = this.get(n, -1L).provideDelegate(this, $$delegatedProperties[0]);
        n = this.i;
        this.i = n + 1;
        this.pos$delegate = this.get(n, new Vector3d()).provideDelegate(this, $$delegatedProperties[1]);
        n = this.i;
        this.i = n + 1;
        this.lookDir$delegate = this.get(n, new Vector3d()).provideDelegate(this, $$delegatedProperties[2]);
        n = this.i;
        this.i = n + 1;
        this.maxDistance$delegate = this.get(n, 10.0).provideDelegate(this, $$delegatedProperties[3]);
        n = this.i;
        this.i = n + 1;
        this.channel$delegate = this.get(n, "").provideDelegate(this, $$delegatedProperties[4]);
        n = this.i;
        this.i = n + 1;
        this.ignoreSelf$delegate = this.get(n, false).provideDelegate(this, $$delegatedProperties[5]);
        n = this.i;
        this.i = n + 1;
        this.scale$delegate = this.get(n, 1.0).provideDelegate(this, $$delegatedProperties[6]);
    }

    public final long getShipId() {
        return ((Number)this.shipId$delegate.getValue(this, $$delegatedProperties[0])).longValue();
    }

    public final void setShipId(long l) {
        this.shipId$delegate.setValue(this, $$delegatedProperties[0], l);
    }

    @NotNull
    public final Vector3d getPos() {
        return (Vector3d)this.pos$delegate.getValue(this, $$delegatedProperties[1]);
    }

    public final void setPos(@NotNull Vector3d vector3d) {
        Intrinsics.checkNotNullParameter((Object)vector3d, (String)"<set-?>");
        this.pos$delegate.setValue(this, $$delegatedProperties[1], vector3d);
    }

    @NotNull
    public final Vector3d getLookDir() {
        return (Vector3d)this.lookDir$delegate.getValue(this, $$delegatedProperties[2]);
    }

    public final void setLookDir(@NotNull Vector3d vector3d) {
        Intrinsics.checkNotNullParameter((Object)vector3d, (String)"<set-?>");
        this.lookDir$delegate.setValue(this, $$delegatedProperties[2], vector3d);
    }

    public final double getMaxDistance() {
        return ((Number)this.maxDistance$delegate.getValue(this, $$delegatedProperties[3])).doubleValue();
    }

    public final void setMaxDistance(double d) {
        this.maxDistance$delegate.setValue(this, $$delegatedProperties[3], d);
    }

    @NotNull
    public final String getChannel() {
        return (String)this.channel$delegate.getValue(this, $$delegatedProperties[4]);
    }

    public final void setChannel(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.channel$delegate.setValue(this, $$delegatedProperties[4], string);
    }

    public final boolean getIgnoreSelf() {
        return (Boolean)this.ignoreSelf$delegate.getValue(this, $$delegatedProperties[5]);
    }

    public final void setIgnoreSelf(boolean bl) {
        this.ignoreSelf$delegate.setValue(this, $$delegatedProperties[5], bl);
    }

    public final double getScale() {
        return ((Number)this.scale$delegate.getValue(this, $$delegatedProperties[6])).doubleValue();
    }

    public final void setScale(double d) {
        this.scale$delegate.setValue(this, $$delegatedProperties[6], d);
    }

    public SensorVEntity(long shipId, @NotNull Vector3d pos, @NotNull Vector3d lookDir, double distance, boolean ignoreSelf, double scale, @NotNull String channel) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)lookDir, (String)"lookDir");
        Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
        this();
        this.setShipId(shipId);
        this.setPos(pos);
        this.setChannel(channel);
        this.setLookDir(lookDir);
        this.setMaxDistance(distance);
        this.setIgnoreSelf(ignoreSelf);
        this.setScale(scale);
    }

    @Override
    public boolean iStillExists(@NotNull QueryableShipData<? extends Ship> allShips, @NotNull Collection<Long> dimensionIds) {
        Intrinsics.checkNotNullParameter(allShips, (String)"allShips");
        Intrinsics.checkNotNullParameter(dimensionIds, (String)"dimensionIds");
        return allShips.contains(this.getShipId());
    }

    @Override
    @NotNull
    public List<Long> iAttachedToShips(@NotNull Collection<Long> dimensionIds) {
        Intrinsics.checkNotNullParameter(dimensionIds, (String)"dimensionIds");
        Object[] objectArray = new Long[]{this.getShipId()};
        return CollectionsKt.mutableListOf((Object[])objectArray);
    }

    @Override
    @NotNull
    public List<Vector3d> iGetAttachmentPoints(long qshipId) {
        return this.getShipId() == qshipId || qshipId == -1L ? CollectionsKt.listOf((Object)new Vector3d(this.getPos())) : CollectionsKt.emptyList();
    }

    @Override
    public void iOnScaleBy(@NotNull ServerLevel level, double scaleBy, @NotNull Vector3d scalingCenter) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)scalingCenter, (String)"scalingCenter");
        this.setMaxDistance(this.getMaxDistance() * scaleBy);
    }

    @Override
    @Nullable
    public VEntity iCopyVEntity(@NotNull ServerLevel level, @NotNull Map<Long, Long> mapped, @NotNull Map<Long, Pair<Vector3d, Vector3d>> centerPositions) {
        ServerShip serverShip;
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter(mapped, (String)"mapped");
        Intrinsics.checkNotNullParameter(centerPositions, (String)"centerPositions");
        Long l = mapped.get(this.getShipId());
        if (l == null) {
            return null;
        }
        long nId = l;
        Pair<Vector3d, Vector3d> pair = centerPositions.get(this.getShipId());
        if (pair == null) {
            return null;
        }
        Pair<Vector3d, Vector3d> pair2 = pair;
        Vector3d oldCenter = (Vector3d)pair2.component1();
        Vector3d newCenter = (Vector3d)pair2.component2();
        LoadedServerShip loadedServerShip = (LoadedServerShip)VSGameUtilsKt.getShipObjectWorld((ServerLevel)level).getLoadedShips().getById(nId);
        if (loadedServerShip != null) {
            serverShip = (ServerShip)loadedServerShip;
        } else {
            serverShip = (ServerShip)VSGameUtilsKt.getShipObjectWorld((ServerLevel)level).getAllShips().getById(nId);
            if (serverShip == null) {
                return null;
            }
        }
        ServerShip nShip = serverShip;
        Vector3d nPos = this.getPos().minus(oldCenter).plus(newCenter);
        return new SensorVEntity(nShip.getId(), nPos, this.getLookDir(), this.getMaxDistance(), this.getIgnoreSelf(), this.getScale(), this.getChannel());
    }

    @Override
    public boolean iOnMakeVEntity(@NotNull ServerLevel level) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        return (LoadedServerShip)VSGameUtilsKt.getShipObjectWorld((ServerLevel)level).getLoadedShips().getById(this.getShipId()) != null;
    }

    @Override
    public void iOnDeleteVEntity(@NotNull ServerLevel level) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
    }

    @Override
    public void tick(@NotNull MinecraftServer server, @NotNull Function0<Unit> unregister) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        Intrinsics.checkNotNullParameter(unregister, (String)"unregister");
        ServerShip serverShip = (ServerShip)VSGameUtilsKt.getShipObjectWorld((MinecraftServer)server).getAllShips().getById(this.getShipId());
        if (serverShip == null) {
            return;
        }
        ServerShip ship = serverShip;
        ship.getChunkClaimDimension();
        ServerLevel serverLevel = null;
        for (ServerLevel level : server.m_129785_()) {
            Intrinsics.checkNotNull((Object)level);
            if (!Intrinsics.areEqual((Object)VSGameUtilsKt.getDimensionId((Level)((Level)level)), (Object)ship.getChunkClaimDimension())) continue;
            serverLevel = level;
            break;
        }
        if (serverLevel == null) {
            return;
        }
        RaycastFunctions.RaycastResult result = RaycastFunctions.raycast$default(RaycastFunctions.INSTANCE, (Level)serverLevel, new RaycastFunctions.Source(VSShipPosTransformsKt.transformDirectionShipToWorld((Ship)ship, this.getLookDir()), VSShipPosTransformsKt.posShipToWorld$default((Ship)ship, this.getPos().plus(this.getLookDir().times(0.5).times(this.getScale())), null, 4, null)), this.getMaxDistance(), this.getIgnoreSelf() ? Long.valueOf(ship.getId()) : null, null, null, null, null, 240, null);
        Vector3d vector3d = result.getOrigin();
        Vector3d vector3d2 = result.getWorldHitPos();
        if (vector3d2 == null) {
            vector3d2 = result.getOrigin().plus(result.getLookVec().times(this.getMaxDistance()));
        }
        double distance = vector3d.minus(vector3d2).dist();
        MessagingNetwork.INSTANCE.notify(this.getChannel(), new Signal(Math.min(distance / this.getMaxDistance(), 1.0)));
    }

    @Override
    @Nullable
    public CompoundTag iNbtSerialize() {
        return VEAutoSerializable.DefaultImpls.iNbtSerialize(this);
    }

    @Override
    @Nullable
    public VEntity iNbtDeserialize(@NotNull CompoundTag tag, @NotNull Map<Long, String> lastDimensionIds) {
        return VEAutoSerializable.DefaultImpls.iNbtDeserialize(this, tag, lastDimensionIds);
    }

    @Override
    @NotNull
    public <T> ReflectableItemDelegate<T> get(int pos, @NotNull T t) {
        return VEAutoSerializable.DefaultImpls.get(this, pos, t);
    }

    @Override
    @JsonIgnore
    @ApiStatus.NonExtendable
    @NotNull
    public CompoundTag tSerialize() {
        return VEAutoSerializable.DefaultImpls.tSerialize(this);
    }

    @Override
    @JsonIgnore
    @ApiStatus.NonExtendable
    public void tDeserialize(@NotNull CompoundTag tag) {
        VEAutoSerializable.DefaultImpls.tDeserialize(this, tag);
    }

    @Override
    @JsonIgnore
    @NotNull
    public CompoundTag tGetBuffer() {
        return VEAutoSerializable.DefaultImpls.tGetBuffer(this);
    }

    @Override
    @JsonIgnore
    @Nullable
    public ReflectableObject getReflectObjectOverride() {
        return VEAutoSerializable.DefaultImpls.getReflectObjectOverride(this);
    }

    @Override
    @JsonIgnore
    @ApiStatus.NonExtendable
    @NotNull
    public List<ReflectableItemDelegate<?>> getAllReflectableItems(boolean processSubReflectables, @NotNull Function1<? super ReflectableItemDelegate<?>, Boolean> filterBy) {
        return VEAutoSerializable.DefaultImpls.getAllReflectableItems(this, processSubReflectables, filterBy);
    }

    @Override
    @JsonIgnore
    @ApiStatus.NonExtendable
    @NotNull
    public List<ReflectableItemDelegate<?>> getReflectableItemsWithoutDataclassConstructorItems(boolean processSubReflectables, @NotNull Function1<? super ReflectableItemDelegate<?>, Boolean> filterBy) {
        return VEAutoSerializable.DefaultImpls.getReflectableItemsWithoutDataclassConstructorItems(this, processSubReflectables, filterBy);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(SensorVEntity.class, "shipId", "getShipId()J", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(SensorVEntity.class, "pos", "getPos()Lnet/spaceeye/vmod/utils/Vector3d;", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(SensorVEntity.class, "lookDir", "getLookDir()Lnet/spaceeye/vmod/utils/Vector3d;", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(SensorVEntity.class, "maxDistance", "getMaxDistance()D", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(SensorVEntity.class, "channel", "getChannel()Ljava/lang/String;", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(SensorVEntity.class, "ignoreSelf", "getIgnoreSelf()Z", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(SensorVEntity.class, "scale", "getScale()D", 0)))};
        $$delegatedProperties = kPropertyArray;
    }
}

