/*
 * Decompiled with CFR 0.152.
 */
package net.spaceeye.vmod.vEntityManaging.types.entities;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.spaceeye.vmod.VMConfig;
import net.spaceeye.vmod.reflectable.ReflectableItemDelegate;
import net.spaceeye.vmod.reflectable.ReflectableObject;
import net.spaceeye.vmod.shipAttachments.ThrusterData;
import net.spaceeye.vmod.shipAttachments.ThrustersController;
import net.spaceeye.vmod.utils.Vector3d;
import net.spaceeye.vmod.vEntityManaging.Tickable;
import net.spaceeye.vmod.vEntityManaging.VEntity;
import net.spaceeye.vmod.vEntityManaging.util.ExtendableVEntity;
import net.spaceeye.vmod.vEntityManaging.util.TickableVEntityExtension;
import net.spaceeye.vmod.vEntityManaging.util.VEAutoSerializable;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.valkyrienskies.core.api.ships.LoadedServerShip;
import org.valkyrienskies.core.api.ships.QueryableShipData;
import org.valkyrienskies.core.api.ships.ServerShip;
import org.valkyrienskies.core.api.ships.Ship;
import org.valkyrienskies.mod.common.VSGameUtilsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0096\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b#\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005B5\b\u0016\u0012\n\u0010\u0006\u001a\u00060\u0007j\u0002`\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0004\u0010\u0010J(\u00105\u001a\u0002062\f\u00107\u001a\b\u0012\u0004\u0012\u000209082\u0010\u0010:\u001a\f\u0012\b\u0012\u00060\u0007j\u0002`\b0;H\u0016J$\u0010<\u001a\f\u0012\b\u0012\u00060\u0007j\u0002`\b0=2\u0010\u0010:\u001a\f\u0012\b\u0012\u00060\u0007j\u0002`\b0;H\u0016J\u001a\u0010>\u001a\b\u0012\u0004\u0012\u00020\n0?2\n\u0010@\u001a\u00060\u0007j\u0002`\bH\u0016J \u0010A\u001a\u00020B2\u0006\u0010C\u001a\u00020D2\u0006\u0010E\u001a\u00020\r2\u0006\u0010F\u001a\u00020\nH\u0016JR\u0010G\u001a\u0004\u0018\u00010H2\u0006\u0010C\u001a\u00020D2\u001a\u0010I\u001a\u0016\u0012\b\u0012\u00060\u0007j\u0002`\b\u0012\b\u0012\u00060\u0007j\u0002`\b0J2\"\u0010K\u001a\u001e\u0012\b\u0012\u00060\u0007j\u0002`\b\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0L0JH\u0016J\u0010\u0010M\u001a\u0002062\u0006\u0010C\u001a\u00020DH\u0016J\u0010\u0010N\u001a\u00020B2\u0006\u0010C\u001a\u00020DH\u0016J\n\u0010O\u001a\u0004\u0018\u00010PH\u0016J*\u0010Q\u001a\u0004\u0018\u00010H2\u0006\u0010R\u001a\u00020P2\u0016\u0010S\u001a\u0012\u0012\b\u0012\u00060\u0007j\u0002`\b\u0012\u0004\u0012\u00020\u000f0JH\u0016J\u001e\u0010V\u001a\u00020B2\u0006\u0010W\u001a\u00020X2\f\u0010Y\u001a\b\u0012\u0004\u0012\u00020B0ZH\u0016R\u0012\u0010\u0011\u001a\u00020\u00128\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R3\u0010\u0006\u001a\u00060\u0007j\u0002`\b2\n\u0010\u0013\u001a\u00060\u0007j\u0002`\b8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0018\u0010\u0019\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R+\u0010\t\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\n8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u001e\u0010\u0019\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR+\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\n8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b!\u0010\u0019\u001a\u0004\b\u001f\u0010\u001b\"\u0004\b \u0010\u001dR+\u0010\f\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\r8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b&\u0010\u0019\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R+\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u000f8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b+\u0010\u0019\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*R+\u0010,\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00128F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b1\u0010\u0019\u001a\u0004\b-\u0010.\"\u0004\b/\u00100R\u001a\u00102\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b3\u0010#\"\u0004\b4\u0010%R\u000e\u0010T\u001a\u000206X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010U\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006["}, d2={"Lnet/spaceeye/vmod/vEntityManaging/types/entities/ThrusterVEntity;", "Lnet/spaceeye/vmod/vEntityManaging/util/ExtendableVEntity;", "Lnet/spaceeye/vmod/vEntityManaging/Tickable;", "Lnet/spaceeye/vmod/vEntityManaging/util/VEAutoSerializable;", "<init>", "()V", "shipId", "", "Lorg/valkyrienskies/core/api/ships/properties/ShipId;", "pos", "Lnet/spaceeye/vmod/utils/Vector3d;", "forceDir", "force", "", "channel", "", "(JLnet/spaceeye/vmod/utils/Vector3d;Lnet/spaceeye/vmod/utils/Vector3d;DLjava/lang/String;)V", "i", "", "<set-?>", "getShipId", "()J", "setShipId", "(J)V", "shipId$delegate", "Lnet/spaceeye/vmod/reflectable/ReflectableItemDelegate;", "getPos", "()Lnet/spaceeye/vmod/utils/Vector3d;", "setPos", "(Lnet/spaceeye/vmod/utils/Vector3d;)V", "pos$delegate", "getForceDir", "setForceDir", "forceDir$delegate", "getForce", "()D", "setForce", "(D)V", "force$delegate", "getChannel", "()Ljava/lang/String;", "setChannel", "(Ljava/lang/String;)V", "channel$delegate", "thrusterId", "getThrusterId", "()I", "setThrusterId", "(I)V", "thrusterId$delegate", "percentage", "getPercentage", "setPercentage", "iStillExists", "", "allShips", "Lorg/valkyrienskies/core/api/ships/QueryableShipData;", "Lorg/valkyrienskies/core/api/ships/Ship;", "dimensionIds", "", "iAttachedToShips", "", "iGetAttachmentPoints", "", "qshipId", "iOnScaleBy", "", "level", "Lnet/minecraft/server/level/ServerLevel;", "scaleBy", "scalingCenter", "iCopyVEntity", "Lnet/spaceeye/vmod/vEntityManaging/VEntity;", "mapped", "", "centerPositions", "Lkotlin/Pair;", "iOnMakeVEntity", "iOnDeleteVEntity", "iNbtSerialize", "Lnet/minecraft/nbt/CompoundTag;", "iNbtDeserialize", "tag", "lastDimensionIds", "wasRemoved", "lastPercentage", "tick", "server", "Lnet/minecraft/server/MinecraftServer;", "unregister", "Lkotlin/Function0;", "VMod"})
@SourceDebugExtension(value={"SMAP\nThrusterVEntity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ThrusterVEntity.kt\nnet/spaceeye/vmod/vEntityManaging/types/entities/ThrusterVEntity\n+ 2 ExtendableVEntity.kt\nnet/spaceeye/vmod/vEntityManaging/util/ExtendableVEntity\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,109:1\n56#2:110\n800#3,11:111\n1855#3,2:122\n*S KotlinDebug\n*F\n+ 1 ThrusterVEntity.kt\nnet/spaceeye/vmod/vEntityManaging/types/entities/ThrusterVEntity\n*L\n100#1:110\n100#1:111,11\n100#1:122,2\n*E\n"})
public final class ThrusterVEntity
extends ExtendableVEntity
implements Tickable,
VEAutoSerializable {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @JsonIgnore
    private int i;
    @NotNull
    private final ReflectableItemDelegate shipId$delegate;
    @NotNull
    private final ReflectableItemDelegate pos$delegate;
    @NotNull
    private final ReflectableItemDelegate forceDir$delegate;
    @NotNull
    private final ReflectableItemDelegate force$delegate;
    @NotNull
    private final ReflectableItemDelegate channel$delegate;
    @NotNull
    private final ReflectableItemDelegate thrusterId$delegate;
    private double percentage;
    private boolean wasRemoved;
    private double lastPercentage;

    public ThrusterVEntity() {
        int n = this.i;
        this.i = n + 1;
        this.shipId$delegate = this.get(n, -1L).provideDelegate(this, $$delegatedProperties[0]);
        n = this.i;
        this.i = n + 1;
        this.pos$delegate = this.get(n, new Vector3d()).provideDelegate(this, $$delegatedProperties[1]);
        n = this.i;
        this.i = n + 1;
        this.forceDir$delegate = this.get(n, new Vector3d()).provideDelegate(this, $$delegatedProperties[2]);
        n = this.i;
        this.i = n + 1;
        this.force$delegate = this.get(n, 1.0).provideDelegate(this, $$delegatedProperties[3]);
        n = this.i;
        this.i = n + 1;
        this.channel$delegate = this.get(n, "").provideDelegate(this, $$delegatedProperties[4]);
        n = this.i;
        this.i = n + 1;
        this.thrusterId$delegate = this.get(n, -1).provideDelegate(this, $$delegatedProperties[5]);
        this.lastPercentage = this.percentage;
    }

    public final long getShipId() {
        return ((Number)this.shipId$delegate.getValue(this, $$delegatedProperties[0])).longValue();
    }

    public final void setShipId(long l) {
        this.shipId$delegate.setValue(this, $$delegatedProperties[0], l);
    }

    @NotNull
    public final Vector3d getPos() {
        return (Vector3d)this.pos$delegate.getValue(this, $$delegatedProperties[1]);
    }

    public final void setPos(@NotNull Vector3d vector3d) {
        Intrinsics.checkNotNullParameter((Object)vector3d, (String)"<set-?>");
        this.pos$delegate.setValue(this, $$delegatedProperties[1], vector3d);
    }

    @NotNull
    public final Vector3d getForceDir() {
        return (Vector3d)this.forceDir$delegate.getValue(this, $$delegatedProperties[2]);
    }

    public final void setForceDir(@NotNull Vector3d vector3d) {
        Intrinsics.checkNotNullParameter((Object)vector3d, (String)"<set-?>");
        this.forceDir$delegate.setValue(this, $$delegatedProperties[2], vector3d);
    }

    public final double getForce() {
        return ((Number)this.force$delegate.getValue(this, $$delegatedProperties[3])).doubleValue();
    }

    public final void setForce(double d) {
        this.force$delegate.setValue(this, $$delegatedProperties[3], d);
    }

    @NotNull
    public final String getChannel() {
        return (String)this.channel$delegate.getValue(this, $$delegatedProperties[4]);
    }

    public final void setChannel(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.channel$delegate.setValue(this, $$delegatedProperties[4], string);
    }

    public final int getThrusterId() {
        return ((Number)this.thrusterId$delegate.getValue(this, $$delegatedProperties[5])).intValue();
    }

    public final void setThrusterId(int n) {
        this.thrusterId$delegate.setValue(this, $$delegatedProperties[5], n);
    }

    public final double getPercentage() {
        return this.percentage;
    }

    public final void setPercentage(double d) {
        this.percentage = d;
    }

    public ThrusterVEntity(long shipId, @NotNull Vector3d pos, @NotNull Vector3d forceDir, double force, @NotNull String channel) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)forceDir, (String)"forceDir");
        Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
        this();
        this.setShipId(shipId);
        this.setPos(pos);
        this.setForceDir(forceDir);
        this.setForce(force);
        this.setChannel(channel);
    }

    @Override
    public boolean iStillExists(@NotNull QueryableShipData<? extends Ship> allShips, @NotNull Collection<Long> dimensionIds) {
        Intrinsics.checkNotNullParameter(allShips, (String)"allShips");
        Intrinsics.checkNotNullParameter(dimensionIds, (String)"dimensionIds");
        return allShips.contains(this.getShipId());
    }

    @Override
    @NotNull
    public List<Long> iAttachedToShips(@NotNull Collection<Long> dimensionIds) {
        Intrinsics.checkNotNullParameter(dimensionIds, (String)"dimensionIds");
        Object[] objectArray = new Long[]{this.getShipId()};
        return CollectionsKt.mutableListOf((Object[])objectArray);
    }

    @Override
    @NotNull
    public List<Vector3d> iGetAttachmentPoints(long qshipId) {
        return this.getShipId() == qshipId || qshipId == -1L ? CollectionsKt.listOf((Object)new Vector3d(this.getPos())) : CollectionsKt.emptyList();
    }

    @Override
    public void iOnScaleBy(@NotNull ServerLevel level, double scaleBy, @NotNull Vector3d scalingCenter) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)scalingCenter, (String)"scalingCenter");
        if (!VMConfig.INSTANCE.getSERVER().getSCALE_THRUSTERS_THRUST()) {
            return;
        }
        Ship ship = VSGameUtilsKt.getShipObjectWorld((ServerLevel)level).getLoadedShips().getById(this.getShipId());
        Intrinsics.checkNotNull((Object)ship);
        LoadedServerShip ship2 = (LoadedServerShip)ship;
        ThrustersController controller = ThrustersController.Companion.getOrCreate(ship2);
        ThrusterData thrusterData = controller.getThruster(this.getThrusterId());
        Intrinsics.checkNotNull((Object)thrusterData);
        ThrusterData thruster = thrusterData;
        controller.updateThruster(this.getThrusterId(), ThrusterData.copy$default(thruster, 0, null, null, thruster.getForce() * scaleBy * scaleBy * scaleBy, 0.0, null, 55, null));
    }

    @Override
    @Nullable
    public VEntity iCopyVEntity(@NotNull ServerLevel level, @NotNull Map<Long, Long> mapped, @NotNull Map<Long, Pair<Vector3d, Vector3d>> centerPositions) {
        ServerShip serverShip;
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter(mapped, (String)"mapped");
        Intrinsics.checkNotNullParameter(centerPositions, (String)"centerPositions");
        Long l = mapped.get(this.getShipId());
        if (l == null) {
            return null;
        }
        long nId = l;
        Pair<Vector3d, Vector3d> pair = centerPositions.get(this.getShipId());
        if (pair == null) {
            return null;
        }
        Pair<Vector3d, Vector3d> pair2 = pair;
        Vector3d oldCenter = (Vector3d)pair2.component1();
        Vector3d newCenter = (Vector3d)pair2.component2();
        LoadedServerShip loadedServerShip = (LoadedServerShip)VSGameUtilsKt.getShipObjectWorld((ServerLevel)level).getLoadedShips().getById(nId);
        if (loadedServerShip != null) {
            serverShip = (ServerShip)loadedServerShip;
        } else {
            serverShip = (ServerShip)VSGameUtilsKt.getShipObjectWorld((ServerLevel)level).getAllShips().getById(nId);
            if (serverShip == null) {
                return null;
            }
        }
        ServerShip nShip = serverShip;
        Vector3d nPos = this.getPos().minus(oldCenter).plus(newCenter);
        return new ThrusterVEntity(nShip.getId(), nPos, new Vector3d(this.getForceDir()), this.getForce(), this.getChannel());
    }

    @Override
    public boolean iOnMakeVEntity(@NotNull ServerLevel level) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        LoadedServerShip loadedServerShip = (LoadedServerShip)VSGameUtilsKt.getShipObjectWorld((ServerLevel)level).getLoadedShips().getById(this.getShipId());
        if (loadedServerShip == null) {
            return false;
        }
        LoadedServerShip ship = loadedServerShip;
        ThrustersController controller = ThrustersController.Companion.getOrCreate(ship);
        this.setThrusterId(controller.newThruster(this.getPos(), this.getForceDir(), this.getForce()));
        return true;
    }

    @Override
    public void iOnDeleteVEntity(@NotNull ServerLevel level) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        this.wasRemoved = true;
        LoadedServerShip loadedServerShip = (LoadedServerShip)VSGameUtilsKt.getShipObjectWorld((ServerLevel)level).getLoadedShips().getById(this.getShipId());
        if (loadedServerShip == null) {
            return;
        }
        LoadedServerShip ship = loadedServerShip;
        ThrustersController controller = ThrustersController.Companion.getOrCreate(ship);
        controller.removeThruster(this.getThrusterId());
    }

    @Override
    @Nullable
    public CompoundTag iNbtSerialize() {
        CompoundTag tag;
        block0: {
            CompoundTag compoundTag = tag = VEAutoSerializable.DefaultImpls.iNbtSerialize(this);
            if (compoundTag == null) break block0;
            compoundTag.m_128347_("percentage", this.percentage);
        }
        return tag;
    }

    @Override
    @Nullable
    public VEntity iNbtDeserialize(@NotNull CompoundTag tag, @NotNull Map<Long, String> lastDimensionIds) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter(lastDimensionIds, (String)"lastDimensionIds");
        this.percentage = tag.m_128459_("percentage");
        return VEAutoSerializable.DefaultImpls.iNbtDeserialize(this, tag, lastDimensionIds);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void tick(@NotNull MinecraftServer server, @NotNull Function0<Unit> unregister) {
        void $this$filterIsInstanceTo$iv$iv$iv;
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        Intrinsics.checkNotNullParameter(unregister, (String)"unregister");
        if (this.wasRemoved) {
            unregister.invoke();
            return;
        }
        ExtendableVEntity this_$iv = this;
        boolean $i$f$getExtensionsOfType = false;
        Iterable $this$filterIsInstance$iv$iv = this_$iv.getExtensions();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv$iv;
        Collection destination$iv$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv$iv : $this$filterIsInstanceTo$iv$iv$iv) {
            if (!(element$iv$iv$iv instanceof TickableVEntityExtension)) continue;
            destination$iv$iv$iv.add(element$iv$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TickableVEntityExtension it = (TickableVEntityExtension)element$iv;
            boolean bl = false;
            it.tick(server);
        }
        if (this.lastPercentage == this.percentage) {
            return;
        }
        this.lastPercentage = this.percentage;
        LoadedServerShip loadedServerShip = (LoadedServerShip)VSGameUtilsKt.getShipObjectWorld((MinecraftServer)server).getLoadedShips().getById(this.getShipId());
        if (loadedServerShip == null) {
            return;
        }
        if (!ThrustersController.Companion.getOrCreate(loadedServerShip).activateThruster(this.getThrusterId(), this.percentage)) {
            unregister.invoke();
            return;
        }
    }

    @Override
    @NotNull
    public <T> ReflectableItemDelegate<T> get(int pos, @NotNull T t) {
        return VEAutoSerializable.DefaultImpls.get(this, pos, t);
    }

    @Override
    @JsonIgnore
    @ApiStatus.NonExtendable
    @NotNull
    public CompoundTag tSerialize() {
        return VEAutoSerializable.DefaultImpls.tSerialize(this);
    }

    @Override
    @JsonIgnore
    @ApiStatus.NonExtendable
    public void tDeserialize(@NotNull CompoundTag tag) {
        VEAutoSerializable.DefaultImpls.tDeserialize(this, tag);
    }

    @Override
    @JsonIgnore
    @NotNull
    public CompoundTag tGetBuffer() {
        return VEAutoSerializable.DefaultImpls.tGetBuffer(this);
    }

    @Override
    @JsonIgnore
    @Nullable
    public ReflectableObject getReflectObjectOverride() {
        return VEAutoSerializable.DefaultImpls.getReflectObjectOverride(this);
    }

    @Override
    @JsonIgnore
    @ApiStatus.NonExtendable
    @NotNull
    public List<ReflectableItemDelegate<?>> getAllReflectableItems(boolean processSubReflectables, @NotNull Function1<? super ReflectableItemDelegate<?>, Boolean> filterBy) {
        return VEAutoSerializable.DefaultImpls.getAllReflectableItems(this, processSubReflectables, filterBy);
    }

    @Override
    @JsonIgnore
    @ApiStatus.NonExtendable
    @NotNull
    public List<ReflectableItemDelegate<?>> getReflectableItemsWithoutDataclassConstructorItems(boolean processSubReflectables, @NotNull Function1<? super ReflectableItemDelegate<?>, Boolean> filterBy) {
        return VEAutoSerializable.DefaultImpls.getReflectableItemsWithoutDataclassConstructorItems(this, processSubReflectables, filterBy);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(ThrusterVEntity.class, "shipId", "getShipId()J", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(ThrusterVEntity.class, "pos", "getPos()Lnet/spaceeye/vmod/utils/Vector3d;", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(ThrusterVEntity.class, "forceDir", "getForceDir()Lnet/spaceeye/vmod/utils/Vector3d;", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(ThrusterVEntity.class, "force", "getForce()D", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(ThrusterVEntity.class, "channel", "getChannel()Ljava/lang/String;", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(ThrusterVEntity.class, "thrusterId", "getThrusterId()I", 0)))};
        $$delegatedProperties = kPropertyArray;
    }
}

