/*
 * Decompiled with CFR 0.152.
 */
package forestry.api.genetics;

import forestry.api.genetics.IGenome;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.ILifeStage;
import forestry.api.genetics.ISpeciesType;
import forestry.api.genetics.ITaxon;
import forestry.api.genetics.alleles.AllelePair;
import forestry.api.genetics.alleles.IAllele;
import forestry.api.genetics.alleles.IChromosome;
import forestry.api.genetics.alleles.IKaryotype;
import forestry.api.genetics.alleles.IRegistryAlleleValue;
import java.util.List;
import java.util.Map;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public interface ISpecies<I extends IIndividual>
extends IRegistryAlleleValue {
    public String getTranslationKey();

    default public MutableComponent getDisplayName() {
        return Component.m_237115_((String)this.getTranslationKey());
    }

    default public String getDescriptionTranslationKey() {
        return this.getTranslationKey() + ".desc";
    }

    public IGenome getDefaultGenome();

    public ResourceLocation id();

    public String getBinomial();

    public String getSpeciesName();

    public ITaxon getGenus();

    default public String getGenusName() {
        return this.getGenus().name();
    }

    public ISpeciesType<? extends ISpecies<I>, I> getType();

    public boolean isSecret();

    public int getComplexity();

    default public ItemStack createStack(I individual, ILifeStage stage) {
        return this.getType().createStack(individual, stage);
    }

    default public ItemStack createStack(ILifeStage stage) {
        return this.createStack(this.createIndividual(), stage);
    }

    public I createIndividual(Map<IChromosome<?>, IAllele> var1);

    public I createIndividualFromPairs(Map<IChromosome<?>, AllelePair<?>> var1);

    public I createIndividual(IGenome var1);

    default public I createIndividual() {
        return this.createIndividual(this.getDefaultGenome());
    }

    default public IKaryotype getKaryotype() {
        return this.getDefaultGenome().getKaryotype();
    }

    public boolean hasGlint();

    @Override
    public boolean isDominant();

    public String getAuthority();

    public int getEscritoireColor();

    default public <S extends ISpecies<?>> S cast() {
        return (S)this;
    }

    public void addTooltip(I var1, List<Component> var2);
}

