/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.genetics.effects;

import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.genetics.IEffectData;
import forestry.api.genetics.IGenome;
import forestry.apiculture.genetics.effects.ThrottledBeeEffect;
import forestry.core.genetics.EffectData;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class CreeperBeeEffect
extends ThrottledBeeEffect {
    private static final int explosionChance = 50;
    private static final byte defaultForce = 12;
    private static final byte indexExplosionTimer = 1;
    private static final byte indexExplosionForce = 2;

    public CreeperBeeEffect() {
        super(true, 20, false, true);
    }

    @Override
    public IEffectData validateStorage(IEffectData storedData) {
        EffectData data;
        if (!(storedData instanceof EffectData) || (data = (EffectData)storedData).getIntSize() < 3) {
            return new EffectData(3, 0);
        }
        return storedData;
    }

    @Override
    public IEffectData doEffectThrottled(IGenome genome, IEffectData storedData, IBeeHousing housing) {
        Level world = housing.getWorldObj();
        BlockPos housingCoords = housing.getCoordinates();
        if (storedData.getInteger(1) > 0) {
            CreeperBeeEffect.progressExplosion(storedData, world, housingCoords);
            return storedData;
        }
        List<Player> players = ThrottledBeeEffect.getEntitiesInRange(genome, housing, Player.class);
        for (Player player : players) {
            int chance = 50;
            storedData.setInteger(2, 12);
            int count = BeeManager.armorApiaristHelper.wearsItems((LivingEntity)player, this, true);
            if (count > 3) continue;
            if (count > 2) {
                chance = 5;
                storedData.setInteger(2, 6);
            } else if (count > 1) {
                chance = 20;
                storedData.setInteger(2, 8);
            } else if (count > 0) {
                chance = 35;
                storedData.setInteger(2, 10);
            }
            if (world.f_46441_.m_188503_(1000) >= chance) continue;
            float pitch = (1.0f + (world.f_46441_.m_188501_() - world.f_46441_.m_188501_()) * 0.2f) * 0.7f;
            world.m_6263_(null, (double)housingCoords.m_123341_(), (double)housingCoords.m_123342_(), (double)housingCoords.m_123343_(), SoundEvents.f_11913_, SoundSource.BLOCKS, 4.0f, pitch);
            storedData.setInteger(1, 2);
        }
        return storedData;
    }

    private static void progressExplosion(IEffectData storedData, Level world, BlockPos pos) {
        int explosionTimer = storedData.getInteger(1);
        storedData.setInteger(1, --explosionTimer);
        if (explosionTimer > 0) {
            return;
        }
        world.m_255391_(null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (float)storedData.getInteger(2), false, Level.ExplosionInteraction.NONE);
    }
}

