/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.genetics.effects;

import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.genetics.IEffectData;
import forestry.api.genetics.IGenome;
import forestry.apiculture.genetics.effects.ThrottledBeeEffect;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Fox;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.EntityTeleportEvent;

public class PhasingBeeEffect
extends ThrottledBeeEffect {
    public PhasingBeeEffect() {
        super(true, 40, true, true);
    }

    @Override
    IEffectData doEffectThrottled(IGenome genome, IEffectData storedData, IBeeHousing housing) {
        ServerLevel level = (ServerLevel)housing.getWorldObj();
        RandomSource random = level.f_46441_;
        List<LivingEntity> list = PhasingBeeEffect.getEntitiesInRange(genome, housing, LivingEntity.class);
        block0: for (LivingEntity entity : list) {
            int count = BeeManager.armorApiaristHelper.wearsItems(entity, this, true);
            if (count >= 4) continue;
            double x = entity.m_20185_();
            double y = entity.m_20186_();
            double z = entity.m_20189_();
            for (int i = 0; i < 16; ++i) {
                double targetX = x + (random.m_188500_() - 0.5) * 16.0;
                double targetY = Mth.m_14008_((double)(y + (double)(random.m_188503_(16) - 8)), (double)level.m_141937_(), (double)(level.m_141937_() + level.m_143344_() - 1));
                double targetZ = z + (random.m_188500_() - 0.5) * 16.0;
                if (entity.m_20159_()) {
                    entity.m_8127_();
                }
                Vec3 vec3 = entity.m_20182_();
                level.m_214171_(GameEvent.f_238175_, vec3, GameEvent.Context.m_223717_((Entity)entity));
                EntityTeleportEvent.ChorusFruit event = ForgeEventFactory.onChorusFruitTeleport((LivingEntity)entity, (double)targetX, (double)targetY, (double)targetZ);
                if (event.isCanceled()) continue block0;
                if (!entity.m_20984_(event.getTargetX(), event.getTargetY(), event.getTargetZ(), true)) continue;
                SoundEvent sound = entity instanceof Fox ? SoundEvents.f_11953_ : SoundEvents.f_11757_;
                level.m_6263_(null, x, y, z, sound, SoundSource.BLOCKS, 1.0f, 1.0f);
                entity.m_5496_(sound, 1.0f, 1.0f);
                continue block0;
            }
        }
        return storedData;
    }

    @Override
    public IEffectData doFX(IGenome genome, IEffectData storedData, IBeeHousing housing) {
        Level level = housing.getWorldObj();
        level.m_7106_((ParticleOptions)ParticleTypes.f_123760_, (double)housing.getCoordinates().m_123341_() + 0.5, (double)housing.getCoordinates().m_123342_() + 0.5 + level.f_46441_.m_188500_() * 2.0, (double)housing.getCoordinates().m_123343_() + 0.5, level.f_46441_.m_188583_(), 0.0, level.f_46441_.m_188583_());
        return storedData;
    }
}

