/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.items;

import forestry.api.ForestryCapabilities;
import forestry.api.apiculture.IArmorApiarist;
import forestry.api.apiculture.genetics.IBeeEffect;
import forestry.apiculture.features.ApicultureItems;
import forestry.core.features.CoreItems;
import forestry.core.items.definitions.EnumCraftingMaterial;
import forestry.modules.features.FeatureItem;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.Nullable;

public class ItemArmorApiarist
extends ArmorItem {
    public static final String TEXTURE_APIARIST_ARMOR_PRIMARY = "forestry:textures/item/apiarist_armor_1.png";
    public static final String TEXTURE_APIARIST_ARMOR_SECONDARY = "forestry:textures/item/apiarist_armor_2.png";

    public ItemArmorApiarist(ArmorItem.Type type) {
        super((ArmorMaterial)new ApiaristArmorMaterial(), type, new Item.Properties());
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
        if (ApicultureItems.APIARIST_LEGS.itemEqual(stack)) {
            return TEXTURE_APIARIST_ARMOR_SECONDARY;
        }
        return TEXTURE_APIARIST_ARMOR_PRIMARY;
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return new ICapabilityProvider(){

            public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
                return cap == ForestryCapabilities.ARMOR_APIARIST ? LazyOptional.of(() -> ArmorApiarist.INSTANCE).cast() : LazyOptional.empty();
            }
        };
    }

    public static final class ApiaristArmorMaterial
    implements ArmorMaterial {
        private static final int[] reductions = new int[]{1, 3, 2, 1};
        private static final int[] DURABILITY = new int[]{33, 48, 45, 39};

        public int m_266425_(ArmorItem.Type type) {
            return DURABILITY[type.ordinal()];
        }

        public int m_7366_(ArmorItem.Type type) {
            return reductions[type.ordinal()];
        }

        public int m_6646_() {
            return 15;
        }

        public SoundEvent m_7344_() {
            return SoundEvents.f_11678_;
        }

        public Ingredient m_6230_() {
            return Ingredient.m_43929_((ItemLike[])new ItemLike[]{((FeatureItem)CoreItems.CRAFTING_MATERIALS.get(EnumCraftingMaterial.WOVEN_SILK)).get()});
        }

        public String m_6082_() {
            return "APIARIST_ARMOR";
        }

        public float m_6651_() {
            return 0.0f;
        }

        public float m_6649_() {
            return 0.0f;
        }
    }

    public static enum ArmorApiarist implements IArmorApiarist
    {
        INSTANCE;


        @Override
        public boolean protectEntity(LivingEntity entity, ItemStack armor, @Nullable IBeeEffect cause, boolean doProtect) {
            return true;
        }
    }
}

