/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.particles;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import forestry.apiculture.particles.ApicultureParticles;
import forestry.core.utils.ModUtil;
import java.util.Locale;
import javax.annotation.Nonnull;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;

public class BeeTargetParticleData
implements ParticleOptions {
    public static final ParticleOptions.Deserializer<BeeTargetParticleData> DESERIALIZER = new ParticleOptions.Deserializer<BeeTargetParticleData>(){

        @Nonnull
        public BeeTargetParticleData fromCommand(@Nonnull ParticleType<BeeTargetParticleData> type, @Nonnull StringReader reader) throws CommandSyntaxException {
            reader.expect(' ');
            int entityId = reader.readInt();
            reader.expect(' ');
            int color = reader.readInt();
            return new BeeTargetParticleData(entityId, color);
        }

        public BeeTargetParticleData fromNetwork(@Nonnull ParticleType<BeeTargetParticleData> type, FriendlyByteBuf buf) {
            return new BeeTargetParticleData(buf.readInt(), buf.readInt());
        }
    };
    public static Codec<BeeTargetParticleData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("entity").forGetter(data -> data.entity), (App)Codec.INT.fieldOf("color").forGetter(data -> data.color)).apply((Applicative)instance, BeeTargetParticleData::new));
    public final int entity;
    public final int color;

    public BeeTargetParticleData(int entity, int color) {
        this.entity = entity;
        this.color = color;
    }

    public BeeTargetParticleData(Entity entity, int color) {
        this.entity = entity.m_19879_();
        this.color = color;
    }

    @Nonnull
    public ParticleType<?> m_6012_() {
        return (ParticleType)ApicultureParticles.BEE_TARGET_ENTITY_PARTICLE.get();
    }

    public void m_7711_(@Nonnull FriendlyByteBuf buffer) {
        buffer.writeLong((long)this.entity);
        buffer.writeInt(this.color);
    }

    @Nonnull
    public String m_5942_() {
        return String.format(Locale.ROOT, "%s %d %d", ModUtil.getRegistryName(this.m_6012_()), this.entity, this.color);
    }
}

