/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiimpl.plugin;

import com.google.common.collect.ImmutableMap;
import forestry.api.genetics.ISpeciesType;
import forestry.api.lepidopterology.IButterflyCocoon;
import forestry.api.lepidopterology.IButterflyEffect;
import forestry.api.lepidopterology.genetics.IButterflySpecies;
import forestry.api.plugin.IButterflySpeciesBuilder;
import forestry.api.plugin.ILepidopterologyRegistration;
import forestry.apiimpl.plugin.ButterflySpeciesBuilder;
import forestry.apiimpl.plugin.MutationsRegistration;
import forestry.apiimpl.plugin.Registrar;
import forestry.apiimpl.plugin.SpeciesRegistration;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;

public class LepidopterologyRegistration
extends SpeciesRegistration<IButterflySpeciesBuilder, IButterflySpecies, ButterflySpeciesBuilder>
implements ILepidopterologyRegistration {
    private final Registrar<ResourceLocation, IButterflyCocoon, IButterflyCocoon> cocoons = new Registrar(IButterflyCocoon.class);
    private final Registrar<ResourceLocation, IButterflyEffect, IButterflyEffect> effects = new Registrar(IButterflyEffect.class);

    public LepidopterologyRegistration(ISpeciesType<IButterflySpecies, ?> type) {
        super(type);
    }

    @Override
    public IButterflySpeciesBuilder registerSpecies(ResourceLocation id, String genus, String species, boolean dominant, TextColor serumColor, float rarity) {
        return ((IButterflySpeciesBuilder)((IButterflySpeciesBuilder)this.register(id, genus, species)).setDominant(dominant)).setSerumColor(serumColor).setRarity(rarity);
    }

    @Override
    public void registerCocoon(ResourceLocation id, IButterflyCocoon cocoon) {
        this.cocoons.create(id, cocoon);
    }

    @Override
    public void registerEffect(ResourceLocation id, IButterflyEffect effect) {
        this.effects.create(id, effect);
    }

    @Override
    protected ButterflySpeciesBuilder createSpeciesBuilder(ResourceLocation id, String genus, String species, MutationsRegistration mutations) {
        return new ButterflySpeciesBuilder(id, genus, species, mutations);
    }

    public ImmutableMap<ResourceLocation, IButterflyCocoon> getCocoons() {
        return this.cocoons.build();
    }

    public ImmutableMap<ResourceLocation, IButterflyEffect> getEffects() {
        return this.effects.build();
    }
}

