/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiimpl.plugin;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.mojang.datafixers.util.Pair;
import forestry.Forestry;
import forestry.api.IForestryApi;
import forestry.api.apiculture.genetics.IBeeSpecies;
import forestry.api.apiculture.genetics.IBeeSpeciesType;
import forestry.api.arboriculture.ITreeSpecies;
import forestry.api.circuits.CircuitHolder;
import forestry.api.circuits.ICircuit;
import forestry.api.circuits.ICircuitLayout;
import forestry.api.client.IForestryClientApi;
import forestry.api.client.arboriculture.ILeafSprite;
import forestry.api.client.arboriculture.ILeafTint;
import forestry.api.core.IError;
import forestry.api.genetics.ILifeStage;
import forestry.api.genetics.IMutationManager;
import forestry.api.genetics.ISpeciesType;
import forestry.api.genetics.ITaxon;
import forestry.api.lepidopterology.genetics.IButterflySpecies;
import forestry.api.lepidopterology.genetics.IButterflySpeciesType;
import forestry.api.plugin.IForestryPlugin;
import forestry.api.plugin.IPollenRegistration;
import forestry.apiimpl.ForestryApiImpl;
import forestry.apiimpl.GeneticManager;
import forestry.apiimpl.client.BeeClientManager;
import forestry.apiimpl.client.ButterflyClientManager;
import forestry.apiimpl.client.ForestryClientApiImpl;
import forestry.apiimpl.client.TreeClientManager;
import forestry.apiimpl.client.plugin.ClientRegistration;
import forestry.apiimpl.plugin.CircuitRegistration;
import forestry.apiimpl.plugin.ErrorRegistration;
import forestry.apiimpl.plugin.FarmingRegistration;
import forestry.apiimpl.plugin.GeneticRegistration;
import forestry.arboriculture.client.FixedLeafTint;
import forestry.core.circuits.CircuitLayout;
import forestry.core.circuits.CircuitManager;
import forestry.core.errors.ErrorManager;
import forestry.core.genetics.PollenManager;
import forestry.core.genetics.alleles.AlleleManager;
import forestry.core.utils.SpeciesUtil;
import forestry.farming.FarmingManager;
import forestry.plugin.DefaultForestryPlugin;
import forestry.sorting.FilterManager;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ShortOpenHashMap;
import it.unimi.dsi.fastutil.shorts.Short2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraftforge.eventbus.api.IEventBus;

public class PluginManager {
    private static final ArrayList<IForestryPlugin> LOADED_PLUGINS = new ArrayList();
    @Nullable
    @Deprecated
    private static RuntimeException asyncThrown = null;

    public static void loadPlugins() {
        ServiceLoader<IForestryPlugin> serviceLoader = ServiceLoader.load(IForestryPlugin.class);
        serviceLoader.stream().map(ServiceLoader.Provider::get).sorted(Comparator.comparing(IForestryPlugin::id)).forEachOrdered(plugin -> {
            if (plugin.shouldLoad()) {
                if (plugin.getClass() == DefaultForestryPlugin.class) {
                    LOADED_PLUGINS.add(0, (IForestryPlugin)plugin);
                } else {
                    LOADED_PLUGINS.add((IForestryPlugin)plugin);
                }
                Forestry.LOGGER.debug("Registered IForestryPlugin {} with class {}", (Object)plugin.id(), (Object)plugin.getClass().getName());
            } else {
                Forestry.LOGGER.warn("Detected IForestryPlugin {} with class {} but did not load it because IForestryPlugin.shouldLoad returned false.", (Object)plugin.id(), (Object)plugin.getClass().getName());
            }
        });
        LOADED_PLUGINS.trimToSize();
    }

    public static void registerErrors() {
        ErrorRegistration registration = new ErrorRegistration();
        for (IForestryPlugin plugin : LOADED_PLUGINS) {
            plugin.registerErrors(registration);
        }
        ArrayList<IError> errors = registration.getErrors();
        int errorCount = errors.size();
        Short2ObjectOpenHashMap byNumericId = new Short2ObjectOpenHashMap(errorCount);
        Object2ShortOpenHashMap numericIdLookup = new Object2ShortOpenHashMap(errorCount);
        ImmutableMap.Builder byId = ImmutableMap.builderWithExpectedSize((int)errorCount);
        for (int i = 0; i < errors.size(); ++i) {
            IError error = errors.get(i);
            byNumericId.put((short)i, (Object)error);
            numericIdLookup.put((Object)error, (short)i);
            byId.put((Object)error.getId(), (Object)error);
        }
        ((ForestryApiImpl)IForestryApi.INSTANCE).setErrorManager(new ErrorManager((Short2ObjectOpenHashMap<IError>)byNumericId, (Object2ShortOpenHashMap<IError>)numericIdLookup, (ImmutableMap<ResourceLocation, IError>)byId.build()));
    }

    public static void registerCircuits() {
        CircuitRegistration registration = new CircuitRegistration();
        for (IForestryPlugin plugin : LOADED_PLUGINS) {
            try {
                plugin.registerCircuits(registration);
            }
            catch (Throwable e) {
                asyncThrown = new RuntimeException("An error was thrown by plugin " + plugin.id() + " during IForestryPlugin.registerCircuits", e);
                Forestry.LOGGER.fatal((Object)asyncThrown);
            }
        }
        ArrayList<CircuitLayout> layouts = registration.getLayouts();
        ImmutableMap.Builder layoutsByIdBuilder = ImmutableMap.builderWithExpectedSize((int)layouts.size());
        for (CircuitLayout layout : layouts) {
            layoutsByIdBuilder.put((Object)layout.getId(), (Object)layout);
        }
        ImmutableMap layoutsById = layoutsByIdBuilder.build();
        ArrayList<CircuitHolder> circuits = registration.getCircuits();
        ImmutableMultimap.Builder circuitHoldersBuilder = new ImmutableMultimap.Builder();
        ImmutableMap.Builder circuitsBuilder = ImmutableMap.builderWithExpectedSize((int)circuits.size());
        for (CircuitHolder holder : circuits) {
            ICircuitLayout layout = (ICircuitLayout)layoutsById.get((Object)holder.layoutId());
            if (layout == null) {
                throw new IllegalStateException("Attempted to register a CircuitHolder but no layout was registered with its layout ID: " + holder);
            }
            circuitHoldersBuilder.put((Object)layout, (Object)holder);
            ICircuit circuit = holder.circuit();
            circuitsBuilder.put((Object)circuit.getId(), (Object)circuit);
        }
        try {
            ((ForestryApiImpl)IForestryApi.INSTANCE).setCircuitManager(new CircuitManager((ImmutableMultimap<ICircuitLayout, CircuitHolder>)circuitHoldersBuilder.build(), (ImmutableMap<String, ICircuitLayout>)layoutsById, (ImmutableMap<String, ICircuit>)circuitsBuilder.buildOrThrow()));
        }
        catch (IllegalArgumentException exception) {
            Forestry.LOGGER.fatal("Failed to register circuits: two circuits were registered with the same ID");
            throw exception;
        }
    }

    public static void registerGenetics() {
        GeneticRegistration registration = new GeneticRegistration();
        for (IForestryPlugin plugin : LOADED_PLUGINS) {
            plugin.registerGenetics(registration);
        }
        ImmutableMap<ResourceLocation, ISpeciesType<?, ?>> speciesTypes = registration.buildSpeciesTypes();
        ImmutableMap<String, ITaxon> taxa = registration.buildTaxa();
        Forestry.LOGGER.debug("Registered {} species types: {}", (Object)speciesTypes.size(), (Object)Arrays.toString(speciesTypes.keySet().toArray((Object[])new ResourceLocation[0])));
        ForestryApiImpl api = (ForestryApiImpl)IForestryApi.INSTANCE;
        AlleleManager alleleManager = (AlleleManager)api.getAlleleManager();
        GeneticManager geneticManager = new GeneticManager(taxa, speciesTypes);
        api.setGeneticManager(geneticManager);
        api.setFilterManager(new FilterManager(registration.getFilterRuleTypes()));
        alleleManager.setRegistrationState(1);
        LinkedHashMap<ISpeciesType, ImmutableMap> allSpecies = new LinkedHashMap<ISpeciesType, ImmutableMap>(speciesTypes.size());
        IdentityHashMap<ISpeciesType, IMutationManager> allMutations = new IdentityHashMap<ISpeciesType, IMutationManager>(speciesTypes.size());
        for (ISpeciesType iSpeciesType : speciesTypes.values()) {
            Pair pair = iSpeciesType.handleSpeciesRegistration(LOADED_PLUGINS);
            ImmutableMap species = (ImmutableMap)pair.getFirst();
            IMutationManager mutations = (IMutationManager)pair.getSecond();
            allSpecies.put(iSpeciesType, species);
            allMutations.put(iSpeciesType, mutations);
            Forestry.LOGGER.debug("Registered {} species for species type {}", (Object)species.size(), (Object)iSpeciesType.id());
            Forestry.LOGGER.debug("Registered {} mutations for species type {}", (Object)mutations.getAllMutations().size(), (Object)iSpeciesType.id());
        }
        alleleManager.setRegistrationState(2);
        for (Map.Entry entry : allSpecies.entrySet()) {
            ISpeciesType speciesType = (ISpeciesType)entry.getKey();
            speciesType.onSpeciesRegistered((ImmutableMap)entry.getValue(), (IMutationManager)allMutations.get(speciesType));
            if (speciesType.getAllSpecies().isEmpty()) {
                throw new IllegalStateException("Failed to register species for type " + speciesType.id());
            }
            speciesType.getMutations();
        }
        geneticManager.setMutations(ImmutableMap.copyOf(allMutations));
    }

    public static void registerFarming() {
        FarmingRegistration registration = new FarmingRegistration();
        for (IForestryPlugin plugin : LOADED_PLUGINS) {
            try {
                plugin.registerFarming(registration);
            }
            catch (Throwable t) {
                throw new RuntimeException("An error was thrown by plugin " + plugin.id() + " during IForestryPlugin.registerFarming", t);
            }
        }
        FarmingManager manager = new FarmingManager((Object2IntOpenHashMap<Item>)new Object2IntOpenHashMap(registration.getFertilizers()), registration.buildFarmTypes());
        ((ForestryApiImpl)IForestryApi.INSTANCE).setFarmingManager(manager);
    }

    public static void registerPollen() {
        HashMap pollenTypes = new HashMap();
        IPollenRegistration registration = pollen -> {
            ResourceLocation id = pollen.id();
            if (pollenTypes.containsKey(id)) {
                throw new IllegalStateException("A pollen type was already registered with ID " + pollen + ": " + pollenTypes.get(id));
            }
            pollenTypes.put(id, pollen);
        };
        for (IForestryPlugin plugin : LOADED_PLUGINS) {
            plugin.registerPollen(registration);
        }
        ((ForestryApiImpl)IForestryApi.INSTANCE).setPollenManager(new PollenManager(ImmutableMap.copyOf(pollenTypes)));
    }

    @Deprecated
    public static void registerAsyncException(IEventBus modBus) {
        modBus.addListener(event -> {
            if (asyncThrown != null) {
                throw asyncThrown;
            }
        });
    }

    public static void registerClient() {
        ClientRegistration registration = new ClientRegistration();
        for (IForestryPlugin plugin : LOADED_PLUGINS) {
            plugin.registerClient(consumer -> consumer.accept(registration));
        }
        List<IBeeSpecies> beeSpecies = SpeciesUtil.getAllBeeSpecies();
        IdentityHashMap<ILifeStage, Map<IBeeSpecies, ResourceLocation>> beeModels = new IdentityHashMap<ILifeStage, Map<IBeeSpecies, ResourceLocation>>();
        for (ILifeStage stage : ((IBeeSpeciesType)SpeciesUtil.BEE_TYPE.get()).getLifeStages()) {
            Map locationsByStage = registration.getBeeModels().getOrDefault(stage, Map.of());
            IdentityHashMap<IBeeSpecies, ResourceLocation> modelsByStage = new IdentityHashMap<IBeeSpecies, ResourceLocation>(locationsByStage.size());
            for (IBeeSpecies species : beeSpecies) {
                ResourceLocation modelLocation = (ResourceLocation)locationsByStage.get(species.id());
                if (modelLocation == null) {
                    modelLocation = Objects.requireNonNull(registration.getDefaultBeeModel(stage), "IClientRegistration.setDefaultBeeModel has not been called for life stage " + stage.m_7912_() + ", unable to resolve bee default model");
                }
                modelsByStage.put(species, modelLocation);
            }
            beeModels.put(stage, modelsByStage);
        }
        ((ForestryClientApiImpl)IForestryClientApi.INSTANCE).setBeeManager(new BeeClientManager(beeModels));
        HashMap<ResourceLocation, ILeafSprite> spritesById = registration.getLeafSprites();
        HashMap<ResourceLocation, ILeafTint> tintsById = registration.getTints();
        HashMap<ResourceLocation, Pair<ResourceLocation, ResourceLocation>> modelsById = registration.getSaplingModels();
        List<ITreeSpecies> treeSpecies = SpeciesUtil.getAllTreeSpecies();
        IdentityHashMap<ITreeSpecies, ILeafSprite> sprites = new IdentityHashMap<ITreeSpecies, ILeafSprite>(treeSpecies.size());
        IdentityHashMap<ITreeSpecies, ILeafTint> tints = new IdentityHashMap<ITreeSpecies, ILeafTint>(treeSpecies.size());
        IdentityHashMap<ITreeSpecies, Pair<ResourceLocation, ResourceLocation>> models = new IdentityHashMap<ITreeSpecies, Pair<ResourceLocation, ResourceLocation>>(treeSpecies.size());
        for (ITreeSpecies species : treeSpecies) {
            ResourceLocation id = species.id();
            ILeafSprite sprite = Objects.requireNonNull(spritesById.get(id), "No leaf tint registered for tree species " + id);
            ILeafTint tint = tintsById.getOrDefault(id, new FixedLeafTint(species.getEscritoireColor()));
            Pair<ResourceLocation, ResourceLocation> modelPair = modelsById.get(id);
            sprites.put(species, sprite);
            tints.put(species, tint);
            if (modelPair != null) {
                models.put(species, modelPair);
                continue;
            }
            String path = id.m_135815_().replace("tree_", "");
            models.put(species, (Pair<ResourceLocation, ResourceLocation>)Pair.of((Object)new ResourceLocation(id.m_135827_(), "block/sapling/" + path), (Object)new ResourceLocation(id.m_135827_(), "item/sapling/" + path)));
        }
        ((ForestryClientApiImpl)IForestryClientApi.INSTANCE).setTreeManager(new TreeClientManager(sprites, tints, models));
        HashMap<ResourceLocation, Pair<ResourceLocation, ResourceLocation>> butterflyTexturesById = registration.getButterflyTextures();
        List butterflySpecies = ((IButterflySpeciesType)SpeciesUtil.BUTTERFLY_TYPE.get()).getAllSpecies();
        IdentityHashMap<IButterflySpecies, Pair<ResourceLocation, ResourceLocation>> butterflyTextures = new IdentityHashMap<IButterflySpecies, Pair<ResourceLocation, ResourceLocation>>(butterflySpecies.size());
        for (IButterflySpecies species : butterflySpecies) {
            ResourceLocation id = species.id();
            Pair<ResourceLocation, ResourceLocation> texturePair = modelsById.get(id);
            if (texturePair != null) {
                butterflyTextures.put(species, texturePair);
                continue;
            }
            String path = id.m_135815_().replace("butterfly_", "");
            butterflyTextures.put(species, butterflyTexturesById.getOrDefault(id, (Pair<ResourceLocation, ResourceLocation>)Pair.of((Object)new ResourceLocation(id.m_135827_(), "item/butterfly/" + path), (Object)new ResourceLocation(id.m_135827_(), "textures/entity/butterfly/" + path + ".png"))));
        }
        ((ForestryClientApiImpl)IForestryClientApi.INSTANCE).setButterflyManager(new ButterflyClientManager(butterflyTextures));
    }
}

