/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.blocks;

import forestry.arboriculture.worldgen.FeatureArboriculture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class BlockExtendedLeaves
extends LeavesBlock {
    private static final ThreadLocal<byte[]> SURROUNDINGS = ThreadLocal.withInitial(() -> new byte[32768]);
    private static final byte SUPPORTED_LEAVES = 0;
    private static final byte NO_LEAVES = -1;
    private static final byte UNSUPPORTED_LEAVES = -2;
    public static final BooleanProperty SUPPORTED = BooleanProperty.m_61465_((String)"supported");

    public BlockExtendedLeaves(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)SUPPORTED, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{SUPPORTED});
    }

    public boolean m_6724_(BlockState state) {
        return super.m_6724_(state) && (Boolean)state.m_61143_((Property)SUPPORTED) == false;
    }

    protected boolean m_221385_(BlockState state) {
        return super.m_221385_(state) && (Boolean)state.m_61143_((Property)SUPPORTED) == false;
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        boolean newSupported;
        BlockState newState = super.m_7417_(state, facing, facingState, level, currentPos, facingPos);
        boolean oldSupported = (Boolean)newState.m_61143_((Property)SUPPORTED);
        if (oldSupported != (newSupported = BlockExtendedLeaves.hasSupport(newState, level, currentPos))) {
            newState.m_61124_((Property)SUPPORTED, (Comparable)Boolean.valueOf(newSupported));
            level.m_186460_(currentPos, (Block)this, 1);
        }
        return newState;
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        BlockState newState = BlockExtendedLeaves.m_54435_((BlockState)state, (LevelAccessor)level, (BlockPos)pos);
        boolean shouldBeSupported = BlockExtendedLeaves.hasSupport(newState, (LevelAccessor)level, pos);
        if ((newState = (BlockState)newState.m_61124_((Property)SUPPORTED, (Comparable)Boolean.valueOf(shouldBeSupported))) != state) {
            level.m_7731_(pos, newState, 3);
            if (shouldBeSupported != (Boolean)state.m_61143_((Property)SUPPORTED)) {
                for (Direction direction : Direction.f_122346_) {
                    BlockPos neighborPos = pos.m_121945_(direction);
                    BlockState neighborState = level.m_8055_(neighborPos);
                    if (!(neighborState.m_60734_() instanceof BlockExtendedLeaves)) continue;
                    level.m_186460_(neighborPos, neighborState.m_60734_(), 1);
                }
            }
        }
    }

    private static boolean hasSupport(BlockState state, LevelAccessor level, BlockPos pos) {
        if ((Integer)state.m_61143_((Property)f_54418_) <= 6) {
            return true;
        }
        return FeatureArboriculture.SKIP_EXTENDED_CHECKS.get() != false || BlockExtendedLeaves.hasExtendedSupport(level, pos);
    }

    private static boolean hasExtendedSupport(LevelAccessor level, BlockPos pos) {
        int index;
        byte[] surroundings = SURROUNDINGS.get();
        BlockPos.MutableBlockPos cursor = new BlockPos.MutableBlockPos();
        int x = pos.m_123341_();
        int y = pos.m_123342_();
        int z = pos.m_123343_();
        for (int xOffset = -4; xOffset <= 4; ++xOffset) {
            cursor.m_142451_(x + xOffset);
            for (int yOffset = -4; yOffset <= 4; ++yOffset) {
                cursor.m_142448_(y + yOffset);
                for (int zOffset = -4; zOffset <= 4; ++zOffset) {
                    cursor.m_142443_(z + zOffset);
                    BlockState state = level.m_8055_((BlockPos)cursor);
                    index = (xOffset + 16 << 10) + (yOffset + 16 << 5) + (zOffset + 16);
                    if (state.m_61138_((Property)f_54418_)) {
                        if ((Integer)state.m_61143_((Property)f_54418_) <= 6) {
                            surroundings[index] = 0;
                            continue;
                        }
                        surroundings[index] = -2;
                        continue;
                    }
                    surroundings[index] = -1;
                }
            }
        }
        for (byte sustainedValue = 1; sustainedValue <= 4; sustainedValue = (byte)((byte)(sustainedValue + 1))) {
            for (int xOffset = -4; xOffset <= 4; ++xOffset) {
                for (int yOffset = -4; yOffset <= 4; ++yOffset) {
                    for (int zOffset = -4; zOffset <= 4; ++zOffset) {
                        index = (xOffset + 16 << 10) + (yOffset + 16 << 5) + (zOffset + 16);
                        if (surroundings[index] != sustainedValue - 1) continue;
                        BlockExtendedLeaves.checkAndSetSupport(surroundings, xOffset - 1, yOffset, zOffset, sustainedValue);
                        BlockExtendedLeaves.checkAndSetSupport(surroundings, xOffset + 1, yOffset, zOffset, sustainedValue);
                        BlockExtendedLeaves.checkAndSetSupport(surroundings, xOffset, yOffset - 1, zOffset, sustainedValue);
                        BlockExtendedLeaves.checkAndSetSupport(surroundings, xOffset, yOffset + 1, zOffset, sustainedValue);
                        BlockExtendedLeaves.checkAndSetSupport(surroundings, xOffset, yOffset, zOffset - 1, sustainedValue);
                        BlockExtendedLeaves.checkAndSetSupport(surroundings, xOffset, yOffset, zOffset + 1, sustainedValue);
                    }
                }
            }
        }
        return surroundings[16912] >= 0;
    }

    private static void checkAndSetSupport(byte[] array, int x, int y, int z, byte supportValue) {
        if (x < -16 || x > 16 || y < -16 || y > 16 || z < -16 || z > 16) {
            return;
        }
        int arrayIndex = (x + 16 << 10) + (y + 16 << 5) + (z + 16);
        if (array[arrayIndex] == -2) {
            array[arrayIndex] = supportValue;
        }
    }
}

