/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.blocks;

import com.google.common.base.Preconditions;
import forestry.api.arboriculture.ICharcoalManager;
import forestry.api.arboriculture.ICharcoalPileWall;
import forestry.api.arboriculture.TreeManager;
import forestry.arboriculture.blocks.BlockAsh;
import forestry.arboriculture.features.CharcoalBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class LogPileBlock
extends Block {
    public static final BooleanProperty IS_ACTIVE = BooleanProperty.m_61465_((String)"active");
    public static final IntegerProperty AGE = BlockStateProperties.f_61409_;
    public static final int RANDOM_TICK = 160;
    public static final int TICK_RATE = 960;

    public LogPileBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_60978_(1.5f).m_60918_(SoundType.f_56736_).m_60955_());
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)AGE, (Comparable)Integer.valueOf(0))).m_61124_((Property)IS_ACTIVE, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{IS_ACTIVE, AGE});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        for (Direction facing : Direction.f_122346_) {
            BlockState facingState = context.m_43725_().m_8055_(context.m_8083_().m_121945_(facing));
            if (!facingState.m_60713_((Block)this) || !((Boolean)facingState.m_61143_((Property)IS_ACTIVE)).booleanValue()) continue;
            return (BlockState)this.m_49966_().m_61124_((Property)IS_ACTIVE, (Comparable)Boolean.valueOf(true));
        }
        return this.m_49966_();
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block blockIn, BlockPos fromPos, boolean p_220069_6_) {
        BlockState fromState = level.m_8055_(fromPos);
        if (fromState.m_60713_(Blocks.f_50083_) && !((Boolean)state.m_61143_((Property)IS_ACTIVE)).booleanValue()) {
            this.activatePile(state, level, pos, true);
        }
    }

    private void activatePile(BlockState state, Level level, BlockPos pos, boolean scheduleUpdate) {
        level.m_7731_(pos, (BlockState)state.m_61124_((Property)IS_ACTIVE, (Comparable)Boolean.valueOf(true)), 2);
        if (scheduleUpdate) {
            level.m_186460_(pos, (Block)this, (960 + level.f_46441_.m_188503_(160)) / 4);
        }
    }

    public void m_213897_(BlockState state, ServerLevel world, BlockPos pos, RandomSource rand) {
        if (((Boolean)state.m_61143_((Property)IS_ACTIVE)).booleanValue()) {
            for (Direction facing : Direction.f_122346_) {
                BlockPos position = pos.m_121945_(facing);
                if (!world.m_46805_(position)) continue;
                BlockState blockState = world.m_8055_(position);
                Block block = blockState.m_60734_();
                if (block == this) {
                    if (!((Boolean)state.m_61143_((Property)IS_ACTIVE)).booleanValue() && ((Boolean)blockState.m_61143_((Property)IS_ACTIVE)).booleanValue()) {
                        this.activatePile(state, (Level)world, pos, false);
                        continue;
                    }
                    if (((Boolean)blockState.m_61143_((Property)IS_ACTIVE)).booleanValue() || !((Boolean)state.m_61143_((Property)IS_ACTIVE)).booleanValue()) continue;
                    this.activatePile(blockState, (Level)world, position, true);
                    continue;
                }
                if (!world.m_46859_(position) && Block.m_49863_((LevelReader)world, (BlockPos)position, (Direction)facing.m_122424_()) && !block.isFlammable(blockState, (BlockGetter)world, position, facing.m_122424_())) continue;
                world.m_46597_(pos, Blocks.f_50083_.m_49966_());
                return;
            }
            if (rand.m_188501_() < 0.5f) {
                if ((Integer)state.m_61143_((Property)AGE) < 7) {
                    world.m_7731_(pos, (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf((Integer)state.m_61143_((Property)AGE) + 1)), 2);
                } else {
                    BlockState ashState = CharcoalBlocks.ASH.setValue(BlockAsh.AMOUNT, Math.min(Math.round(8.0f + this.getCharcoalAmount((Level)world, pos)), 63));
                    world.m_7731_(pos, ashState, 2);
                }
            }
            world.m_186460_(pos, (Block)this, 960 + world.f_46441_.m_188503_(160));
        }
    }

    public int getFireSpreadSpeed(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return 12;
    }

    public boolean isFlammable(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return true;
    }

    public int getFlammability(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return 25;
    }

    public int getLightEmission(BlockState state, BlockGetter world, BlockPos pos) {
        if (((Boolean)state.m_61143_((Property)IS_ACTIVE)).booleanValue()) {
            return 10;
        }
        return super.getLightEmission(state, world, pos);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource rand) {
        if (((Boolean)state.m_61143_((Property)IS_ACTIVE)).booleanValue()) {
            if (rand.m_188500_() < 0.1) {
                level.m_7785_((double)((float)pos.m_123341_() + 0.5f), (double)((float)pos.m_123342_() + 0.5f), (double)((float)pos.m_123343_() + 0.5f), SoundEvents.f_11936_, SoundSource.BLOCKS, 1.0f + rand.m_188501_(), rand.m_188501_() * 0.7f + 0.3f, false);
            }
            float f = (float)pos.m_123341_() + 0.5f;
            float f1 = (float)pos.m_123342_() + 0.0f + rand.m_188501_() * 6.0f / 16.0f;
            float f2 = (float)pos.m_123343_() + 0.5f;
            float f3 = 0.52f;
            float f4 = rand.m_188501_() * 0.6f - 0.3f;
            if (rand.m_188500_() < 0.2) {
                level.m_7106_((ParticleOptions)ParticleTypes.f_123755_, (double)(f + f3) - 0.5, (double)(f1 + 1.0f), (double)(f2 + f4), 0.0, 0.15, 0.0);
            } else {
                level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, (double)(f + f3) - 0.5, (double)(f1 + 1.0f), (double)(f2 + f4), 0.0, 0.15, 0.0);
            }
        }
    }

    private float getCharcoalAmount(Level world, BlockPos pos) {
        float charcoalAmount = 0.0f;
        for (Direction facing : Direction.f_122346_) {
            charcoalAmount += (float)this.getCharcoalFaceAmount(world, pos, facing);
        }
        return Mth.m_14036_((float)(charcoalAmount / 6.0f), (float)8.0f, (float)55.0f);
    }

    private int getCharcoalFaceAmount(Level world, BlockPos pos, Direction facing) {
        ICharcoalManager charcoalManager = (ICharcoalManager)Preconditions.checkNotNull((Object)TreeManager.charcoalManager);
        BlockPos.MutableBlockPos testPos = pos.m_122032_();
        testPos.m_122173_(facing);
        for (int i = 0; i < 16 && world.m_46805_((BlockPos)testPos) && !world.m_46859_((BlockPos)testPos); ++i) {
            BlockState state = world.m_8055_((BlockPos)testPos);
            ICharcoalPileWall wall = charcoalManager.getWall(state);
            if (wall != null) {
                return wall.getCharcoalAmount();
            }
            testPos.m_122173_(facing);
        }
        return 0;
    }
}

