/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.client;

import com.mojang.datafixers.util.Pair;
import forestry.api.ForestryConstants;
import forestry.arboriculture.ForestryWoodType;
import forestry.arboriculture.entities.ForestryBoat;
import java.util.EnumMap;
import net.minecraft.client.model.BoatModel;
import net.minecraft.client.model.ChestBoatModel;
import net.minecraft.client.model.ListModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.BoatRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.vehicle.Boat;

public class ForestryBoatRenderer
extends BoatRenderer {
    private final EnumMap<ForestryWoodType, Pair<ResourceLocation, ListModel<Boat>>> boatResources = new EnumMap(ForestryWoodType.class);

    public ForestryBoatRenderer(EntityRendererProvider.Context ctx, boolean hasChest) {
        super(ctx, hasChest);
        for (ForestryWoodType type : ForestryWoodType.VALUES) {
            Pair pair = new Pair((Object)ForestryConstants.forestry(ForestryBoatRenderer.getTextureLocation(type, hasChest)), ForestryBoatRenderer.createBoatModel(ctx, type, hasChest));
            this.boatResources.put(type, (Pair<ResourceLocation, ListModel<Boat>>)pair);
        }
    }

    private static String getTextureLocation(ForestryWoodType type, boolean hasChest) {
        return (hasChest ? "textures/entity/chest_boat/" : "textures/entity/boat/") + type.m_7912_() + ".png";
    }

    private static ListModel<Boat> createBoatModel(EntityRendererProvider.Context ctx, ForestryWoodType type, boolean hasChest) {
        ModelLayerLocation modelLoc = ForestryBoatRenderer.createBoatModelLocation(type, hasChest);
        ModelPart root = ctx.m_174023_(modelLoc);
        return hasChest ? new ChestBoatModel(root) : new BoatModel(root);
    }

    public static ModelLayerLocation createBoatModelLocation(ForestryWoodType type, boolean hasChest) {
        return new ModelLayerLocation(ForestryConstants.forestry((hasChest ? "chest_boat/" : "boat/") + type.m_7912_()), "main");
    }

    public Pair<ResourceLocation, ListModel<Boat>> getModelWithLocation(Boat boat) {
        Pair<ResourceLocation, ListModel<Boat>> pair;
        if (boat instanceof ForestryBoat) {
            ForestryBoat forestryBoat = (ForestryBoat)boat;
            pair = this.boatResources.get(forestryBoat.getWoodType());
        } else {
            pair = super.getModelWithLocation(boat);
        }
        return pair;
    }
}

