/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.genetics;

import forestry.api.apiculture.genetics.IBee;
import forestry.api.arboriculture.genetics.ITree;
import forestry.api.arboriculture.genetics.ITreeSpeciesType;
import forestry.api.arboriculture.genetics.TreeLifeStage;
import forestry.api.genetics.ISpeciesType;
import forestry.api.genetics.pollen.ForestryPollenTypes;
import forestry.api.genetics.pollen.IPollen;
import forestry.api.genetics.pollen.IPollenType;
import forestry.arboriculture.blocks.BlockDefaultLeaves;
import forestry.arboriculture.tiles.TileLeaves;
import forestry.core.config.ForestryConfig;
import forestry.core.utils.SpeciesUtil;
import forestry.core.utils.TreeUtil;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class TreePollenType
implements IPollenType<ITree> {
    @Override
    public ResourceLocation id() {
        return ForestryPollenTypes.TREE;
    }

    @Override
    public boolean canPollinate(LevelAccessor level, BlockPos pos, @Nullable Object pollinator) {
        if (level.m_7702_(pos) instanceof TileLeaves) {
            return true;
        }
        BlockState state = level.m_8055_(pos);
        Optional persistent = state.m_61145_((Property)BlockDefaultLeaves.f_54419_);
        if (persistent.isPresent() && ((Boolean)persistent.get()).booleanValue()) {
            return false;
        }
        ITree individual = ((ITreeSpeciesType)SpeciesUtil.TREE_TYPE.get()).getVanillaIndividual(state);
        if (individual != null) {
            return !individual.getSpecies().getDecorativeLeaves().m_150930_(state.m_60734_().m_5456_());
        }
        return false;
    }

    @Override
    @Nullable
    public IPollen<ITree> tryCollectPollen(LevelAccessor level, BlockPos pos, @Nullable Object pollinator) {
        TileLeaves leaves;
        ITree tree;
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof TileLeaves && (tree = (leaves = (TileLeaves)blockEntity).getTree()) != null) {
            return new TreePollen(tree);
        }
        ITree vanillaIndividual = ((ITreeSpeciesType)SpeciesUtil.TREE_TYPE.get()).getVanillaIndividual(level.m_8055_(pos));
        return vanillaIndividual == null ? null : new TreePollen(vanillaIndividual);
    }

    @Override
    public boolean tryPollinate(LevelAccessor level, BlockPos pos, ITree pollen, @Nullable Object pollinator) {
        boolean convertVanilla = pollinator instanceof IBee && (Boolean)ForestryConfig.SERVER.pollinateVanillaLeaves.get() != false;
        TileLeaves leaves = TreeUtil.getOrCreateLeaves(level, pos, convertVanilla);
        return leaves != null && TreeUtil.tryMate(leaves, pollen);
    }

    @Override
    public IPollen<ITree> readNbt(Tag nbt) {
        return new TreePollen((ITree)SpeciesUtil.deserializeIndividual((ISpeciesType)SpeciesUtil.TREE_TYPE.get(), nbt));
    }

    public class TreePollen
    implements IPollen<ITree> {
        private final ITree pollen;

        public TreePollen(ITree pollen) {
            this.pollen = pollen;
        }

        @Override
        public IPollenType<ITree> getType() {
            return TreePollenType.this;
        }

        @Override
        public ITree getPollen() {
            return this.pollen;
        }

        @Override
        @Nullable
        public Tag writeNbt() {
            return SpeciesUtil.serializeIndividual(this.pollen);
        }

        @Override
        public ItemStack createStack() {
            return this.pollen.createStack(TreeLifeStage.POLLEN);
        }
    }
}

