/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.worldgen;

import forestry.api.arboriculture.ITreeGenData;
import forestry.arboriculture.worldgen.FeatureTree;
import forestry.arboriculture.worldgen.TreeBlockTypeLeaf;
import forestry.arboriculture.worldgen.TreeBlockTypeLog;
import forestry.arboriculture.worldgen.TreeContour;
import forestry.core.worldgen.FeatureHelper;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;

public class FeatureCherryVanilla
extends FeatureTree {
    private static final float WIDE_BOTTOM_LAYER_HOLE_CHANCE = 0.25f;
    private static final float CORNER_HOLE_CHANCE = 0.25f;
    private static final float HANGING_LEAVES_CHANCE = 0.16666667f;
    private static final float HANGING_LEAVES_EXTENSION_CHANCE = 0.33333334f;

    public FeatureCherryVanilla(ITreeGenData data) {
        super(data, 7, 1);
    }

    @Override
    public Set<BlockPos> generateTrunk(LevelAccessor level, RandomSource rand, TreeBlockTypeLog wood, BlockPos startPos) {
        boolean multipleBranches;
        int branchCount;
        wood.setDirection(Direction.UP);
        int i = Math.max(2, this.height - 1 + rand.m_216332_(-4, -3));
        int j = Math.max(1, this.height - 5);
        if (j >= i) {
            ++j;
        }
        boolean middleBranch = (branchCount = 1 + rand.m_188503_(3)) == 3;
        boolean bl = multipleBranches = branchCount >= 2;
        int l = middleBranch ? this.height : (multipleBranches ? Math.max(i, j) + 1 : i + 1);
        BlockPos.MutableBlockPos cursor = startPos.m_122032_();
        for (int i1 = 0; i1 < l; ++i1) {
            FeatureHelper.addBlock(level, (BlockPos)cursor, wood, FeatureHelper.EnumReplaceMode.ALL);
            cursor.m_122184_(0, 1, 0);
        }
        HashSet<BlockPos> branchPositions = new HashSet<BlockPos>();
        if (middleBranch) {
            branchPositions.add(cursor.m_7918_(0, 1, 0));
        }
        cursor.m_122190_((Vec3i)startPos);
        Direction direction = Direction.Plane.HORIZONTAL.m_235690_(rand);
        branchPositions.add(this.generateBranch(level, rand, startPos, wood, direction, i, i < l - 1, cursor));
        if (multipleBranches) {
            branchPositions.add(this.generateBranch(level, rand, startPos, wood, direction.m_122424_(), j, j < l - 1, cursor));
        }
        return branchPositions;
    }

    private BlockPos generateBranch(LevelAccessor level, RandomSource rand, BlockPos pos, TreeBlockTypeLog wood, Direction horizontal, int pSecondBranchStartOffsetFromTop, boolean isLow, BlockPos.MutableBlockPos cursor) {
        Direction vertical;
        cursor.m_122190_((Vec3i)pos).m_122175_(Direction.UP, pSecondBranchStartOffsetFromTop);
        int i = this.height - 1 + rand.m_216332_(-1, 0);
        boolean lowBranch = isLow || i < pSecondBranchStartOffsetFromTop;
        int j = rand.m_216332_(2, 4) + (lowBranch ? 1 : 0);
        BlockPos blockpos = pos.m_5484_(horizontal, j).m_6630_(i);
        int k = lowBranch ? 2 : 1;
        wood.setDirection(horizontal);
        for (int l = 0; l < k; ++l) {
            FeatureHelper.addBlock(level, (BlockPos)cursor.m_122173_(horizontal), wood, FeatureHelper.EnumReplaceMode.ALL);
        }
        Direction direction = vertical = blockpos.m_123342_() > cursor.m_123342_() ? Direction.UP : Direction.DOWN;
        int distance;
        while ((distance = cursor.m_123333_((Vec3i)blockpos)) != 0) {
            float upwardChance = (float)Math.abs(blockpos.m_123342_() - cursor.m_123342_()) / (float)distance;
            boolean upwardGrowth = rand.m_188501_() < upwardChance;
            cursor.m_122173_(upwardGrowth ? vertical : horizontal);
            wood.setDirection(upwardGrowth ? vertical : horizontal);
            FeatureHelper.addBlock(level, (BlockPos)cursor, wood, FeatureHelper.EnumReplaceMode.ALL);
        }
        return blockpos.m_7494_();
    }

    @Override
    protected void generateLeaves(LevelAccessor level, RandomSource rand, TreeBlockTypeLeaf leaf, TreeContour contour, BlockPos startPos) {
        int foliageHeight = 5;
        int foliageRadius = 4;
        boolean wideTrunk = this.girth >= 2;
        for (BlockPos branchEnd : contour.getBranchEnds()) {
            int i = foliageRadius - 1;
            this.placeLeavesRow(level, rand, leaf, contour, branchEnd, i - 2, foliageHeight - 3, wideTrunk);
            this.placeLeavesRow(level, rand, leaf, contour, branchEnd, i - 1, foliageHeight - 4, wideTrunk);
            this.placeLeavesRow(level, rand, leaf, contour, branchEnd, i, 0, wideTrunk);
            this.placeLeavesRowWithHangingLeavesBelow(level, rand, leaf, contour, branchEnd, i, -1, wideTrunk);
            this.placeLeavesRowWithHangingLeavesBelow(level, rand, leaf, contour, branchEnd, i - 1, -2, wideTrunk);
        }
    }

    private void placeLeavesRow(LevelAccessor level, RandomSource rand, TreeBlockTypeLeaf leaf, TreeContour contour, BlockPos pos, int pRange, int y, boolean wideTrunk) {
        int i = wideTrunk ? 1 : 0;
        BlockPos.MutableBlockPos cursor = new BlockPos.MutableBlockPos();
        for (int x = -pRange; x <= pRange + i; ++x) {
            for (int z = -pRange; z <= pRange + i; ++z) {
                if (this.shouldSkipLocationSigned(rand, x, y, z, pRange, wideTrunk)) continue;
                cursor.m_122154_((Vec3i)pos, x, y, z);
                FeatureHelper.addBlock(level, (BlockPos)cursor, leaf, FeatureHelper.EnumReplaceMode.AIR, contour);
            }
        }
    }

    protected boolean shouldSkipLocationSigned(RandomSource pRandom, int x, int y, int z, int pRange, boolean wideTrunk) {
        int adjustedZ;
        int adjustedX;
        if (wideTrunk) {
            adjustedX = Math.min(Math.abs(x), Math.abs(x - 1));
            adjustedZ = Math.min(Math.abs(z), Math.abs(z - 1));
        } else {
            adjustedX = Math.abs(x);
            adjustedZ = Math.abs(z);
        }
        return this.shouldSkipLocation(pRandom, adjustedX, y, adjustedZ, pRange);
    }

    protected boolean shouldSkipLocation(RandomSource rand, int x, int y, int z, int range) {
        boolean wide;
        if (y == -1 && (x == range || z == range) && rand.m_188501_() < 0.25f) {
            return true;
        }
        boolean isEdge = x == range && z == range;
        boolean bl = wide = range > 2;
        if (wide) {
            return isEdge || x + z > range * 2 - 2 && rand.m_188501_() < 0.25f;
        }
        return isEdge && rand.m_188501_() < 0.25f;
    }

    protected void placeLeavesRowWithHangingLeavesBelow(LevelAccessor level, RandomSource rand, TreeBlockTypeLeaf leaf, TreeContour contour, BlockPos pos, int range, int y, boolean wideTrunk) {
        this.placeLeavesRow(level, rand, leaf, contour, pos, range, y, wideTrunk);
        int i = wideTrunk ? 1 : 0;
        BlockPos below = pos.m_7495_();
        BlockPos.MutableBlockPos cursor = new BlockPos.MutableBlockPos();
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            Direction right = direction.m_122427_();
            int j = right.m_122421_() == Direction.AxisDirection.POSITIVE ? range + i : range;
            cursor.m_122154_((Vec3i)pos, 0, y - 1, 0).m_122175_(right, j).m_122175_(direction, -range);
            for (int k = -range; k < range + i; ++k) {
                boolean hasLeafAbove = contour.hasLeaf((BlockPos)cursor.m_122173_(Direction.UP));
                cursor.m_122173_(Direction.DOWN);
                if (hasLeafAbove && cursor.m_123333_((Vec3i)below) < 7 && rand.m_188501_() <= 0.16666667f) {
                    FeatureHelper.addBlock(level, (BlockPos)cursor, leaf, FeatureHelper.EnumReplaceMode.AIR);
                    cursor.m_122173_(Direction.DOWN);
                    if (cursor.m_123333_((Vec3i)below) < 7 && rand.m_188501_() <= 0.33333334f) {
                        FeatureHelper.addBlock(level, (BlockPos)cursor, leaf, FeatureHelper.EnumReplaceMode.AIR);
                    }
                    cursor.m_122173_(Direction.UP);
                }
                cursor.m_122173_(direction);
            }
        }
    }
}

