/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.commands;

import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import forestry.Forestry;
import forestry.api.IForestryApi;
import forestry.api.genetics.IGeneticManager;
import forestry.api.genetics.ISpecies;
import forestry.api.genetics.ISpeciesType;
import forestry.api.genetics.alleles.BeeChromosomes;
import forestry.api.genetics.alleles.ButterflyChromosomes;
import forestry.api.genetics.alleles.IAllele;
import forestry.api.genetics.alleles.IBooleanChromosome;
import forestry.api.genetics.alleles.IChromosome;
import forestry.api.genetics.alleles.IKaryotype;
import forestry.core.utils.SpeciesUtil;
import forestry.core.utils.Translator;
import java.util.Collection;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.loading.FMLEnvironment;

public class DiagnosticsCommand {
    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return Commands.m_82127_((String)"diagnostics").executes(DiagnosticsCommand::diagnostics);
    }

    private static int diagnostics(CommandContext<CommandSourceStack> ctx) {
        CommandSourceStack source = (CommandSourceStack)ctx.getSource();
        source.m_243053_((Component)Component.m_237113_((String)"Running Forestry diagnostics..."));
        IGeneticManager genetics = IForestryApi.INSTANCE.getGeneticManager();
        ISpeciesType[] types = (ISpeciesType[])genetics.getSpeciesTypes().toArray(ISpeciesType[]::new);
        Forestry.LOGGER.info("Found {} species types", (Object)types.length);
        for (ISpeciesType type : types) {
            List allSpecies = type.getAllSpecies();
            Forestry.LOGGER.info("Species type {} has {} registered species", (Object)type.id(), (Object)allSpecies.size());
            for (ISpecies species : allSpecies) {
                if (FMLEnvironment.dist != Dist.CLIENT) continue;
                if (!Translator.canTranslateToLocal(species.getTranslationKey())) {
                    Forestry.LOGGER.error(species.id() + " is missing a translated name");
                }
                if (species.getType() != SpeciesUtil.BEE_TYPE.get() || Translator.canTranslateToLocal(species.getDescriptionTranslationKey())) continue;
                Forestry.LOGGER.error(species.id() + " is missing a description");
            }
            if (FMLEnvironment.dist != Dist.CLIENT) continue;
            IKaryotype karyotype = type.getKaryotype();
            for (IChromosome chromosome : karyotype.getChromosomes()) {
                if (chromosome == karyotype.getSpeciesChromosome() || chromosome instanceof IBooleanChromosome || chromosome == BeeChromosomes.FERTILITY || chromosome == ButterflyChromosomes.FERTILITY) continue;
                Collection alleles = karyotype.getAlleles(chromosome);
                Forestry.LOGGER.info("Chromosome {} has {} alleles", (Object)chromosome.id(), (Object)alleles.size());
                for (IAllele allele : alleles) {
                    String translationKey = chromosome.getTranslationKey(allele.cast());
                    if (Translator.canTranslateToLocal(translationKey)) continue;
                    Forestry.LOGGER.error("Allele for chromosome {} is missing a translation - {}", (Object)chromosome.id(), (Object)translationKey);
                }
            }
        }
        source.m_243053_((Component)Component.m_237113_((String)"Diagnostics complete. Check log for details"));
        return 0;
    }
}

