/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.data.builder;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import forestry.factory.features.FactoryRecipeTypes;
import forestry.factory.recipes.RecipeSerializers;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraftforge.fluids.FluidStack;

public class HygroregulatorRecipeBuilder {
    private FluidStack liquid;
    private int humiditySteps;
    private int temperatureSteps;
    private int retainTime;

    public HygroregulatorRecipeBuilder setLiquid(FluidStack liquid) {
        this.liquid = liquid;
        return this;
    }

    public HygroregulatorRecipeBuilder setHumiditySteps(int humiditySteps) {
        this.humiditySteps = humiditySteps;
        return this;
    }

    public HygroregulatorRecipeBuilder setTemperatureSteps(int temperatureSteps) {
        this.temperatureSteps = temperatureSteps;
        return this;
    }

    public HygroregulatorRecipeBuilder setRetainTime(int retainTime) {
        this.retainTime = retainTime;
        return this;
    }

    public void build(Consumer<FinishedRecipe> consumer, ResourceLocation id) {
        consumer.accept(new Result(id, this.liquid, this.retainTime, this.humiditySteps, this.temperatureSteps));
    }

    private static class Result
    implements FinishedRecipe {
        private final ResourceLocation id;
        private final FluidStack liquid;
        private final byte humiditySteps;
        private final byte temperatureSteps;
        private final int retainTime;

        public Result(ResourceLocation id, FluidStack liquid, int retainTime, int humiditySteps, int temperatureSteps) {
            this.id = id;
            this.liquid = liquid;
            this.retainTime = retainTime;
            this.humiditySteps = (byte)humiditySteps;
            this.temperatureSteps = (byte)temperatureSteps;
        }

        public void m_7917_(JsonObject json) {
            json.add("liquid", (JsonElement)RecipeSerializers.serializeFluid(this.liquid));
            json.addProperty("time", (Number)this.retainTime);
            json.addProperty("humidity_steps", (Number)this.humiditySteps);
            json.addProperty("temperature_steps", (Number)this.temperatureSteps);
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        public RecipeSerializer<?> m_6637_() {
            return FactoryRecipeTypes.HYGROREGULATOR.serializer();
        }

        @Nullable
        public JsonObject m_5860_() {
            return null;
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return null;
        }
    }
}

