/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.data.models;

import com.google.common.collect.Iterables;
import forestry.api.ForestryConstants;
import forestry.api.modules.ForestryModuleIds;
import forestry.apiculture.features.ApicultureItems;
import forestry.core.data.builder.FilledCrateModelBuilder;
import forestry.core.data.models.ForestryBlockStateProvider;
import forestry.core.fluids.ForestryFluids;
import forestry.core.utils.ModUtil;
import forestry.cultivation.blocks.BlockTypePlanter;
import forestry.cultivation.features.CultivationBlocks;
import forestry.lepidopterology.features.LepidopterologyItems;
import forestry.modules.features.FeatureBlock;
import forestry.modules.features.FeatureItem;
import forestry.modules.features.ModFeatureRegistry;
import forestry.storage.features.CrateItems;
import forestry.storage.items.ItemBackpack;
import forestry.storage.items.ItemCrated;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemNameBlockItem;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.loaders.DynamicFluidContainerModelBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.RegistryObject;

public class ForestryItemModelProvider
extends ItemModelProvider {
    public ForestryItemModelProvider(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "forestry", existingFileHelper);
    }

    protected void registerModels() {
        ((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(LepidopterologyItems.CATERPILLAR_GE.getName(), this.mcLoc("item/generated"))).texture("layer0", ForestryConstants.forestry("item/caterpillar.body2"))).texture("layer1", ForestryConstants.forestry("item/caterpillar.body"));
        ((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(LepidopterologyItems.SERUM_GE.getName(), this.mcLoc("item/generated"))).texture("layer0", ForestryConstants.forestry("item/liquids/jar.bottle"))).texture("layer1", ForestryConstants.forestry("item/liquids/jar.contents"));
        for (FeatureItem<ItemCrated> featureCrated : CrateItems.getCrates()) {
            Item containedItem = ((ItemCrated)featureCrated.get()).getContained().m_41720_();
            String string = featureCrated.getName();
            if (ApicultureItems.BEE_COMBS.itemEqual(containedItem)) {
                this.filledCrateModelLayered(string, this.modLoc("item/bee_combs.0"), this.modLoc("item/bee_combs.1"));
                continue;
            }
            if (ApicultureItems.POLLEN_CLUSTER.itemEqual(containedItem)) {
                this.filledCrateModelLayered(string, this.modLoc("item/pollen.0"), this.modLoc("item/pollen.1"));
                continue;
            }
            ResourceLocation contained = ModUtil.getRegistryName(containedItem);
            ResourceLocation contentsTexture = containedItem instanceof BlockItem && !(containedItem instanceof ItemNameBlockItem) ? new ResourceLocation(contained.m_135827_(), "block/" + contained.m_135815_()) : new ResourceLocation(contained.m_135827_(), "item/" + contained.m_135815_());
            this.filledCrateModel(string, contentsTexture);
        }
        this.basicItem((Item)ApicultureItems.FRAME_CREATIVE.get());
        this.filledCrateModel(CrateItems.CRATED_CACTUS.getName(), this.mcLoc("block/cactus_side"));
        this.filledCrateModel(CrateItems.CRATED_MYCELIUM.getName(), this.mcLoc("block/mycelium_side"));
        this.filledCrateModel(CrateItems.CRATED_GRASS_BLOCK.getName(), this.mcLoc("block/grass_block_top"));
        this.filledCrateModel(CrateItems.CRATED_PROPOLIS.getName(), this.modLoc("item/propolis.0"));
        for (Map.Entry cell : Iterables.concat((Iterable)CultivationBlocks.MANAGED_PLANTER.getFeatureByType().entrySet(), (Iterable)CultivationBlocks.MANUAL_PLANTER.getFeatureByType().entrySet())) {
            Object block = ((FeatureBlock)cell.getValue()).block();
            this.withExistingParent(ForestryBlockStateProvider.path(block), ForestryConstants.forestry("block/" + ((BlockTypePlanter)cell.getKey()).m_7912_()));
        }
        for (Iterator<FeatureItem<ItemCrated>> iterator : ForestryFluids.values()) {
            BucketItem item = ((ForestryFluids)((Object)iterator)).getBucket();
            if (item == null) continue;
            ((ItemModelBuilder)((DynamicFluidContainerModelBuilder)((ItemModelBuilder)this.getBuilder(ForestryItemModelProvider.path((Item)item))).customLoader(DynamicFluidContainerModelBuilder::begin)).fluid(((ForestryFluids)((Object)iterator)).getFluid()).end()).parent((ModelFile)this.getExistingFile(new ResourceLocation("forge:item/bucket")));
        }
        for (RegistryObject object : ModFeatureRegistry.get(ForestryModuleIds.STORAGE).getRegistry(Registries.f_256913_).getEntries()) {
            String path;
            if (!(object.get() instanceof ItemBackpack)) continue;
            boolean bl = (path = object.getId().m_135815_()).endsWith("woven");
            ((ItemModelBuilder)this.withExistingParent(path, bl ? this.modLoc("item/backpack/woven_neutral") : this.modLoc("item/backpack/normal_neutral"))).override().predicate(this.mcLoc("mode"), 1.0f).model((ModelFile)ForestryBlockStateProvider.file(bl ? this.modLoc("item/backpack/woven_locked") : this.modLoc("item/backpack/normal_locked"))).end().override().predicate(this.mcLoc("mode"), 2.0f).model((ModelFile)ForestryBlockStateProvider.file(bl ? this.modLoc("item/backpack/woven_receive") : this.modLoc("item/backpack/normal_receive"))).end().override().predicate(this.mcLoc("mode"), 3.0f).model((ModelFile)ForestryBlockStateProvider.file(bl ? this.modLoc("item/backpack/woven_resupply") : this.modLoc("item/backpack/normal_resupply"))).end();
        }
    }

    private static String path(Item block) {
        return ModUtil.getRegistryName(block).m_135815_();
    }

    private void filledCrateModel(String id, ResourceLocation texture) {
        ((FilledCrateModelBuilder)((ItemModelBuilder)this.getBuilder(id)).customLoader(FilledCrateModelBuilder::begin)).layer1(texture).end();
    }

    private void filledCrateModelLayered(String id, ResourceLocation layer1, ResourceLocation layer2) {
        ((FilledCrateModelBuilder)((ItemModelBuilder)this.getBuilder(id)).customLoader(FilledCrateModelBuilder::begin)).layer1(layer1).layer2(layer2).end();
    }
}

