/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.genetics;

import com.google.common.collect.ImmutableMap;
import forestry.api.genetics.pollen.IPollen;
import forestry.api.genetics.pollen.IPollenManager;
import forestry.api.genetics.pollen.IPollenType;
import java.util.Collection;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.LevelAccessor;
import org.jetbrains.annotations.Nullable;

public class PollenManager
implements IPollenManager {
    private final ImmutableMap<ResourceLocation, IPollenType<?>> types;

    public PollenManager(ImmutableMap<ResourceLocation, IPollenType<?>> types) {
        this.types = types;
    }

    @Override
    public boolean canPollinate(LevelAccessor level, BlockPos pos, @Nullable Object pollinator) {
        for (IPollenType type : this.types.values()) {
            if (!type.canPollinate(level, pos, pollinator)) continue;
            return true;
        }
        return false;
    }

    @Override
    @javax.annotation.Nullable
    public IPollen<?> getPollen(LevelAccessor level, BlockPos pos, @javax.annotation.Nullable Object pollinator) {
        for (IPollenType type : this.types.values()) {
            IPollen pollen = type.tryCollectPollen(level, pos, pollinator);
            if (pollen == null) continue;
            return pollen;
        }
        return null;
    }

    @Override
    @javax.annotation.Nullable
    public IPollen<?> getPollenOfType(LevelAccessor level, BlockPos pos, @javax.annotation.Nullable Object pollinator, Set<ResourceLocation> pollenTypes) {
        for (ResourceLocation id : pollenTypes) {
            IPollen pollen;
            IPollenType type = (IPollenType)this.types.get((Object)id);
            if (type == null || (pollen = type.tryCollectPollen(level, pos, pollinator)) == null) continue;
            return pollen;
        }
        return null;
    }

    @Override
    @javax.annotation.Nullable
    public IPollenType<?> getPollenType(ResourceLocation id) {
        return (IPollenType)this.types.get((Object)id);
    }

    @Override
    public Collection<IPollenType<?>> getAllPollenTypes() {
        return this.types.values();
    }
}

