/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui.ledgers;

import forestry.api.client.IForestryClientApi;
import forestry.api.climate.IClimateProvider;
import forestry.api.core.TemperatureType;
import forestry.api.genetics.ClimateHelper;
import forestry.core.gui.ledgers.Ledger;
import forestry.core.gui.ledgers.LedgerManager;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;

public class ClimateLedger
extends Ledger {
    private final IClimateProvider climateProvider;

    public ClimateLedger(LedgerManager manager, IClimateProvider climateProvider) {
        super(manager, "climate");
        this.climateProvider = climateProvider;
        this.maxHeight = 72;
    }

    @Override
    public void draw(GuiGraphics graphics, int y, int x) {
        TemperatureType temperature = this.climateProvider.temperature();
        this.drawBackground(graphics, y, x);
        this.drawSprite(graphics, IForestryClientApi.INSTANCE.getTextureManager().getSprite(temperature), x + 3, y + 4);
        if (!this.isFullyOpened()) {
            return;
        }
        this.drawHeader(graphics, (Component)Component.m_237115_((String)"for.gui.climate"), x + 22, y + 8);
        this.drawSubheader(graphics, (Component)Component.m_237115_((String)"for.gui.temperature").m_130946_(":"), x + 22, y + 20);
        this.drawText(graphics, ClimateHelper.toDisplay(temperature).getString(), x + 22, y + 32);
        this.drawSubheader(graphics, (Component)Component.m_237115_((String)"for.gui.humidity").m_130946_(":"), x + 22, y + 44);
        this.drawText(graphics, ClimateHelper.toDisplay(this.climateProvider.humidity()).getString(), x + 22, y + 56);
    }

    @Override
    public Component getTooltip() {
        return Component.m_237113_((String)"T: ").m_7220_((Component)ClimateHelper.toDisplay(this.climateProvider.temperature())).m_7220_((Component)Component.m_237113_((String)" / H: ")).m_7220_((Component)ClimateHelper.toDisplay(this.climateProvider.humidity()));
    }
}

