/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui.widgets;

import forestry.api.core.tooltips.ToolTip;
import forestry.core.gui.GuiUtil;
import forestry.core.gui.widgets.Widget;
import forestry.core.gui.widgets.WidgetManager;
import forestry.core.utils.ItemTooltipUtil;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class ItemStackWidgetBase
extends Widget {
    public ItemStackWidgetBase(WidgetManager widgetManager, int xPos, int yPos) {
        super(widgetManager, xPos, yPos);
    }

    protected abstract ItemStack getItemStack();

    @Override
    public void draw(GuiGraphics graphics, int startX, int startY) {
        ItemStack itemStack = this.getItemStack();
        if (!itemStack.m_41619_()) {
            GuiUtil.drawItemStack(graphics, this.manager.gui, itemStack, this.xPos + startX, this.yPos + startY);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ToolTip getToolTip(int mouseX, int mouseY) {
        ItemStack itemStack = this.getItemStack();
        ToolTip tip = new ToolTip();
        if (!itemStack.m_41619_()) {
            tip.addAll(ItemTooltipUtil.getInformation(itemStack));
        }
        return tip;
    }
}

