/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.items;

import forestry.core.items.ItemProperties;
import forestry.core.utils.ItemTooltipUtil;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemBlockForestry<B extends Block>
extends BlockItem {
    private final int burnTime;

    public ItemBlockForestry(B block, Item.Properties builder) {
        super(block, builder);
        if (builder instanceof ItemProperties) {
            ItemProperties properties = (ItemProperties)builder;
            this.burnTime = properties.burnTime;
        } else {
            this.burnTime = -1;
        }
    }

    public ItemBlockForestry(B block) {
        this(block, new Item.Properties());
    }

    public B m_40614_() {
        return (B)super.m_40614_();
    }

    public int getBurnTime(ItemStack itemStack, @Nullable RecipeType<?> recipeType) {
        return this.burnTime;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag advanced) {
        super.m_7373_(stack, world, tooltip, advanced);
        ItemTooltipUtil.addInformation(stack, world, tooltip, advanced);
    }
}

