/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.models;

import com.google.common.base.Preconditions;
import forestry.core.models.baker.ModelBaker;
import forestry.core.models.baker.ModelBakerModel;
import forestry.core.utils.ResourceUtil;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.ModelData;

public abstract class ModelBlockDefault<B extends Block, K>
implements BakedModel {
    @Nullable
    private ItemOverrides overrideList;
    protected final Class<B> blockClass;
    @Nullable
    protected ModelBakerModel blockModel;
    @Nullable
    protected ModelBakerModel itemModel;

    protected ModelBlockDefault(Class<B> blockClass) {
        this.blockClass = blockClass;
    }

    protected BakedModel bakeModel(BlockState state, K key, B block, ModelData extraData) {
        ModelBaker baker = new ModelBaker();
        this.bakeBlock(block, extraData, key, baker, false);
        this.blockModel = baker.bake(false);
        this.onCreateModel(this.blockModel);
        return this.blockModel;
    }

    protected BakedModel getModel(BlockState state, ModelData extraData) {
        Preconditions.checkArgument((boolean)this.blockClass.isInstance(state.m_60734_()));
        K worldKey = this.getWorldKey(state, extraData);
        Block block = (Block)this.blockClass.cast(state.m_60734_());
        return this.bakeModel(state, worldKey, block, extraData);
    }

    protected BakedModel bakeModel(ItemStack stack, Level world, K key) {
        ModelBaker baker = new ModelBaker();
        Block block = Block.m_49814_((Item)stack.m_41720_());
        Preconditions.checkArgument((boolean)this.blockClass.isInstance(block));
        Block bBlock = (Block)this.blockClass.cast(block);
        this.bakeBlock(bBlock, ModelData.EMPTY, key, baker, true);
        this.itemModel = baker.bake(true);
        return this.itemModel;
    }

    protected BakedModel getModel(ItemStack stack, Level world) {
        return this.bakeModel(stack, world, this.getInventoryKey(stack));
    }

    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull RandomSource rand, @Nonnull ModelData extraData, @Nullable RenderType renderType) {
        Preconditions.checkNotNull((Object)state);
        BakedModel model = this.getModel(state, extraData);
        return model.getQuads(state, side, rand, extraData, renderType);
    }

    public List<BakedQuad> m_213637_(@Nullable BlockState state, @Nullable Direction side, RandomSource rand) {
        return this.getQuads(state, side, rand, ModelData.EMPTY, null);
    }

    protected void onCreateModel(ModelBakerModel model) {
        model.setAmbientOcclusion(true);
    }

    public boolean m_7541_() {
        return (this.itemModel != null || this.blockModel != null) && (this.blockModel != null ? this.blockModel.m_7541_() : this.itemModel.m_7541_());
    }

    public boolean m_7539_() {
        return this.itemModel != null && this.itemModel.m_7539_();
    }

    public boolean m_7521_() {
        return (this.itemModel != null || this.blockModel != null) && (this.blockModel != null ? this.blockModel.m_7521_() : this.itemModel.m_7521_());
    }

    public boolean m_7547_() {
        return this.itemModel != null && this.itemModel.m_7547_();
    }

    public TextureAtlasSprite m_6160_() {
        if (this.blockModel != null) {
            return this.blockModel.m_6160_();
        }
        return ResourceUtil.getMissingTexture();
    }

    public ItemTransforms m_7442_() {
        if (this.itemModel == null) {
            return ItemTransforms.f_111786_;
        }
        return this.itemModel.m_7442_();
    }

    protected ItemOverrides createOverrides() {
        return new DefaultItemOverrideList();
    }

    public ItemOverrides m_7343_() {
        if (this.overrideList == null) {
            this.overrideList = this.createOverrides();
        }
        return this.overrideList;
    }

    protected abstract K getInventoryKey(ItemStack var1);

    protected abstract K getWorldKey(BlockState var1, ModelData var2);

    protected abstract void bakeBlock(B var1, ModelData var2, K var3, ModelBaker var4, boolean var5);

    private class DefaultItemOverrideList
    extends ItemOverrides {
        @Nullable
        public BakedModel m_173464_(BakedModel originalModel, ItemStack stack, @Nullable ClientLevel world, @Nullable LivingEntity entity, int p_173469_) {
            if (world == null) {
                world = Minecraft.m_91087_().f_91073_;
            }
            return ModelBlockDefault.this.getModel(stack, (Level)world);
        }
    }
}

