/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.multiblock;

import com.mojang.authlib.GameProfile;
import forestry.api.core.ILocationProvider;
import forestry.api.core.ISpectacleBlock;
import forestry.api.multiblock.IMultiblockController;
import forestry.api.multiblock.IMultiblockLogic;
import forestry.api.multiblock.MultiblockTileEntityBase;
import forestry.core.config.Constants;
import forestry.core.inventory.FakeInventoryAdapter;
import forestry.core.inventory.IInventoryAdapter;
import forestry.core.multiblock.IMultiblockControllerInternal;
import forestry.core.tiles.IFilterSlotDelegate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.network.NetworkHooks;

public abstract class MultiblockTileEntityForestry<T extends IMultiblockLogic>
extends MultiblockTileEntityBase<T>
implements WorldlyContainer,
IFilterSlotDelegate,
ILocationProvider,
MenuProvider,
ISpectacleBlock {
    @Nullable
    private GameProfile owner;

    public MultiblockTileEntityForestry(BlockEntityType<?> tileEntityType, BlockPos pos, BlockState state, T multiblockLogic) {
        super(tileEntityType, pos, state, multiblockLogic);
    }

    public void openGui(ServerPlayer player, BlockPos pos) {
        NetworkHooks.openScreen((ServerPlayer)player, (MenuProvider)this, (BlockPos)pos);
    }

    @Override
    public void m_142466_(CompoundTag data) {
        super.m_142466_(data);
        if (data.m_128441_("owner")) {
            CompoundTag ownerNbt = data.m_128469_("owner");
            this.owner = NbtUtils.m_129228_((CompoundTag)ownerNbt);
        }
        this.getInternalInventory().read(data);
    }

    @Override
    public void m_183515_(CompoundTag data) {
        super.m_183515_(data);
        if (this.owner != null) {
            CompoundTag nbt = new CompoundTag();
            NbtUtils.m_129230_((CompoundTag)nbt, (GameProfile)this.owner);
            data.m_128365_("owner", (Tag)nbt);
        }
        this.getInternalInventory().write(data);
    }

    public IInventoryAdapter getInternalInventory() {
        return FakeInventoryAdapter.INSTANCE;
    }

    public boolean allowsAutomation() {
        return false;
    }

    public boolean m_7983_() {
        return this.getInternalInventory().m_7983_();
    }

    public final int m_6643_() {
        return this.getInternalInventory().m_6643_();
    }

    public final ItemStack m_8020_(int slotIndex) {
        return this.getInternalInventory().m_8020_(slotIndex);
    }

    public final ItemStack m_7407_(int slotIndex, int amount) {
        return this.getInternalInventory().m_7407_(slotIndex, amount);
    }

    public ItemStack m_8016_(int slotIndex) {
        return this.getInternalInventory().m_8016_(slotIndex);
    }

    public final void m_6836_(int slotIndex, ItemStack itemstack) {
        this.getInternalInventory().m_6836_(slotIndex, itemstack);
    }

    public final int m_6893_() {
        return this.getInternalInventory().m_6893_();
    }

    public final void m_5856_(Player player) {
        this.getInternalInventory().m_5856_(player);
    }

    public final void m_5785_(Player player) {
        this.getInternalInventory().m_5785_(player);
    }

    public final boolean m_6542_(Player player) {
        return this.getInternalInventory().m_6542_(player);
    }

    public final boolean m_7013_(int slotIndex, ItemStack itemStack) {
        return this.getInternalInventory().m_7013_(slotIndex, itemStack);
    }

    public int[] m_7071_(Direction side) {
        if (this.allowsAutomation()) {
            return this.getInternalInventory().m_7071_(side);
        }
        return Constants.SLOTS_NONE;
    }

    public final boolean m_7155_(int slotIndex, ItemStack itemStack, Direction side) {
        return this.allowsAutomation() && this.getInternalInventory().m_7155_(slotIndex, itemStack, side);
    }

    public final boolean m_7157_(int slotIndex, ItemStack itemStack, Direction side) {
        return this.allowsAutomation() && this.getInternalInventory().m_7157_(slotIndex, itemStack, side);
    }

    @Override
    public final boolean canSlotAccept(int slotIndex, ItemStack stack) {
        return this.getInternalInventory().canSlotAccept(slotIndex, stack);
    }

    @Override
    public final boolean isLocked(int slotIndex) {
        return this.getInternalInventory().isLocked(slotIndex);
    }

    @Override
    @Nullable
    public final Level getWorldObj() {
        return this.f_58857_;
    }

    @Override
    @Nullable
    public final GameProfile getOwner() {
        return this.owner;
    }

    public final void setOwner(GameProfile owner) {
        this.owner = owner;
    }

    public void m_6211_() {
        this.getInternalInventory().m_6211_();
    }

    @Override
    public boolean isHighlighted(Player player) {
        IMultiblockControllerInternal internal;
        IMultiblockController iMultiblockController;
        return player.m_7500_() && (iMultiblockController = this.getMultiblockLogic().getController()) instanceof IMultiblockControllerInternal && this.f_58858_.equals((Object)(internal = (IMultiblockControllerInternal)iMultiblockController).getReferenceCoord());
    }
}

