/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.tiles;

import forestry.api.IForestryApi;
import forestry.api.client.ForestrySprites;
import forestry.api.core.INbtWritable;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.ISpecies;
import forestry.api.genetics.ISpeciesType;
import forestry.core.network.IStreamable;
import forestry.core.utils.ColourUtil;
import forestry.core.utils.NetworkUtil;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class EscritoireGameToken
implements INbtWritable,
IStreamable {
    @Nullable
    private ISpeciesType<? extends ISpecies<?>, ?> tokenType;
    @Nullable
    private IIndividual tokenIndividual;
    private ItemStack tokenStack = ItemStack.f_41583_;
    private State state = State.UNREVEALED;

    public EscritoireGameToken(FriendlyByteBuf data) {
        this.readData(data);
    }

    public EscritoireGameToken(ISpecies<?> species) {
        this.setTokenSpecies(species);
    }

    public EscritoireGameToken(CompoundTag nbt) {
        this.read(nbt);
    }

    private void setTokenSpecies(ResourceLocation typeId, ResourceLocation speciesId) {
        if (this.tokenType != null && typeId == this.tokenType.id()) {
            this.setTokenSpecies(this.tokenType.getSpecies(speciesId));
        } else {
            ISpeciesType<?, ?> type = IForestryApi.INSTANCE.getGeneticManager().getSpeciesType(typeId);
            this.setTokenSpecies((ISpecies<?>)type.getSpecies(speciesId));
        }
    }

    private void setTokenSpecies(ISpecies<?> species) {
        this.tokenIndividual = species.createIndividual();
        this.tokenType = species.getType();
        this.tokenStack = species.createStack(species.getType().getDefaultStage());
    }

    public ItemStack getTokenStack() {
        return this.tokenStack;
    }

    public boolean isVisible() {
        return this.state != State.UNREVEALED;
    }

    public boolean isProbed() {
        return this.state == State.PROBED;
    }

    public boolean isMatched() {
        return this.state == State.MATCHED;
    }

    public boolean isSelected() {
        return this.state == State.SELECTED;
    }

    public void setFailed() {
        this.state = State.FAILED;
    }

    public void setProbed(boolean probed) {
        this.state = probed ? State.PROBED : State.UNREVEALED;
    }

    public void setSelected() {
        this.state = State.SELECTED;
    }

    public void setMatched() {
        this.state = State.MATCHED;
    }

    public int getTokenColour() {
        if (this.tokenIndividual == null || !this.isVisible()) {
            return 0xFFFFFF;
        }
        int iconColor = this.tokenIndividual.getSpecies().getEscritoireColor();
        if (this.state == State.MATCHED) {
            return ColourUtil.multiplyRGBComponents(iconColor, 0.7f);
        }
        return iconColor;
    }

    public Component getTooltip() {
        return !this.tokenStack.m_41619_() ? this.tokenStack.m_41786_() : Component.m_237115_((String)"for.gui.unknown");
    }

    @Nullable
    public ResourceLocation getOverlayToken() {
        return switch (this.state) {
            case State.FAILED -> ForestrySprites.ERROR_ERRORED;
            case State.SELECTED -> ForestrySprites.ERROR_UNKNOWN;
            default -> null;
        };
    }

    public boolean matches(EscritoireGameToken other) {
        return ItemStack.m_41728_((ItemStack)this.tokenStack, (ItemStack)other.getTokenStack());
    }

    @Override
    public CompoundTag write(CompoundTag nbt) {
        nbt.m_128405_("state", this.state.ordinal());
        if (this.tokenIndividual != null) {
            nbt.m_128359_("tokenSpecies", this.tokenIndividual.getSpecies().id().toString());
        }
        return nbt;
    }

    private void read(CompoundTag nbt) {
        if (nbt.m_128441_("state")) {
            int stateOrdinal = nbt.m_128451_("state");
            this.state = State.VALUES[stateOrdinal];
        }
        String tokenSpecies = nbt.m_128461_("tokenSpecies");
        String tokenType = nbt.m_128461_("tokenSpeciesType");
        if (!tokenSpecies.isEmpty() && !tokenType.isEmpty()) {
            this.setTokenSpecies(new ResourceLocation(tokenType), new ResourceLocation(tokenSpecies));
        }
    }

    @Override
    public void writeData(FriendlyByteBuf data) {
        NetworkUtil.writeEnum(data, this.state);
        if (this.tokenIndividual != null && this.tokenType != null) {
            data.writeBoolean(true);
            data.m_130085_(this.tokenIndividual.getSpecies().id());
            data.m_130085_(this.tokenType.id());
        } else {
            data.writeBoolean(false);
        }
    }

    @Override
    public void readData(FriendlyByteBuf data) {
        this.state = (State)NetworkUtil.readEnum((FriendlyByteBuf)data, (Enum[])State.VALUES);
        if (data.readBoolean()) {
            ResourceLocation speciesId = data.m_130281_();
            ResourceLocation typeId = data.m_130281_();
            this.setTokenSpecies(typeId, speciesId);
        }
    }

    private static enum State {
        UNREVEALED,
        PROBED,
        SELECTED,
        MATCHED,
        FAILED;

        public static final State[] VALUES;

        static {
            VALUES = State.values();
        }
    }
}

