/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.tiles;

import com.mojang.authlib.GameProfile;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.ISpecies;
import forestry.api.genetics.ISpeciesType;
import forestry.api.genetics.capability.IIndividualHandlerItem;
import forestry.core.features.CoreTiles;
import forestry.core.gui.ContainerEscritoire;
import forestry.core.inventory.InventoryEscritoire;
import forestry.core.inventory.watchers.ISlotPickupWatcher;
import forestry.core.network.IStreamableGui;
import forestry.core.network.packets.PacketItemStackDisplay;
import forestry.core.tiles.EscritoireGame;
import forestry.core.tiles.IItemStackDisplay;
import forestry.core.tiles.TileBase;
import forestry.core.utils.InventoryUtil;
import forestry.core.utils.NetworkUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class TileEscritoire
extends TileBase
implements WorldlyContainer,
ISlotPickupWatcher,
IStreamableGui,
IItemStackDisplay {
    private final EscritoireGame game = new EscritoireGame();
    private ItemStack individualOnDisplayClient = ItemStack.f_41583_;

    public TileEscritoire(BlockPos pos, BlockState state) {
        super(CoreTiles.ESCRITOIRE.tileType(), pos, state);
        this.setInternalInventory(new InventoryEscritoire(this));
    }

    @Override
    public void m_142466_(CompoundTag compoundNBT) {
        super.m_142466_(compoundNBT);
        this.game.read(compoundNBT);
    }

    @Override
    public void m_183515_(CompoundTag compoundNBT) {
        super.m_183515_(compoundNBT);
        this.game.write(compoundNBT);
    }

    public EscritoireGame getGame() {
        return this.game;
    }

    public void choose(GameProfile gameProfile, int index) {
        this.game.choose(index);
        this.processTurnResult(gameProfile);
    }

    private void processTurnResult(GameProfile gameProfile) {
        if (this.getGame().getStatus() != EscritoireGame.Status.SUCCESS) {
            return;
        }
        IIndividual individual = IIndividualHandlerItem.getIndividual(this.m_8020_(0));
        if (individual == null) {
            return;
        }
        ISpecies<?> species = individual.getSpecies();
        ISpeciesType<ISpecies<?>, ?> root = species.getType();
        for (ItemStack itemstack : root.getResearchBounty((ISpecies<?>)species.cast(), this.f_58857_, gameProfile, individual.cast(), this.game.getBountyLevel())) {
            InventoryUtil.addStack((Container)this.getInternalInventory(), itemstack, 1, 6, true);
        }
    }

    private boolean areProbeSlotsFilled() {
        int filledSlots = 0;
        int required = this.game.getSampleSize(5);
        for (int i = 7; i < 7 + required; ++i) {
            if (this.m_8020_(i).m_41619_()) continue;
            ++filledSlots;
        }
        return filledSlots >= required;
    }

    public void probe() {
        if (this.f_58857_.f_46443_) {
            return;
        }
        ItemStack analyze = this.m_8020_(0);
        if (!analyze.m_41619_() && this.areProbeSlotsFilled()) {
            this.game.probe(analyze, (Container)this, 7, 5);
        }
    }

    @Override
    public void writeGuiData(FriendlyByteBuf data) {
        this.game.writeData(data);
    }

    @Override
    public void readGuiData(FriendlyByteBuf data) {
        this.game.readData(data);
    }

    @Override
    public void writeData(FriendlyByteBuf data) {
        super.writeData(data);
        ItemStack displayStack = this.getIndividualOnDisplay();
        data.m_130055_(displayStack);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void readData(FriendlyByteBuf data) {
        super.readData(data);
        this.individualOnDisplayClient = data.m_130267_();
    }

    @Override
    public void onTake(int slotIndex, Player player) {
        if (slotIndex == 0) {
            this.game.reset();
            PacketItemStackDisplay packet = new PacketItemStackDisplay(this, this.getIndividualOnDisplay());
            NetworkUtil.sendNetworkPacket(packet, this.f_58858_, this.f_58857_);
        }
    }

    @Override
    public void m_6836_(int slotIndex, ItemStack itemstack) {
        super.m_6836_(slotIndex, itemstack);
        if (slotIndex == 0 && this.f_58857_ != null && !this.f_58857_.f_46443_) {
            PacketItemStackDisplay packet = new PacketItemStackDisplay(this, this.getIndividualOnDisplay());
            NetworkUtil.sendNetworkPacket(packet, this.f_58858_, this.f_58857_);
        }
    }

    public AbstractContainerMenu m_7208_(int windowId, Inventory inv, Player player) {
        return new ContainerEscritoire(windowId, player.m_150109_(), this);
    }

    @Override
    public void handleItemStackForDisplay(ItemStack itemStack) {
        if (!ItemStack.m_41728_((ItemStack)itemStack, (ItemStack)this.individualOnDisplayClient)) {
            this.individualOnDisplayClient = itemStack;
        }
    }

    public ItemStack getIndividualOnDisplay() {
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return this.individualOnDisplayClient;
        }
        return this.m_8020_(0);
    }
}

