/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.tiles;

import forestry.core.tiles.TileBase;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public abstract class TileMill
extends TileBase {
    public float speed = 0.01f;
    public int stage = 0;
    public int charge = 0;
    public float progress;

    protected TileMill(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public void clientTick(Level level, BlockPos pos, BlockState state) {
        this.update(level, pos, false);
    }

    @Override
    public void serverTick(Level level, BlockPos pos, BlockState state) {
        this.update(level, pos, true);
    }

    @Override
    public void writeData(FriendlyByteBuf data) {
        super.writeData(data);
        data.writeInt(this.charge);
        data.writeFloat(this.speed);
        data.writeInt(this.stage);
    }

    @Override
    public void readData(FriendlyByteBuf data) {
        super.readData(data);
        this.charge = data.readInt();
        this.speed = data.readFloat();
        this.stage = data.readInt();
    }

    private void update(Level level, BlockPos pos, boolean isSimulating) {
        if (this.charge <= 0) {
            if (this.stage > 0) {
                this.progress += this.speed;
            }
            if ((double)this.progress > 0.5) {
                this.stage = 2;
            }
            if (this.progress > 1.0f) {
                this.progress = 0.0f;
                this.stage = 0;
            }
            return;
        }
        this.progress += this.speed;
        if (this.stage <= 0) {
            this.stage = 1;
        }
        if ((double)this.progress > 0.5 && this.stage == 1) {
            this.stage = 2;
            if (this.charge < 7 && isSimulating) {
                ++this.charge;
                this.sendNetworkUpdate();
            }
        }
        if (this.progress > 1.0f) {
            this.progress = 0.0f;
            this.stage = 0;
            if (this.charge >= 7) {
                this.activate(level, pos);
            }
        }
    }

    protected abstract void activate(Level var1, BlockPos var2);
}

