/*
 * Decompiled with CFR 0.152.
 */
package forestry.cultivation.gui.widgets;

import com.mojang.blaze3d.systems.RenderSystem;
import forestry.api.core.tooltips.ToolTip;
import forestry.api.farming.HorizontalDirection;
import forestry.core.gui.widgets.ItemStackWidget;
import forestry.core.gui.widgets.WidgetManager;
import forestry.core.render.ColourProperties;
import forestry.cultivation.inventory.InventoryPlanter;
import javax.annotation.Nullable;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class GhostItemStackWidget
extends ItemStackWidget {
    private final Slot slot;

    public GhostItemStackWidget(WidgetManager widgetManager, int xPos, int yPos, ItemStack itemStack, Slot slot) {
        super(widgetManager, xPos, yPos, itemStack);
        this.slot = slot;
    }

    @Override
    public void draw(GuiGraphics graphics, int startX, int startY) {
        if (!this.slot.m_6657_()) {
            super.draw(graphics, startX, startY);
        }
        RenderSystem.disableDepthTest();
        RenderSystem.enableBlend();
        Component directionString = this.getDirectionString();
        if (directionString != null) {
            Font font = this.manager.minecraft.f_91062_;
            graphics.m_280430_(font, directionString, this.xPos + startX + 5, this.yPos + startY + 4, ColourProperties.INSTANCE.get("gui.screen"));
        }
        graphics.m_280246_(1.0f, 1.0f, 1.0f, 0.5f);
        graphics.m_280218_(this.manager.gui.textureFile, this.xPos + startX, this.yPos + startY, 206, 0, 16, 16);
        RenderSystem.disableBlend();
        RenderSystem.enableDepthTest();
    }

    @Nullable
    private Component getDirectionString() {
        if (this.slot.getSlotIndex() >= InventoryPlanter.CONFIG.productionStart || this.slot.getSlotIndex() < InventoryPlanter.CONFIG.productionStart + InventoryPlanter.CONFIG.productionCount) {
            return null;
        }
        int index = this.slot.getSlotIndex() % 4;
        Direction direction = HorizontalDirection.VALUES.get(index);
        String directionString = direction.m_7912_();
        return Component.m_237115_((String)("for.gui.planter." + directionString));
    }

    @Override
    @Nullable
    public ToolTip getToolTip(int mouseX, int mouseY) {
        return null;
    }
}

