/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.blocks;

import forestry.core.blocks.BlockBase;
import forestry.core.blocks.IBlockType;
import forestry.core.blocks.IMachineProperties;
import forestry.core.blocks.MachineProperties;
import forestry.core.tiles.IForestryTicker;
import forestry.core.tiles.TileBase;
import forestry.core.tiles.TileMill;
import forestry.core.tiles.TilePowered;
import forestry.factory.features.FactoryTiles;
import forestry.factory.tiles.TileBottler;
import forestry.factory.tiles.TileCarpenter;
import forestry.factory.tiles.TileFermenter;
import forestry.factory.tiles.TileMoistener;
import forestry.factory.tiles.TileSqueezer;
import forestry.factory.tiles.TileStill;
import forestry.modules.features.FeatureTileType;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public enum BlockTypeFactoryTesr implements IBlockType
{
    BOTTLER(FactoryTiles.BOTTLER, "bottler", TileBottler::serverTick),
    CARPENTER(FactoryTiles.CARPENTER, "carpenter", TileCarpenter::serverTick),
    CENTRIFUGE(FactoryTiles.CENTRIFUGE, "centrifuge", TilePowered::serverTick),
    FERMENTER(FactoryTiles.FERMENTER, "fermenter", TileFermenter::serverTick),
    MOISTENER(FactoryTiles.MOISTENER, "moistener", TileMoistener::serverTick),
    SQUEEZER(FactoryTiles.SQUEEZER, "squeezer", TileSqueezer::serverTick),
    STILL(FactoryTiles.STILL, "still", TileStill::serverTick),
    RAINMAKER(FactoryTiles.RAINMAKER, "rainmaker", "textures/block/rainmaker_");

    private final IMachineProperties<?> machineProperties;

    private <T extends TileBase> BlockTypeFactoryTesr(@Nullable FeatureTileType<T> teClass, String name, IForestryTicker<T> serverTicker) {
        VoxelShape nsBase = Block.m_49796_((double)2.0, (double)2.0, (double)4.0, (double)14.0, (double)14.0, (double)12.0);
        VoxelShape nsFront = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)4.0);
        VoxelShape nsBack = Block.m_49796_((double)0.0, (double)0.0, (double)12.0, (double)16.0, (double)16.0, (double)16.0);
        VoxelShape ns = Shapes.m_83124_((VoxelShape)nsBase, (VoxelShape[])new VoxelShape[]{nsFront, nsBack});
        VoxelShape ewBase = Block.m_49796_((double)4.0, (double)2.0, (double)2.0, (double)12.0, (double)14.0, (double)14.0);
        VoxelShape ewFront = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)16.0);
        VoxelShape ewBack = Block.m_49796_((double)12.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
        VoxelShape ew = Shapes.m_83124_((VoxelShape)ewBase, (VoxelShape[])new VoxelShape[]{ewFront, ewBack});
        this.machineProperties = ((MachineProperties.Builder)((MachineProperties.Builder)new MachineProperties.Builder(teClass, name).setServerTicker(serverTicker)).setShape((state, reader, pos, context) -> {
            Direction direction = (Direction)state.m_61143_(BlockBase.FACING);
            return direction == Direction.NORTH || direction == Direction.SOUTH ? ns : ew;
        })).create();
    }

    private <T extends TileMill> BlockTypeFactoryTesr(FeatureTileType<T> teClass, String name, String renderMillTexture) {
        VoxelShape pedestal = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);
        VoxelShape column = Block.m_49796_((double)5.0, (double)1.0, (double)4.0, (double)11.0, (double)16.0, (double)12.0);
        VoxelShape extension = Block.m_49796_((double)1.0, (double)8.0, (double)7.0, (double)15.0, (double)10.0, (double)9.0);
        this.machineProperties = ((MachineProperties.Builder)((MachineProperties.Builder)((MachineProperties.Builder)new MachineProperties.Builder(teClass, name).setShape(() -> Shapes.m_83124_((VoxelShape)pedestal, (VoxelShape[])new VoxelShape[]{column, extension}))).setClientTicker(TileMill::clientTick)).setServerTicker(TileMill::serverTick)).create();
    }

    @Override
    public IMachineProperties<?> getMachineProperties() {
        return this.machineProperties;
    }

    public String m_7912_() {
        return this.getMachineProperties().m_7912_();
    }
}

