/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.gui;

import forestry.core.gui.GuiForestryTitled;
import forestry.core.gui.widgets.TankWidget;
import forestry.factory.gui.ContainerFermenter;
import forestry.factory.tiles.TileFermenter;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;

public class GuiFermenter
extends GuiForestryTitled<ContainerFermenter> {
    private final TileFermenter tile;

    public GuiFermenter(ContainerFermenter container, Inventory inventory, Component title) {
        super("textures/gui/fermenter.png", container, inventory, title);
        this.tile = (TileFermenter)container.getTile();
        this.widgetManager.add(new TankWidget(this.widgetManager, 35, 19, 0));
        this.widgetManager.add(new TankWidget(this.widgetManager, 125, 19, 1));
    }

    @Override
    protected void m_7286_(GuiGraphics graphics, float partialTicks, int mX, int mY) {
        int bioRemain;
        super.m_7286_(graphics, partialTicks, mX, mY);
        int fuelRemain = this.tile.getBurnTimeRemainingScaled(16);
        if (fuelRemain > 0) {
            graphics.m_280218_(this.textureFile, this.f_97735_ + 98, this.f_97736_ + 46 + 17 - fuelRemain, 176, 95 - fuelRemain, 4, fuelRemain);
        }
        if ((bioRemain = this.tile.getFermentationProgressScaled(16)) > 0) {
            graphics.m_280218_(this.textureFile, this.f_97735_ + 74, this.f_97736_ + 32 + 17 - bioRemain, 176, 77 - bioRemain, 4, bioRemain);
        }
    }

    @Override
    protected void addLedgers() {
        this.addErrorLedger(this.tile);
        this.addHintLedger("fermenter");
        this.addPowerLedger(this.tile.getEnergyManager());
    }
}

