/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.recipes.jei.fermenter;

import forestry.api.ForestryConstants;
import forestry.api.fuels.FermenterFuel;
import forestry.api.fuels.FuelManager;
import forestry.api.recipes.IFermenterRecipe;
import forestry.api.recipes.IVariableFermentable;
import forestry.core.recipes.jei.ForestryRecipeCategory;
import forestry.core.recipes.jei.ForestryRecipeType;
import forestry.factory.blocks.BlockTypeFactoryTesr;
import forestry.factory.features.FactoryBlocks;
import forestry.modules.features.FeatureBlock;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.forge.ForgeTypes;
import mezz.jei.api.gui.builder.IIngredientAcceptor;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class FermenterRecipeCategory
extends ForestryRecipeCategory<IFermenterRecipe> {
    private static final ResourceLocation TEXTURE = ForestryConstants.forestry("textures/gui/fermenter.png");
    private final IDrawableAnimated progressBar0;
    private final IDrawableAnimated progressBar1;
    private final IDrawable tankOverlay;
    private final IDrawable icon;

    public FermenterRecipeCategory(IGuiHelper guiHelper) {
        super((IDrawable)guiHelper.createDrawable(TEXTURE, 34, 18, 108, 60), "block.forestry.fermenter");
        IDrawableStatic progressBarDrawable0 = guiHelper.createDrawable(TEXTURE, 176, 60, 4, 18);
        this.progressBar0 = guiHelper.createAnimatedDrawable(progressBarDrawable0, 40, IDrawableAnimated.StartDirection.BOTTOM, false);
        IDrawableStatic progressBarDrawable1 = guiHelper.createDrawable(TEXTURE, 176, 78, 4, 18);
        this.progressBar1 = guiHelper.createAnimatedDrawable(progressBarDrawable1, 80, IDrawableAnimated.StartDirection.BOTTOM, false);
        this.tankOverlay = guiHelper.createDrawable(TEXTURE, 192, 0, 16, 58);
        ItemStack fermenter = new ItemStack(((FeatureBlock)FactoryBlocks.TESR.get(BlockTypeFactoryTesr.FERMENTER)).block());
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)fermenter);
    }

    public RecipeType<IFermenterRecipe> getRecipeType() {
        return ForestryRecipeType.FERMENTER;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    @Override
    public void setRecipe(IRecipeLayoutBuilder builder, IFermenterRecipe recipe, IFocusGroup focuses) {
        IRecipeSlotBuilder ingredientInputSlot = (IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 51, 5).addIngredients(recipe.getInputItem());
        Collection<FermenterFuel> fuels = FuelManager.fermenterFuel.values();
        List<ItemStack> fuelInputs = fuels.stream().map(FermenterFuel::item).toList();
        builder.addSlot(RecipeIngredientRole.INPUT, 41, 39).addItemStacks(fuelInputs);
        FluidStack fluidInput = recipe.getInputFluid().copy();
        fluidInput.setAmount(recipe.getFermentationValue());
        builder.addSlot(RecipeIngredientRole.INPUT, 1, 1).setFluidRenderer(3000L, false, 16, 58).setOverlay(this.tankOverlay, 0, 0).addIngredient((IIngredientType)ForgeTypes.FLUID_STACK, (Object)fluidInput);
        int baseAmount = Math.round((float)recipe.getFermentationValue() * recipe.getModifier());
        List<FluidStack> outputs = Arrays.stream(recipe.getInputItem().m_43908_()).map(fermentable -> {
            int amount = baseAmount;
            Item patt3784$temp = fermentable.m_41720_();
            if (patt3784$temp instanceof IVariableFermentable) {
                IVariableFermentable variableFermentable = (IVariableFermentable)patt3784$temp;
                amount = (int)((float)amount * variableFermentable.getFermentationModifier((ItemStack)fermentable));
            }
            return new FluidStack(recipe.getOutput(), amount);
        }).toList();
        IRecipeSlotBuilder fluidOutputSlot = (IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 91, 1).setFluidRenderer(3000L, false, 16, 58).setOverlay(this.tankOverlay, 0, 0).addIngredients((IIngredientType)ForgeTypes.FLUID_STACK, outputs);
        builder.createFocusLink(new IIngredientAcceptor[]{ingredientInputSlot, fluidOutputSlot});
    }

    public void draw(IFermenterRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics graphics, double mouseX, double mouseY) {
        this.progressBar0.draw(graphics, 40, 14);
        this.progressBar1.draw(graphics, 64, 28);
    }
}

