/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.logic.farmables;

import com.google.common.collect.ImmutableSet;
import forestry.api.farming.ICrop;
import forestry.api.farming.IFarmable;
import forestry.core.utils.BlockUtil;
import forestry.farming.logic.crops.CropDestroy;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class FarmableSapling
implements IFarmable {
    protected final Item germling;
    protected final Block saplingBlock;
    protected final ImmutableSet<Item> windfall;

    public FarmableSapling(Item germling, ImmutableSet<Item> windfall) {
        this.germling = germling;
        this.windfall = windfall;
        this.saplingBlock = Block.m_49814_((Item)germling);
    }

    @Override
    public boolean plantSaplingAt(Player player, ItemStack germling, Level level, BlockPos pos) {
        ItemStack copy = germling.m_41777_();
        player.m_21008_(InteractionHand.MAIN_HAND, copy);
        BlockHitResult result = new BlockHitResult(Vec3.f_82478_, Direction.UP, pos.m_7495_(), true);
        InteractionResult actionResult = copy.m_41661_(new UseOnContext(player, InteractionHand.MAIN_HAND, result));
        player.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
        if (actionResult.m_19077_()) {
            Block block = Block.m_49814_((Item)germling.m_41720_());
            BlockUtil.sendPlaceSound(level, pos, block == Blocks.f_50016_ ? Blocks.f_50746_.m_49966_() : block.m_49966_());
            return true;
        }
        return false;
    }

    @Override
    public boolean isSaplingAt(Level level, BlockPos pos, BlockState state) {
        return state.m_60734_() == this.saplingBlock;
    }

    @Override
    public ICrop getCropAt(Level level, BlockPos pos, BlockState state) {
        if (!state.m_204336_(BlockTags.f_13106_)) {
            return null;
        }
        return new CropDestroy(level, state, pos, null);
    }

    @Override
    public boolean isGermling(ItemStack stack) {
        return stack.m_150930_(this.germling);
    }

    @Override
    public void addGermlings(Consumer<ItemStack> accumulator) {
        accumulator.accept(new ItemStack((ItemLike)this.germling));
    }

    @Override
    public void addProducts(Consumer<ItemStack> accumulator) {
        for (Item item : this.windfall) {
            accumulator.accept(new ItemStack((ItemLike)item));
        }
    }

    @Override
    public boolean isWindfall(ItemStack stack) {
        return this.windfall.contains((Object)stack.m_41720_());
    }
}

